/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.CDOViewProviderRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.internal.cdo.view.PluginContainerViewProvider;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.io.IOUtil;

public class CDOURIHandler
implements URIHandler {
    private static final String CDO_URI_SCHEME = "cdo";
    private InternalCDOView view;
    private CDOViewProvider.CDOViewProvider2 viewProvider2;
    private URI viewURI;

    public CDOURIHandler(InternalCDOView view) {
        this.view = view;
    }

    public InternalCDOView getView() {
        return this.view;
    }

    public boolean canHandle(URI uri) {
        if (CDO_URI_SCHEME.equals(uri.scheme())) {
            String repositoryUUID = PluginContainerViewProvider.getRepositoryUUID(uri);
            return Objects.equals(repositoryUUID, this.view.getSession().getRepositoryInfo().getUUID());
        }
        if (this.viewURI != null) {
            URI uri2 = this.viewProvider2.getViewURI(uri);
            return this.viewURI == uri2;
        }
        CDOViewProvider provider = this.view.getProvider();
        if (provider != null) {
            CDOViewProvider[] viewProviders;
            CDOViewProvider[] cDOViewProviderArray = viewProviders = CDOViewProviderRegistry.INSTANCE.getViewProviders(uri);
            int n = viewProviders.length;
            int n2 = 0;
            while (n2 < n) {
                CDOViewProvider viewProvider = cDOViewProviderArray[n2];
                if (viewProvider == provider) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        String path = this.getPath(uri);
        return this.view.hasResource(path);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        this.modify(uri, node -> node.delete(options));
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        throw new IOException("CDOURIHandler.createInputStream() not implemented");
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        throw new IOException("CDOURIHandler.createOutputStream() not implemented");
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return ContentHandler.INVALID_CONTENT_DESCRIPTION;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        String path = this.getPath(uri);
        return CDOURIHandler.getAttributes(this.view, path, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }

    void setViewProvider2(CDOViewProvider.CDOViewProvider2 viewProvider2) {
        this.viewProvider2 = viewProvider2;
        this.viewURI = viewProvider2.getViewURI(this.view);
    }

    private String getPath(URI uri) {
        if (CDO_URI_SCHEME.equals(uri.scheme())) {
            return CDOURIUtil.extractResourcePath(uri);
        }
        CDOViewProvider[] cDOViewProviderArray = CDOViewProviderRegistry.INSTANCE.getViewProviders(uri);
        int n = cDOViewProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOViewProvider viewProvider = cDOViewProviderArray[n2];
            if (viewProvider instanceof CDOViewProvider.CDOViewProvider2) {
                return ((CDOViewProvider.CDOViewProvider2)viewProvider).getPath(uri);
            }
            ++n2;
        }
        return null;
    }

    private void modify(URI uri, ResourceNodeModifier modifier) throws IOException {
        if (this.view.isHistorical()) {
            throw new IOException("View is historical: " + this.view);
        }
        String path = this.getPath(uri);
        CDOTransaction transaction = null;
        try {
            try {
                InternalCDOSession session = this.view.getSession();
                CDOBranch branch = this.view.getBranch();
                transaction = session.openTransaction(branch);
                CDOResourceNode node = transaction.getResourceNode(path);
                modifier.modify(node);
                CDOCommitInfo commitInfo = transaction.commit();
                if (commitInfo != null) {
                    this.view.waitForUpdate(commitInfo.getTimeStamp());
                }
            }
            catch (Exception ex) {
                throw IOUtil.ioException((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(transaction);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)transaction);
    }

    public static Map<String, ?> getAttributes(CDOView view, String path, Map<?, ?> options) {
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        CDOResourceNode node = view.getResourceNode(path);
        if (node != null) {
            Set requestedAttributes = (Set)options.get("requestedAttributes");
            if (requestedAttributes == null || requestedAttributes.contains("timeStamp")) {
                long stamp = node instanceof CDOResource ? ((CDOResource)node).getTimeStamp() : -1L;
                result.put("timeStamp", Long.valueOf(stamp));
            }
            if (requestedAttributes == null || requestedAttributes.contains("directory")) {
                result.put("directory", Boolean.valueOf(node instanceof CDOResourceFolder));
            }
            if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
                result.put("readOnly", Boolean.valueOf(view.isReadOnly()));
            }
        }
        return result;
    }

    @FunctionalInterface
    private static interface ResourceNodeModifier {
        public void modify(CDOResourceNode var1) throws IOException;
    }
}

