/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.osgi.framework.BundleContext;

public final class CodeGenEcorePlugin
extends EMFPlugin {
    public static final CodeGenEcorePlugin INSTANCE = new CodeGenEcorePlugin();
    private static Implementation plugin;
    public static final String ID = "org.eclipse.emf.codegen.ecore";

    private CodeGenEcorePlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static class GeneratorAdaptersRegistryReader
    extends RegistryReader {
        static final String EXTENSION_POINT_ID = "generatorAdapters";
        static final String ADAPTER_FACTORY_ELEMENT = "adapterFactory";
        static final String ADAPTER_ELEMENT = "adapter";
        static final String MODEL_PACKAGE_ATTRIBUTE = "modelPackage";
        static final String MODEL_CLASS_ATTRIBUTE = "modelClass";
        static final String CLASS_ATTRIBUTE = "class";

        public GeneratorAdaptersRegistryReader() {
            super(Platform.getExtensionRegistry(), CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        }

        protected boolean readElement(IConfigurationElement element) {
            String modelPackage;
            String name = element.getName();
            if (ADAPTER_FACTORY_ELEMENT.equals(name)) {
                modelPackage = element.getAttribute(MODEL_PACKAGE_ATTRIBUTE);
                if (modelPackage == null) {
                    modelPackage = "http://www.eclipse.org/emf/2002/GenModel";
                }
                if (element.getAttribute(CLASS_ATTRIBUTE) == null) {
                    this.logMissingAttribute(element, CLASS_ATTRIBUTE);
                } else {
                    GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.addDescriptor(modelPackage, new Descriptor(element));
                    return true;
                }
            }
            if (ADAPTER_ELEMENT.equals(name)) {
                modelPackage = element.getAttribute(MODEL_PACKAGE_ATTRIBUTE);
                String modelClass = element.getAttribute(MODEL_CLASS_ATTRIBUTE);
                if (modelPackage == null) {
                    modelPackage = "http://www.eclipse.org/emf/2002/GenModel";
                }
                if (modelClass == null) {
                    this.logMissingAttribute(element, MODEL_CLASS_ATTRIBUTE);
                } else if (element.getAttribute(CLASS_ATTRIBUTE) == null) {
                    this.logMissingAttribute(element, CLASS_ATTRIBUTE);
                } else {
                    GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.addDescriptor(modelPackage, new GenericDescriptor(modelPackage, modelClass, element));
                    return true;
                }
            }
            return false;
        }

        static class Descriptor
        extends RegistryReader.PluginClassDescriptor
        implements GeneratorAdapterFactory.Descriptor {
            public Descriptor(IConfigurationElement element) {
                super(element, GeneratorAdaptersRegistryReader.CLASS_ATTRIBUTE);
            }

            public GeneratorAdapterFactory createAdapterFactory() {
                return (GeneratorAdapterFactory)this.createInstance();
            }
        }

        static class GenericDescriptor
        extends RegistryReader.PluginClassDescriptor
        implements GeneratorAdapterFactory.Descriptor {
            private String modelPackage;
            private String modelClass;

            public GenericDescriptor(String modelPackage, String modelClass, IConfigurationElement element) {
                super(element, GeneratorAdaptersRegistryReader.CLASS_ATTRIBUTE);
                this.modelPackage = modelPackage;
                this.modelClass = modelClass;
            }

            public GeneratorAdapterFactory createAdapterFactory() {
                return new AdapterFactory();
            }

            class AdapterFactory
            extends AbstractGeneratorAdapterFactory {
                protected GeneratorAdapter adapter;

                AdapterFactory() {
                }

                protected Adapter createAdapter(Notifier target) {
                    EClassifier eClassifier;
                    ResourceSet resourceSet = this.getGenerator().getOptions().resourceSet;
                    EPackage.Registry packageRegistry = resourceSet != null ? resourceSet.getPackageRegistry() : EPackage.Registry.INSTANCE;
                    EPackage ePackage = packageRegistry.getEPackage(GenericDescriptor.this.modelPackage);
                    if (ePackage != null && (eClassifier = ePackage.getEClassifier(GenericDescriptor.this.modelClass)).isInstance((Object)target)) {
                        this.adapter = (GeneratorAdapter)GenericDescriptor.this.createInstance();
                        return (Adapter)GenericDescriptor.this.createInstance();
                    }
                    return null;
                }

                protected GeneratorAdapter createAdapter(Object object) {
                    try {
                        if (Class.forName(String.valueOf(GenericDescriptor.this.modelPackage) + "." + GenericDescriptor.this.modelClass).isInstance(object)) {
                            this.adapter = (GeneratorAdapter)GenericDescriptor.this.createInstance();
                            return this.adapter;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    return null;
                }

                public void dispose() {
                    if (this.adapter != null) {
                        this.adapter.dispose();
                    }
                }
            }
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            new GeneratorAdaptersRegistryReader().readRegistry();
        }
    }
}

