/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.dynamic.DocumentReader;
import org.eclipse.help.internal.dynamic.ExtensionHandler;
import org.eclipse.help.internal.dynamic.IncludeHandler;
import org.eclipse.help.internal.dynamic.ProcessorHandler;
import org.eclipse.help.internal.dynamic.XMLProcessor;
import org.eclipse.help.search.IHelpSearchIndex;
import org.eclipse.help.search.ISearchDocument;
import org.eclipse.help.search.SearchParticipant;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SearchParticipantXML
extends SearchParticipant {
    private Stack<String> stack = new Stack();
    private SAXParser parser;
    private XMLProcessor processor;
    private boolean hasFilters;

    protected abstract void handleStartElement(String var1, Attributes var2, IParsedXMLContent var3);

    protected abstract void handleEndElement(String var1, IParsedXMLContent var2);

    protected void handleStartDocument(IParsedXMLContent data) {
    }

    protected void handleEndDocument(IParsedXMLContent data) {
    }

    protected void handleProcessingInstruction(String type, IParsedXMLContent data) {
    }

    protected abstract void handleText(String var1, IParsedXMLContent var2);

    /*
     * Loose catch block
     */
    @Override
    public IStatus addDocument(IHelpSearchIndex index, String pluginId, String name, URL url, String id, ISearchDocument doc) {
        IStatus iStatus;
        InputStream stream;
        block15: {
            String summary;
            stream = null;
            if (this.parser == null) {
                SAXParser p;
                this.parser = p = XmlProcessorFactory.createSAXParserNoExternal();
            }
            this.stack.clear();
            this.hasFilters = false;
            ParsedXMLContent parsed = new ParsedXMLContent(index.getLocale());
            XMLHandler handler = new XMLHandler(parsed);
            stream = ProxyUtil.getStream(url);
            stream = this.preprocess(stream, name, index.getLocale());
            this.parser.parse(stream, (DefaultHandler)handler);
            doc.addContents(parsed.getContent());
            String title = parsed.getTitle();
            if (title != null) {
                this.addTitle(title, doc);
            }
            if ((summary = parsed.getSummary()) != null) {
                doc.setSummary(summary);
            }
            if (this.hasFilters) {
                doc.setHasFilters(true);
            }
            iStatus = Status.OK_STATUS;
            if (stream == null) break block15;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            stream = null;
        }
        return iStatus;
        catch (Exception e) {
            Status status;
            block16: {
                try {
                    status = new Status(4, "org.eclipse.help.base", 4, "Exception occurred while adding document " + name + " to index.", (Throwable)e);
                    if (stream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        stream = null;
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                stream = null;
            }
            return status;
        }
    }

    protected String getTopElement() {
        return this.stack.peek();
    }

    protected String getElementStackPath() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.stack.size()) {
            if (i > 0) {
                buf.append("/");
            }
            buf.append((String)this.stack.get(i));
            ++i;
        }
        return buf.toString();
    }

    protected InputStream preprocess(InputStream in, String name, String locale) {
        if (this.processor == null) {
            DocumentReader reader = new DocumentReader();
            this.processor = new XMLProcessor(new ProcessorHandler[]{new IncludeHandler(reader, locale), new ExtensionHandler(reader, locale)});
        }
        try {
            return this.processor.process(in, name, null);
        }
        catch (Throwable t) {
            String msg = "An error occured while pre-processing user assistance document \"" + name + "\" for search indexing";
            ILog.of(this.getClass()).error(msg, t);
            return in;
        }
    }

    protected static interface IParsedXMLContent {
        public String getLocale();

        public void setTitle(String var1);

        public void addToSummary(String var1);

        public void addText(String var1);
    }

    private static class ParsedXMLContent
    implements IParsedXMLContent {
        private StringBuilder buffer = new StringBuilder();
        private StringBuilder summary = new StringBuilder();
        private String title;
        private String locale;
        private static int SUMMARY_LENGTH = 200;

        public ParsedXMLContent(String locale) {
            this.locale = locale;
        }

        @Override
        public String getLocale() {
            return this.locale;
        }

        @Override
        public void setTitle(String title) {
            this.title = title;
        }

        @Override
        public void addToSummary(String text) {
            if (this.summary.length() >= SUMMARY_LENGTH) {
                return;
            }
            if (this.summary.length() > 0) {
                this.summary.append(" ");
            }
            this.summary.append(text);
            if (this.summary.length() > SUMMARY_LENGTH) {
                this.summary.delete(SUMMARY_LENGTH, this.summary.length());
            }
        }

        @Override
        public void addText(String text) {
            if (this.buffer.length() > 0) {
                this.buffer.append(" ");
            }
            this.buffer.append(text);
        }

        public String getContent() {
            return this.buffer.toString();
        }

        public String getSummary() {
            String header;
            String summaryStr = this.summary.toString();
            if (this.title != null && summaryStr.length() >= this.title.length() && (header = summaryStr.substring(0, this.title.length())).equalsIgnoreCase(this.title)) {
                return summaryStr.substring(this.title.length()).trim();
            }
            return summaryStr;
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        public ParsedXMLContent data;

        public XMLHandler(ParsedXMLContent data) {
            this.data = data;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            SearchParticipantXML.this.stack.push(qName);
            SearchParticipantXML.this.handleStartElement(qName, attributes, this.data);
            if (attributes.getValue("filter") != null || qName.equalsIgnoreCase("filter")) {
                SearchParticipantXML.this.hasFilters = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            SearchParticipantXML.this.handleEndElement(qName, this.data);
            String top = SearchParticipantXML.this.stack.peek();
            if (top != null && top.equals(qName)) {
                SearchParticipantXML.this.stack.pop();
            }
        }

        @Override
        public void startDocument() throws SAXException {
            SearchParticipantXML.this.handleStartDocument(this.data);
        }

        @Override
        public void endDocument() throws SAXException {
            SearchParticipantXML.this.handleEndDocument(this.data);
        }

        @Override
        public void processingInstruction(String target, String pidata) throws SAXException {
            SearchParticipantXML.this.handleProcessingInstruction(target, this.data);
        }

        @Override
        public void characters(char[] characters, int start, int length) throws SAXException {
            if (length == 0) {
                return;
            }
            StringBuilder buff = new StringBuilder();
            int i = 0;
            while (i < length) {
                buff.append(characters[start + i]);
                ++i;
            }
            String text = buff.toString();
            if (text.trim().length() > 0) {
                SearchParticipantXML.this.handleText(text, this.data);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }
    }
}

