/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorDiagramTypeProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(null, true);
        IProject pr = null;
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            int resType = delta.getResource().getType();
            if (resType == 4) {
                pr = (IProject)delta.getResource();
            } else if (resType == 1) {
                IFile file = (IFile)delta.getResource();
                pr = file.getProject();
                if (!file.exists() && delta.getKind() == 2) {
                    IProject project;
                    pr = project = file.getProject();
                    final String name = project.getName();
                    if (file.getFullPath().equals((Object)ModelIntegrationUtil.getDiagramXMLFullPath(name))) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IEditorReference[] editorRefs;
                                IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IEditorReference[] iEditorReferenceArray = editorRefs = workbenchPage.getEditorReferences();
                                int n = editorRefs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IEditorPart editor;
                                    IEditorReference editorRef = iEditorReferenceArray[n2];
                                    if ("org.eclipse.jpt.jpadiagrameditor.ui".equals(editorRef.getId()) && !name.equals(editorRef.getName()) && (editor = editorRef.getEditor(false)) != null) {
                                        workbenchPage.closeEditor(editor, false);
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                        });
                    }
                }
            }
            ++n2;
        }
        if (pr == null) {
            return;
        }
        this.rearrangeIsARelations(pr);
    }

    private void rearrangeIsARelations(IProject pr) {
        if (pr == null) {
            return;
        }
        Diagram d = ModelIntegrationUtil.getDiagramByProject(pr);
        if (d == null) {
            return;
        }
        final JPAEditorDiagramTypeProvider provider = ModelIntegrationUtil.getProviderByDiagram(d.getName());
        if (provider == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                JpaArtifactFactory.instance().rearrangeIsARelationsInTransaction(provider.getFeatureProvider());
            }
        });
    }
}

