/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.EjbRef;
import org.eclipse.jst.jee.model.internal.mergers.BaseRefsMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class EJBRefsMerger
extends BaseRefsMerger {
    public EJBRefsMerger(List _baseEjbRefs, List _toMergeEjbRefs) {
        super(_baseEjbRefs, _toMergeEjbRefs);
    }

    @Override
    public List process() throws ModelException {
        ArrayList warnings = new ArrayList();
        if (this.getToMergeElemets() == null || this.getToMergeElemets().isEmpty()) {
            return warnings;
        }
        for (Object object : this.getToMergeElemets()) {
            Object findMatchingRef = null;
            findMatchingRef = object instanceof EjbLocalRef ? EJBRefsMerger.findMatchingLocalRef(this.getBaseElements(), object) : EJBRefsMerger.findMatchingRef(this.getBaseElements(), object);
            if (findMatchingRef != null) {
                this.copyMissingPropertesInBase(findMatchingRef, object);
                continue;
            }
            this.getBaseElements().add(EcoreUtil.copy((EObject)((EObject)object)));
        }
        return warnings;
    }

    private static EjbRef findMatchingRef(List xmlRefs, Object ref) throws ModelException {
        EjbRef result = null;
        for (Object currentXMLRef : xmlRefs) {
            if (!EJBRefsMerger.isMatchingRef(currentXMLRef, ref)) continue;
            result = (EjbRef)currentXMLRef;
            break;
        }
        return result;
    }

    private static EjbLocalRef findMatchingLocalRef(List xmlRefs, Object ref) throws ModelException {
        EjbLocalRef result = null;
        for (Object currentXMLRef : xmlRefs) {
            if (!EJBRefsMerger.isMatchingRef(currentXMLRef, ref)) continue;
            result = (EjbLocalRef)currentXMLRef;
            break;
        }
        return result;
    }

    private static boolean isMatchingRef(Object xmlRef, Object annotatedRef) throws ModelException {
        String annotatedRefName;
        boolean result = false;
        String xmlRefName = xmlRef instanceof EjbRef ? ((EjbRef)xmlRef).getEjbRefName() : ((EjbLocalRef)xmlRef).getEjbRefName();
        String string = annotatedRefName = annotatedRef instanceof EjbRef ? ((EjbRef)annotatedRef).getEjbRefName() : ((EjbLocalRef)annotatedRef).getEjbRefName();
        if (xmlRefName.equals(annotatedRefName)) {
            result = true;
        }
        return result;
    }

    @Override
    protected void copyMissingPropertesInBase(Object base, Object toMerge) {
        if (base instanceof EjbRef) {
            this.copyEjbRefPropsInBase((EjbRef)base, (EjbRef)toMerge);
        } else if (base instanceof EjbLocalRef) {
            this.copyEjbLocalRefPropsInBase((EjbLocalRef)base, (EjbLocalRef)toMerge);
        }
    }

    private void copyEjbLocalRefPropsInBase(EjbLocalRef base, EjbLocalRef toMerge) {
        if (base.getEjbLink() == null) {
            base.setEjbLink(toMerge.getEjbLink());
        }
        if (base.getMappedName() == null) {
            base.setMappedName(toMerge.getMappedName());
        }
        if (!base.isSetEjbRefType()) {
            base.setEjbRefType(toMerge.getEjbRefType());
        }
        if (base.getLocal() == null) {
            base.setLocal(toMerge.getLocal());
        }
        if (base.getLocalHome() == null) {
            base.setLocalHome(toMerge.getLocalHome());
        }
    }

    private void copyEjbRefPropsInBase(EjbRef base, EjbRef toMerge) {
        if (base.getEjbLink() == null) {
            base.setEjbLink(toMerge.getEjbLink());
        }
        if (base.getMappedName() == null) {
            base.setMappedName(toMerge.getMappedName());
        }
        if (!base.isSetEjbRefType()) {
            base.setEjbRefType(toMerge.getEjbRefType());
        }
        if (base.getRemote() == null) {
            base.setRemote(toMerge.getRemote());
        }
        if (base.getHome() == null) {
            base.setHome(toMerge.getHome());
        }
    }
}

