/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2e.core.project.IBuildProjectFileResolver;
import org.eclipse.m2e.internal.launch.MavenBuildProjectDataConnection;
import org.eclipse.m2e.internal.maven.listener.M2EMavenBuildDataBridge;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class MavenConsoleLineTracker
implements IConsoleLineTracker {
    private static final ILog log = Platform.getLog(MavenConsoleLineTracker.class);
    private static final String PLUGIN_ID = "org.eclipse.m2e.launching";
    private static final String IDENTIFIER = "([\\w\\.\\-]+)";
    private static final Pattern LISTENING_MARKER = Pattern.compile("Listening for transport dt_socket at address: (\\d+)$");
    private static final int DEBUGGER_PORT = 1;
    private static final Pattern RUNNING_TEST_CLASS = Pattern.compile("Running ([\\w\\.]+)$");
    private static final int TEST_CLASS_NAME = 1;
    private static final Pattern EXECUTION_FAILURE = Pattern.compile("^\\[ERROR\\] Failed to execute goal .+ on project ([\\w\\.\\-]+)");
    private static final int FAILED_PROJECT_ID = 1;
    private static final Pattern ESCAPE_CHARACTERS = Pattern.compile("\\e\\[[\\d;]*?[^\\d;]");
    private boolean isMavenBuildProcess;
    private IConsole console;
    ILaunch launch;
    private boolean initialized = false;
    private ProjectReference mavenProject;
    private final Deque<IRegion> projectDefinitionLines = new ArrayDeque<IRegion>(3);
    private final List<int[]> removedLineLocations = new ArrayList<int[]>();
    private static final Pattern GROUP_ARTIFACT_LINE = Pattern.compile("^\\[INFO\\] -+< ([\\w\\.\\-]+):([\\w\\.\\-]+) >-+$");
    private static final int GROUP_ID = 1;
    private static final int ARTIFACT_ID = 2;
    private static final Pattern VERSION_LINE = Pattern.compile("^\\[INFO\\] Building .+ ([\\w\\.\\-]+)( +\\[\\d+/\\d+\\])?$");
    private static final int VERSION = 1;
    private static final Pattern FROM_FILE_LINE = Pattern.compile("^\\[INFO\\] +from ");
    private static final Pattern PACKAGING_TYPE_LINE = Pattern.compile("^\\[INFO\\] -+\\[ [\\w\\-\\. ]+ \\]-+$");

    public void init(IConsole console) {
        if (this.initialized) {
            throw new IllegalStateException("MavenConsoleLineTracker already connected to console");
        }
        this.console = console;
        this.launch = console.getProcess().getLaunch();
        ILaunchConfiguration launchConfiguration = this.launch.getLaunchConfiguration();
        this.isMavenBuildProcess = launchConfiguration != null && this.isMavenProcess(launchConfiguration);
        this.initialized = true;
    }

    public void lineAppended(IRegion line) {
        if (this.isMavenBuildProcess) {
            try {
                String text = this.getText(line);
                if (this.mavenProject == null) {
                    return;
                }
                Matcher runningTestMatcher = RUNNING_TEST_CLASS.matcher(text);
                if (runningTestMatcher.find()) {
                    String testName = runningTestMatcher.group(1);
                    int start = runningTestMatcher.start(1);
                    int end = start + testName.length();
                    start = MavenConsoleLineTracker.getOriginalIndex(start, this.removedLineLocations);
                    end = MavenConsoleLineTracker.getOriginalIndex(end, this.removedLineLocations);
                    MavenTestReportHyperLink link = new MavenTestReportHyperLink(this.mavenProject, testName);
                    this.console.addLink((IHyperlink)link, line.getOffset() + start, end - start);
                    return;
                }
                Matcher listeningMatcher = LISTENING_MARKER.matcher(text);
                if (listeningMatcher.find()) {
                    String portString = listeningMatcher.group(1);
                    MavenConsoleLineTracker.launchRemoteJavaApp(this.mavenProject.project(), portString);
                    return;
                }
                Matcher failureMatcher = EXECUTION_FAILURE.matcher(text);
                if (failureMatcher.find()) {
                    this.addProjectLink(line, failureMatcher, 1, 1, this.removedLineLocations);
                }
            }
            catch (BadLocationException text) {
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private boolean isMavenProcess(ILaunchConfiguration launchConfiguration) {
        try {
            ILaunchConfigurationType type = launchConfiguration.getType();
            return PLUGIN_ID.equals(type.getPluginIdentifier());
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private String getText(IRegion lineRegion) throws BadLocationException {
        String line2;
        Matcher vMatcher;
        Iterator<IRegion> previousLines;
        String line1;
        this.removedLineLocations.clear();
        String line0 = this.getLineText(lineRegion, this.removedLineLocations);
        if (this.projectDefinitionLines.size() < 3) {
            this.projectDefinitionLines.add(lineRegion);
            return line0;
        }
        if (PACKAGING_TYPE_LINE.matcher(line0).matches() && FROM_FILE_LINE.matcher(line1 = this.getLineText((previousLines = this.projectDefinitionLines.descendingIterator()).next(), null)).find() && (vMatcher = VERSION_LINE.matcher(line2 = this.getLineText(previousLines.next(), null))).matches()) {
            ArrayList<int[]> removedLine3Locations;
            String version = vMatcher.group(1);
            IRegion line3Region = previousLines.next();
            String line3 = this.getLineText(line3Region, removedLine3Locations = new ArrayList<int[]>());
            Matcher gaMatcher = GROUP_ARTIFACT_LINE.matcher(line3);
            if (gaMatcher.matches()) {
                String groupId = gaMatcher.group(1);
                String artifactId = gaMatcher.group(2);
                this.mavenProject = this.getProject(groupId, artifactId, version);
                if (this.mavenProject != null) {
                    this.addProjectLink(line3Region, gaMatcher, 1, 2, removedLine3Locations);
                }
            }
        }
        this.projectDefinitionLines.remove();
        this.projectDefinitionLines.add(lineRegion);
        return line0;
    }

    private String getLineText(IRegion region, List<int[]> removedLocations) throws BadLocationException {
        String rawText = this.console.getDocument().get(region.getOffset(), region.getLength()).strip();
        Matcher m = ESCAPE_CHARACTERS.matcher(rawText);
        return removedLocations == null ? m.replaceAll("") : m.replaceAll(mr -> {
            removedLocations.add(new int[]{mr.start(), mr.end() - mr.start()});
            return "";
        });
    }

    private static int getOriginalIndex(int index, List<int[]> removedLocations) {
        int i = 0;
        while (i < removedLocations.size() && removedLocations.get(i)[0] < index) {
            index += removedLocations.get(i)[1];
            ++i;
        }
        return index;
    }

    private void addProjectLink(IRegion line, Matcher matcher, int startGroup, int endGroup, List<int[]> removedLocations) {
        ProjectHyperLink link = new ProjectHyperLink(this.mavenProject);
        int start = MavenConsoleLineTracker.getOriginalIndex(matcher.start(startGroup), removedLocations);
        int end = MavenConsoleLineTracker.getOriginalIndex(matcher.end(endGroup), removedLocations);
        this.console.addLink((IHyperlink)link, line.getOffset() + start, end - start);
    }

    private ProjectReference getProject(String groupId, String artifactId, String version) {
        M2EMavenBuildDataBridge.MavenProjectBuildData buildProject = MavenBuildProjectDataConnection.getBuildProject(this.launch, groupId, artifactId, version);
        if (buildProject == null) {
            return null;
        }
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        URI basedirURI = buildProject.projectBasedir.toUri();
        Optional<IProject> project = Arrays.stream(wsRoot.findContainersForLocationURI(basedirURI)).filter(IProject.class::isInstance).map(IProject.class::cast).findFirst();
        return project.isPresent() ? new ProjectReference(project.get(), buildProject) : null;
    }

    public void dispose() {
        this.isMavenBuildProcess = false;
        this.projectDefinitionLines.clear();
        this.mavenProject = null;
        this.initialized = false;
    }

    private static void launchRemoteJavaApp(IProject project, String portString) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, "Connecting debugger to port " + portString);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, IJavaLaunchConfigurationConstants.ID_SOCKET_ATTACH_VM_CONNECTOR);
        HashMap<String, String> connectMap = new HashMap<String, String>();
        connectMap.put("port", portString);
        connectMap.put("hostname", "localhost");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, connectMap);
        if (project != null && project.exists()) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        }
        DebugUITools.launch((ILaunchConfiguration)workingCopy, (String)"debug");
    }

    private static void openFileInStandardEditor(IFile file) {
        try {
            file.refreshLocal(0, null);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static class MavenTestReportHyperLink
    implements IHyperlink {
        private final String testName;
        private final ProjectReference project;

        public MavenTestReportHyperLink(ProjectReference project, String testName) {
            this.testName = testName;
            this.project = project;
        }

        public void linkActivated() {
            List<java.nio.file.Path> reportFiles = MavenTestReportHyperLink.getTestReportFiles(this.project.buildProject().projectBuildDirectory, this.testName);
            if (!reportFiles.isEmpty()) {
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                for (java.nio.file.Path reportFile : reportFiles) {
                    IFile[] files = wsRoot.findFilesForLocationURI(reportFile.toUri());
                    if (files.length <= 0) continue;
                    MavenConsoleLineTracker.openFileInStandardEditor(files[0]);
                }
            }
        }

        private static List<java.nio.file.Path> getTestReportFiles(java.nio.file.Path baseDir, String testName) {
            ArrayList<java.nio.file.Path> jUnitXMLFiles = new ArrayList<java.nio.file.Path>();
            ArrayList plainTextFiles = new ArrayList();
            java.nio.file.Path jUnitReportFile = java.nio.file.Path.of("TEST-" + testName + ".xml", new String[0]);
            java.nio.file.Path plainTextSummaryFile = java.nio.file.Path.of(String.valueOf(testName) + ".txt", new String[0]);
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (Stream<java.nio.file.Path> s = Files.walk(baseDir, new FileVisitOption[0]);){
                    s.forEach(p -> {
                        if (p.endsWith(jUnitReportFile) && Files.isRegularFile(p, new LinkOption[0])) {
                            jUnitXMLFiles.add((java.nio.file.Path)p);
                        } else if (p.endsWith(plainTextSummaryFile) && Files.isRegularFile(p, new LinkOption[0])) {
                            plainTextFiles.add(p);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error("Failed to search test summary files", (Throwable)e);
                return Collections.emptyList();
            }
            return !jUnitXMLFiles.isEmpty() ? jUnitXMLFiles : plainTextFiles;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }

    private static class ProjectHyperLink
    implements IHyperlink {
        private final ProjectReference project;

        public ProjectHyperLink(ProjectReference project) {
            this.project = project;
        }

        public void linkActivated() {
            IFile projectFile;
            java.nio.file.Path relativePath = this.project.buildProject().projectBasedir.relativize(this.project.buildProject().projectFile);
            String filename = relativePath.getFileName().toString();
            if ("pom.xml".equals(filename)) {
                projectFile = this.project.project().getFile("pom.xml");
            } else {
                Optional<IPath> resolvedPomfile = this.resolvePath(filename);
                IPath projectFilePath = Path.fromOSString((String)relativePath.toString());
                if (resolvedPomfile.isPresent()) {
                    projectFilePath = projectFilePath.removeLastSegments(1).append(resolvedPomfile.get());
                }
                projectFile = this.project.project().getFile(projectFilePath);
            }
            MavenConsoleLineTracker.openFileInStandardEditor(projectFile);
        }

        private Optional<IPath> resolvePath(String filename) {
            BundleContext ctx = FrameworkUtil.getBundle(MavenConsoleLineTracker.class).getBundleContext();
            try {
                return ctx.getServiceReferences(IBuildProjectFileResolver.class, null).stream().map(reference -> {
                    IBuildProjectFileResolver resolver = (IBuildProjectFileResolver)ctx.getService(reference);
                    try {
                        IPath iPath = resolver != null ? resolver.resolveProjectFile(filename) : null;
                        return iPath;
                    }
                    finally {
                        ctx.ungetService(reference);
                    }
                }).filter(Objects::nonNull).findFirst();
            }
            catch (InvalidSyntaxException e) {
                throw new AssertionError("Unexpected exception", e);
            }
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }

    private record ProjectReference(IProject project, M2EMavenBuildDataBridge.MavenProjectBuildData buildProject) {
    }
}

