/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.swing.text.html.HTML;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.RedirectException;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.xmlrpc.XmlRpcException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.core.HtmlTag;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugHistory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFilePart;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaFlag;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryResponse;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaUserMatchResponse;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.CustomTransitionManager;
import org.eclipse.mylyn.internal.bugzilla.core.GzipGetMethod;
import org.eclipse.mylyn.internal.bugzilla.core.GzipPostMethod;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.internal.bugzilla.core.MultiBugReportFactory;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfigurationFactory;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryQueryResultsFactory;
import org.eclipse.mylyn.internal.bugzilla.core.service.BugzillaXmlRpcClient;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryLocation;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;

public class BugzillaClient {
    private static final String INPUT_TYPE_HIDDEN_NAME_BUGZILLA_LOGIN_TOKEN = "<input type=\"hidden\" name=\"Bugzilla_login_token";
    private static final String UNKNOWN_REPOSITORY_ERROR = "An unknown repository error has occurred: ";
    private static final String COOKIE_BUGZILLA_LOGIN = "Bugzilla_login";
    protected static final String USER_AGENT = "BugzillaConnector";
    public static final int MAX_RETRIEVED_PER_QUERY = 50;
    private static final String QUERY_DELIMITER = "?";
    private static final String KEY_ID = "id";
    private static final String VAL_TRUE = "true";
    private static final String KEY_CC = "cc";
    private static final String POST_BUG_CGI = "/post_bug.cgi";
    private static final String ENTER_BUG_PRODUCT_CGI = "/enter_bug.cgi?product=";
    private static final String ENTER_ATTACHMENT_CGI = "/attachment.cgi?action=enter&bugid=";
    private static final String PROCESS_BUG_CGI = "/process_bug.cgi";
    private static final String PROCESS_ATTACHMENT_CGI = "/attachment.cgi";
    public static final int WRAP_LENGTH = 80;
    private static final String VAL_PROCESS_BUG = "process_bug";
    private static final String KEY_FORM_NAME = "form_name";
    private static final String VAL_NONE = "none";
    private static final String KEY_KNOB = "knob";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_SHORT_DESC = "short_desc";
    private static final String VALUE_CONTENTTYPEMETHOD_MANUAL = "manual";
    private static final String VALUE_ISPATCH = "1";
    private static final String VALUE_ACTION_INSERT = "insert";
    private static final String ATTRIBUTE_CONTENTTYPEENTRY = "contenttypeentry";
    private static final String ATTRIBUTE_CONTENTTYPEMETHOD = "contenttypemethod";
    private static final String ATTRIBUTE_ISPATCH = "ispatch";
    private static final String CONTENT_TYPE_APP_RDF_XML = "application/rdf+xml";
    private static final String CONTENT_TYPE_APP_XML = "application/xml";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private static final String[] VALID_CONFIG_CONTENT_TYPES = new String[]{"application/rdf+xml", "application/xml", "text/xml"};
    private static final String ATTR_CHARSET = "charset";
    protected Proxy proxy = Proxy.NO_PROXY;
    protected URL repositoryUrl;
    protected String characterEncoding;
    private boolean loggedIn;
    private final Map<String, String> configParameters;
    private final HttpClient httpClient = new HttpClient(WebUtil.getConnectionManager());
    private boolean lastModifiedSupported = true;
    private final BugzillaLanguageSettings bugzillaLanguageSettings;
    private RepositoryConfiguration repositoryConfiguration;
    private HostConfiguration hostConfiguration;
    private final AbstractWebLocation location;
    private final BugzillaRepositoryConnector connector;
    private BugzillaXmlRpcClient xmlRpcClient = null;

    public BugzillaClient(AbstractWebLocation location, String characterEncoding, Map<String, String> configParameters, BugzillaLanguageSettings languageSettings, BugzillaRepositoryConnector connector) throws MalformedURLException {
        this.repositoryUrl = new URL(location.getUrl());
        this.location = location;
        this.characterEncoding = characterEncoding;
        this.configParameters = configParameters;
        this.bugzillaLanguageSettings = languageSettings;
        this.connector = connector;
        this.proxy = location.getProxyForHost(location.getUrl(), "HTTP");
        WebUtil.configureHttpClient((HttpClient)this.httpClient, (String)USER_AGENT);
    }

    public BugzillaClient(AbstractWebLocation location, TaskRepository taskRepository, BugzillaRepositoryConnector connector) throws MalformedURLException {
        this(location, taskRepository.getCharacterEncoding(), taskRepository.getProperties(), BugzillaClient.getLanguageSettings(taskRepository), connector);
    }

    private static BugzillaLanguageSettings getLanguageSettings(TaskRepository taskRepository) {
        String language = taskRepository.getProperty("bugzilla.languageSetting");
        if (language == null || language.equals("")) {
            language = "en (default)";
        }
        return BugzillaRepositoryConnector.getLanguageSetting(language);
    }

    public void validate(IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        GzipGetMethod method = null;
        try {
            this.logout(monitor);
            method = this.getConnect(this.repositoryUrl + "/", monitor);
        }
        catch (Throwable throwable) {
            if (method != null) {
                WebUtil.releaseConnection(method, (IProgressMonitor)monitor);
            }
            throw throwable;
        }
        if (method != null) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
        CustomTransitionManager validTransitions = new CustomTransitionManager();
        String transitionsFileName = this.configParameters.get("bugzilla.desciptorFile");
        if (transitionsFileName != null && !transitionsFileName.equals("") && !validTransitions.parse(transitionsFileName)) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "Invalide Transition File Content"));
        }
        if (Boolean.parseBoolean(this.configParameters.get("bugzilla.xmlrpc.status.transition"))) {
            this.getXmlRpcClient();
            int uID = -1;
            try {
                uID = this.xmlRpcClient.login(monitor);
                if (uID == -1) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "XMLRPC user could not login"));
                }
            }
            catch (XmlRpcException e) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "XMLRPC is not installed"));
            }
        }
    }

    protected boolean hasAuthenticationCredentials() {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        return credentials != null && credentials.getUserName() != null && credentials.getUserName().length() > 0;
    }

    protected boolean hasHTTPAuthenticationCredentials() {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.HTTP);
        return credentials != null && credentials.getUserName() != null && credentials.getUserName().length() > 0;
    }

    private GzipGetMethod getConnect(String serverURL, IProgressMonitor monitor) throws IOException, CoreException {
        return this.connectInternal(serverURL, false, monitor, null);
    }

    protected GzipGetMethod getConnectGzip(String serverURL, IProgressMonitor monitor) throws IOException, CoreException {
        return this.getConnectGzip(serverURL, monitor, null);
    }

    protected GzipGetMethod getConnectGzip(String serverURL, IProgressMonitor monitor, String eTagValue) throws IOException, CoreException {
        return this.connectInternal(serverURL, true, monitor, eTagValue);
    }

    private GzipGetMethod connectInternal(String requestURL, boolean gzip, IProgressMonitor monitor, String eTagValue) throws IOException, CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        int attempt = 0;
        while (attempt < 2) {
            int code;
            this.authenticate(monitor);
            GzipGetMethod getMethod = new GzipGetMethod(WebUtil.getRequestPath((String)requestURL), gzip);
            if (requestURL.contains(QUERY_DELIMITER)) {
                getMethod.setQueryString(requestURL.substring(requestURL.indexOf(QUERY_DELIMITER)));
            }
            getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.getCharacterEncoding());
            if (eTagValue != null && eTagValue.compareTo("") != 0) {
                getMethod.setRequestHeader("If-None-Match", eTagValue);
            }
            this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
            getMethod.setDoAuthentication(true);
            try {
                code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)getMethod, (IProgressMonitor)monitor);
            }
            catch (IOException e) {
                WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
            }
            switch (code) {
                case 200: {
                    return getMethod;
                }
                case 304: {
                    WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "Not changed"));
                }
                case 401: 
                case 403: {
                    this.loggedIn = false;
                    WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
                    this.authenticate(monitor);
                    break;
                }
                case 407: {
                    this.loggedIn = false;
                    WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                }
                case 500: {
                    this.loggedIn = false;
                    InputStream stream = this.getResponseStream((HttpMethodBase)getMethod, monitor);
                    ByteArrayOutputStream ou = new ByteArrayOutputStream(1024);
                    BugzillaClient.transferData(stream, ou);
                    WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, this.repositoryUrl.toString(), "Error = 500"));
                }
                default: {
                    WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
                }
            }
            ++attempt;
        }
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "All connection attempts to " + this.repositoryUrl.toString() + " failed. Please verify connection and authentication information."));
    }

    public void logout(IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        String loginUrl = this.repositoryUrl + "/relogin.cgi";
        GzipGetMethod method = null;
        try {
            method = this.getConnect(loginUrl, monitor);
            this.loggedIn = false;
            this.httpClient.getState().clearCookies();
        }
        finally {
            if (method != null) {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            }
        }
    }

    protected InputStream getResponseStream(HttpMethodBase method, IProgressMonitor monitor) throws IOException {
        InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
        if (this.isZippedReply(method)) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    private boolean isZippedReply(HttpMethodBase method) {
        boolean zipped = method.getResponseHeader("Content-encoding") != null && method.getResponseHeader("Content-encoding").getValue().equals("gzip") || method.getResponseHeader("Content-Type") != null && method.getResponseHeader("Content-Type").getValue().equals("application/x-gzip");
        return zipped;
    }

    private static String getStringFromInputStream(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String getBugzillaLoginTokenIfExists(IProgressMonitor monitor) throws CoreException {
        String loginToken = null;
        GzipPostMethod getMethod = new GzipPostMethod(String.valueOf(WebUtil.getRequestPath((String)this.repositoryUrl.toString())) + "/index.cgi", true);
        try {
            try {
                getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.getCharacterEncoding());
                getMethod.setDoAuthentication(true);
                getMethod.setFollowRedirects(false);
                this.httpClient.getState().clearCookies();
                int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)getMethod, (IProgressMonitor)monitor);
                WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
                if (code != 200) {
                    this.loggedIn = false;
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
                }
                code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)getMethod, (IProgressMonitor)monitor);
                if (code != 200) {
                    this.loggedIn = false;
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
                }
                InputStream is = this.getResponseStream((HttpMethodBase)getMethod, monitor);
                String result = BugzillaClient.getStringFromInputStream(is);
                if (result.lastIndexOf(INPUT_TYPE_HIDDEN_NAME_BUGZILLA_LOGIN_TOKEN) != -1) {
                    int index = result.lastIndexOf(INPUT_TYPE_HIDDEN_NAME_BUGZILLA_LOGIN_TOKEN);
                    String loginTokenAndRest = result.substring(index);
                    int valueStart = loginTokenAndRest.indexOf("value=\"") + 7;
                    int valueEnd = loginTokenAndRest.indexOf("\">");
                    loginToken = loginTokenAndRest.substring(valueStart, valueEnd);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
            }
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
        }
        return loginToken;
    }

    public void authenticate(IProgressMonitor monitor) throws CoreException {
        GzipPostMethod postMethod;
        block31: {
            if (this.loggedIn || !this.hasAuthenticationCredentials() && !this.hasHTTPAuthenticationCredentials()) {
                return;
            }
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            postMethod = null;
            try {
                try {
                    int code;
                    NameValuePair[] formData;
                    this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
                    String loginToken = this.getBugzillaLoginTokenIfExists(monitor);
                    if (loginToken != null) {
                        formData = new NameValuePair[3];
                        formData[2] = new NameValuePair("Bugzilla_login_token", loginToken);
                    } else {
                        formData = new NameValuePair[2];
                    }
                    AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
                    AuthenticationCredentials httpAuthCredentials = this.location.getCredentials(AuthenticationType.HTTP);
                    if (credentials == null && httpAuthCredentials == null) {
                        this.loggedIn = false;
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Authentication credentials from location missing."));
                    }
                    if (credentials != null) {
                        String password = credentials.getPassword();
                        if ("".equals(password) && !this.hasHTTPAuthenticationCredentials()) {
                            this.loggedIn = false;
                            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 13, this.repositoryUrl.toString(), "Empty password not allowed for Authentication credentials."));
                        }
                        formData[0] = new NameValuePair(COOKIE_BUGZILLA_LOGIN, credentials.getUserName());
                        formData[1] = new NameValuePair("Bugzilla_password", credentials.getPassword());
                    }
                    postMethod = new GzipPostMethod(WebUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl.toString()) + "/index.cgi?GoAheadAndLogIn=1")), true);
                    postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.getCharacterEncoding());
                    if (credentials != null) {
                        postMethod.setRequestBody(formData);
                    }
                    postMethod.setDoAuthentication(true);
                    postMethod.setFollowRedirects(false);
                    if (httpAuthCredentials != null && httpAuthCredentials.getUserName() != null && httpAuthCredentials.getUserName().length() > 0) {
                        this.httpClient.getParams().setAuthenticationPreemptive(true);
                    }
                    if ((code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)postMethod, (IProgressMonitor)monitor)) == 401 || code == 403) {
                        this.loggedIn = false;
                        WebUtil.releaseConnection((HttpMethodBase)postMethod, (IProgressMonitor)monitor);
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "HTTP authentication failed."));
                    }
                    if (code == 407) {
                        this.loggedIn = false;
                        WebUtil.releaseConnection((HttpMethodBase)postMethod, (IProgressMonitor)monitor);
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                    }
                    if (code != 200) {
                        this.loggedIn = false;
                        WebUtil.releaseConnection((HttpMethodBase)postMethod, (IProgressMonitor)monitor);
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
                    }
                    if (httpAuthCredentials != null && httpAuthCredentials.getUserName() != null && httpAuthCredentials.getUserName().length() > 0) {
                        this.loggedIn = true;
                        InputStream inputStream = this.getResponseStream((HttpMethodBase)postMethod, monitor);
                        try {
                            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, this.getCharacterEncoding()));
                            try {
                                String errorMessage = this.extractErrorMessage(in);
                                if (errorMessage != null) {
                                    this.loggedIn = false;
                                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), errorMessage));
                                }
                                break block31;
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        break block31;
                    }
                    if (this.hasAuthenticationCredentials()) {
                        Cookie[] cookieArray = this.httpClient.getState().getCookies();
                        int n = cookieArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Cookie cookie = cookieArray[n2];
                            if (cookie.getName().equals(COOKIE_BUGZILLA_LOGIN)) {
                                this.loggedIn = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!this.loggedIn) {
                            InputStream input = this.getResponseStream((HttpMethodBase)postMethod, monitor);
                            try {
                                throw new CoreException((IStatus)this.parseHtmlError(input));
                            }
                            catch (Throwable throwable) {
                                input.close();
                                throw throwable;
                            }
                        }
                    } else {
                        this.loggedIn = true;
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
                }
            }
            catch (Throwable throwable) {
                if (postMethod != null) {
                    WebUtil.releaseConnection(postMethod, (IProgressMonitor)monitor);
                }
                this.httpClient.getParams().setAuthenticationPreemptive(false);
                throw throwable;
            }
        }
        if (postMethod != null) {
            WebUtil.releaseConnection((HttpMethodBase)postMethod, (IProgressMonitor)monitor);
        }
        this.httpClient.getParams().setAuthenticationPreemptive(false);
    }

    private String extractErrorMessage(Reader responseContent) throws IOException, ParseException {
        HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer(responseContent, null);
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (this.isErrorMessageToken(token)) {
                return BugzillaClient.computeErrorMessage(tokenizer, token);
            }
            token = tokenizer.nextToken();
        }
        return null;
    }

    private static String computeErrorMessage(HtmlStreamTokenizer tokenizer, HtmlStreamTokenizer.Token token) throws IOException, ParseException {
        int tagDepth = 0;
        String errorMessage = "";
        token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                HtmlTag htmlTag = (HtmlTag)token.getValue();
                if (htmlTag.isEndTag()) {
                    if (--tagDepth < 0) {
                        break;
                    }
                } else {
                    ++tagDepth;
                }
            } else {
                errorMessage = String.valueOf(errorMessage) + token.toString();
            }
            token = tokenizer.nextToken();
        }
        errorMessage = errorMessage.replaceAll("\\s+", " ");
        return errorMessage;
    }

    private boolean isErrorMessageToken(HtmlStreamTokenizer.Token token) {
        HtmlTag ta;
        String st;
        return token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.TD && !((HtmlTag)token.getValue()).isEndTag() && (st = (ta = (HtmlTag)token.getValue()).getAttribute(KEY_ID)) != null && st.equals("error_msg");
    }

    /*
     * Exception decompiling
     */
    public boolean getSearchHits(IRepositoryQuery query, TaskDataCollector collector, TaskAttributeMapper mapper, IProgressMonitor monitor) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected RepositoryQueryResultsFactory getQueryResultsFactory(InputStream stream) {
        return new RepositoryQueryResultsFactory(stream, this.getCharacterEncoding());
    }

    public void setupExistingBugAttributes(String serverUrl, TaskData existingReport) {
        BugzillaAttribute element;
        BugzillaAttribute[] reportElements1 = new BugzillaAttribute[]{BugzillaAttribute.SHORT_DESC, BugzillaAttribute.BUG_STATUS, BugzillaAttribute.RESOLUTION, BugzillaAttribute.BUG_ID, BugzillaAttribute.REP_PLATFORM, BugzillaAttribute.PRODUCT, BugzillaAttribute.OP_SYS, BugzillaAttribute.COMPONENT, BugzillaAttribute.VERSION, BugzillaAttribute.PRIORITY, BugzillaAttribute.BUG_SEVERITY, BugzillaAttribute.ASSIGNED_TO};
        BugzillaAttribute[] reportElements2 = new BugzillaAttribute[]{BugzillaAttribute.REPORTER, BugzillaAttribute.DEPENDSON, BugzillaAttribute.BLOCKED, BugzillaAttribute.BUG_FILE_LOC, BugzillaAttribute.NEWCC, BugzillaAttribute.KEYWORDS, BugzillaAttribute.CC, BugzillaAttribute.NEW_COMMENT};
        TaskRepository taskRepository = existingReport.getAttributeMapper().getTaskRepository();
        BugzillaAttribute[] bugzillaAttributeArray = reportElements1;
        int n = reportElements1.length;
        int n2 = 0;
        while (n2 < n) {
            element = bugzillaAttributeArray[n2];
            BugzillaTaskDataHandler.createAttribute(existingReport, element);
            ++n2;
        }
        BugzillaUtil.addAttributeIfUsed(BugzillaAttribute.TARGET_MILESTONE, "bugzilla.param.usetargetmilestone", taskRepository, existingReport, true);
        bugzillaAttributeArray = reportElements2;
        n = reportElements2.length;
        n2 = 0;
        while (n2 < n) {
            element = bugzillaAttributeArray[n2];
            BugzillaTaskDataHandler.createAttribute(existingReport, element);
            ++n2;
        }
        BugzillaUtil.addAttributeIfUsed(BugzillaAttribute.QA_CONTACT, "bugzilla.param.useqacontact", taskRepository, existingReport, true);
        BugzillaUtil.addAttributeIfUsed(BugzillaAttribute.STATUS_WHITEBOARD, "bugzilla.param.usestatuswhiteboard", taskRepository, existingReport, true);
        BugzillaUtil.addAttributeIfUsed(BugzillaAttribute.ALIAS, "bugzilla.param.usebugaliases", taskRepository, existingReport, false);
        BugzillaUtil.addAttributeIfUsed(BugzillaAttribute.CLASSIFICATION, "bugzilla.param.use.classification", taskRepository, existingReport, false);
        BugzillaUtil.addAttributeIfUsed(BugzillaAttribute.SEE_ALSO, "bugzilla.param.use_see_also", taskRepository, existingReport, false);
        BugzillaUtil.addAttributeIfUsed(BugzillaAttribute.REMOVE_SEE_ALSO, "bugzilla.param.use_see_also", taskRepository, existingReport, false);
        BugzillaUtil.addAttributeIfUsed(BugzillaAttribute.SEE_ALSO_READ, "bugzilla.param.use_see_also", taskRepository, existingReport, false);
        if (this.repositoryConfiguration == null) {
            this.repositoryConfiguration = this.connector.getRepositoryConfiguration(serverUrl);
        }
        if (this.repositoryConfiguration != null) {
            for (BugzillaCustomField bugzillaCustomField : this.repositoryConfiguration.getCustomFields()) {
                existingReport.getRoot().createAttribute(bugzillaCustomField.getName());
            }
        }
    }

    public static String getBugUrlWithoutLogin(String repositoryUrl, String id) {
        String url = String.valueOf(repositoryUrl) + "/show_bug.cgi?id=" + id;
        return url;
    }

    public static String getCharsetFromString(String string) {
        int charsetStartIndex = string.indexOf(ATTR_CHARSET);
        if (charsetStartIndex != -1) {
            int charsetEndIndex = string.indexOf("\"", charsetStartIndex);
            if (charsetEndIndex == -1) {
                charsetEndIndex = string.length();
            }
            String charsetString = string.substring(charsetStartIndex + 8, charsetEndIndex);
            if (Charset.availableCharsets().containsKey(charsetString)) {
                return charsetString;
            }
        }
        return null;
    }

    @Deprecated
    public RepositoryConfiguration getRepositoryConfiguration(IProgressMonitor monitor) throws IOException, CoreException {
        return this.getRepositoryConfiguration(monitor, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RepositoryConfiguration getRepositoryConfiguration(IProgressMonitor monitor, String eTagValue) throws IOException, CoreException {
        method = null;
        attempt = 0;
        while (true) {
            block25: {
                block23: {
                    if (attempt >= 2) {
                        return null;
                    }
                    try {
                        method = this.getConnectGzip(this.repositoryUrl + "/config.cgi?ctype=rdf", monitor, eTagValue);
                        if (method == null) {
                            throw new IOException("Could not retrieve configuratoin. HttpClient return null method.");
                        }
                        stream = this.getResponseStream((HttpMethodBase)method, monitor);
                        try {
                            if (method.getResponseHeader("Content-Type") == null) ** GOTO lbl73
                            responseTypeHeader = method.getResponseHeader("Content-Type");
                            var10_10 = BugzillaClient.VALID_CONFIG_CONTENT_TYPES;
                            var9_9 = BugzillaClient.VALID_CONFIG_CONTENT_TYPES.length;
                            var8_8 = 0;
                            if (true) ** GOTO lbl41
                        }
                        catch (Throwable var15_16) {
                            stream.close();
                            throw var15_16;
                        }
lbl21:
                        // 1 sources

                        while (true) {
                            stream.close();
                            ++attempt;
                            if (method == null) break block23;
                            break;
                        }
                    }
                    catch (Throwable var17_17) {
                        ++attempt;
                        if (method != null) {
                            WebUtil.releaseConnection(method, (IProgressMonitor)monitor);
                        }
                        throw var17_17;
                    }
                    WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                }
                return var16_15;
                {
                    block24: {
                        while (true) {
                            if (attempt != 0) {
                                throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "No products found in repository configuration. Ensure credentials are valid."));
                            }
                            this.loggedIn = false;
                            break block24;
                            break;
                        }
                        while (true) {
                            ++var8_8;
lbl41:
                            // 2 sources

                            if (var8_8 >= var9_9) break block24;
                            type = var10_10[var8_8];
                            if (!responseTypeHeader.getValue().toLowerCase(Locale.ENGLISH).contains(type)) continue;
                            configFactory = new RepositoryConfigurationFactory(stream, this.getCharacterEncoding());
                            this.repositoryConfiguration = configFactory.getConfiguration();
                            eTag = method.getResponseHeader("ETag");
                            if (eTag != null) {
                                this.repositoryConfiguration.setETagValue(eTag.getValue());
                            } else {
                                this.repositoryConfiguration.setETagValue(null);
                            }
                            lastModifiedHeader = method.getResponseHeader("Last-Modified");
                            if (lastModifiedHeader != null) {
                                try {
                                    this.repositoryConfiguration.setLastModifiedHeader(DateUtil.parseDate((String)lastModifiedHeader.getValue()));
                                }
                                catch (DateParseException e) {
                                    this.repositoryConfiguration.setLastModifiedHeader(null);
                                }
                            } else {
                                this.repositoryConfiguration.setLastModifiedHeader(null);
                            }
                            if (this.repositoryConfiguration != null) break;
                        }
                        this.getXmlRpcClient();
                        if (this.xmlRpcClient != null) {
                            this.xmlRpcClient.updateConfiguration(monitor, this.repositoryConfiguration, this.configParameters.get("bugzilla.desciptorFile"));
                        } else {
                            this.repositoryConfiguration.setValidTransitions(monitor, this.configParameters.get("bugzilla.desciptorFile"), null);
                        }
                        if (!this.repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT).isEmpty()) {
                            this.repositoryConfiguration.setRepositoryUrl(this.repositoryUrl.toString());
                        }
                        if (this.repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT).isEmpty()) ** continue;
                        var16_15 = this.repositoryConfiguration;
                        ** continue;
                    }
                    if (!this.loggedIn) break block25;
                    throw new CoreException((IStatus)this.parseHtmlError(stream));
                }
            }
            stream.close();
            ++attempt;
            if (method == null) continue;
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    public InputStream getAttachmentData(String attachmentId, IProgressMonitor monitor) throws IOException, CoreException {
        Status status;
        block12: {
            GzipGetMethod method;
            block10: {
                block9: {
                    InputStream inputStream;
                    block11: {
                        String url = this.repositoryUrl + "/attachment.cgi?id=" + attachmentId;
                        method = this.getConnect(url, monitor);
                        status = null;
                        if (method.getStatusCode() != 200) break block9;
                        Header contentDisposition = method.getResponseHeader("Content-disposition");
                        if (contentDisposition == null) {
                            status = this.parseHtmlError(method.getResponseBodyAsStream());
                            break block10;
                        }
                        inputStream = method.getResponseBodyAsStream();
                        if (status == null) break block11;
                        WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                        throw new CoreException((IStatus)status);
                    }
                    return inputStream;
                }
                try {
                    try {
                        status = this.parseHtmlError(method.getResponseBodyAsStream());
                    }
                    catch (Exception e) {
                        status = new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to retrieve attachment", (Throwable)e);
                        if (status != null) {
                            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                            throw new CoreException((IStatus)status);
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (status != null) {
                        WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                        throw new CoreException((IStatus)status);
                    }
                    throw throwable;
                }
            }
            if (status != null) {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                throw new CoreException((IStatus)status);
            }
        }
        throw new CoreException((IStatus)status);
    }

    private String getCharacterEncoding() {
        if (this.repositoryConfiguration != null && this.repositoryConfiguration.getEncoding() != null && this.repositoryConfiguration.getEncoding().length() > 0) {
            return this.repositoryConfiguration.getEncoding();
        }
        return this.characterEncoding;
    }

    public void postAttachment(String bugReportID, String comment, AbstractTaskAttachmentSource source, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws HttpException, IOException, CoreException {
        GzipPostMethod postMethod;
        block28: {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            String description = source.getDescription();
            String contentType = source.getContentType();
            String filename = source.getName();
            boolean isPatch = false;
            if (attachmentAttribute != null) {
                TaskAttachmentMapper mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
                if (mapper.getDescription() != null) {
                    description = mapper.getDescription();
                }
                if (mapper.getContentType() != null) {
                    contentType = mapper.getContentType();
                }
                if (mapper.getFileName() != null) {
                    filename = mapper.getFileName();
                }
                if (mapper.isPatch() != null) {
                    isPatch = mapper.isPatch();
                }
            }
            Assert.isNotNull((Object)bugReportID);
            Assert.isNotNull((Object)source);
            Assert.isNotNull((Object)contentType);
            if (description == null) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", Messages.BugzillaClient_description_required_when_submitting_attachments));
            }
            this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
            this.authenticate(monitor);
            postMethod = null;
            try {
                postMethod = new GzipPostMethod(WebUtil.getRequestPath((String)(this.repositoryUrl + PROCESS_ATTACHMENT_CGI)), true);
                postMethod.getParams().setBooleanParameter("http.protocol.expect-continue", true);
                ArrayList<Object> parts = new ArrayList<Object>();
                parts.add(new StringPart("action", VALUE_ACTION_INSERT, this.getCharacterEncoding()));
                parts.add(new StringPart("bugid", bugReportID, this.getCharacterEncoding()));
                if (description != null) {
                    parts.add(new StringPart("description", description, this.getCharacterEncoding()));
                }
                if (comment != null) {
                    parts.add(new StringPart(KEY_COMMENT, comment, this.getCharacterEncoding()));
                }
                parts.add((Object)new BugzillaFilePart(source, filename, contentType, this.getCharacterEncoding()));
                if (isPatch) {
                    parts.add(new StringPart(ATTRIBUTE_ISPATCH, VALUE_ISPATCH));
                } else {
                    parts.add(new StringPart(ATTRIBUTE_CONTENTTYPEMETHOD, VALUE_CONTENTTYPEMETHOD_MANUAL));
                    parts.add(new StringPart(ATTRIBUTE_CONTENTTYPEENTRY, contentType));
                }
                if (attachmentAttribute != null) {
                    Collection attributes = attachmentAttribute.getAttributes().values();
                    for (TaskAttribute a : attributes) {
                        TaskAttribute requestee;
                        if (a.getId().startsWith("task.common.kind.flag_type") && this.repositoryConfiguration != null) {
                            List<BugzillaFlag> flags = this.repositoryConfiguration.getFlags();
                            requestee = a.getAttribute("requestee");
                            a = a.getAttribute("state");
                            String value = a.getValue();
                            String id = "";
                            if (value.equals(" ")) continue;
                            String flagname = a.getMetaData().getLabel();
                            BugzillaFlag theFlag = null;
                            for (BugzillaFlag bugzillaFlag : flags) {
                                if (!flagname.equals(bugzillaFlag.getName())) continue;
                                theFlag = bugzillaFlag;
                                break;
                            }
                            if (theFlag != null) {
                                int flagTypeNumber = theFlag.getFlagId();
                                id = "flag_type-" + flagTypeNumber;
                                value = a.getValue();
                                if (value.equals(QUERY_DELIMITER) && requestee != null) {
                                    parts.add(new StringPart("requestee_type-" + flagTypeNumber, requestee.getValue() != null ? requestee.getValue() : ""));
                                }
                            }
                            parts.add(new StringPart(id, value != null ? value : ""));
                            continue;
                        }
                        if (!a.getId().startsWith("task.common.kind.flag")) continue;
                        TaskAttribute flagnumber = a.getAttribute("number");
                        requestee = a.getAttribute("requestee");
                        a = a.getAttribute("state");
                        String id = "flag-" + flagnumber.getValue();
                        String value = a.getValue();
                        if (value.equals(" ") || value.equals("")) {
                            value = "X";
                        }
                        if (value.equals(QUERY_DELIMITER) && requestee != null) {
                            parts.add(new StringPart("requestee-" + flagnumber.getValue(), requestee.getValue() != null ? requestee.getValue() : ""));
                        }
                        parts.add(new StringPart(id, value != null ? value : ""));
                    }
                }
                String token = null;
                BugzillaVersion bugzillaVersion = null;
                bugzillaVersion = this.repositoryConfiguration != null ? this.repositoryConfiguration.getInstallVersion() : BugzillaVersion.MIN_VERSION;
                if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) > 0) {
                    token = this.getTokenInternal(this.repositoryUrl + ENTER_ATTACHMENT_CGI + bugReportID, monitor);
                }
                if (token != null) {
                    parts.add(new StringPart(BugzillaAttribute.TOKEN.getKey(), token));
                }
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[1]), postMethod.getParams()));
                postMethod.setDoAuthentication(true);
                int status = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)postMethod, (IProgressMonitor)monitor);
                if (status == 200) {
                    try (InputStream input = this.getResponseStream((HttpMethodBase)postMethod, monitor);){
                        this.parsePostResponse(bugReportID, input);
                        break block28;
                    }
                }
                WebUtil.releaseConnection((HttpMethodBase)postMethod, (IProgressMonitor)monitor);
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, this.repositoryUrl.toString(), "Http error: " + HttpStatus.getStatusText((int)status)));
            }
            catch (Throwable throwable) {
                if (postMethod != null) {
                    WebUtil.releaseConnection(postMethod, (IProgressMonitor)monitor);
                }
                throw throwable;
            }
        }
        if (postMethod != null) {
            WebUtil.releaseConnection((HttpMethodBase)postMethod, (IProgressMonitor)monitor);
        }
    }

    private GzipPostMethod postFormData(String formUrl, NameValuePair[] formData, IProgressMonitor monitor) throws IOException, CoreException {
        Header locationHeader;
        GzipPostMethod postMethod = null;
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        this.authenticate(monitor);
        postMethod = new GzipPostMethod(WebUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl.toString()) + formUrl)), true);
        postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.getCharacterEncoding());
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(WebUtil.getConnectionTimeout());
        postMethod.setRequestBody(formData);
        postMethod.setDoAuthentication(true);
        int status = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)postMethod, (IProgressMonitor)monitor);
        if (status == 200) {
            return postMethod;
        }
        if (status == 302 && (locationHeader = postMethod.getResponseHeader("location")) != null) {
            String redirectLocation = locationHeader.getValue();
            if (!redirectLocation.startsWith("http")) {
                redirectLocation = String.valueOf(this.location.getUrl()) + "/" + redirectLocation;
            }
            WebUtil.releaseConnection((HttpMethodBase)postMethod, (IProgressMonitor)monitor);
            throw new RedirectException(redirectLocation);
        }
        WebUtil.releaseConnection((HttpMethodBase)postMethod, (IProgressMonitor)monitor);
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), new IOException("Communication error occurred during upload. \n\n" + HttpStatus.getStatusText((int)status))));
    }

    public void postUpdateAttachment(TaskAttribute taskAttribute, String action, IProgressMonitor monitor) throws IOException, CoreException {
        ArrayList<NameValuePair> formData = new ArrayList<NameValuePair>(5);
        formData.add(new NameValuePair("action", action));
        formData.add(new NameValuePair(ATTRIBUTE_CONTENTTYPEMETHOD, VALUE_CONTENTTYPEMETHOD_MANUAL));
        formData.add(new NameValuePair(KEY_ID, taskAttribute.getValue()));
        Collection attributes = taskAttribute.getAttributes().values();
        for (TaskAttribute attrib : attributes) {
            String id = attrib.getId();
            if (id.equals(BugzillaAttribute.DELTA_TS.getKey())) continue;
            String value = attrib.getValue();
            if (id.equals("task.common.attachment.author") || id.equals("date") || id.equals("size") || id.equals("task.common.attachment.url")) continue;
            if (id.equals("desc")) {
                id = "description";
            }
            if (id.equals("ctype")) {
                id = ATTRIBUTE_CONTENTTYPEENTRY;
            }
            if (id.equals("task.common.attachment.deprecated")) {
                id = "isobsolete";
            }
            if (id.equals("task.common.attachment.patch")) {
                id = ATTRIBUTE_ISPATCH;
            }
            if (id.startsWith("task.common.kind.flag_type")) {
                requestee = attrib.getAttribute("requestee");
                state = attrib.getAttribute("state");
                requesteeName = "requestee_type-" + id.substring(26);
                requesteeValue = requestee.getValue();
                value = state.getValue();
                if (value.equals(" ") || value.equals("")) {
                    value = "X";
                }
                if (value.equals(QUERY_DELIMITER)) {
                    formData.add(new NameValuePair(requesteeName, requesteeValue));
                }
                id = "flag_type-" + id.substring(26);
            } else if (id.startsWith("task.common.kind.flag")) {
                requestee = attrib.getAttribute("requestee");
                state = attrib.getAttribute("state");
                requesteeName = "requestee-" + id.substring(21);
                requesteeValue = requestee.getValue();
                value = state.getValue();
                if (value.equals(" ") || value.equals("")) {
                    value = "X";
                }
                if (value.equals(QUERY_DELIMITER)) {
                    formData.add(new NameValuePair(requesteeName, requesteeValue));
                }
                id = "flag-" + id.substring(21);
            }
            if (value.equals("")) continue;
            formData.add(new NameValuePair(id, value));
        }
        GzipPostMethod method = null;
        InputStream input = null;
        try {
            method = this.postFormData(PROCESS_ATTACHMENT_CGI, formData.toArray(new NameValuePair[formData.size()]), monitor);
            if (method == null) {
                throw new IOException(Messages.BugzillaClient_could_not_post_form_null_returned);
            }
            input = this.getResponseStream((HttpMethodBase)method, monitor);
            this.parsePostResponse(taskAttribute.getTaskData().getTaskId(), input);
        }
        catch (Throwable throwable) {
            if (input != null) {
                input.close();
            }
            if (method != null) {
                WebUtil.releaseConnection(method, (IProgressMonitor)monitor);
            }
            throw throwable;
        }
        if (input != null) {
            input.close();
        }
        if (method != null) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    public RepositoryResponse postTaskData(TaskData taskData, IProgressMonitor monitor) throws IOException, CoreException {
        try {
            return this.postTaskDataInternal(taskData, monitor);
        }
        catch (CoreException e) {
            TaskAttribute qaContact = taskData.getRoot().getAttribute(BugzillaAttribute.QA_CONTACT.getKey());
            if (qaContact != null) {
                String qaContactValue = qaContact.getValue();
                String message = e.getMessage();
                if ("An unknown repository error has occurred: Bugzilla/Bug.pm line".equals(message) && qaContactValue != null && !qaContactValue.equals("") && e.getStatus() instanceof RepositoryStatus) {
                    RepositoryStatus repositoryStatus = (RepositoryStatus)e.getStatus();
                    RepositoryStatus status = RepositoryStatus.createHtmlStatus((String)repositoryStatus.getRepositoryUrl(), (int)1, (String)"org.eclipse.mylyn.bugzilla", (int)1, (String)"Error may result when QAContact field not enabled.", (String)repositoryStatus.getHtmlMessage());
                    throw new CoreException((IStatus)status);
                }
            }
            if (e.getStatus().getCode() == 3) {
                return this.postTaskDataInternal(taskData, monitor);
            }
            if (e.getStatus().getCode() == 99) {
                taskData.getRoot().removeAttribute(BugzillaAttribute.TOKEN.getKey());
                return this.postTaskDataInternal(taskData, monitor);
            }
            throw e;
        }
    }

    private String getTokenInternal(String bugUrl, IProgressMonitor monitor) throws IOException, CoreException {
        String tokenValue = null;
        if (!this.loggedIn) {
            this.authenticate((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        GzipGetMethod getMethod = new GzipGetMethod(WebUtil.getRequestPath((String)bugUrl), false);
        getMethod.setRequestHeader("Content-Type", "text/xml; charset=" + this.getCharacterEncoding());
        this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        getMethod.setDoAuthentication(true);
        InputStream inStream = null;
        try {
            try {
                int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)getMethod, (IProgressMonitor)monitor);
                if (code == 200) {
                    inStream = this.getResponseStream((HttpMethodBase)getMethod, monitor);
                    HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)new BufferedReader(new InputStreamReader(inStream, this.getCharacterEncoding())), null);
                    HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                    while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                        if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.INPUT && !((HtmlTag)token.getValue()).isEndTag()) {
                            HtmlTag tag = (HtmlTag)token.getValue();
                            String name = tag.getAttribute("name");
                            String value = tag.getAttribute("value");
                            if (name != null && name.equalsIgnoreCase(BugzillaAttribute.TOKEN.getKey()) && value != null && value.length() > 0 && tokenValue == null) {
                                tokenValue = value;
                            }
                        }
                        token = tokenizer.nextToken();
                    }
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to retrieve group security information", (Throwable)e));
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
        }
        return tokenValue;
    }

    public RepositoryResponse postTaskDataInternal(TaskData taskData, IProgressMonitor monitor) throws IOException, CoreException {
        NameValuePair[] formData = null;
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        this.authenticate((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (this.repositoryConfiguration == null) {
            this.getRepositoryConfiguration((IProgressMonitor)new SubProgressMonitor(monitor, 1), null);
            this.connector.addRepositoryConfiguration(this.repositoryConfiguration);
        }
        if (taskData == null) {
            return null;
        }
        if (taskData.isNew()) {
            String token = null;
            BugzillaVersion bugzillaVersion = null;
            bugzillaVersion = this.repositoryConfiguration != null ? this.repositoryConfiguration.getInstallVersion() : BugzillaVersion.MIN_VERSION;
            if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) > 0) {
                TaskAttribute productAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.PRODUCT.getKey());
                token = this.getTokenInternal(String.valueOf(taskData.getRepositoryUrl()) + ENTER_BUG_PRODUCT_CGI + URLEncoder.encode(productAttribute.getValue(), "UTF-8"), monitor);
            }
            formData = this.getPairsForNew(taskData, token);
        } else {
            formData = this.getPairsForExisting(taskData, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        GzipPostMethod method = null;
        InputStream input = null;
        try {
            BugzillaRepositoryResponse response;
            method = taskData.isNew() ? this.postFormData(POST_BUG_CGI, formData, monitor) : this.postFormData(PROCESS_BUG_CGI, formData, monitor);
            if (method == null) {
                throw new IOException("Could not post form, client returned null method.");
            }
            input = this.getResponseStream((HttpMethodBase)method, monitor);
            BugzillaRepositoryResponse bugzillaRepositoryResponse = response = this.parsePostResponse(taskData.getTaskId(), input);
            return bugzillaRepositoryResponse;
        }
        catch (CoreException e) {
            throw e;
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (method != null) {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            }
        }
    }

    private NameValuePair[] getPairsForNew(TaskData taskData, String token) {
        HashMap<String, NameValuePair> fields = new HashMap<String, NameValuePair>();
        if (token != null) {
            fields.put(BugzillaAttribute.TOKEN.getKey(), new NameValuePair(BugzillaAttribute.TOKEN.getKey(), token));
        }
        BugzillaVersion bugzillaVersion = null;
        bugzillaVersion = this.repositoryConfiguration != null ? this.repositoryConfiguration.getInstallVersion() : BugzillaVersion.MIN_VERSION;
        ArrayList attributes = new ArrayList(taskData.getRoot().getAttributes().values());
        for (TaskAttribute a : attributes) {
            if (a == null || a.getId() == null || a.getId().compareTo("") == 0) continue;
            String value = null;
            value = a.getValue();
            if (value == null) continue;
            String id = a.getId();
            if (id.equals(BugzillaAttribute.BUG_STATUS.getKey()) && bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) >= 0 && (this.repositoryConfiguration.getOptionValues(BugzillaAttribute.BUG_STATUS).contains(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.IN_PROGRESS.toString()) || this.repositoryConfiguration.getOptionValues(BugzillaAttribute.BUG_STATUS).contains(IBugzillaConstants.BUGZILLA_REPORT_STATUS_4_0.CONFIRMED.toString()))) {
                TaskAttribute attributeOperation = taskData.getRoot().getMappedAttribute("task.common.operation");
                value = attributeOperation.getValue().toUpperCase();
                if (BugzillaOperation.new_default.toString().toUpperCase().equals(value)) continue;
                fields.put(id, new NameValuePair(id, value != null ? value : ""));
            }
            if (id.equals(BugzillaAttribute.NEWCC.getKey())) {
                TaskAttribute b = taskData.getRoot().createAttribute(BugzillaAttribute.CC.getKey());
                b.getMetaData().defaults().setReadOnly(BugzillaAttribute.CC.isReadOnly()).setKind(BugzillaAttribute.CC.getKind()).setLabel(BugzillaAttribute.CC.toString()).setType(BugzillaAttribute.CC.getType());
                for (String val : a.getValues()) {
                    if (val == null) continue;
                    b.addValue(val);
                }
                a = b;
                id = a.getId();
                this.cleanIfShortLogin(a);
            } else {
                this.cleanQAContact(a);
            }
            if (a.getMetaData().getType() != null && a.getMetaData().getType().equals("multiSelect")) {
                List values = a.getValues();
                int i = 0;
                for (String string : values) {
                    fields.put(String.valueOf(id) + i++, new NameValuePair(id, string != null ? string : ""));
                }
                continue;
            }
            if (id == null || id.compareTo("") == 0) continue;
            fields.put(id, new NameValuePair(id, value != null ? value : ""));
        }
        TaskAttribute descAttribute = taskData.getRoot().getMappedAttribute("task.common.description");
        if (descAttribute != null && !descAttribute.getValue().equals("")) {
            if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_18) == 0) {
                fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, BugzillaClient.formatTextToLineWrap(descAttribute.getValue(), true)));
            } else {
                fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, descAttribute.getValue()));
            }
        }
        return fields.values().toArray(new NameValuePair[fields.size()]);
    }

    private void cleanQAContact(TaskAttribute a) {
        if (a.getId().equals(BugzillaAttribute.QA_CONTACT.getKey())) {
            this.cleanIfShortLogin(a);
        }
    }

    private void cleanIfShortLogin(TaskAttribute a) {
        int atIndex;
        if (VAL_TRUE.equals(this.configParameters.get("bugzilla.shortLoginEnabled")) && a.getValue() != null && a.getValue().length() > 0 && (atIndex = a.getValue().indexOf("@")) != -1) {
            String newValue = a.getValue().substring(0, atIndex);
            a.setValue(newValue);
        }
    }

    private NameValuePair[] getPairsForExisting(TaskData model, IProgressMonitor monitor) throws CoreException {
        TaskAttribute attributeRemoveSeeAlso;
        List removeCC;
        TaskAttribute attributeRemoveCC;
        boolean groupSecurityEnabled = false;
        HashMap<String, NameValuePair> fields = new HashMap<String, NameValuePair>();
        fields.put(KEY_FORM_NAME, new NameValuePair(KEY_FORM_NAME, VAL_PROCESS_BUG));
        Collection attributes = model.getRoot().getAttributes().values();
        Iterator itr = attributes.iterator();
        boolean tokenFound = false;
        boolean tokenRequired = false;
        BugzillaVersion bugzillaVersion = null;
        bugzillaVersion = this.repositoryConfiguration != null ? this.repositoryConfiguration.getInstallVersion() : BugzillaVersion.MIN_VERSION;
        while (itr.hasNext()) {
            TaskAttribute a = (TaskAttribute)itr.next();
            if (a == null) continue;
            String id = a.getId();
            if (id.equalsIgnoreCase(BugzillaAttribute.TOKEN.getKey())) {
                tokenFound = true;
            } else if (id.equals(BugzillaAttribute.QA_CONTACT.getKey()) || id.equals(BugzillaAttribute.ASSIGNED_TO.getKey())) {
                this.cleanIfShortLogin(a);
            } else {
                if (id.equals(BugzillaAttribute.REPORTER.getKey()) || id.equals(BugzillaAttribute.CC.getKey()) || id.equals(BugzillaAttribute.REMOVECC.getKey()) || id.equals(BugzillaAttribute.REMOVE_SEE_ALSO.getKey()) || id.equals(BugzillaAttribute.SEE_ALSO_READ.getKey()) || id.equals(BugzillaAttribute.CREATION_TS.getKey()) || id.equals(BugzillaAttribute.BUG_STATUS.getKey()) || id.equals(BugzillaAttribute.VOTES.getKey())) continue;
                if (id.equals(BugzillaAttribute.NEW_COMMENT.getKey())) {
                    if (bugzillaVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_2_18) == 0) {
                        a.setValue(BugzillaClient.formatTextToLineWrap(a.getValue(), true));
                    }
                } else if (id.equals(BugzillaAttribute.GROUP.getKey()) && a.getValue().length() > 0) {
                    groupSecurityEnabled = true;
                }
            }
            if (a.getMetaData().getType() != null && a.getMetaData().getType().equals("multiSelect")) {
                List values = a.getValues();
                int i = 0;
                for (String string : values) {
                    fields.put(String.valueOf(id) + i++, new NameValuePair(id, string != null ? string : ""));
                }
                continue;
            }
            if (id == null || id.compareTo("") == 0) continue;
            String value = a.getValue();
            if (id.equals(BugzillaAttribute.DELTA_TS.getKey()) && (bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_4_7) < 0 || bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_5) >= 0 && bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_6) < 0)) {
                value = BugzillaClient.stripTimeZone(value);
            }
            if (id.startsWith("task.common.kind.flag_type") && this.repositoryConfiguration != null) {
                List<BugzillaFlag> flags = this.repositoryConfiguration.getFlags();
                requestee = a.getAttribute("requestee");
                value = (a = a.getAttribute("state")).getValue();
                if (value.equals(" ") || value.equals("")) continue;
                String flagname = a.getMetaData().getLabel();
                BugzillaFlag theFlag = null;
                for (BugzillaFlag bugzillaFlag : flags) {
                    if (!flagname.equals(bugzillaFlag.getName()) || !bugzillaFlag.getType().equals("bug")) continue;
                    theFlag = bugzillaFlag;
                    break;
                }
                if (theFlag != null) {
                    int flagTypeNumber = theFlag.getFlagId();
                    id = "flag_type-" + flagTypeNumber;
                    value = a.getValue();
                    if (value.equals(QUERY_DELIMITER) && requestee != null) {
                        fields.put("requestee_type-" + flagTypeNumber, new NameValuePair("requestee_type-" + flagTypeNumber, requestee.getValue() != null ? requestee.getValue() : ""));
                    }
                }
            } else if (id.startsWith("task.common.kind.flag")) {
                TaskAttribute flagnumber = a.getAttribute("number");
                requestee = a.getAttribute("requestee");
                a = a.getAttribute("state");
                id = "flag-" + flagnumber.getValue();
                value = a.getValue();
                if (value.equals(" ") || value.equals("")) {
                    value = "X";
                }
                if (value.equals(QUERY_DELIMITER) && requestee != null) {
                    fields.put("requestee-" + flagnumber.getValue(), new NameValuePair("requestee-" + flagnumber.getValue(), requestee.getValue() != null ? requestee.getValue() : ""));
                }
            } else {
                if (id.startsWith("task.common.comment-")) {
                    String valueID = a.getValue();
                    TaskAttribute definedIsPrivate = a.getAttribute("defined_isprivate_" + valueID);
                    TaskAttribute isPrivate = a.getAttribute("isprivate_" + valueID);
                    if (definedIsPrivate == null || isPrivate == null) continue;
                    fields.put(definedIsPrivate.getId(), new NameValuePair(definedIsPrivate.getId(), definedIsPrivate.getValue() != null ? definedIsPrivate.getValue() : ""));
                    fields.put(isPrivate.getId(), new NameValuePair(isPrivate.getId(), isPrivate.getValue() != null ? isPrivate.getValue() : ""));
                    continue;
                }
                if (id.compareTo(BugzillaAttribute.LONG_DESC.getKey()) == 0) {
                    TaskAttribute idAttribute = a.getAttribute(KEY_ID);
                    if (idAttribute != null) {
                        String valueID = idAttribute.getValue();
                        TaskAttribute definedIsPrivate = a.getAttribute("defined_isprivate_" + valueID);
                        TaskAttribute isPrivate = a.getAttribute("isprivate_" + valueID);
                        if (definedIsPrivate != null && isPrivate != null) {
                            fields.put(definedIsPrivate.getId(), new NameValuePair(definedIsPrivate.getId(), definedIsPrivate.getValue() != null ? definedIsPrivate.getValue() : ""));
                            fields.put(isPrivate.getId(), new NameValuePair(isPrivate.getId(), isPrivate.getValue() != null ? isPrivate.getValue() : ""));
                        }
                    }
                } else if (id.startsWith("task.common.")) continue;
            }
            if (id.equals(BugzillaAttribute.DELTA_TS.getKey())) {
                value = BugzillaUtil.removeTimezone(value);
            }
            fields.put(id, new NameValuePair(id, value != null ? value : ""));
        }
        TaskAttribute attributeBugId = model.getRoot().getAttribute(BugzillaAttribute.BUG_ID.getKey());
        if (attributeBugId != null) {
            fields.put(KEY_ID, new NameValuePair(KEY_ID, attributeBugId.getValue()));
        }
        if (bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_2) < 0) {
            TaskAttribute attributeOperation = model.getRoot().getMappedAttribute("task.common.operation");
            if (attributeOperation == null) {
                fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, VAL_NONE));
            } else {
                TaskAttribute originalOperation = model.getRoot().getAttribute("task.common.operation-" + attributeOperation.getValue());
                if (originalOperation == null) {
                    fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, VAL_NONE));
                } else {
                    String inputAttributeId = originalOperation.getMetaData().getValue("task.meta.associated.attribute");
                    if (inputAttributeId == null || inputAttributeId.equals("")) {
                        String sel = attributeOperation.getValue();
                        fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, sel));
                    } else {
                        fields.put(KEY_KNOB, new NameValuePair(KEY_KNOB, attributeOperation.getValue()));
                        TaskAttribute inputAttribute = attributeOperation.getTaskData().getRoot().getAttribute(inputAttributeId);
                        if (inputAttribute != null) {
                            if (inputAttribute.getOptions().size() > 0) {
                                sel = inputAttribute.getValue();
                                knob = inputAttribute.getId();
                                if (knob.equals(BugzillaOperation.resolve.getInputId()) || knob.equals(BugzillaOperation.close_with_resolution.getInputId())) {
                                    knob = BugzillaAttribute.RESOLUTION.getKey();
                                }
                                fields.put(knob, new NameValuePair(knob, inputAttribute.getOption(sel)));
                            } else {
                                sel = inputAttribute.getValue();
                                knob = attributeOperation.getValue();
                                if (knob.equals(BugzillaOperation.reassign.toString())) {
                                    knob = BugzillaAttribute.ASSIGNED_TO.getKey();
                                }
                                fields.put(knob, new NameValuePair(knob, sel));
                            }
                        }
                    }
                }
                if (model.getRoot().getMappedAttribute("task.common.comment.new") != null && model.getRoot().getMappedAttribute("task.common.comment.new").getValue().length() > 0) {
                    fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, model.getRoot().getMappedAttribute("task.common.comment.new").getValue()));
                } else if (attributeOperation != null && attributeOperation.getValue().equals(BugzillaOperation.duplicate.toString())) {
                    fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, ""));
                }
            }
        } else {
            tokenRequired = bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_2) > 0;
            String fieldName = BugzillaAttribute.BUG_STATUS.getKey();
            TaskAttribute attributeStatus = model.getRoot().getMappedAttribute("task.common.status");
            TaskAttribute attributeOperation = model.getRoot().getMappedAttribute("task.common.operation");
            if (attributeOperation == null) {
                fields.put(fieldName, new NameValuePair(fieldName, attributeStatus.getValue()));
            } else {
                TaskAttribute originalOperation = model.getRoot().getAttribute("task.common.operation-" + attributeOperation.getValue());
                if (originalOperation == null) {
                    fields.put(fieldName, new NameValuePair(fieldName, attributeStatus.getValue()));
                } else {
                    TaskAttribute inputAttribute;
                    String inputAttributeId = originalOperation.getMetaData().getValue("task.meta.associated.attribute");
                    String selOp = attributeOperation.getValue().toUpperCase();
                    if (selOp.equals("NONE")) {
                        selOp = attributeStatus.getValue();
                    }
                    if (selOp.equals("ACCEPT")) {
                        selOp = "ASSIGNED";
                    }
                    if (selOp.equals("RESOLVE")) {
                        selOp = "RESOLVED";
                    }
                    if (selOp.equals("VERIFY")) {
                        selOp = "VERIFIED";
                    }
                    if (selOp.equals("CLOSE")) {
                        selOp = "CLOSED";
                    }
                    if (selOp.equals("REOPEN")) {
                        selOp = "REOPENED";
                    }
                    if (selOp.equals("MARKNEW")) {
                        selOp = "NEW";
                    }
                    if (selOp.equals("DUPLICATE")) {
                        selOp = this.repositoryConfiguration != null ? this.repositoryConfiguration.getDuplicateStatus() : "RESOLVED";
                        String knob = BugzillaAttribute.RESOLUTION.getKey();
                        fields.put(knob, new NameValuePair(knob, "DUPLICATE"));
                    }
                    fields.put(fieldName, new NameValuePair(fieldName, selOp));
                    if (inputAttributeId != null && !inputAttributeId.equals("") && (inputAttribute = attributeOperation.getTaskData().getRoot().getAttribute(inputAttributeId)) != null) {
                        if (inputAttribute.getOptions().size() > 0) {
                            sel = inputAttribute.getValue();
                            knob = inputAttribute.getId();
                            if (knob.equals(BugzillaOperation.resolve.getInputId())) {
                                knob = BugzillaAttribute.RESOLUTION.getKey();
                            }
                            fields.put(knob, new NameValuePair(knob, inputAttribute.getOption(sel)));
                        } else {
                            sel = inputAttribute.getValue();
                            knob = attributeOperation.getValue();
                            if (knob.equals(BugzillaOperation.duplicate.toString())) {
                                knob = inputAttributeId;
                            }
                            if (knob.equals(BugzillaOperation.reassign.toString())) {
                                knob = BugzillaAttribute.ASSIGNED_TO.getKey();
                            }
                            fields.put(knob, new NameValuePair(knob, sel));
                        }
                    }
                }
            }
            if (model.getRoot().getMappedAttribute("task.common.comment.new") != null && model.getRoot().getMappedAttribute("task.common.comment.new").getValue().length() > 0) {
                fields.put(KEY_COMMENT, new NameValuePair(KEY_COMMENT, model.getRoot().getMappedAttribute("task.common.comment.new").getValue()));
            }
        }
        if (model.getRoot().getMappedAttribute(BugzillaAttribute.SHORT_DESC.getKey()) != null) {
            fields.put(KEY_SHORT_DESC, new NameValuePair(KEY_SHORT_DESC, model.getRoot().getMappedAttribute(BugzillaAttribute.SHORT_DESC.getKey()).getValue()));
        }
        if ((attributeRemoveCC = model.getRoot().getMappedAttribute(BugzillaAttribute.REMOVECC.getKey())) != null && (removeCC = attributeRemoveCC.getValues()) != null && removeCC.size() > 0) {
            String[] s = new String[removeCC.size()];
            fields.put(KEY_CC, new NameValuePair(KEY_CC, BugzillaClient.toCommaSeparatedList(removeCC.toArray(s))));
            fields.put(BugzillaAttribute.REMOVECC.getKey(), new NameValuePair(BugzillaAttribute.REMOVECC.getKey(), VAL_TRUE));
        }
        if ((attributeRemoveSeeAlso = model.getRoot().getMappedAttribute(BugzillaAttribute.REMOVE_SEE_ALSO.getKey())) != null) {
            List removeSeeAlso = attributeRemoveSeeAlso.getValues();
            int idx = 0;
            for (String string : removeSeeAlso) {
                fields.put(String.valueOf(BugzillaAttribute.REMOVE_SEE_ALSO.getKey()) + idx++, new NameValuePair(BugzillaAttribute.REMOVE_SEE_ALSO.getKey(), string));
            }
        }
        if (groupSecurityEnabled || !tokenFound && tokenRequired) {
            HtmlInformation htmlInfo = this.getHtmlOnlyInformation(model, monitor);
            if (groupSecurityEnabled) {
                for (String key : htmlInfo.getGroups().keySet()) {
                    fields.put(key, new NameValuePair(key, htmlInfo.getGroups().get(key)));
                }
            }
            if (htmlInfo.getToken() != null && htmlInfo.getToken().length() > 0 && tokenRequired) {
                NameValuePair tokenPair = (NameValuePair)fields.get(BugzillaAttribute.TOKEN.getKey());
                if (tokenPair != null) {
                    tokenPair.setValue(htmlInfo.getToken());
                } else {
                    fields.put(BugzillaAttribute.TOKEN.getKey(), new NameValuePair(BugzillaAttribute.TOKEN.getKey(), htmlInfo.getToken()));
                }
            }
        }
        return fields.values().toArray(new NameValuePair[fields.size()]);
    }

    private HtmlInformation getHtmlOnlyInformation(TaskData taskData, IProgressMonitor monitor) throws CoreException {
        HtmlInformation htmlInfo = new HtmlInformation();
        this.authenticate((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        String bugUrl = String.valueOf(taskData.getRepositoryUrl()) + "/show_bug.cgi?id=" + taskData.getTaskId();
        GzipGetMethod getMethod = new GzipGetMethod(WebUtil.getRequestPath((String)bugUrl), false);
        getMethod.setRequestHeader("Content-Type", "text/xml; charset=" + this.getCharacterEncoding());
        this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        getMethod.setDoAuthentication(true);
        InputStream inStream = null;
        try {
            try {
                int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)getMethod, (IProgressMonitor)monitor);
                if (code == 200) {
                    inStream = this.getResponseStream((HttpMethodBase)getMethod, monitor);
                    HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)new BufferedReader(new InputStreamReader(inStream, this.getCharacterEncoding())), null);
                    String formName = null;
                    HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                    while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                        if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.FORM && !((HtmlTag)token.getValue()).isEndTag()) {
                            tag = (HtmlTag)token.getValue();
                            formName = tag.getAttribute("name");
                        } else if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.INPUT && !((HtmlTag)token.getValue()).isEndTag()) {
                            tag = (HtmlTag)token.getValue();
                            String id = tag.getAttribute(KEY_ID);
                            String checkedValue = tag.getAttribute("checked");
                            String type = tag.getAttribute("type");
                            String name = tag.getAttribute("name");
                            String value = tag.getAttribute("value");
                            if (type != null && type.equalsIgnoreCase("checkbox") && id != null && id.startsWith("bit-")) {
                                htmlInfo.getGroups().put(id, checkedValue);
                            } else if (name != null && name.equalsIgnoreCase(BugzillaAttribute.TOKEN.getKey()) && value != null && value.length() > 0 && formName != null && formName.equals("changeform")) {
                                htmlInfo.setToken(value);
                            }
                        }
                        token = tokenizer.nextToken();
                    }
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Unable to retrieve group security information", (Throwable)e));
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            WebUtil.releaseConnection((HttpMethodBase)getMethod, (IProgressMonitor)monitor);
        }
        return htmlInfo;
    }

    public static String stripTimeZone(String longTime) {
        String[] values;
        String result = longTime;
        if (longTime != null && (values = longTime.split(" ")) != null && values.length > 2) {
            result = String.valueOf(values[0]) + " " + values[1];
        }
        return result;
    }

    private static String toCommaSeparatedList(String[] strings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buffer.append(strings[i]);
            if (i != strings.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private Status parseHtmlError(InputStream inputStream) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, this.getCharacterEncoding()));
            this.parseRepositoryResponse(null, in);
            return new Status(4, "org.eclipse.mylyn.bugzilla", "No Exception from parseHtmlError");
        }
        catch (CoreException e) {
            if (e.getStatus() instanceof BugzillaStatus || e.getStatus() instanceof RepositoryStatus) {
                return (Status)e.getStatus();
            }
            return new Status(4, "org.eclipse.mylyn.bugzilla", "No Exception from parseHtmlError, Status is not from expected Type");
        }
        catch (UnsupportedEncodingException e1) {
            return new Status(4, "org.eclipse.mylyn.bugzilla", "UnsupportedEncodingException:", (Throwable)e1);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.mylyn.bugzilla", "IOException:", (Throwable)e);
        }
    }

    private BugzillaRepositoryResponse parsePostResponse(String taskId, InputStream inputStream) throws IOException, CoreException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, this.getCharacterEncoding()));
        return this.parseRepositoryResponse(taskId, in);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BugzillaRepositoryResponse parseRepositoryResponse(String taskId, BufferedReader in) throws IOException, CoreException {
        block33: {
            block32: {
                tokenizer = new HtmlStreamTokenizer((Reader)in, null);
                isTitle = false;
                title = "";
                body = "";
                errorMessage = null;
                token = tokenizer.nextToken();
lbl8:
                // 2 sources

                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    body = String.valueOf(body) + token.toString();
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.TITLE && !((HtmlTag)token.getValue()).isEndTag()) {
                        isTitle = true;
                        break block32;
                    }
                    if (!isTitle) ** GOTO lbl-1000
                    if (token.getType() != HtmlStreamTokenizer.Token.TAG) {
                        title = String.valueOf(title) + ((StringBuffer)token.getValue()).toString().toLowerCase(Locale.ENGLISH) + " ";
                        break block32;
                    }
                    if (token.getType() != HtmlStreamTokenizer.Token.TAG || ((HtmlTag)token.getValue()).getTagType() != HTML.Tag.TITLE || !((HtmlTag)token.getValue()).isEndTag()) break block32;
                    found = false;
                    var12_16 = this.bugzillaLanguageSettings.getResponseForCommand("changes_submitted").iterator();
                    if (true) ** GOTO lbl31
lbl-1000:
                    // 1 sources

                    {
                        block34: {
                            if (!this.isErrorMessageToken(token)) break block32;
                            errorMessage = BugzillaClient.computeErrorMessage(tokenizer, token);
                            break block33;
                            do {
                                v0 = found = title.indexOf(value = (string = var12_16.next()).toLowerCase(Locale.ENGLISH)) != -1;
                                if (!found) continue;
                                response = new BugzillaRepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, taskId);
                                this.parseResultOK(tokenizer, response);
                                var20_22 = response;
                                return var20_22;
lbl31:
                                // 2 sources

                            } while (var12_16.hasNext());
                            for (String string : this.bugzillaLanguageSettings.getResponseForCommand("processed")) {
                                value = string.toLowerCase(Locale.ENGLISH);
                                v1 = found = title.indexOf(value) != -1;
                                if (!found) continue;
                                response = new BugzillaRepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, taskId);
                                this.parseResultOK(tokenizer, response);
                                var20_23 = response;
                                return var20_23;
                            }
                            for (String string : this.bugzillaLanguageSettings.getResponseForCommand("submitted")) {
                                value = string.toLowerCase(Locale.ENGLISH);
                                v2 = found = title.indexOf(value) != -1;
                                if (!found) continue;
                                stopIndex = title.indexOf(value);
                                if (stopIndex <= -1) break block34;
                                var16_27 = this.bugzillaLanguageSettings.getResponseForCommand("bug").iterator();
                                if (true) ** GOTO lbl57
                            }
                            var12_16 = this.bugzillaLanguageSettings.getResponseForCommand("error_login").iterator();
                            if (true) ** GOTO lbl76
                            do {
                                if ((startIndex = title.indexOf(value = (string2 = var16_27.next()).toLowerCase(Locale.ENGLISH))) > -1) {
                                    result = title.substring(startIndex += value.length(), stopIndex).trim();
                                    response = new BugzillaRepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, result);
                                    this.parseResultOK(tokenizer, response);
                                    var20_24 = response;
                                    return var20_24;
                                }
lbl57:
                                // 3 sources

                                ** try [egrp 4[TRYBLOCK] [3 : 618->1958)] { 
lbl58:
                                // 1 sources

                            } while (var16_27.hasNext());
                        }
                        StatusHandler.log((IStatus)new BugzillaStatus(1, "org.eclipse.mylyn.bugzilla", 7, "Unable to retrieve new task id from: " + title));
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, Messages.BugzillaClient_Unable_to_retrieve_new_task));
                    }
                }
                break block33;
lbl-1000:
                // 2 sources

                {
                    catch (ParseException e) {
                        this.loggedIn = false;
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "Unable to parse response from " + this.repositoryUrl.toString() + "."));
                        break;
                    }
                }
                finally {
                    in.close();
                }
                do {
                    v3 = found = title.indexOf(value = (string = var12_16.next()).toLowerCase(Locale.ENGLISH)) != -1;
                    if (!found) continue;
                    this.loggedIn = false;
                    if (this.hasAuthenticationCredentials() == false) throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), Messages.BugzillaClient_anonymous_user_not_allowed));
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), title));
lbl76:
                    // 2 sources

                } while (var12_16.hasNext());
                for (String string : this.bugzillaLanguageSettings.getResponseForCommand("error_collision")) {
                    value = string.toLowerCase(Locale.ENGLISH);
                    v4 = found = title.indexOf(value) != -1;
                    if (!found) continue;
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 6, this.repositoryUrl.toString()));
                }
                for (String string : this.bugzillaLanguageSettings.getResponseForCommand("error_comment_required")) {
                    value = string.toLowerCase(Locale.ENGLISH);
                    v5 = found = title.indexOf(value) != -1;
                    if (!found) continue;
                    throw new CoreException((IStatus)new BugzillaStatus(1, "org.eclipse.mylyn.bugzilla", 9));
                }
                for (String string : this.bugzillaLanguageSettings.getResponseForCommand("suspicious_action")) {
                    value = string.toLowerCase(Locale.ENGLISH);
                    v6 = found = title.indexOf(value) != -1;
                    if (!found) continue;
                    tokenError = tokenizer.nextToken();
                    if (true) ** GOTO lbl101
                }
                var12_16 = this.bugzillaLanguageSettings.getResponseForCommand("error_logged_out").iterator();
                if (true) ** GOTO lbl108
                do {
                    body = String.valueOf(body) + tokenError.toString();
                    if (tokenError.getType() == HtmlStreamTokenizer.Token.COMMENT && tokenError.getValue().toString().startsWith("reason=")) {
                        reason = tokenError.getValue().toString().substring(7);
                        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 99, this.repositoryUrl.toString(), "Reason = " + reason));
                    }
                    tokenError = tokenizer.nextToken();
lbl101:
                    // 2 sources

                } while (tokenError.getType() != HtmlStreamTokenizer.Token.EOF);
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 99, this.repositoryUrl.toString(), "unknown reason because Bugzilla < 4.0 was used"));
                do {
                    v7 = found = title.indexOf(value = (string = var12_16.next()).toLowerCase(Locale.ENGLISH)) != -1;
                    if (!found) continue;
                    this.loggedIn = false;
                    throw new CoreException((IStatus)new BugzillaStatus(1, "org.eclipse.mylyn.bugzilla", 10, "You have been logged out. Please retry operation."));
lbl108:
                    // 2 sources

                } while (var12_16.hasNext());
                iterator = this.bugzillaLanguageSettings.getResponseForCommand("error_confirm_match").iterator();
                while (iterator.hasNext() && !found) {
                    value = iterator.next().toLowerCase(Locale.ENGLISH);
                    v8 = found = found != false || title.indexOf(value) != -1;
                }
                if (found) {
                    matchResponse = new BugzillaUserMatchResponse();
                    matchResponse.parseResultConfirmMatch(tokenizer, this.repositoryUrl.toString(), body);
                }
                found = false;
                iterator = this.bugzillaLanguageSettings.getResponseForCommand("error_match_failed").iterator();
                while (iterator.hasNext() && !found) {
                    value = iterator.next().toLowerCase(Locale.ENGLISH);
                    v9 = found = found != false || title.indexOf(value) != -1;
                }
                if (found) {
                    matchResponse = new BugzillaUserMatchResponse();
                    matchResponse.parseResultMatchFailed(tokenizer, this.repositoryUrl.toString(), body);
                }
                isTitle = false;
            }
            token = tokenizer.nextToken();
            ** GOTO lbl8
        }
        if (this.hasAuthenticationCredentials() && !this.loggedIn) {
            builder = new StringBuilder("Cookies: ");
            var13_18 = this.httpClient.getState().getCookies();
            var12_17 = var13_18.length;
            var11_15 = 0;
            while (var11_15 < var12_17) {
                cookie = var13_18[var11_15];
                builder.append(String.valueOf(cookie.getName()) + " = " + cookie.getValue() + "  ");
                ++var11_15;
            }
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "An unknown repository error has occurred: " + body));
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", builder.toString()));
        }
        result = title.trim();
        if (errorMessage != null) {
            if (result.length() > 0) {
                result = String.valueOf(result) + ": " + errorMessage;
                throw new CoreException((IStatus)RepositoryStatus.createHtmlStatus((String)this.repositoryUrl.toString(), (int)4, (String)"org.eclipse.mylyn.bugzilla", (int)1, (String)result, (String)body));
            }
            result = errorMessage;
            throw new CoreException((IStatus)RepositoryStatus.createHtmlStatus((String)this.repositoryUrl.toString(), (int)4, (String)"org.eclipse.mylyn.bugzilla", (int)1, (String)result, (String)body));
        }
        if (result.length() == 0 && body.contains("Bugzilla/Bug.pm line")) {
            result = "Bugzilla/Bug.pm line";
        }
        status = RepositoryStatus.createHtmlStatus((String)this.repositoryUrl.toString(), (int)1, (String)"org.eclipse.mylyn.bugzilla", (int)1, (String)("An unknown repository error has occurred: " + result), (String)body);
        throw new CoreException((IStatus)status);
    }

    public void getTaskData(Set<String> taskIds, TaskDataCollector collector, TaskAttributeMapper mapper, IProgressMonitor monitor) throws IOException, CoreException {
        if (this.repositoryConfiguration == null) {
            this.getRepositoryConfiguration((IProgressMonitor)new SubProgressMonitor(monitor, 1), null);
            this.connector.addRepositoryConfiguration(this.repositoryConfiguration);
        }
        GzipPostMethod method = null;
        HashMap<String, TaskData> taskDataMap = new HashMap<String, TaskData>();
        taskIds = new HashSet<String>(taskIds);
        int authenticationAttempt = 0;
        while (taskIds.size() > 0) {
            NameValuePair[] formData;
            Iterator<String> itr;
            HashSet<String> idsToRetrieve;
            block23: {
                block24: {
                    idsToRetrieve = new HashSet<String>();
                    itr = taskIds.iterator();
                    int x = 0;
                    while (itr.hasNext() && x < 50) {
                        String taskId;
                        String taskIdOrg = taskId = itr.next();
                        boolean changed = false;
                        while (taskId.startsWith("0")) {
                            taskId = taskId.substring(1);
                            changed = true;
                        }
                        idsToRetrieve.add(taskId);
                        if (changed) {
                            taskIds.remove(taskIdOrg);
                            taskIds.add(taskId);
                        }
                        ++x;
                    }
                    formData = new NameValuePair[idsToRetrieve.size() + 2];
                    if (idsToRetrieve.size() != 0) break block23;
                    if (method == null) break block24;
                    WebUtil.releaseConnection(method, (IProgressMonitor)monitor);
                }
                return;
            }
            try {
                try {
                    itr = idsToRetrieve.iterator();
                    int x = 0;
                    while (itr.hasNext()) {
                        String taskId = itr.next();
                        formData[x] = new NameValuePair(KEY_ID, taskId);
                        TaskData taskData = new TaskData(mapper, this.getConnectorKind(), this.repositoryUrl.toString(), taskId);
                        this.setupExistingBugAttributes(this.repositoryUrl.toString(), taskData);
                        taskDataMap.put(taskId, taskData);
                        ++x;
                    }
                    formData[x++] = new NameValuePair("ctype", "xml");
                    formData[x] = new NameValuePair("excludefield", "attachmentdata");
                    method = this.postFormData("/show_bug.cgi", formData, monitor);
                    if (method == null) {
                        throw new IOException("Could not post form, client returned null method.");
                    }
                    boolean parseable = false;
                    if (method.getResponseHeader("Content-Type") != null) {
                        Header responseTypeHeader = method.getResponseHeader("Content-Type");
                        String[] stringArray = VALID_CONFIG_CONTENT_TYPES;
                        int n = VALID_CONFIG_CONTENT_TYPES.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String type = stringArray[n2];
                            if (responseTypeHeader.getValue().toLowerCase(Locale.ENGLISH).contains(type)) {
                                try (InputStream input = this.getResponseStream((HttpMethodBase)method, monitor);){
                                    MultiBugReportFactory factory = new MultiBugReportFactory(input, this.getCharacterEncoding(), this.connector);
                                    ArrayList<BugzillaCustomField> customFields = new ArrayList();
                                    if (this.repositoryConfiguration != null) {
                                        customFields = this.repositoryConfiguration.getCustomFields();
                                    }
                                    factory.populateReport(taskDataMap, collector, mapper, customFields);
                                    taskIds.removeAll(idsToRetrieve);
                                    taskDataMap.clear();
                                    parseable = true;
                                    break;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (!parseable) {
                        throw new CoreException((IStatus)this.parseHtmlError(this.getResponseStream((HttpMethodBase)method, monitor)));
                    }
                }
                catch (CoreException c) {
                    if (c.getStatus().getCode() == 3 && authenticationAttempt < 1) {
                        this.loggedIn = false;
                        ++authenticationAttempt;
                    } else {
                        throw c;
                    }
                    if (method == null) continue;
                    WebUtil.releaseConnection(method, (IProgressMonitor)monitor);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (method != null) {
                    WebUtil.releaseConnection(method, (IProgressMonitor)monitor);
                }
                throw throwable;
            }
            if (method == null) continue;
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    protected String getConnectorKind() {
        return "bugzilla";
    }

    public String getConfigurationTimestamp(IProgressMonitor monitor) throws CoreException {
        if (!this.lastModifiedSupported) {
            return null;
        }
        String lastModified = null;
        HeadMethod method = null;
        try {
            try {
                method = this.connectHead(this.repositoryUrl + "/config.cgi?ctype=rdf", monitor);
                Header lastModifiedHeader = method.getResponseHeader("Last-Modified");
                if (lastModifiedHeader != null && lastModifiedHeader.getValue() != null && lastModifiedHeader.getValue().length() > 0) {
                    lastModified = lastModifiedHeader.getValue();
                } else {
                    this.lastModifiedSupported = false;
                }
            }
            catch (Exception e) {
                this.lastModifiedSupported = false;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error retrieving configuration timestamp", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (method != null) {
                WebUtil.releaseConnection(method, (IProgressMonitor)monitor);
            }
            throw throwable;
        }
        if (method != null) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
        return lastModified;
    }

    private HeadMethod connectHead(String requestURL, IProgressMonitor monitor) throws IOException, CoreException {
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        int attempt = 0;
        while (attempt < 2) {
            int code;
            this.authenticate(monitor);
            HeadMethod headMethod = new HeadMethod(WebUtil.getRequestPath((String)requestURL));
            if (requestURL.contains(QUERY_DELIMITER)) {
                headMethod.setQueryString(requestURL.substring(requestURL.indexOf(QUERY_DELIMITER)));
            }
            headMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.getCharacterEncoding());
            headMethod.setDoAuthentication(true);
            try {
                code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)headMethod, (IProgressMonitor)monitor);
            }
            catch (IOException e) {
                WebUtil.releaseConnection((HttpMethodBase)headMethod, (IProgressMonitor)monitor);
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 5, this.repositoryUrl.toString(), e));
            }
            if (code == 200) {
                return headMethod;
            }
            if (code != 401 && code != 403) {
                if (code == 407) {
                    this.loggedIn = false;
                    WebUtil.releaseConnection((HttpMethodBase)headMethod, (IProgressMonitor)monitor);
                    throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "Proxy authentication required"));
                }
                WebUtil.releaseConnection((HttpMethodBase)headMethod, (IProgressMonitor)monitor);
                throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 11, "Http error: " + HttpStatus.getStatusText((int)code)));
            }
            WebUtil.releaseConnection((HttpMethodBase)headMethod, (IProgressMonitor)monitor);
            this.loggedIn = false;
            this.authenticate(monitor);
            ++attempt;
        }
        throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 3, this.repositoryUrl.toString(), "All connection attempts to " + this.repositoryUrl.toString() + " failed. Please verify connection and authentication information."));
    }

    public void setRepositoryConfiguration(RepositoryConfiguration repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        return this.repositoryConfiguration;
    }

    public static String formatTextToLineWrap(String origText, boolean hardWrap) {
        if (!hardWrap) {
            return origText;
        }
        String newText = "";
        while (!origText.equals("")) {
            int newLine = origText.indexOf(10);
            if (newLine == -1 || newLine > 80) {
                if (origText.length() > 80) {
                    int spaceIndex = origText.lastIndexOf(" ", 80);
                    if (spaceIndex == -1 && (spaceIndex = origText.indexOf(" ", 80)) == -1) {
                        spaceIndex = newLine;
                    }
                    newText = String.valueOf(newText) + origText.substring(0, spaceIndex) + "\n";
                    if (origText.charAt(spaceIndex) == ' ' || origText.charAt(spaceIndex) == '\n') {
                        origText = origText.substring(spaceIndex + 1, origText.length());
                        continue;
                    }
                    origText = origText.substring(spaceIndex, origText.length());
                    continue;
                }
                newText = String.valueOf(newText) + origText;
                origText = "";
                continue;
            }
            newText = String.valueOf(newText) + origText.substring(0, newLine + 1);
            origText = origText.substring(newLine + 1, origText.length());
        }
        return newText;
    }

    private void parseResultOK(HtmlStreamTokenizer tokenizer, BugzillaRepositoryResponse response) throws IOException, CoreException {
        String codeString = "";
        boolean inBugzillaBody = false;
        int dlLevel = 0;
        boolean isDT = false;
        boolean isCODE = false;
        String dt1 = "";
        String dt2 = "";
        try {
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.DIV) {
                    String idValue = ((HtmlTag)token.getValue()).getAttribute(KEY_ID);
                    inBugzillaBody = idValue != null ? idValue.equals("bugzilla-body") : false;
                }
                if (inBugzillaBody) {
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                        if (((HtmlTag)token.getValue()).getTagType() == HTML.Tag.DL) {
                            dlLevel = ((HtmlTag)token.getValue()).isEndTag() ? --dlLevel : ++dlLevel;
                        } else if (((HtmlTag)token.getValue()).getTagType() == HTML.Tag.DT) {
                            boolean bl = isDT = !((HtmlTag)token.getValue()).isEndTag();
                            if (isDT) {
                                if (dlLevel == 1) {
                                    dt1 = " ";
                                } else if (dlLevel == 2) {
                                    dt2 = " ";
                                }
                            }
                        } else if (((HtmlTag)token.getValue()).getTagType() == HTML.Tag.CODE) {
                            if (isCODE) {
                                if (codeString.length() > 0) {
                                    codeString = codeString.replace("&#64;", "@");
                                    response.addResponseData(dt1, dt2, codeString);
                                }
                                codeString = "";
                            }
                            isCODE = !((HtmlTag)token.getValue()).isEndTag();
                        }
                    } else if (isDT) {
                        if (dlLevel == 1) {
                            dt1 = String.valueOf(dt1) + " " + token.getValue();
                        } else if (dlLevel == 2) {
                            dt2 = String.valueOf(dt2) + " " + token.getValue();
                        }
                    } else if (isCODE) {
                        codeString = String.valueOf(codeString) + token.getValue();
                    }
                }
                token = tokenizer.nextToken();
            }
        }
        catch (ParseException e) {
            throw new CoreException((IStatus)new BugzillaStatus(4, "org.eclipse.mylyn.bugzilla", 7, "Unable to parse response from " + this.repositoryUrl.toString() + "."));
        }
    }

    public void setDescriptorFile(String canonicalPath) {
        this.configParameters.put("bugzilla.desciptorFile", canonicalPath);
    }

    private BugzillaXmlRpcClient getXmlRpcClient() {
        boolean useXMLRPC = Boolean.parseBoolean(this.configParameters.get("bugzilla.xmlrpc.status.transition"));
        if (useXMLRPC && this.xmlRpcClient == null) {
            WebLocation webLocation = new WebLocation(this.repositoryUrl + "/xmlrpc.cgi");
            String username = "";
            String password = "";
            if (this.location.getCredentials(AuthenticationType.REPOSITORY) != null) {
                username = this.location.getCredentials(AuthenticationType.REPOSITORY).getUserName();
            }
            if (this.location.getCredentials(AuthenticationType.REPOSITORY) != null) {
                password = this.location.getCredentials(AuthenticationType.REPOSITORY).getPassword();
            }
            webLocation.setCredentials(AuthenticationType.REPOSITORY, username, password);
            this.xmlRpcClient = new BugzillaXmlRpcClient((AbstractWebLocation)webLocation, this);
            this.xmlRpcClient.setContentTypeCheckingEnabled(true);
        }
        return this.xmlRpcClient;
    }

    public List<BugHistory> getBugHistory(String id, IProgressMonitor monitor) throws CoreException {
        int bugId = Integer.parseInt(id);
        try {
            BugzillaXmlRpcClient client = this.getXmlRpcClient();
            if (client == null) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "XMLRPC is not available"));
            }
            return client.getHistory(new Integer[]{bugId}, monitor);
        }
        catch (XmlRpcException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla", "XMLRPC is not installed"));
        }
    }

    private static void transferData(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public static String changeSeparator(String path, char oldSeparator, char newSeparator) {
        return path.replace(oldSeparator, newSeparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void downloadXMLTransFile(String transFile, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        String loginUrl = this.repositoryUrl + "/xml_transition_file.mylyn";
        GzipGetMethod method = null;
        try {
            method = this.getConnect(loginUrl, monitor);
            File file = new File(BugzillaClient.changeSeparator(transFile, '/', File.separatorChar));
            file.getParentFile().mkdirs();
            Throwable throwable = null;
            Object var7_8 = null;
            try {
                InputStream input = this.getResponseStream((HttpMethodBase)method, monitor);
                try {
                    try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(transFile));){
                        BugzillaClient.transferData(input, output);
                    }
                    if (input == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
                input.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            if (method != null) {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            }
        }
    }

    public BugzillaRepositoryConnector getConnector() {
        return this.connector;
    }

    public TaskRepository getTaskRepository() {
        if (this.location instanceof TaskRepositoryLocation) {
            return ((TaskRepositoryLocation)this.location).getTaskRepository();
        }
        return null;
    }

    private class HtmlInformation {
        private final Map<String, String> groups = new HashMap<String, String>();
        private String token;

        public Map<String, String> getGroups() {
            return this.groups;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }
    }
}

