/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.model.MethodKey;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;

public abstract class AbstractIllegalMethodReference
extends AbstractProblemDetector {
    private Map<MethodKey, IMethodDescriptor> fIllegalMethods = new HashMap<MethodKey, IMethodDescriptor>();
    private Map<IMethodDescriptor, String> fMethodComponents = new HashMap<IMethodDescriptor, String>();

    void addIllegalMethod(IMethodDescriptor method, String componentId) {
        this.fIllegalMethods.put(new MethodKey(method.getEnclosingType().getQualifiedName(), method.getName(), method.getSignature(), true), method);
        this.fMethodComponents.put(method, componentId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean considerReference(IReference reference, IProgressMonitor monitor) {
        IApiMember member;
        MethodKey key = new MethodKey(reference.getReferencedTypeName(), reference.getReferencedMemberName(), reference.getReferencedSignature(), true);
        if (super.considerReference(reference, monitor) && this.fIllegalMethods.containsKey(key)) {
            this.retainReference(reference);
            return true;
        }
        if ((reference.getReferenceFlags() & 2) > 0 && (member = reference.getResolvedReference()) == null) {
            try {
                ((Reference)reference).resolve();
                member = reference.getResolvedReference();
            }
            catch (CoreException coreException) {}
            IApiMember iApiMember = member;
            if (iApiMember instanceof IApiMethod) {
                void method;
                IApiMethod iApiMethod = (IApiMethod)iApiMember;
                IApiMethod cfr_ignored_0 = (IApiMethod)iApiMember;
                if (method.isDefaultMethod()) {
                    return this.considerReference(reference, monitor);
                }
            }
        }
        return false;
    }

    @Override
    protected boolean isProblem(IReference reference, IProgressMonitor monitor) {
        if (!super.isProblem(reference, monitor)) {
            return false;
        }
        IApiMember method = reference.getResolvedReference();
        String componentId = this.fMethodComponents.get(method.getHandle());
        return this.isReferenceFromComponent(reference, componentId);
    }

    @Override
    protected int getElementType(IReference reference) {
        return 6;
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        if (method.isConstructor()) {
            return 7;
        }
        return 8;
    }
}

