/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.shared.target.AddBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.CopyLocationAction;
import org.eclipse.pde.internal.ui.shared.target.CopyTreeSelectionAction;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationContentProvider;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationHandlerAdapter;
import org.eclipse.pde.internal.ui.shared.target.UpdateTargetJob;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;

public class TargetLocationsGroup {
    private static final String BUTTON_STATE = "ButtonState";
    private TreeViewer fTreeViewer;
    private Action fCopySelectionAction;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fUpdateButton;
    private Button fRefreshButton;
    private Button fExpandCollapseButton;
    private Button fShowContentButton;
    private ITargetDefinition fTarget;
    private ListenerList<ITargetChangedListener> fChangeListeners = new ListenerList();
    private ListenerList<ITargetChangedListener> fReloadListeners = new ListenerList();
    private static final TargetLocationHandlerAdapter ADAPTER = new TargetLocationHandlerAdapter();

    public static TargetLocationsGroup createInForm(Composite parent, FormToolkit toolkit) {
        TargetLocationsGroup contentTable = new TargetLocationsGroup();
        contentTable.createFormContents(parent, toolkit);
        return contentTable;
    }

    public static TargetLocationsGroup createInDialog(Composite parent) {
        TargetLocationsGroup contentTable = new TargetLocationsGroup();
        contentTable.createDialogContents(parent);
        return contentTable;
    }

    private TargetLocationsGroup() {
    }

    public void addTargetChangedListener(ITargetChangedListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    public void addTargetReloadListener(ITargetChangedListener listener) {
        this.fReloadListeners.add((Object)listener);
    }

    private void createFormContents(Composite parent, FormToolkit toolkit) {
        Composite comp = toolkit.createComposite(parent);
        comp.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        comp.setLayoutData((Object)new GridData(1808));
        Tree atree = toolkit.createTree(comp, 770);
        atree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        atree.setLayoutData((Object)gd);
        this.initializeTree(atree);
        Composite buttonComp = toolkit.createComposite(comp);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fAddButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Add, 8);
        this.fEditButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Edit, 8);
        this.fRemoveButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Remove, 8);
        this.fUpdateButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Update, 8);
        this.fUpdateButton.setToolTipText(Messages.TargetLocationsGroup_update);
        this.fRefreshButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Refresh, 8);
        this.fRefreshButton.setToolTipText(Messages.TargetLocationsGroup_refresh);
        this.fExpandCollapseButton = toolkit.createButton(buttonComp, Messages.BundleContainerTable_Btn_Text_ExpandAll, 8);
        this.fShowContentButton = toolkit.createButton(comp, Messages.TargetLocationsGroup_1, 32);
        this.initializeTreeViewer(atree);
        this.initializeButtons();
        toolkit.paintBordersFor(comp);
    }

    private void createDialogContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808, 0, 0);
        Tree atree = new Tree(comp, 2818);
        atree.setFont(comp.getFont());
        atree.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        atree.setLayoutData((Object)gd);
        this.initializeTree(atree);
        Composite buttonComp = SWTFactory.createComposite(comp, 2, 1, 1808);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.fAddButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Add, null);
        this.fEditButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Edit, null);
        this.fRemoveButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Remove, null);
        this.fUpdateButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Update, null);
        this.fRefreshButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_Btn_Text_Refresh, null);
        this.fExpandCollapseButton = SWTFactory.createPushButton(buttonComp, Messages.BundleContainerTable_Btn_Text_ExpandAll, null);
        this.fShowContentButton = SWTFactory.createCheckButton(comp, Messages.TargetLocationsGroup_1, null, false, 2);
        this.initializeTreeViewer(atree);
        this.initializeButtons();
    }

    private void initializeTree(Tree tree) {
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && TargetLocationsGroup.this.fRemoveButton.getEnabled()) {
                    TargetLocationsGroup.this.handleRemove();
                } else if (e.keyCode == 99 && (e.stateMask & 0x40000) != 0) {
                    TargetLocationsGroup.this.fCopySelectionAction.run();
                }
            }
        });
    }

    private void initializeTreeViewer(Tree tree) {
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setContentProvider((IContentProvider)new TargetLocationContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IStatus && !(e2 instanceof IStatus)) {
                    return 1;
                }
                if (e2 instanceof IStatus && !(e1 instanceof IStatus)) {
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fTreeViewer.addSelectionChangedListener(event -> this.updateButtons());
        this.fTreeViewer.addDoubleClickListener(event -> {
            if (!event.getSelection().isEmpty()) {
                this.handleEdit();
            }
        });
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.createContextMenu(this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                TargetLocationsGroup.this.setExpandCollapseState();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                TargetLocationsGroup.this.setExpandCollapseState();
            }
        });
        this.fTreeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                TargetLocationsGroup.this.setExpandCollapseState();
            }
        });
    }

    private void setExpandCollapseState() {
        if (this.fTreeViewer == null) {
            return;
        }
        if (this.fTreeViewer.getVisibleExpandedElements().length == 0) {
            this.fExpandCollapseButton.setText(Messages.BundleContainerTable_Btn_Text_ExpandAll);
        } else {
            this.fExpandCollapseButton.setText(Messages.BundleContainerTable_Btn_Text_CollapseAll);
        }
    }

    private void createContextMenu(Tree tree) {
        this.fCopySelectionAction = new CopyTreeSelectionAction(tree);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.fCopySelectionAction);
        menuManager.add((IAction)new CopyLocationAction((StructuredViewer)this.fTreeViewer));
        Menu menu = menuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private void initializeButtons() {
        this.fAddButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAdd()));
        this.fAddButton.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(this.fAddButton);
        this.fEditButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleEdit()));
        this.fEditButton.setLayoutData((Object)new GridData());
        this.fEditButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fEditButton);
        this.fRemoveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemove()));
        this.fRemoveButton.setLayoutData((Object)new GridData());
        this.fRemoveButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fRemoveButton);
        this.fUpdateButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleUpdate()));
        this.fUpdateButton.setLayoutData((Object)new GridData());
        this.fUpdateButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fUpdateButton);
        this.fRefreshButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleReload()));
        this.fRefreshButton.setLayoutData((Object)new GridData());
        this.fRefreshButton.setEnabled(true);
        SWTFactory.setButtonDimensionHint(this.fRefreshButton);
        this.fExpandCollapseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toggleCollapse()));
        this.fExpandCollapseButton.setLayoutData((Object)new GridData());
        this.fExpandCollapseButton.setEnabled(false);
        SWTFactory.setButtonDimensionHint(this.fExpandCollapseButton);
        this.fShowContentButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ((TargetLocationContentProvider)this.fTreeViewer.getContentProvider()).setShowLocationContent(this.fShowContentButton.getSelection());
            this.fTreeViewer.refresh();
            this.fTreeViewer.expandAll();
            this.fExpandCollapseButton.setText(Messages.BundleContainerTable_Btn_Text_CollapseAll);
        }));
        this.fShowContentButton.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(this.fShowContentButton);
    }

    public void setInput(ITargetDefinition target) {
        this.fTarget = target;
        boolean isCollapsed = this.fTreeViewer.getVisibleExpandedElements().length == 0;
        this.fTreeViewer.setInput((Object)this.fTarget);
        if (isCollapsed) {
            this.fTreeViewer.collapseAll();
        }
        this.updateButtons();
    }

    private void handleAdd() {
        AddBundleContainerWizard wizard = new AddBundleContainerWizard(this.fTarget);
        Shell parent = this.fTreeViewer.getTree().getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        if (dialog.open() != 1) {
            this.contentsChanged(false);
            this.fTreeViewer.refresh();
            this.updateButtons();
        }
    }

    private void handleEdit() {
        Shell parent;
        WizardDialog wizard;
        IWizard editWizard;
        ITreeSelection selection = this.fTreeViewer.getStructuredSelection();
        TreePath[] paths = selection.getPaths();
        if (paths.length == 1 && (editWizard = ADAPTER.getEditWizard(this.fTarget, paths[0])) != null && (wizard = new WizardDialog(parent = this.fTreeViewer.getTree().getShell(), editWizard)).open() == 0) {
            this.updateXML();
            this.contentsChanged(false);
            this.fTreeViewer.refresh();
            this.updateButtons();
        }
    }

    private void updateXML() {
        this.fTarget.setTargetLocations(this.fTarget.getTargetLocations());
    }

    private void handleRemove() {
        ITreeSelection selection = this.fTreeViewer.getStructuredSelection();
        DeleteButtonState state = Objects.requireNonNullElse(this.fRemoveButton.getData(BUTTON_STATE), DeleteButtonState.NONE);
        if (selection.isEmpty() || state == DeleteButtonState.NONE) {
            this.fRemoveButton.setEnabled(false);
            return;
        }
        IStatus tstatus = this.fTarget.getStatus();
        IStatus status = state == DeleteButtonState.REMOVE ? TargetLocationsGroup.log(ADAPTER.remove(this.fTarget, selection.getPaths())) : TargetLocationsGroup.log(ADAPTER.toggle(this.fTarget, selection.getPaths()));
        boolean forceReload = tstatus != null && !tstatus.isOK() || status != null && status.isOK() && status.getCode() == 102;
        this.updateXML();
        this.contentsChanged(forceReload);
        this.fTreeViewer.refresh();
        this.updateButtons();
    }

    private void handleUpdate() {
        ITreeSelection selection = this.fTreeViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            this.fUpdateButton.setEnabled(false);
            return;
        }
        List<IJobFunction> updateActions = Collections.singletonList(monitor -> TargetLocationsGroup.log(ADAPTER.update(this.fTarget, selection.getPaths(), monitor)));
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIJob job = UIJob.create((String)Messages.UpdateTargetJob_UpdateJobName, monitor -> {
                    IStatus result = event.getJob().getResult();
                    if (!result.isOK()) {
                        if (!TargetLocationsGroup.this.fTreeViewer.getControl().isDisposed()) {
                            ErrorDialog.openError((Shell)TargetLocationsGroup.this.fTreeViewer.getTree().getShell(), (String)Messages.TargetLocationsGroup_TargetUpdateErrorDialog, (String)result.getMessage(), (IStatus)result);
                        }
                    } else if (result.getCode() != 101) {
                        if (!TargetLocationsGroup.this.fTreeViewer.getControl().isDisposed()) {
                            TargetLocationsGroup.this.contentsChanged(true);
                            TargetLocationsGroup.this.fTreeViewer.refresh(true);
                            TargetLocationsGroup.this.updateButtons();
                        }
                        try {
                            ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
                            if (service != null) {
                                ITargetHandle currentTarget = service.getWorkspaceTargetHandle();
                                if (TargetLocationsGroup.this.fTarget.getHandle().equals(currentTarget)) {
                                    LoadTargetDefinitionJob.load((ITargetDefinition)TargetLocationsGroup.this.fTarget);
                                }
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                });
                job.schedule();
            }
        };
        UpdateTargetJob.update(updateActions, (IJobChangeListener)listener);
    }

    private void updateButtons() {
        TreePath[] paths;
        ITreeSelection selection = this.fTreeViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            this.fRemoveButton.setEnabled(false);
            this.fRemoveButton.setText(Messages.BundleContainerTable_Btn_Text_Remove);
            this.fRemoveButton.setData(BUTTON_STATE, (Object)DeleteButtonState.NONE);
            this.fUpdateButton.setEnabled(false);
            this.fEditButton.setEnabled(false);
            if (this.fTreeViewer != null) {
                this.setExpandCollapseState();
            }
            return;
        }
        boolean canRemove = false;
        boolean canEdit = false;
        boolean canUpdate = false;
        boolean canEnable = false;
        boolean canDisable = false;
        TreePath[] treePathArray = paths = selection.getPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            canRemove |= ADAPTER.canRemove(this.fTarget, path);
            canDisable |= ADAPTER.canDisable(this.fTarget, path);
            canEnable |= ADAPTER.canEnable(this.fTarget, path);
            canUpdate |= ADAPTER.canUpdate(this.fTarget, path);
            canEdit = paths.length == 1 && ADAPTER.canEdit(this.fTarget, path);
            ++n2;
        }
        this.fEditButton.setEnabled(canEdit);
        this.fUpdateButton.setEnabled(canUpdate);
        DeleteButtonState state = DeleteButtonState.computeState(canRemove, canEnable, canDisable);
        switch (state) {
            case DISABLE: {
                this.fRemoveButton.setText(Messages.BundleContainerTable_Btn_Text_Disable);
                break;
            }
            case ENABLE: {
                this.fRemoveButton.setText(Messages.BundleContainerTable_Btn_Text_Enable);
                break;
            }
            case TOGGLE: {
                this.fRemoveButton.setText(Messages.BundleContainerTable_Btn_Text_Toggle);
                break;
            }
            default: {
                this.fRemoveButton.setText(Messages.BundleContainerTable_Btn_Text_Remove);
            }
        }
        this.fRemoveButton.setEnabled(state != DeleteButtonState.NONE);
        this.fRemoveButton.setData(BUTTON_STATE, (Object)state);
    }

    private void handleReload() {
        TargetLocationsGroup.log(ADAPTER.reload(this.fTarget, this.fTarget.getTargetLocations(), (IProgressMonitor)new NullProgressMonitor()));
        UIJob job = UIJob.create((String)"Refreshing...", monitor -> this.contentsReload());
        job.schedule();
    }

    private void toggleCollapse() {
        if (this.fTreeViewer == null) {
            return;
        }
        if (this.fTreeViewer.getVisibleExpandedElements().length == 0) {
            this.fTreeViewer.expandAll();
            this.fExpandCollapseButton.setText(Messages.BundleContainerTable_Btn_Text_CollapseAll);
        } else {
            this.fTreeViewer.collapseAll();
            this.fExpandCollapseButton.setText(Messages.BundleContainerTable_Btn_Text_ExpandAll);
        }
    }

    private void contentsChanged(boolean force) {
        for (ITargetChangedListener listener : this.fChangeListeners) {
            listener.contentsChanged(this.fTarget, this, true, force);
        }
    }

    private void contentsReload() {
        for (ITargetChangedListener listener : this.fReloadListeners) {
            listener.contentsChanged(this.fTarget, this, true, true);
        }
    }

    private static IStatus log(IStatus status) {
        if (status != null && !status.isOK()) {
            PDEPlugin.log(status);
        }
        return status;
    }

    public void setExpandCollapseState(boolean b) {
        if (this.fExpandCollapseButton != null) {
            this.fExpandCollapseButton.setEnabled(b);
        }
    }

    private static enum DeleteButtonState {
        NONE,
        REMOVE,
        ENABLE,
        DISABLE,
        TOGGLE;


        static DeleteButtonState computeState(boolean canRemove, boolean canEnable, boolean canDisable) {
            if (canRemove) {
                if (canEnable || canDisable) {
                    return NONE;
                }
                return REMOVE;
            }
            if (canEnable) {
                if (canDisable) {
                    return TOGGLE;
                }
                return ENABLE;
            }
            if (canDisable) {
                return DISABLE;
            }
            return NONE;
        }
    }
}

