/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.parts;

import java.util.ArrayList;
import org.eclipse.php.composer.ui.parts.ComboPart;
import org.eclipse.php.composer.ui.parts.IComboFormEntryListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ComboFormEntry {
    private Label label;
    private ComboPart combo;
    private boolean ignoreNotify = false;
    private ArrayList<IComboFormEntryListener> listeners = new ArrayList();

    public ComboFormEntry(Composite parent, FormToolkit toolkit, String labelText) {
        this(parent, toolkit, labelText, 0x800000);
    }

    public ComboFormEntry(Composite parent, FormToolkit toolkit, String labelText, int style) {
        this.createControl(parent, toolkit, labelText, style);
    }

    public Label getLabel() {
        return this.label;
    }

    public ComboPart getComboPart() {
        return this.combo;
    }

    public String getValue() {
        return this.combo.getSelection();
    }

    public void setValue(String value) {
        this.combo.setText(value);
    }

    public void setValue(String value, boolean ignoreNotify) {
        this.ignoreNotify = ignoreNotify;
        this.setValue(value);
        this.ignoreNotify = false;
    }

    public void setEditable(boolean editable) {
        this.combo.setEnabled(editable);
    }

    public void addComboFormEntryListener(IComboFormEntryListener listener) {
        this.listeners.add(listener);
    }

    public void removeComboFormEntryListener(IComboFormEntryListener listener) {
        this.listeners.remove(listener);
    }

    private void createControl(Composite parent, FormToolkit toolkit, String labelText, int style) {
        if (labelText != null) {
            this.label = toolkit.createLabel(parent, labelText);
            this.label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        }
        this.combo = new ComboPart();
        this.combo.createControl(parent, toolkit, style);
        this.addListener();
        this.fillIntoGrid(parent);
    }

    private void addListener() {
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ComboFormEntry.this.ignoreNotify) {
                    return;
                }
                for (IComboFormEntryListener listener : ComboFormEntry.this.listeners) {
                    listener.textValueChanged(ComboFormEntry.this);
                }
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ComboFormEntry.this.ignoreNotify) {
                    return;
                }
                for (IComboFormEntryListener listener : ComboFormEntry.this.listeners) {
                    listener.selectionChanged(ComboFormEntry.this);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void fillIntoGrid(Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridData gd;
            int span = ((GridLayout)layout).numColumns;
            if (this.label != null) {
                gd = new GridData(4);
                this.label.setLayoutData((Object)gd);
                --span;
            }
            gd = new GridData(256);
            gd.horizontalSpan = span;
            if (this.label != null) {
                gd.horizontalIndent = 3;
            }
            gd.grabExcessHorizontalSpace = span == 1;
            gd.widthHint = 10;
            this.combo.getControl().setLayoutData((Object)gd);
        } else if (layout instanceof TableWrapLayout) {
            TableWrapData td;
            int span = ((TableWrapLayout)layout).numColumns;
            if (this.label != null) {
                td = new TableWrapData();
                td.valign = 32;
                this.label.setLayoutData((Object)td);
                --span;
            }
            td = new TableWrapData(128);
            td.colspan = span;
            if (this.label != null) {
                td.indent = 3;
            }
            td.grabHorizontal = span == 1;
            td.valign = 32;
            this.combo.getControl().setLayoutData((Object)td);
        }
    }
}

