/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ems.ui;

import java.net.URI;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ptp.ems.core.EnvManagerConfigString;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.ems.ui.IErrorListener;
import org.eclipse.ptp.internal.ems.ui.EnvManagerChecklist;
import org.eclipse.ptp.internal.ems.ui.messages.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class EnvManagerConfigWidget
extends Composite {
    private Button useEMSCheckbox;
    private Button manualConfigCheckbox;
    private Composite stack;
    private StackLayout stackLayout;
    private Label noEnvConfigLabel;
    private Text envConfigTextbox;
    private EnvManagerChecklist envConfigChecklist;

    public EnvManagerConfigWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout g = new GridLayout(1, false);
        g.marginHeight = 0;
        g.marginWidth = 0;
        this.setLayout((Layout)g);
        this.createCheckbox(this);
        this.createManualOverrideCheckbox(this);
        this.createStack(this);
        this.createNoEnvConfigLabel();
        this.createEnvConfigTextbox();
        this.createEnvConfigChecklist();
        this.setTopControl();
    }

    public void setConnection(IRemoteConnection connection) {
        if (this.envConfigChecklist != null) {
            this.envConfigChecklist.setConnection(connection);
        }
    }

    private void createCheckbox(Composite composite) {
        this.useEMSCheckbox = new Button(composite, 96);
        this.useEMSCheckbox.setText(Messages.EnvConfigurationControl_UseEMS);
        this.useEMSCheckbox.setLayoutData((Object)new GridData(4, 128, true, false));
        this.useEMSCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvManagerConfigWidget.this.onSelectLoadModules();
            }
        });
    }

    private void onSelectLoadModules() {
        boolean isChecked = this.useEMSCheckbox.getSelection();
        this.manualConfigCheckbox.setVisible(isChecked);
        this.setTopControl();
    }

    private void setTopControl() {
        if (this.useEMSCheckbox.getSelection()) {
            if (this.manualConfigCheckbox.getSelection()) {
                if (this.stackLayout.topControl == this.envConfigChecklist && this.isChecklistEnabled()) {
                    this.setTextFromChecklist();
                }
                this.stackLayout.topControl = this.envConfigTextbox;
            } else {
                this.stackLayout.topControl = this.envConfigChecklist;
                this.stack.setSize(this.envConfigChecklist.computeSize(-1, -1));
            }
        } else {
            this.stackLayout.topControl = this.noEnvConfigLabel;
        }
        this.stack.getParent().layout();
        this.stack.layout();
    }

    private void setTextFromChecklist() {
        IEnvManager envManager = this.envConfigChecklist.getEnvManager();
        EnvManagerConfigString config = new EnvManagerConfigString();
        config.setEnvMgmtEnabled(true);
        config.setManualConfig(false);
        config.setConnectionName(this.getConnectionName());
        config.setConfigElements(this.getSelectedElements());
        String bashCommands = envManager.getBashConcatenation("\n", false, (IEnvManagerConfig)config, null);
        this.envConfigTextbox.setText(bashCommands);
    }

    private void createManualOverrideCheckbox(Composite composite) {
        this.manualConfigCheckbox = new Button(composite, 32);
        this.manualConfigCheckbox.setText(Messages.EnvConfigurationControl_ManualOverride);
        this.manualConfigCheckbox.setLayoutData((Object)new GridData(4, 128, true, false));
        this.manualConfigCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvManagerConfigWidget.this.onSelectManualConfig();
            }
        });
    }

    private void onSelectManualConfig() {
        this.setTopControl();
    }

    private void createStack(Composite composite) {
        this.stack = new Composite(composite, 0);
        this.stack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.stack.setLayout((Layout)this.stackLayout);
    }

    private void createNoEnvConfigLabel() {
        this.noEnvConfigLabel = new Label(this.stack, 0);
        this.noEnvConfigLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.noEnvConfigLabel.setText("");
    }

    private void createEnvConfigTextbox() {
        this.envConfigTextbox = new Text(this.stack, 2818);
        this.envConfigTextbox.setLayoutData((Object)new GridData(4, 4, true, true));
        this.envConfigTextbox.setText("");
        EnvManagerConfigWidget.allowEnterAndTabInTextbox(this.envConfigTextbox);
        this.envConfigTextbox.setFont(JFaceResources.getTextFont());
    }

    private static void allowEnterAndTabInTextbox(final Text envConfigTextbox) {
        envConfigTextbox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                boolean modifierPressed;
                boolean bl = modifierPressed = (e.stateMask & SWT.MOD1) != 0;
                if (!modifierPressed) {
                    switch (e.detail) {
                        case 4: {
                            envConfigTextbox.insert("\n");
                            e.doit = false;
                            break;
                        }
                        case 16: {
                            envConfigTextbox.insert("\t");
                            e.doit = false;
                            break;
                        }
                        case 8: {
                            e.doit = false;
                        }
                    }
                }
            }
        });
    }

    private void createEnvConfigChecklist() {
        this.envConfigChecklist = new EnvManagerChecklist(this.stack, 0);
        this.envConfigChecklist.setLayoutData(new GridData(4, 4, true, true));
    }

    public void setErrorListener(IErrorListener listener) {
        this.envConfigChecklist.setErrorListener(listener);
    }

    public void configurationChanged(URI uri, IRemoteConnection remoteConnection, List<String> selectedItems) {
        this.envConfigChecklist.reset(uri, remoteConnection, selectedItems);
        this.setTopControl();
    }

    public boolean isUseEMSChecked() {
        return this.useEMSCheckbox.getSelection();
    }

    public boolean isManualConfigChecked() {
        return this.manualConfigCheckbox.getSelection();
    }

    public String getManualConfigText() {
        return this.envConfigTextbox.getText();
    }

    public void setManualConfigText(String text) {
        this.envConfigTextbox.setText(text);
    }

    public List<String> getSelectedElements() {
        return this.envConfigChecklist.getSelectedElements();
    }

    private boolean isValid() {
        return this.envConfigChecklist.isValid();
    }

    private boolean isChecklistEnabled() {
        return this.envConfigChecklist.isChecklistEnabled();
    }

    public void setUseEMSCheckbox(boolean checked) {
        this.useEMSCheckbox.setSelection(checked);
        this.onSelectLoadModules();
    }

    public void setManualConfigCheckbox(boolean checked) {
        this.manualConfigCheckbox.setSelection(checked);
        this.onSelectManualConfig();
    }

    public String getConnectionName() {
        return this.envConfigChecklist.getConnectionName();
    }

    public void saveConfiguration(IEnvManagerConfig config) {
        config.setEnvMgmtEnabled(this.isUseEMSChecked());
        if (this.isUseEMSChecked()) {
            config.setManualConfig(this.isManualConfigChecked());
            if (this.isManualConfigChecked()) {
                config.setManualConfigText(this.getManualConfigText());
            } else if (this.isChecklistEnabled() && this.isValid()) {
                config.setConnectionName(this.getConnectionName());
                config.setConfigElements(this.getSelectedElements());
            }
        }
    }
}

