/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.lookup;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.CTabItemHandler;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ShellHandler;
import org.eclipse.reddeer.core.handler.TabItemHandler;
import org.eclipse.reddeer.core.handler.TableItemHandler;
import org.eclipse.reddeer.core.handler.ToolItemHandler;
import org.eclipse.reddeer.core.handler.TreeItemHandler;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;

public class MenuLookup {
    private static final Logger log = Logger.getLogger(MenuLookup.class);
    private static MenuLookup instance = null;

    private MenuLookup() {
    }

    public static MenuLookup getInstance() {
        if (instance == null) {
            instance = new MenuLookup();
        }
        return instance;
    }

    public Menu getMenuFromFocusControl() {
        Control control = WidgetLookup.getInstance().getFocusControl();
        if (control == null) {
            throw new CoreLayerException("No control has focus. Perhaps something has stolen it? Try to regain focus with for example \"new DefaultShell()\".");
        }
        return ControlHandler.getInstance().getMenu(control);
    }

    public Menu getMenuFromActiveShell() {
        Shell activeShell = ShellLookup.getInstance().getActiveShell();
        if (activeShell == null) {
            throw new CoreLayerException("Cannot find menu bar because there's no active shell");
        }
        return this.getShellMenu(activeShell);
    }

    public Menu getToolItemMenu(ToolItem item) {
        if (!ToolItemHandler.getInstance().isDropDown(item)) {
            throw new CoreLayerException("Given ToolItem isn't of style SWT.DROP_DOWN");
        }
        final ShowMenuListener l = new ShowMenuListener();
        this.addMenuListener(l);
        try {
            ToolItemHandler.getInstance().clickDropDown(item);
            Menu menu = (Menu)Display.syncExec((ResultRunnable)new ResultRunnable<Menu>(){

                public Menu run() {
                    l.getMenu().setVisible(false);
                    return l.getMenu();
                }
            });
            return menu;
        }
        finally {
            this.removeMenuListener(l);
        }
    }

    private void addMenuListener(final Listener listener) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Display.getDisplay().addFilter(22, listener);
            }
        });
    }

    private void removeMenuListener(final Listener listener) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Display.getDisplay().removeFilter(22, listener);
            }
        });
    }

    public Menu getShellMenu(Shell shell) {
        Menu shellMenu = ShellHandler.getInstance().getMenuBar(shell);
        if (shellMenu == null) {
            String shellText = ShellHandler.getInstance().getText(shell);
            throw new CoreLayerException("Cannot find a menu bar of shell " + shellText);
        }
        return shellMenu;
    }

    public Menu getControlMenu(Control c) {
        Menu controlMenu = ControlHandler.getInstance().getMenu(c);
        if (controlMenu == null) {
            throw new CoreLayerException(c.getClass() + " Has no menu");
        }
        return controlMenu;
    }

    public Menu getItemMenu(Item item, Control parentControl) {
        if (item instanceof TreeItem) {
            TreeItemHandler.getInstance().select((TreeItem)item);
        } else if (item instanceof CTabItem) {
            CTabItemHandler.getInstance().activate((CTabItem)item);
        } else if (item instanceof TabItem) {
            TabItemHandler.getInstance().select((TabItem)item);
        } else if (item instanceof TableItem) {
            TableItemHandler.getInstance().select((TableItem)item);
        }
        Menu controlMenu = ControlHandler.getInstance().getMenu(parentControl);
        if (controlMenu == null) {
            throw new CoreLayerException(parentControl.getClass() + " Has no menu");
        }
        return controlMenu;
    }

    private class ShowMenuListener
    implements Listener {
        private Menu menu = null;

        private ShowMenuListener() {
        }

        public Menu getMenu() {
            return this.menu;
        }

        public void handleEvent(Event event) {
            if (event.widget instanceof Menu) {
                Menu menu = (Menu)event.widget;
                if (event.type == 22) {
                    this.menu = menu;
                }
                if (event.type == 23) {
                    this.menu = null;
                }
            }
        }
    }
}

