/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.assist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class TypeAssistant {
    private final EPackage.Registry typeRegistry;
    private final AbstractPropertySection section;

    public TypeAssistant(EPackage.Registry registry, AbstractPropertySection section) {
        this.typeRegistry = registry;
        this.section = section;
    }

    public TypeAssistant(EPackage.Registry registry) {
        this(registry, null);
    }

    public List<EClassifier> proposal(String incompleteName) {
        LinkedHashSet<EClassifier> proposals = new LinkedHashSet<EClassifier>();
        for (Object value : this.getEntryPoints()) {
            if (value instanceof EPackage) {
                this.addProposals(proposals, (EPackage)value, incompleteName);
                continue;
            }
            if (!(value instanceof EPackage.Descriptor)) continue;
            try {
                this.addProposals(proposals, ((EPackage.Descriptor)value).getEPackage(), incompleteName);
            }
            catch (Exception exception) {}
        }
        return new ArrayList<EClassifier>(proposals);
    }

    private Collection<Object> getEntryPoints() {
        Option<RepresentationDescription> desc = this.getCurrentRepresentationDescription();
        ArrayList<Object> values = desc.some() && !((RepresentationDescription)desc.get()).getMetamodel().isEmpty() ? new ArrayList(((RepresentationDescription)desc.get()).getMetamodel()) : new ArrayList<Object>(this.typeRegistry.values());
        return values;
    }

    private Option<RepresentationDescription> getCurrentRepresentationDescription() {
        Object object;
        RepresentationDescription desc = null;
        if (this.section != null && this.section.getSelection() instanceof IStructuredSelection && (object = ((IStructuredSelection)this.section.getSelection()).getFirstElement()) instanceof EObject) {
            if (object instanceof RepresentationDescription) {
                desc = (RepresentationDescription)object;
            } else {
                Option firstAncestorOfType = new EObjectQuery((EObject)object).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getRepresentationDescription());
                if (firstAncestorOfType.some() && firstAncestorOfType.get() instanceof RepresentationDescription) {
                    desc = (RepresentationDescription)firstAncestorOfType.get();
                }
            }
        }
        return Options.newSome(desc);
    }

    private void addProposals(Collection<EClassifier> proposals, EPackage ePackage, String incompleteName) {
        for (EClassifier clazz : ePackage.getEClassifiers()) {
            boolean addProposal = clazz.getName() != null && clazz.getName().startsWith(incompleteName);
            addProposal = addProposal || ePackage.getName() != null && (String.valueOf(ePackage.getName()) + "." + clazz.getName()).startsWith(incompleteName);
            addProposal = addProposal || ePackage.getName() != null && (String.valueOf(ePackage.getName()) + "::" + clazz.getName()).startsWith(incompleteName);
            boolean bl = addProposal = addProposal && clazz instanceof EClass;
            if (!addProposal) continue;
            proposals.add(clazz);
        }
    }
}

