/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal.provider;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tips.core.IHtmlTip;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipAction;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.ide.internal.provider.TipsTipProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class Tip6_ActionsTip
extends Tip
implements IHtmlTip {
    private TipImage fImage;

    public TipImage getImage() {
        if (this.fImage == null) {
            Optional<TipImage> tipImage = TipsTipProvider.getTipImage("images/tips/actions.png");
            this.fImage = tipImage.map(i -> i.setAspectRatio(758, 480, true)).orElse(null);
        }
        return this.fImage;
    }

    public Tip6_ActionsTip(String providerId) {
        super(providerId);
    }

    public List<TipAction> getActions() {
        TipAction tip1 = Tip6_ActionsTip.tip("Clock", "What is the time?", "icons/clock.png", () -> {
            boolean bl = MessageDialog.openConfirm(null, (String)this.getSubject(), (String)DateFormat.getTimeInstance().format(Calendar.getInstance().getTime()));
        });
        TipAction tip2 = Tip6_ActionsTip.tip("Open Preferences", "Opens the preferences", null, () -> {
            PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"myPreferencePage", null, null);
            if (pref != null) {
                pref.open();
            }
        });
        TipAction tip3 = Tip6_ActionsTip.tip("Open Dialog", "Opens a Dialog", "icons/asterisk.png", () -> {
            boolean bl = MessageDialog.openConfirm(null, (String)this.getSubject(), (String)"A dialog was opened.");
        });
        return List.of(tip1, tip2, tip3);
    }

    private static TipAction tip(String text, String tooltip, String imagePath, Runnable runner) {
        TipImage image = imagePath != null ? (TipImage)TipsTipProvider.getTipImage(imagePath).map(i -> i.setAspectRatio(1.0)).orElse(null) : null;
        return new TipAction(text, tooltip, () -> Display.getDefault().syncExec(runner), image);
    }

    public Date getCreationDate() {
        return TipsTipProvider.getDateFromYYMMDD(9, 1, 2019);
    }

    public String getSubject() {
        return "Actions";
    }

    public String getHTML() {
        return "<h2>ActionTips</h2>Some tips enable you to start one or more actions. If this is the case then an additional button will be displayed like in this tip. Go ahead and press the button, or choose another action from the drop down menu next to the button. <br><br><br>";
    }
}

