/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImageDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.ClasspathImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.DefaultImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.FileImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.NullImagePage;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImageEvaluator;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginFileImagePage;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginImagesRoot;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;

public final class ImageDescriptorPropertyEditor
extends TextDialogPropertyEditor
implements IClipboardSourceProvider {
    public static final PropertyEditor INSTANCE = new ImageDescriptorPropertyEditor();

    private ImageDescriptorPropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        if (property.getValue() != Property.UNKNOWN_VALUE) {
            Expression expression = ((GenericProperty)property).getExpression();
            if (expression instanceof NullLiteral) {
                return "(null)";
            }
            if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.jface.resource.ImageDescriptor", (String)"createFromFile(java.lang.Class,java.lang.String)")) {
                MethodInvocation invocation = (MethodInvocation)expression;
                Expression locationExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
                Expression pathExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1);
                Object path = JavaInfoEvaluationHelper.getValue((Expression)pathExpression);
                if (locationExpression instanceof NullLiteral) {
                    return "File: " + path;
                }
                return "Classpath: " + path;
            }
            if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.ResourceManager", (String)"getImageDescriptor(java.lang.String)")) {
                MethodInvocation invocation = (MethodInvocation)expression;
                Expression stringExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
                return "File: " + JavaInfoEvaluationHelper.getValue((Expression)stringExpression);
            }
            if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.ResourceManager", (String)"getImageDescriptor(java.lang.Class,java.lang.String)")) {
                MethodInvocation invocation = (MethodInvocation)expression;
                Expression stringExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1);
                return "Classpath: " + JavaInfoEvaluationHelper.getValue((Expression)stringExpression);
            }
            String[] imageValue = ImageEvaluator.getPluginImageValue(property);
            if (imageValue != null) {
                return "Plugin: " + imageValue[0] + " " + imageValue[1];
            }
        }
        return null;
    }

    public String getClipboardSource(GenericProperty property) throws Exception {
        if (property.getValue() != Property.UNKNOWN_VALUE) {
            Expression expression = property.getExpression();
            if (expression instanceof NullLiteral) {
                return "null";
            }
            JavaInfo javaInfo = property.getJavaInfo();
            String[] imageValue = ImageEvaluator.getPluginImageValue((Property)property);
            if (imageValue == null) {
                IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
                boolean useResourceManager = preferences.getBoolean("useResourceManager");
                String text = this.getText((Property)property);
                if (text.startsWith("File: ")) {
                    String path = text.substring("File: ".length());
                    String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)path);
                    if (useResourceManager) {
                        return "org.eclipse.wb.swt.ResourceManager.getImageDescriptor(" + pathSource + ")";
                    }
                    return "org.eclipse.jface.resource.ImageDescriptor.createFromFile(null, " + pathSource + ")";
                }
                if (text.startsWith("Classpath: ")) {
                    String path = text.substring("Classpath: ".length());
                    String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)path);
                    if (useResourceManager) {
                        return "org.eclipse.wb.swt.ResourceManager.getImageDescriptor({wbp_classTop}, " + pathSource + ")";
                    }
                    return "org.eclipse.jface.resource.ImageDescriptor.createFromFile({wbp_classTop}, " + pathSource + ")";
                }
            } else {
                String symbolicName = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)imageValue[0]);
                String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)imageValue[1]);
                return "org.eclipse.wb.swt.ResourceManager.getPluginImageDescriptor(" + symbolicName + ", " + pathSource + ")";
            }
        }
        return null;
    }

    protected void openDialog(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        JavaInfo javaInfo = genericProperty.getJavaInfo();
        IJavaProject javaProject = javaInfo.getEditor().getJavaProject();
        ImageDialog imageDialog = new ImageDialog(javaProject);
        String[] imageValue = ImageEvaluator.getPluginImageValue(property);
        if (imageValue == null) {
            String text = this.getText(property);
            if (text == null) {
                imageDialog.setInput("DEFAULT", null);
            } else if (text.equals("(null)")) {
                imageDialog.setInput("NULL", null);
            } else if (text.startsWith("File: ")) {
                path = text.substring("File: ".length());
                imageDialog.setInput("FILE", path);
            } else if (text.startsWith("Classpath: ")) {
                path = text.substring("Classpath: ".length());
                imageDialog.setInput("CLASSPATH", path);
            }
        } else {
            imageDialog.setInput("PLUGIN", imageValue);
        }
        if (imageDialog.open() == 0) {
            ImageInfo imageInfo = imageDialog.getImageInfo();
            String source = null;
            String pageId = imageInfo.getPageId();
            if (pageId != "DEFAULT") {
                if (pageId == "NULL") {
                    source = "null";
                } else {
                    IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
                    boolean useResourceManager = preferences.getBoolean("useResourceManager");
                    if (useResourceManager) {
                        ManagerUtils.ensure_ResourceManager(javaInfo);
                    }
                    if (pageId == "FILE") {
                        String path = (String)imageInfo.getData();
                        String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)path);
                        source = useResourceManager ? "org.eclipse.wb.swt.ResourceManager.getImageDescriptor(" + pathSource + ")" : "org.eclipse.jface.resource.ImageDescriptor.createFromFile(null, " + pathSource + ")";
                    } else if (pageId == "CLASSPATH") {
                        String path = "/" + imageInfo.getData();
                        String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)path);
                        source = useResourceManager ? "org.eclipse.wb.swt.ResourceManager.getImageDescriptor({wbp_classTop}, " + pathSource + ")" : "org.eclipse.jface.resource.ImageDescriptor.createFromFile(null, " + pathSource + ")";
                    } else if (pageId == "PLUGIN") {
                        ManagerUtils.ensure_ResourceManager(javaInfo);
                        String[] data = (String[])imageInfo.getData();
                        String symbolicName = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)data[0]);
                        String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)data[1]);
                        source = "org.eclipse.wb.swt.ResourceManager.getPluginImageDescriptor(" + symbolicName + ", " + pathSource + ")";
                    }
                }
            }
            genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
        }
    }

    private static final class ImageDialog
    extends AbstractImageDialog {
        private final IJavaProject m_javaProject;

        protected ImageDialog(IJavaProject javaProject) {
            super(DesignerPlugin.getShell(), (AbstractUIPlugin)Activator.getDefault());
            this.m_javaProject = javaProject;
        }

        protected void addPages(Composite parent) {
            this.addPage((AbstractImagePage)new ClasspathImagePage(parent, 0, (AbstractImageDialog)this, this.m_javaProject));
            this.addPage((AbstractImagePage)new FileImagePage(parent, 0, (AbstractImageDialog)this));
            this.addPage((AbstractImagePage)new NullImagePage(parent, 0, (AbstractImageDialog)this));
            this.addPage((AbstractImagePage)new DefaultImagePage(parent, 0, (AbstractImageDialog)this));
            if (PluginImagesRoot.testPluginProject(this.m_javaProject.getProject())) {
                this.addPage((AbstractImagePage)PluginFileImagePage.createPage(parent, 0, this, this.m_javaProject.getProject()));
            }
        }
    }
}

