/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout.form;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormSide;
import org.eclipse.wb.internal.swt.model.layout.form.IFormDataInfo;
import org.eclipse.wb.internal.swt.support.FormLayoutSupport;
import org.eclipse.wb.internal.xwt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.xwt.model.layout.form.FormAttachmentInfo;
import org.eclipse.wb.internal.xwt.model.layout.form.VirtualFormAttachmentCreationSupport;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

public final class FormDataInfo
extends LayoutDataInfo
implements IFormDataInfo<ControlInfo> {
    private ComplexProperty m_propertyLeft;
    private ComplexProperty m_propertyRight;
    private ComplexProperty m_propertyTop;
    private ComplexProperty m_propertyBottom;

    public FormDataInfo(EditorContext editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                FormDataInfo.this.removeBroadcastListener(this);
                ControlInfo parentControl = (ControlInfo)FormDataInfo.this.getParent();
                FormDataInfo.this.initAttachments(parentControl);
            }
        });
    }

    private void initAttachments(ControlInfo parentControl) throws Exception {
        this.initAttachment(FormSide.LEFT, parentControl);
        this.initAttachment(FormSide.RIGHT, parentControl);
        this.initAttachment(FormSide.TOP, parentControl);
        this.initAttachment(FormSide.BOTTOM, parentControl);
    }

    private void initAttachment(FormSide side, ControlInfo parentControl) throws Exception {
        String sideFieldName = side.getField();
        DocumentElement attachmentElement = this.getAttachmentElement(sideFieldName);
        if (attachmentElement != null) {
            List atts = this.getChildren(FormAttachmentInfo.class);
            for (FormAttachmentInfo attachment : atts) {
                if (!FormDataInfo.getAttachmentSideName(attachment).equals(sideFieldName)) continue;
                attachment.setSide(side);
                return;
            }
        } else {
            this.addVirtualAttachment(side);
        }
    }

    private static String getAttachmentSideName(FormAttachmentInfo attachment) {
        String property = attachment.getElement().getParent().getTag();
        return StringUtils.removeStart((String)property, (String)"FormData.");
    }

    private DocumentElement getAttachmentElement(String field) {
        DocumentElement thisElement = this.getCreationSupport().getElement();
        DocumentElement attachmentParentElement = thisElement.getChild("FormData." + field, false);
        if (attachmentParentElement != null) {
            return attachmentParentElement.getChildAt(0);
        }
        return null;
    }

    private FormAttachmentInfo addVirtualAttachment(FormSide side) throws Exception {
        VirtualFormAttachmentCreationSupport creationSupport = new VirtualFormAttachmentCreationSupport(this, FormLayoutSupport.createFormAttachment(), side);
        FormAttachmentInfo attachment = (FormAttachmentInfo)XmlObjectUtils.createObject((EditorContext)this.getContext(), FormAttachment.class, (CreationSupport)creationSupport);
        attachment.setSide(side);
        this.addChild((ObjectInfo)attachment);
        return attachment;
    }

    /*
     * WARNING - void declaration
     */
    public FormAttachmentInfo getAttachment(int sideInt) throws Exception {
        FormSide side = FormSide.get((int)sideInt);
        for (ObjectInfo child : this.getChildren()) {
            void attachment;
            ObjectInfo objectInfo = child;
            if (!(objectInfo instanceof FormAttachmentInfo)) continue;
            FormAttachmentInfo cfr_ignored_0 = (FormAttachmentInfo)objectInfo;
            FormAttachmentInfo cfr_ignored_1 = (FormAttachmentInfo)objectInfo;
            if (attachment.getSide() != side) continue;
            return attachment;
        }
        return this.addVirtualAttachment(side);
    }

    public void setWidth(int value) throws Exception {
        this.getPropertyByTitle("width").setValue((Object)value);
    }

    public void setHeight(int value) throws Exception {
        this.getPropertyByTitle("height").setValue((Object)value);
    }

    protected void refresh_finish() throws Exception {
        super.refresh_finish();
        this.ensureAttachmentProperties();
        this.updateAttachmentPropertyText(1, this.m_propertyLeft);
        this.updateAttachmentPropertyText(4, this.m_propertyRight);
        this.updateAttachmentPropertyText(8, this.m_propertyTop);
        this.updateAttachmentPropertyText(32, this.m_propertyBottom);
    }

    protected List<Property> getPropertyList() throws Exception {
        this.ensureAttachmentProperties();
        return super.getPropertyList();
    }

    private void updateAttachmentPropertyText(int side, ComplexProperty property) throws Exception {
        FormAttachmentInfo attachment = this.getAttachment(side);
        property.setText(attachment.toString());
    }

    private void ensureAttachmentProperties() throws Exception {
        if (this.m_propertyLeft == null) {
            this.m_propertyLeft = this.createAttachmentProperty(1, "left");
            this.m_propertyRight = this.createAttachmentProperty(4, "right");
            this.m_propertyTop = this.createAttachmentProperty(8, "top");
            this.m_propertyBottom = this.createAttachmentProperty(32, "bottom");
        }
    }

    protected void sortPropertyList(List<Property> properties) {
        ArrayList sorted = Lists.newArrayList();
        sorted.add(this.m_propertyLeft);
        sorted.add(this.m_propertyRight);
        sorted.add(this.m_propertyTop);
        sorted.add(this.m_propertyBottom);
        sorted.add(PropertyUtils.getByTitle(properties, (String)"width"));
        sorted.add(PropertyUtils.getByTitle(properties, (String)"height"));
        properties.clear();
        properties.addAll(sorted);
    }

    private ComplexProperty createAttachmentProperty(int side, String title) throws Exception {
        final FormAttachmentInfo attachment = this.getAttachment(side);
        ComplexProperty attachmentProperty = new ComplexProperty(title, attachment.toString()){

            public void setValue(Object value) throws Exception {
                if (value == Property.UNKNOWN_VALUE) {
                    attachment.delete();
                }
            }
        };
        Collection selectedProperties = CollectionUtils.select(Arrays.asList(attachment.getProperties()), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Property property = (Property)object;
                return !property.getTitle().equals("Class") && !property.getTitle().equals("Constructor");
            }
        });
        attachmentProperty.setProperties(selectedProperties.toArray(new Property[selectedProperties.size()]));
        return attachmentProperty;
    }
}

