/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Project;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import com.google.gwtorm.client.StringKey;

public final class AccountProjectWatch {
    public static final String FILTER_ALL = "*";
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected boolean notifyNewChanges;
    @Column(id=3)
    protected boolean notifyAllComments;
    @Column(id=4)
    protected boolean notifySubmittedChanges;

    protected AccountProjectWatch() {
    }

    public AccountProjectWatch(Key k) {
        this.key = k;
    }

    public Key getKey() {
        return this.key;
    }

    public Account.Id getAccountId() {
        return this.key.accountId;
    }

    public Project.NameKey getProjectNameKey() {
        return this.key.projectName;
    }

    public String getFilter() {
        return FILTER_ALL.equals(this.key.filter.get()) ? null : this.key.filter.get();
    }

    public boolean isNotifyNewChanges() {
        return this.notifyNewChanges;
    }

    public void setNotifyNewChanges(boolean a) {
        this.notifyNewChanges = a;
    }

    public boolean isNotifyAllComments() {
        return this.notifyAllComments;
    }

    public void setNotifyAllComments(boolean a) {
        this.notifyAllComments = a;
    }

    public boolean isNotifySubmittedChanges() {
        return this.notifySubmittedChanges;
    }

    public void setNotifySubmittedChanges(boolean a) {
        this.notifySubmittedChanges = a;
    }

    public static class Filter
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String filter;

        protected Filter() {
        }

        public Filter(String f) {
            this.filter = f != null && !f.isEmpty() ? f : AccountProjectWatch.FILTER_ALL;
        }

        public String get() {
            return this.filter;
        }

        protected void set(String newValue) {
            this.filter = newValue;
        }
    }

    public static class Key
    extends CompoundKey<Account.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Account.Id accountId;
        @Column(id=2)
        protected Project.NameKey projectName;
        @Column(id=3)
        protected Filter filter;

        protected Key() {
            this.accountId = new Account.Id();
            this.projectName = new Project.NameKey();
            this.filter = new Filter();
        }

        public Key(Account.Id a, Project.NameKey g, String f) {
            this.accountId = a;
            this.projectName = g;
            this.filter = new Filter(f);
        }

        public Account.Id getParentKey() {
            return this.accountId;
        }

        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.projectName, this.filter};
        }
    }
}

