/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.refactoring.ApplySuggestedFixes;
import com.google.javascript.refactoring.RefactoringDriver;
import com.google.javascript.refactoring.RefasterJsScanner;
import com.google.javascript.refactoring.SuggestedFix;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.BooleanOptionHandler;

final class RefasterJs {
    @Option(name="--help", hidden=true, handler=BooleanOptionHandler.class, usage="Show instructions for how to use RefasterJS")
    private boolean displayHelp = false;
    @Option(name="--inputs", usage="List of input files for the refactoring. You may also use glob patterns to match files. For example, use --js='**.js' --js='!**_test.js' to recursively include all js files that do not end in _test.js")
    private List<String> inputs = new ArrayList<String>();
    @Option(name="--externs", usage="List of externs files to use in the compilation.")
    private List<String> externs = new ArrayList<String>();
    @Option(name="--refasterjs_template", usage="Location of the JS file to use as the RefasterJS template.")
    private String refasterJsTemplate = null;
    @Option(name="--env", usage="Which set of externs to include. Defaults to BROWSER.")
    private CompilerOptions.Environment environment = CompilerOptions.Environment.BROWSER;
    @Option(name="--dry_run", usage="Use this to display what changes would be made without applying the changes.")
    private boolean dryRun = false;
    @Option(name="--verbose", usage="Use this to print verbose statements from RefasterJS.")
    private boolean verbose = false;
    @Argument
    private List<String> arguments = new ArrayList<String>();

    RefasterJs() {
    }

    private void doMain(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser((Object)this);
        parser.parseArgument(args);
        if (args.length < 1 || this.displayHelp) {
            CmdLineParser p = new CmdLineParser((Object)this);
            p.printUsage((OutputStream)System.out);
            return;
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.refasterJsTemplate) ? 1 : 0) != 0, (Object)"--refasterjs_template must be provided");
        List<String> fileInputs = this.getInputs();
        Preconditions.checkArgument((!fileInputs.isEmpty() ? 1 : 0) != 0, (Object)"At least one input must be provided in the --inputs flag.");
        for (String input : fileInputs) {
            Preconditions.checkArgument((boolean)new File(input).exists(), (String)"Input file %s does not exist.", (Object[])new Object[]{input});
        }
        if (!this.verbose) {
            Logger errorManagerLogger = Logger.getLogger("com.google.javascript.jscomp");
            errorManagerLogger.setLevel(Level.OFF);
        }
        RefasterJsScanner scanner = new RefasterJsScanner();
        scanner.loadRefasterJsTemplate(this.refasterJsTemplate);
        CompilerOptions options = new CompilerOptions();
        options.setEnvironment(this.environment);
        RefactoringDriver driver = new RefactoringDriver.Builder(scanner).addExterns(CommandLineRunner.getBuiltinExterns(this.environment)).addExternsFromFile(this.getExterns()).addInputsFromFile(fileInputs).build();
        System.out.println("Compiling JavaScript code and searching for suggested fixes.");
        List<SuggestedFix> fixes = driver.drive();
        if (!this.verbose) {
            ErrorManager errorManager = driver.getCompiler().getErrorManager();
            System.out.println("Compiler results: " + errorManager.getErrorCount() + " errors and " + errorManager.getWarningCount() + " warnings.");
        }
        System.out.println("Found " + fixes.size() + " suggested fixes.");
        if (this.dryRun) {
            if (!fixes.isEmpty()) {
                System.out.println("SuggestedFixes: " + fixes);
            }
        } else {
            TreeSet affectedFiles = new TreeSet();
            for (SuggestedFix fix : fixes) {
                affectedFiles.addAll(fix.getReplacements().keySet());
            }
            System.out.println("Modifying affected files: " + affectedFiles);
            ApplySuggestedFixes.applySuggestedFixesToFiles(fixes);
        }
    }

    private List<String> getInputs() throws IOException {
        HashSet<String> patterns = new HashSet<String>();
        Splitter commaSplitter = Splitter.on((char)',');
        for (String input : this.inputs) {
            patterns.addAll(commaSplitter.splitToList((CharSequence)input));
        }
        patterns.addAll(this.arguments);
        return CommandLineRunner.findJsFiles(patterns);
    }

    private List<String> getExterns() throws IOException {
        HashSet<String> patterns = new HashSet<String>();
        Splitter commaSplitter = Splitter.on((char)',');
        for (String extern : this.externs) {
            patterns.addAll(commaSplitter.splitToList((CharSequence)extern));
        }
        return CommandLineRunner.findJsFiles(patterns);
    }

    public static void main(String[] args) throws Exception {
        new RefasterJs().doMain(args);
    }
}

