/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.io.File;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.memory.transport.IScrollMemory;
import org.eclipse.cdt.debug.core.memory.transport.ImportRequest;
import org.eclipse.cdt.debug.core.memory.transport.WriteMemory;
import org.eclipse.cdt.debug.internal.core.memory.transport.SRecordImport;
import org.eclipse.cdt.debug.internal.core.memory.transport.TransportJob;
import org.eclipse.cdt.debug.internal.ui.memory.transport.ScrollMemory;
import org.eclipse.cdt.debug.internal.ui.memory.transport.WriteMemoryBlock;
import org.eclipse.cdt.debug.ui.memory.transport.ImportMemoryDialog;
import org.eclipse.cdt.debug.ui.memory.transport.Messages;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryImporter;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SRecordImporter
implements IMemoryImporter {
    File fInputFile;
    BigInteger fStartAddress;
    Boolean fScrollToStart;
    private Text fStartText;
    private Text fFileText;
    private Button fComboRestoreToThisAddress;
    private Button fComboRestoreToFileAddress;
    private Button fScrollToBeginningOnImportComplete;
    private IMemoryBlock fMemoryBlock;
    private ImportMemoryDialog fParentDialog;
    private IDialogSettings fProperties;

    @Override
    public Control createControl(final Composite parent, IMemoryBlock memBlock, IDialogSettings properties, ImportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                SRecordImporter.this.fProperties.put("File", SRecordImporter.this.fFileText.getText().trim());
                SRecordImporter.this.fProperties.put("Start", SRecordImporter.this.fStartText.getText().trim());
                SRecordImporter.this.fProperties.put("ScrollToStart", SRecordImporter.this.fScrollToBeginningOnImportComplete.getSelection());
                SRecordImporter.this.fProperties.put("CustomStartAddress", SRecordImporter.this.fComboRestoreToThisAddress.getSelection());
                try {
                    if (SRecordImporter.this.fProperties.getBoolean("CustomStartAddress")) {
                        SRecordImporter.this.fStartAddress = SRecordImporter.this.getStartAddress();
                    }
                    SRecordImporter.this.fInputFile = SRecordImporter.this.getFile();
                    SRecordImporter.this.fScrollToStart = SRecordImporter.this.getScrollToStart();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        this.fComboRestoreToFileAddress = new Button(composite, 16);
        this.fComboRestoreToFileAddress.setSelection(true);
        this.fComboRestoreToFileAddress.setText(Messages.getString("SRecordImporter.FileAddressRestore"));
        this.fComboRestoreToFileAddress.setSelection(!this.fProperties.getBoolean("CustomStartAddress"));
        this.fComboRestoreToThisAddress = new Button(composite, 16);
        this.fComboRestoreToThisAddress.setText(Messages.getString("SRecordImporter.CustomAddressRestore"));
        this.fComboRestoreToThisAddress.setSelection(this.fProperties.getBoolean("CustomStartAddress"));
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fComboRestoreToFileAddress);
        this.fComboRestoreToThisAddress.setLayoutData((Object)data);
        this.fStartText = new Text(composite, 2048);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fComboRestoreToFileAddress);
        data.left = new FormAttachment((Control)this.fComboRestoreToThisAddress);
        data.width = 120;
        this.fStartText.setLayoutData((Object)data);
        this.fComboRestoreToFileAddress.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SRecordImporter.this.validate();
            }
        });
        this.fComboRestoreToThisAddress.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                    SRecordImporter.this.getStartAddress();
                    SRecordImporter.this.validate();
                }
                catch (Exception ex) {
                    SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                    SRecordImporter.this.fParentDialog.setValid(false);
                }
            }
        });
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 2048);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText(Messages.getString("Importer.File"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText(Messages.getString("Importer.Browse"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        String textValue = this.fProperties.get("File");
        this.fFileText.setText(textValue != null ? textValue : "");
        textValue = this.fProperties.get("Start");
        this.fStartText.setText(textValue != null ? textValue : "0x0");
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4096);
                dialog.setText(Messages.getString("SRecordImporter.ChooseFile"));
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{Messages.getString("Importer.AllFiles")});
                dialog.setFileName(SRecordImporter.this.fFileText.getText().trim());
                dialog.open();
                String filename = dialog.getFileName();
                if (filename != null && filename.length() != 0) {
                    SRecordImporter.this.fFileText.setText(String.valueOf(dialog.getFilterPath()) + File.separator + filename);
                }
                SRecordImporter.this.validate();
            }
        });
        this.fStartText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    boolean restoreToAddress = SRecordImporter.this.fComboRestoreToThisAddress.getSelection();
                    if (restoreToAddress) {
                        SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                        SRecordImporter.this.getStartAddress();
                        SRecordImporter.this.validate();
                    } else {
                        try {
                            SRecordImporter.this.getStartAddress();
                            SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                        }
                        catch (Exception ex) {
                            SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                        }
                    }
                }
                catch (Exception ex) {
                    SRecordImporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                    SRecordImporter.this.validate();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SRecordImporter.this.validate();
            }
        });
        this.fScrollToBeginningOnImportComplete = new Button(composite, 32);
        this.fScrollToBeginningOnImportComplete.setText(Messages.getString("SRecordImporter.ScrollToStart"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton);
        this.fScrollToBeginningOnImportComplete.setLayoutData((Object)data);
        boolean scrollToStart = this.fProperties.getBoolean("ScrollToStart");
        this.fScrollToBeginningOnImportComplete.setSelection(scrollToStart);
        Label spacingLabel = new Label(composite, 0);
        spacingLabel.setText("");
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)this.fScrollToBeginningOnImportComplete);
        spacingLabel.setLayoutData((Object)data);
        Label restrictionLabel = new Label(composite, 0);
        restrictionLabel.setText(Messages.getString("SRecordImporter.32BitLimitationMessage"));
        data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment((Control)spacingLabel);
        restrictionLabel.setLayoutData((Object)data);
        composite.pack();
        parent.pack();
        Display.getDefault().asyncExec(() -> this.validate());
        return composite;
    }

    private void validate() {
        boolean isValid = true;
        try {
            boolean restoreToAddress = this.fComboRestoreToThisAddress.getSelection();
            if (restoreToAddress) {
                this.getStartAddress();
            }
            if (this.fFileText.getText().trim().length() == 0) {
                isValid = false;
            }
            if (!this.getFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    public boolean getScrollToStart() {
        return this.fScrollToBeginningOnImportComplete.getSelection();
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = (text = text.trim()).startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        if (startAddress.bitLength() > 32) {
            throw new NumberFormatException("Start Address is larger than 32 bits");
        }
        return startAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText().trim());
    }

    @Override
    public String getId() {
        return "srecord";
    }

    @Override
    public String getName() {
        return Messages.getString("SRecordImporter.Name");
    }

    @Override
    public void importMemory() {
        try {
            IScrollMemory scroll = this.fScrollToStart != false ? new ScrollMemory(this.fParentDialog) : IScrollMemory.ignore();
            IMemoryBlockExtension block = (IMemoryBlockExtension)this.fMemoryBlock;
            ImportRequest request = new ImportRequest(block.getBigBaseAddress(), this.fStartAddress, (WriteMemory)new WriteMemoryBlock(block));
            SRecordImport memoryImport = new SRecordImport(this.fInputFile, request, scroll, this.fProperties.getBoolean("CustomStartAddress"));
            TransportJob job = new TransportJob("Memory Import from S-Record File", (ICoreRunnable)memoryImport);
            job.setUser(true);
            job.schedule();
        }
        catch (DebugException e) {
            ErrorDialog.openError((Shell)this.fParentDialog.getShell(), (String)"Import Failure", (String)"Failed to retrieve base memory address", (IStatus)e.getStatus());
        }
    }
}

