/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.StringTokenizer;

public class PRSPersistenceUtility {
    public static final String LINESEP = System.getProperty("line.separator");
    private static final String STR_HASH = "#";
    private static final char MARKER_NULL = 'N';
    private static final char MARKER_STRING = '\"';
    private static final char MARKER_CHAR = 'c';
    private static final char MARKER_INT = 'i';
    private static final char MARKER_LONG = 'l';
    private static final char MARKER_DOUBLE = 'd';
    private static final char MARKER_BOOLEAN = 'b';
    private static final char MARKER_DECIMAL = 'D';
    private static final char MARKER_TIMESTAMP = 'T';

    public static LineNumberReader openFileForRead(File file) {
        FileReader rdr;
        try {
            rdr = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return new LineNumberReader(rdr);
    }

    public static PrintWriter openFileForAppend(File file) {
        return PRSPersistenceUtility.openFileForWrite(file, true);
    }

    public static PrintWriter openFileForCreate(File file) {
        return PRSPersistenceUtility.openFileForWrite(file, false);
    }

    private static PrintWriter openFileForWrite(File file, boolean append) {
        FileOutputStream os;
        if (file == null) {
            return null;
        }
        try {
            os = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return new PrintWriter(os);
    }

    public static void addLine(StringBuilder sb, String line) {
        sb.append(line);
        PRSPersistenceUtility.newline(sb);
    }

    public static void newline(StringBuilder sb) {
        sb.append(LINESEP);
    }

    public static void append(StringBuilder sb, Object o) {
        if (o == null) {
            PRSPersistenceUtility.appendNull(sb);
            return;
        }
        if (o instanceof String) {
            PRSPersistenceUtility.append(sb, (String)o);
        } else if (o instanceof Long) {
            PRSPersistenceUtility.append(sb, (Long)o);
        } else if (o instanceof Double) {
            PRSPersistenceUtility.append(sb, (Double)o);
        } else if (o instanceof BigDecimal) {
            PRSPersistenceUtility.append(sb, (BigDecimal)o);
        } else if (o instanceof Timestamp) {
            PRSPersistenceUtility.append(sb, (Timestamp)o);
        } else {
            PRSPersistenceUtility.append(sb, o.toString());
        }
    }

    public static void appendNull(StringBuilder sb) {
        sb.append('N');
        sb.append("|");
    }

    public static void append(StringBuilder sb, String s) {
        if (s == null) {
            PRSPersistenceUtility.appendNull(sb);
            return;
        }
        sb.append('\"');
        sb.append(PRSPersistenceUtility.encodeString(s));
        sb.append('|');
    }

    public static String encodeString(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        int ii = 0;
        while (ii < len) {
            sb.append(PRSPersistenceUtility.encodeChar(s.charAt(ii)));
            ++ii;
        }
        return sb.toString();
    }

    private static String encodeChar(char ch) {
        return ch >= ' ' && ch < '\u007f' && ch != '|' && ch != '#' ? "" + ch : String.format("#%04x", ch & 0xFFFF);
    }

    public static void append(StringBuilder sb, int i) {
        sb.append('i');
        sb.append(i);
        sb.append('|');
    }

    public static void append(StringBuilder sb, long l) {
        sb.append('l');
        sb.append(l);
        sb.append('|');
    }

    public static void append(StringBuilder sb, double d) {
        sb.append('d');
        sb.append(d);
        sb.append('|');
    }

    public static void append(StringBuilder sb, BigDecimal d) {
        sb.append('D');
        sb.append(d);
        sb.append('|');
    }

    public static void append(StringBuilder sb, Timestamp t) {
        sb.append('T');
        sb.append(t.getTime());
        sb.append('|');
    }

    public static void append(StringBuilder sb, char ch) {
        sb.append('c');
        sb.append(PRSPersistenceUtility.encodeChar(ch));
        sb.append('|');
    }

    public static void append(StringBuilder sb, boolean b) {
        sb.append('b');
        sb.append(b ? (char)'t' : 'f');
        sb.append('|');
    }

    public static Object getToken(StringTokenizer st) {
        if (!st.hasMoreTokens()) {
            return null;
        }
        String tok = st.nextToken();
        if (tok == null || tok.length() < 1) {
            return null;
        }
        char marker = tok.charAt(0);
        tok = tok.substring(1);
        switch (marker) {
            case '\"': 
            case 'c': {
                return PRSPersistenceUtility.decodeString(tok);
            }
            case 'i': {
                return Integer.valueOf(tok);
            }
            case 'l': {
                return Long.valueOf(tok);
            }
            case 'd': {
                return Double.valueOf(tok);
            }
            case 'D': {
                return new BigDecimal(tok);
            }
            case 'b': {
                return tok.charAt(0) == 't';
            }
            case 'T': {
                return new Timestamp(Long.parseLong(tok));
            }
        }
        return null;
    }

    public static String getStringToken(StringTokenizer st) {
        Object o = PRSPersistenceUtility.getToken(st);
        return o instanceof String ? (String)o : null;
    }

    private static String decodeString(String s) {
        int hash = s.indexOf(STR_HASH);
        if (hash < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (hash >= 0 && hash < sb.length() - 4) {
            char ch = (char)Integer.parseInt(sb.substring(hash + 1, hash + 5), 16);
            sb.setCharAt(hash, ch);
            sb.delete(hash + 1, hash + 5);
            if (hash >= sb.length() - 1) continue;
            hash = sb.indexOf(STR_HASH, hash + 1);
        }
        return sb.toString();
    }

    public static int getIntToken(StringTokenizer st) {
        Object o = PRSPersistenceUtility.getToken(st);
        return o instanceof Integer ? (Integer)o : 0;
    }

    public static long getLongToken(StringTokenizer st) {
        Object o = PRSPersistenceUtility.getToken(st);
        return o instanceof Long ? (Long)o : 0L;
    }

    public static char getCharToken(StringTokenizer st) {
        Object o = PRSPersistenceUtility.getToken(st);
        return o instanceof String && ((String)o).length() > 0 ? ((String)o).charAt(0) : (char)'\u0000';
    }

    public static boolean getBooleanToken(StringTokenizer st) {
        Object o = PRSPersistenceUtility.getToken(st);
        return o instanceof Boolean && (Boolean)o != false;
    }
}

