/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.preferences;

import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.ui.CDOLabelDecorator;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.prefs.OMPreferencePage;
import org.eclipse.net4j.util.ui.widgets.TextAndDisable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class CDOUIPreferencePage
extends OMPreferencePage {
    private TextAndDisable decoration;
    private Text lockTimeout;
    private Button autoReload;

    public CDOUIPreferencePage() {
        super(OM.PREFS);
    }

    protected Control createUI(Composite parent) {
        Composite composite = UIUtil.createGridComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)UIUtil.createGridData());
        new Label(composite, 0).setText(Messages.getString("CDOUIPreferencePage.0"));
        this.decoration = new TextAndDisable(composite, 2048, CDOLabelDecorator.NO_DECORATION){

            protected GridData createTextLayoutData() {
                return UIUtil.createGridData((boolean)true, (boolean)false);
            }
        };
        this.decoration.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        Text text = this.decoration.getText();
        StringBuffer tags = new StringBuffer();
        String[] stringArray = CDOLabelDecorator.DECORATION_PROPOSALS;
        int n = CDOLabelDecorator.DECORATION_PROPOSALS.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            tags.append(String.valueOf(tag) + " ");
            ++n2;
        }
        text.setToolTipText(String.valueOf(Messages.getString("CDOUIPreferencePage.2")) + tags.toString());
        TextContentAdapter contentAdapter = new TextContentAdapter();
        SimpleContentProposalProvider provider = new SimpleContentProposalProvider(CDOLabelDecorator.DECORATION_PROPOSALS);
        new ContentAssistCommandAdapter((Control)text, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)provider, null, new char[]{'$'}, true);
        UIUtil.addDecorationMargin((Control)text);
        Label lockTimeoutLabel = new Label(composite, 0);
        lockTimeoutLabel.setText(Messages.getString("CDOUIPreferencePage.3"));
        lockTimeoutLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.lockTimeout = new Text(composite, 2048);
        this.lockTimeout.setLayoutData((Object)new GridData(4, 2, true, false));
        UIUtil.setIndentation((Control)this.lockTimeout, (int)7, (int)10);
        this.addListeners((Control)this.lockTimeout);
        this.autoReload = new Button(composite, 32);
        this.autoReload.setText(Messages.getString("CDOUIPreferencePage.1"));
        this.autoReload.setLayoutData((Object)UIUtil.createGridData((int)2, (int)1));
        UIUtil.setIndentation((Control)this.autoReload, (int)-1, (int)10);
        this.initValues();
        return composite;
    }

    protected void dialogChanged() {
        try {
            Long.parseLong(this.lockTimeout.getText());
            this.setErrorMessage(null);
            this.setValid(true);
        }
        catch (NumberFormatException ex) {
            this.setErrorMessage("Lock timeout value (ms) is not valid.");
            this.setValid(false);
        }
    }

    protected void initValues() {
        this.decoration.setValue((String)OM.PREF_LABEL_DECORATION.getValue());
        this.lockTimeout.setText(Long.toString((Long)OM.PREF_LOCK_TIMEOUT.getValue()));
        this.autoReload.setSelection(((Boolean)OM.PREF_EDITOR_AUTO_RELOAD.getValue()).booleanValue());
    }

    public boolean performOk() {
        OM.PREF_LABEL_DECORATION.setValue((Object)this.decoration.getValue());
        OM.PREF_LOCK_TIMEOUT.setValue((Object)Long.parseLong(this.lockTimeout.getText()));
        OM.PREF_EDITOR_AUTO_RELOAD.setValue((Object)this.autoReload.getSelection());
        return super.performOk();
    }
}

