/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;
import org.eclipse.linuxtools.internal.callgraph.launch.ConfigurationOptionsSetter;
import org.eclipse.linuxtools.internal.callgraph.launch.LaunchStapGraph;
import org.eclipse.linuxtools.internal.callgraph.launch.Messages;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class SystemTapOptionsTab
extends CLaunchConfigurationTab {
    private Text scriptFile;
    private Text binaryFile;
    private Text arguments;
    private Text outputFile;
    private Text button_D_text;
    private Text binaryArguments;
    private Text parser;
    private Text viewer;
    private Button fileBrowseButton;
    private Button workspaceBrowseButton;
    private Button button_k;
    private Button button_u;
    private Button button_w;
    private Button button_b;
    private Button button_g;
    private Button button_P;
    private Button button_t;
    private Button button_F;
    private Button buttonSkipBadvars;
    private Button buttonIgnoreDwarf;
    private Button button_q;
    private Button buttonGraphicsMode;
    private Spinner button_p_Spinner;
    private Spinner button_s_Spinner;
    private Spinner button_x_Spinner;
    private Spinner button_v_Spinner;
    private Button useColourButton;
    private String workspacePath;
    private boolean outputFileHasChanged = false;
    private boolean needsOverwritePermission = false;
    private boolean overwritePermission = false;
    private boolean changeOverwrite = false;
    private SelectionListener graphicsModeListener = SelectionListener.widgetSelectedAdapter(e -> {
        if (this.scriptFile.isEnabled()) {
            this.scriptFile.setEnabled(false);
            this.workspaceBrowseButton.setEnabled(false);
            this.fileBrowseButton.setEnabled(false);
            this.scriptFile.setText(PluginConstants.getPluginLocation() + "parse_function.stp");
        } else {
            this.scriptFile.setEnabled(true);
            this.workspaceBrowseButton.setEnabled(true);
            this.fileBrowseButton.setEnabled(true);
        }
        this.updateLaunchConfigurationDialog();
    });
    private SelectionListener selectListener = SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog());
    private ModifyListener modifyListener = e -> this.updateLaunchConfigurationDialog();
    private ModifyListener modifyListenerOutput = e -> {
        this.updateLaunchConfigurationDialog();
        this.outputFileHasChanged = true;
    };
    private FocusListener focusListener = FocusListener.focusLostAdapter(e -> {
        if (this.outputFileHasChanged) {
            this.checkOverwrite();
        }
        this.outputFileHasChanged = false;
        this.updateLaunchConfigurationDialog();
    });

    private void checkOverwrite() {
        File f = new File(this.outputFile.getText());
        this.changeOverwrite = true;
        if (f.exists()) {
            this.needsOverwritePermission = true;
            Shell sh = new Shell();
            this.overwritePermission = MessageDialog.openConfirm((Shell)sh, (String)Messages.getString("SystemTapOptionsTab.ConfirmOverwriteFileTitle"), (String)Messages.getString("SystemTapOptionsTab.ConfirmOverwriteFileMessage"));
        } else {
            this.needsOverwritePermission = false;
        }
    }

    public void createControl(Composite parent) {
        TabFolder fileFolder = new TabFolder(parent, 2048);
        fileFolder.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)fileFolder);
        TabItem fileTab = new TabItem(fileFolder, 0);
        fileTab.setText(Messages.getString("SystemTapOptionsTab.FilesTab"));
        Composite fileTop = new Composite((Composite)fileFolder, 0);
        fileTop.setLayout((Layout)new GridLayout());
        fileTop.setLayoutData((Object)new GridData(1808));
        this.createFileOption(fileTop);
        fileTab.setControl((Control)fileTop);
        TabItem commandTab = new TabItem(fileFolder, 0);
        commandTab.setText(Messages.getString("SystemTapOptionsTab.CommandsTab"));
        Composite commandTop = new Composite((Composite)fileFolder, 0);
        commandTop.setLayout((Layout)new GridLayout());
        commandTop.setLayoutData((Object)new GridData(1808));
        this.createCommandOption(commandTop);
        commandTab.setControl((Control)commandTop);
        TabItem argumentsTab = new TabItem(fileFolder, 0);
        argumentsTab.setText(Messages.getString("SystemTapOptionsTab.Arguments"));
        Composite argumentsTop = new Composite((Composite)fileFolder, 0);
        argumentsTop.setLayout((Layout)new GridLayout());
        argumentsTop.setLayoutData((Object)new GridData(1808));
        this.createArgumentsOption(argumentsTop);
        argumentsTab.setControl((Control)argumentsTop);
        TabItem binaryArgumentsTab = new TabItem(fileFolder, 0);
        binaryArgumentsTab.setText(Messages.getString("SystemTapOptionsTab.44"));
        Composite binaryArgumentsTop = new Composite((Composite)fileFolder, 0);
        binaryArgumentsTop.setLayout((Layout)new GridLayout());
        binaryArgumentsTop.setLayoutData((Object)new GridData(1808));
        this.createBinaryArgumentsOption(binaryArgumentsTop);
        binaryArgumentsTab.setControl((Control)binaryArgumentsTop);
        TabItem parserTab = new TabItem(fileFolder, 0);
        parserTab.setText("Parser");
        Composite parserTop = new Composite((Composite)fileFolder, 0);
        parserTop.setLayout((Layout)new GridLayout());
        parserTop.setLayoutData((Object)new GridData(1808));
        this.createParserOption(parserTop);
        parserTab.setControl((Control)parserTop);
    }

    private void createBinaryArgumentsOption(Composite binaryArgumentsTop) {
        Composite browseTop = new Composite(binaryArgumentsTop, 0);
        browseTop.setLayout((Layout)new GridLayout(1, false));
        GridData browseData = new GridData(768);
        browseTop.setLayoutData((Object)browseData);
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText(Messages.getString("SystemTapOptionsTab.45"));
        this.binaryArguments = new Text(browseTop, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 200;
        this.binaryArguments.setLayoutData((Object)gd);
        this.binaryArguments.addModifyListener(this.modifyListener);
    }

    private void createParserOption(Composite parserTop) {
        Composite browseTop = new Composite(parserTop, 0);
        browseTop.setLayout((Layout)new GridLayout(1, false));
        GridData browseData = new GridData(768);
        browseTop.setLayoutData((Object)browseData);
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText("Parser");
        this.parser = new Text(browseTop, 2048);
        this.parser.setLayoutData((Object)new GridData(768));
        this.parser.addModifyListener(this.modifyListener);
        Button parserButton = this.createPushButton(browseTop, "Find parsers", null);
        parserButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new ListLabelProvider());
            dialog.setTitle("Select parser");
            dialog.setMessage("Select parser to use.");
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            Object[] extensions = reg.getConfigurationElementsFor("org.eclipse.linuxtools.callgraph.core", "parser");
            dialog.setElements(extensions);
            if (dialog.open() == 0) {
                String arg = this.getUsefulLabel(dialog.getFirstResult());
                this.parser.setText(arg);
            }
        }));
        this.viewer = new Text(browseTop, 2048);
        this.viewer.setLayoutData((Object)new GridData(768));
        this.viewer.addModifyListener(this.modifyListener);
        Button viewerButton = this.createPushButton(browseTop, "Find viewers", null);
        viewerButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new ListLabelProvider());
            dialog.setTitle("Select viewer");
            dialog.setMessage("Select viewer to use.");
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.ui", "views");
            ArrayList<IConfigurationElement> ext = new ArrayList<IConfigurationElement>();
            IConfigurationElement[] iConfigurationElementArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement el = iConfigurationElementArray[n2];
                if (el.getNamespaceIdentifier().contains("org.eclipse.linuxtools")) {
                    try {
                        if (el.createExecutableExtension("class") instanceof SystemTapView) {
                            ext.add(el);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            dialog.setElements(ext.toArray());
            if (dialog.open() == 0) {
                String arg = this.getUsefulLabel(dialog.getFirstResult());
                this.viewer.setText(arg);
            }
        }));
    }

    private void createArgumentsOption(Composite argumentsTop) {
        Composite browseTop = new Composite(argumentsTop, 0);
        browseTop.setLayout((Layout)new GridLayout(1, false));
        GridData browseData = new GridData(768);
        browseTop.setLayoutData((Object)browseData);
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText(Messages.getString("SystemTapOptionsTab.SelectArguments"));
        this.arguments = new Text(browseTop, 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 200;
        this.arguments.setLayoutData((Object)gd);
        this.arguments.addModifyListener(this.modifyListener);
        Button probeFunctionButton = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.ProbeFunction"), null);
        probeFunctionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.arguments.setText(this.arguments.getText() + " process(\"" + this.binaryFile.getText() + "\").function(\"\")")));
    }

    private void createFileOption(Composite top) {
        Composite browseTop = new Composite(top, 0);
        browseTop.setLayout((Layout)new GridLayout(4, false));
        browseTop.setLayoutData((Object)new GridData(768));
        Label suppFileLabel = new Label(browseTop, 0);
        suppFileLabel.setText(Messages.getString("SystemTapOptionsTab.ScriptSelector"));
        this.scriptFile = new Text(browseTop, 2048);
        this.scriptFile.setLayoutData((Object)new GridData(768));
        this.scriptFile.addModifyListener(this.modifyListener);
        this.workspaceBrowseButton = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.WorkspaceButton"), null);
        this.workspaceBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(Messages.getString("SystemTapOptionsTab.ResourceButton"));
            dialog.setMessage(Messages.getString("SystemTapOptionsTab.SuppresionsFile"));
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0) {
                IResource resource = (IResource)dialog.getFirstResult();
                String arg = resource.getFullPath().toString();
                this.scriptFile.setText(this.workspacePath + arg);
            }
        }));
        this.fileBrowseButton = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.FileSystem"), null);
        this.fileBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String filePath = this.scriptFile.getText();
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            filePath = dialog.open();
            if (filePath != null) {
                this.scriptFile.setText(filePath);
            }
        }));
        Label binaryFileLabel = new Label(browseTop, 0);
        binaryFileLabel.setText(Messages.getString("SystemTapOptionsTab.SelectBinary"));
        this.binaryFile = new Text(browseTop, 2048);
        this.binaryFile.setLayoutData((Object)new GridData(768));
        this.binaryFile.addModifyListener(this.modifyListener);
        Button workspaceBrowseButton2 = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.WorkspaceButton2"), null);
        workspaceBrowseButton2.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(Messages.getString("SystemTapOptionsTab.SelectResource"));
            dialog.setMessage(Messages.getString("SystemTapOptionsTab.SelectSuppressions"));
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0) {
                IResource resource = (IResource)dialog.getFirstResult();
                String arg = resource.getFullPath().toString();
                this.binaryFile.setText(this.workspacePath + arg);
            }
        }));
        Button fileBrowseButton2 = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.BrowseFiles"), null);
        fileBrowseButton2.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            File file;
            String filePath = this.binaryFile.getText();
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            filePath = dialog.open();
            if (filePath != null && (file = new File(filePath)).exists()) {
                this.binaryFile.setText(filePath);
            }
        }));
        Label outputFileLabel = new Label(browseTop, 0);
        outputFileLabel.setText(Messages.getString("SystemTapOptionsTab.SelectOutput"));
        this.outputFile = new Text(browseTop, 2048);
        this.outputFile.setLayoutData((Object)new GridData(768));
        this.outputFile.addModifyListener(this.modifyListenerOutput);
        this.outputFile.addFocusListener(this.focusListener);
        Button workspaceBrowseButton3 = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.WorkspaceButton2"), null);
        workspaceBrowseButton3.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(Messages.getString("SystemTapOptionsTab.SelectResource"));
            dialog.setMessage(Messages.getString("SystemTapOptionsTab.SelectSuppressions"));
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0) {
                IResource resource = (IResource)dialog.getFirstResult();
                String arg = resource.getFullPath().toString();
                this.outputFile.setText(this.workspacePath + arg);
                this.checkOverwrite();
                this.updateLaunchConfigurationDialog();
            }
        }));
        Button fileBrowseButton3 = this.createPushButton(browseTop, Messages.getString("SystemTapOptionsTab.BrowseFiles"), null);
        fileBrowseButton3.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String filePath = this.outputFile.getText();
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            filePath = dialog.open();
            if (filePath != null) {
                this.outputFile.setText(filePath);
                this.checkOverwrite();
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.useColourButton = new Button(browseTop, 32);
        this.useColourButton.setText(Messages.getString("SystemTapOptionsTab.ColourCodes"));
        this.useColourButton.addSelectionListener(this.selectListener);
        this.useColourButton.setLayoutData((Object)new GridData(768));
    }

    private void createCommandOption(Composite top) {
        Composite buttonsTop = new Composite(top, 0);
        GridLayout gl = new GridLayout(2, true);
        buttonsTop.setLayout((Layout)gl);
        GridData buttonsData = new GridData(4, 1, true, true);
        buttonsTop.setLayoutData((Object)buttonsData);
        this.button_k = new Button(buttonsTop, 32);
        this.button_k.setText(Messages.getString("SystemTapOptionsTab.KeepTemp"));
        this.button_k.addSelectionListener(this.selectListener);
        this.button_k.setLayoutData((Object)new GridData(768));
        this.button_k.setToolTipText(Messages.getString("SystemTapOptionsTab.KeepTempToolTip"));
        this.button_g = new Button(buttonsTop, 32);
        this.button_g.setText(Messages.getString("SystemTapOptionsTab.Guru"));
        this.button_g.addSelectionListener(this.selectListener);
        this.button_g.setLayoutData((Object)new GridData(768));
        this.button_g.setToolTipText(Messages.getString("SystemTapOptionsTab.GuruToolTip"));
        this.button_P = new Button(buttonsTop, 32);
        this.button_P.setText(Messages.getString("SystemTapOptionsTab.Prologue"));
        this.button_P.addSelectionListener(this.selectListener);
        this.button_P.setLayoutData((Object)new GridData(768));
        this.button_P.setToolTipText(Messages.getString("SystemTapOptionsTab.PrologueSearchToolTip"));
        this.button_u = new Button(buttonsTop, 32);
        this.button_u.setText(Messages.getString("SystemTapOptionsTab.Unused"));
        this.button_u.addSelectionListener(this.selectListener);
        this.button_u.setLayoutData((Object)new GridData(768));
        this.button_u.setToolTipText(Messages.getString("SystemTapOptionsTab.12"));
        this.button_w = new Button(buttonsTop, 32);
        this.button_w.setText(Messages.getString("SystemTapOptionsTab.Warnings"));
        this.button_w.addSelectionListener(this.selectListener);
        this.button_w.setLayoutData((Object)new GridData(768));
        this.button_w.setToolTipText(Messages.getString("SystemTapOptionsTab.DisableWarningsToolTip"));
        this.button_b = new Button(buttonsTop, 32);
        this.button_b.setText(Messages.getString("SystemTapOptionsTab.Bulk"));
        this.button_b.addSelectionListener(this.selectListener);
        this.button_b.setLayoutData((Object)new GridData(768));
        this.button_b.setToolTipText(Messages.getString("SystemTapOptionsTab.15"));
        this.button_t = new Button(buttonsTop, 32);
        this.button_t.setText(Messages.getString("SystemTapOptionsTab.Timing"));
        this.button_t.addSelectionListener(this.selectListener);
        this.button_t.setLayoutData((Object)new GridData(768));
        this.button_t.setToolTipText(Messages.getString("SystemTapOptionsTab.CollectTimingToolTip"));
        this.button_F = new Button(buttonsTop, 32);
        this.button_F.setText(Messages.getString("SystemTapOptionsTab.LeaveProbesRunning"));
        this.button_F.addSelectionListener(this.selectListener);
        this.button_F.setLayoutData((Object)new GridData(768));
        this.button_F.setToolTipText(Messages.getString("SystemTapOptionsTab.LeaveProbesToolTip"));
        this.buttonSkipBadvars = new Button(buttonsTop, 32);
        this.buttonSkipBadvars.setText(Messages.getString("SystemTapOptionsTab.IgnoreBadVars"));
        this.buttonSkipBadvars.addSelectionListener(this.selectListener);
        this.buttonSkipBadvars.setLayoutData((Object)new GridData(768));
        this.buttonSkipBadvars.setToolTipText(Messages.getString("SystemTapOptionsTab.30"));
        this.buttonIgnoreDwarf = new Button(buttonsTop, 32);
        this.buttonIgnoreDwarf.setText(Messages.getString("SystemTapOptionsTab.ForTesting"));
        this.buttonIgnoreDwarf.addSelectionListener(this.selectListener);
        this.buttonIgnoreDwarf.setLayoutData((Object)new GridData(768));
        this.buttonIgnoreDwarf.setToolTipText(Messages.getString("SystemTapOptionsTab.IgnoreDebugToolTip"));
        this.button_q = new Button(buttonsTop, 32);
        this.button_q.setText(Messages.getString("SystemTapOptionsTab.Button_qInfo"));
        this.button_q.addSelectionListener(this.selectListener);
        this.button_q.setLayoutData((Object)new GridData(768));
        this.button_q.setToolTipText(Messages.getString("SystemTapOptionsTab.33"));
        this.buttonGraphicsMode = new Button(buttonsTop, 32);
        this.buttonGraphicsMode.setText(Messages.getString("SystemTapOptionsTab.3"));
        this.buttonGraphicsMode.addSelectionListener(this.graphicsModeListener);
        this.buttonGraphicsMode.setLayoutData((Object)new GridData(768));
        this.buttonGraphicsMode.setToolTipText(Messages.getString("SystemTapOptionsTab.41"));
        Composite button_p_Spinner_Top = new Composite(buttonsTop, 0);
        button_p_Spinner_Top.setLayout((Layout)new GridLayout(2, true));
        button_p_Spinner_Top.setLayoutData((Object)new GridData(768));
        Label button_p_Spinner_Label = new Label(button_p_Spinner_Top, 0);
        button_p_Spinner_Label.setText(Messages.getString("SystemTapOptionsTab.19"));
        this.button_p_Spinner = new Spinner(button_p_Spinner_Top, 2048);
        this.button_p_Spinner.setMaximum(Integer.MAX_VALUE);
        this.button_p_Spinner.addModifyListener(this.modifyListener);
        this.button_p_Spinner.setLayoutData((Object)new GridData(768));
        button_p_Spinner_Label.setToolTipText(Messages.getString("SystemTapOptionsTab.StopAfterPassToolTip"));
        Composite button_s_Spinner_Top = new Composite(buttonsTop, 0);
        button_s_Spinner_Top.setLayout((Layout)new GridLayout(2, true));
        button_s_Spinner_Top.setLayoutData((Object)new GridData(768));
        Label button_s_Spinner_Label = new Label(button_s_Spinner_Top, 0);
        button_s_Spinner_Label.setText(Messages.getString("SystemTapOptionsTab.BufferWith"));
        this.button_s_Spinner = new Spinner(button_s_Spinner_Top, 2048);
        this.button_s_Spinner.setMaximum(Integer.MAX_VALUE);
        this.button_s_Spinner.addModifyListener(this.modifyListener);
        this.button_s_Spinner.setLayoutData((Object)new GridData(768));
        button_s_Spinner_Label.setToolTipText(Messages.getString("SystemTapOptionsTab.BufferWithToolTip"));
        Composite button_x_Spinner_Top = new Composite(buttonsTop, 0);
        button_x_Spinner_Top.setLayout((Layout)new GridLayout(2, true));
        button_x_Spinner_Top.setLayoutData((Object)new GridData(768));
        Label button_x_Spinner_Label = new Label(button_x_Spinner_Top, 0);
        button_x_Spinner_Label.setText(Messages.getString("SystemTapOptionsTab.TargetPID"));
        this.button_x_Spinner = new Spinner(button_x_Spinner_Top, 2048);
        this.button_x_Spinner.setMaximum(Integer.MAX_VALUE);
        this.button_x_Spinner.addModifyListener(this.modifyListener);
        this.button_x_Spinner.setLayoutData((Object)new GridData(768));
        button_x_Spinner_Label.setToolTipText(Messages.getString("SystemTapOptionsTab.TargetPIDToolTip"));
        Composite button_v_Spinner_Top = new Composite(buttonsTop, 0);
        button_v_Spinner_Top.setLayout((Layout)new GridLayout(2, true));
        button_v_Spinner_Top.setLayoutData((Object)new GridData(768));
        Label button_v_Spinner_Label = new Label(button_v_Spinner_Top, 0);
        button_v_Spinner_Label.setText(Messages.getString("SystemTapOptionsTab.18"));
        this.button_v_Spinner = new Spinner(button_v_Spinner_Top, 2048);
        this.button_v_Spinner.setMaximum(3);
        this.button_v_Spinner.addModifyListener(this.modifyListener);
        this.button_v_Spinner.setLayoutData((Object)new GridData(768));
        button_v_Spinner_Label.setToolTipText(Messages.getString("SystemTapOptionsTab.TargetPIDToolTip"));
        Label button_D_label = new Label(buttonsTop, 0);
        button_D_label.setText(Messages.getString("SystemTapOptionsTab.PreprocessorDirective"));
        this.button_D_text = new Text(buttonsTop, 2048);
        this.button_D_text.setLayoutData((Object)new GridData(768));
        this.button_D_text.addModifyListener(this.modifyListener);
        button_D_label.setToolTipText(Messages.getString("SystemTapOptionsTab.PreprocessorToolTip"));
    }

    public String getName() {
        return Messages.getString("SystemTapOptionsTab.MainTabName");
    }

    private Shell getActiveWorkbenchShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private IBinary chooseBinary(IBinary[] binaries) {
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof IBinary) {
                    void bin;
                    IBinary iBinary = (IBinary)object;
                    IBinary cfr_ignored_0 = (IBinary)object;
                    StringBuilder name = new StringBuilder();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof IBinary) {
                    void bin;
                    IBinary iBinary = (IBinary)object;
                    IBinary cfr_ignored_0 = (IBinary)object;
                    StringBuilder name = new StringBuilder();
                    name.append(bin.getCPU() + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getActiveWorkbenchShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements((Object[])binaries);
        dialog.setTitle(Messages.getString("SystemtTapOptionsTab.Callgraph"));
        dialog.setMessage(Messages.getString("SystemtTapOptionsTab.Choose_a_local_application"));
        dialog.setUpperListLabel(Messages.getString("SystemtTapOptionsTab.Binaries"));
        dialog.setLowerListLabel(Messages.getString("SystemtTapOptionsTab.Qualifier"));
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IBinary)dialog.getFirstResult();
        }
        return null;
    }

    private IBinary getBinary(ILaunchConfiguration config) {
        try {
            ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
            IBinary[] binaries = project.getBinaryContainer().getBinaries();
            if (binaries != null && binaries.length > 0) {
                if (binaries.length == 1 && binaries[0] != null) {
                    return binaries[0];
                }
                return this.chooseBinary(binaries);
            }
            return null;
        }
        catch (CoreException e) {
            return null;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath location = root.getLocation();
        this.workspacePath = location.toString();
        try {
            this.button_k.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.KEEP_TEMPORARY", false));
            this.button_u.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.NO_CODE_ELISION", false));
            this.button_w.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.DISABLE_WARNINGS", false));
            this.button_b.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.BULK_MODE", false));
            this.button_g.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.GURU", false));
            this.button_P.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.PROLOGUE_SEARCH", false));
            this.button_t.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.TIMING_INFO", false));
            this.buttonSkipBadvars.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.SKIP_BADVARS", false));
            this.buttonIgnoreDwarf.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.IGNORE_DWARF", false));
            this.button_q.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.TAPSET_COVERAGE", false));
            this.button_F.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.LEAVE_RUNNING", false));
            this.button_s_Spinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.BUFFER_BYTES", 0));
            this.button_x_Spinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.TARGET_PID", 0));
            this.button_v_Spinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_VERBOSE", 0));
            this.button_p_Spinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.PASS", 0));
            this.button_D_text.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.C_DIRECTIVES", ""));
            this.binaryFile.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", ""));
            this.scriptFile.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", ""));
            this.outputFile.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", ""));
            this.arguments.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", ""));
            this.binaryArguments.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_ARGUMENTS", ""));
            this.parser.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", ""));
            this.viewer.setText(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", ""));
            this.useColourButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.getControl().setRedraw(false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.KEEP_TEMPORARY", this.button_k.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.GURU", this.button_g.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PROLOGUE_SEARCH", this.button_P.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.NO_CODE_ELISION", this.button_u.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.DISABLE_WARNINGS", this.button_w.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BULK_MODE", this.button_b.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TIMING_INFO", this.button_t.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.SKIP_BADVARS", this.buttonSkipBadvars.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.IGNORE_DWARF", this.buttonIgnoreDwarf.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TAPSET_COVERAGE", this.button_q.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.LEAVE_RUNNING", this.button_F.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PASS", this.button_p_Spinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BUFFER_BYTES", this.button_s_Spinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TARGET_PID", this.button_x_Spinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_VERBOSE", this.button_v_Spinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", this.parser.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", this.viewer.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.C_DIRECTIVES", this.button_D_text.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", this.binaryFile.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", this.scriptFile.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", this.arguments.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_ARGUMENTS", this.binaryArguments.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", this.outputFile.getText());
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", this.useColourButton.getSelection());
        if (this.buttonGraphicsMode.getSelection()) {
            this.scriptFile.setEnabled(false);
            this.workspaceBrowseButton.setEnabled(false);
            this.fileBrowseButton.setEnabled(false);
        } else {
            this.scriptFile.setEnabled(true);
            this.workspaceBrowseButton.setEnabled(true);
            this.fileBrowseButton.setEnabled(true);
        }
        if (this.changeOverwrite) {
            if (this.needsOverwritePermission && this.overwritePermission || !this.needsOverwritePermission) {
                configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.OVERWRITE", true);
            } else {
                configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.OVERWRITE", false);
            }
            this.changeOverwrite = false;
        }
        this.getControl().setRedraw(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_VERBOSE", 0);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.KEEP_TEMPORARY", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.GURU", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PROLOGUE_SEARCH", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.NO_CODE_ELISION", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.DISABLE_WARNINGS", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BULK_MODE", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TIMING_INFO", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.SKIP_BADVARS", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.IGNORE_DWARF", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TAPSET_COVERAGE", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.LEAVE_RUNNING", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PASS", 0);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BUFFER_BYTES", 0);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.TARGET_PID", 0);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.C_DIRECTIVES", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_ARGUMENTS", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.GENERATED_SCRIPT", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.NEED_TO_GENERATE", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", "");
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", false);
        configuration.setAttribute("org.eclipse.linuxtools.callgraph.launch.COMMAND_LIST", ConfigurationOptionsSetter.setOptions((ILaunchConfiguration)configuration));
        ICElement cElement = null;
        cElement = this.getContext((ILaunchConfiguration)configuration, this.getPlatform((ILaunchConfiguration)configuration));
        if (cElement != null) {
            this.initializeCProject(cElement, configuration);
        } else {
            configuration.setMappedResources(null);
        }
        IBinary bin = this.getBinary((ILaunchConfiguration)configuration);
        if (bin != null) {
            String programName = bin.getResource().getProjectRelativePath().toString();
            configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programName);
            configuration.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            LaunchStapGraph launch = new LaunchStapGraph();
            launch.setTestMode(true);
            launch.launch(bin, "", configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid = true;
        try {
            String sPath = launchConfig.getAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", "");
            File script = new File(sPath);
            if (sPath.equals("") || !script.exists()) {
                valid = false;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return valid;
    }

    private String getUsefulLabel(Object element) {
        Object o;
        if (element instanceof IConfigurationElement && (o = ((IConfigurationElement)element).getParent()) instanceof IExtension) {
            IExtension e = (IExtension)((IConfigurationElement)element).getParent();
            return e.getUniqueIdentifier();
        }
        return Messages.getString("SystemTapOptionsTab.1");
    }

    private static class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IConfigurationElement) {
                Object o = ((IConfigurationElement)element).getParent();
                if (o instanceof IExtension) {
                    IExtension e = (IExtension)((IConfigurationElement)element).getParent();
                    return e.getLabel();
                }
                if (o instanceof IConfigurationElement) {
                    IConfigurationElement e = (IConfigurationElement)((IConfigurationElement)element).getParent();
                    return e.getName();
                }
            }
            return Messages.getString("SystemTapOptionsTab.46");
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }
    }
}

