/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountInfo;

public class RegistryAccountStorageManager {
    public List<IRegistryAccount> getAccounts() {
        ArrayList<IRegistryAccount> accounts = new ArrayList<IRegistryAccount>();
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences dockerNode = preferences.node("org.eclipse.linuxtools.docker.ui.accounts");
        String[] stringArray = dockerNode.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String[] tokens = key.split(",");
            if (tokens.length > 1) {
                String serverAddress = tokens[0];
                String username = tokens[1];
                String email = tokens.length > 2 ? tokens[2] : "";
                RegistryAccountInfo account = new RegistryAccountInfo(serverAddress, username, email, null, false);
                accounts.add(account);
            }
            ++n2;
        }
        return accounts;
    }

    public IRegistryAccount getAccount(String serverAddress, String username) {
        return this.getAccounts().stream().filter(a -> a.getServerAddress().equals(serverAddress) && a.getUsername().equals(username)).findFirst().orElse(null);
    }

    public void add(IRegistryAccount info) {
        ISecurePreferences preferences = this.getDockerNode();
        char[] password = info.getPassword();
        String key = this.getKeyFor(info);
        try {
            preferences.put(key, password != null ? new String(password) : null, true);
        }
        catch (StorageException e) {
            Activator.logErrorMessage("Failed to store Docker registry password", e);
        }
    }

    public void remove(IRegistryAccount info) {
        ISecurePreferences preferences = this.getDockerNode();
        String key = this.getKeyFor(info);
        preferences.remove(key);
    }

    private ISecurePreferences getDockerNode() {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences dockerNode = preferences.node("org.eclipse.linuxtools.docker.ui.accounts");
        return dockerNode;
    }

    private String getKeyFor(IRegistryAccount info) {
        return info.getServerAddress() + "," + info.getUsername() + "," + info.getEmail();
    }
}

