/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.actions;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SpecfileEditorToggleCommentActionDelegate
extends AbstractHandler {
    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor specfileEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
        IDocumentProvider dp = specfileEditor.getDocumentProvider();
        IDocument document = dp.getDocument((Object)specfileEditor.getEditorInput());
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ISelection iSelection = currentSelection;
        if (iSelection instanceof ITextSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
            Object selectedContent = "";
            try {
                void selection;
                int begin = document.getLineOffset(selection.getStartLine());
                StringBuilder sb = new StringBuilder(document.get().substring(0, begin));
                String content = document.get().substring(begin, selection.getOffset() + selection.getLength());
                selectedContent = this.linesContentCommentChar(content) ? (selection.getStartLine() == selection.getEndLine() ? "#" + content : "#" + content.replace("\n", "\n#")) : content.replaceFirst("#", "").replace("\n#", "\n");
                sb.append((String)selectedContent);
                sb.append(document.get().substring(selection.getOffset() + selection.getLength(), document.get().length()));
                document.set(sb.toString());
                specfileEditor.setHighlightRange(selection.getOffset(), selection.getLength(), true);
            }
            catch (BadLocationException e) {
                SpecfileLog.logError(e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean linesContentCommentChar(String content) {
        LineNumberReader reader = new LineNumberReader(new StringReader(content));
        boolean ret = false;
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return ret;
                }
                if (!line.startsWith("#")) return true;
                ret = false;
            }
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
            return false;
        }
    }
}

