/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Calendar;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.commons.workbench.forms.DatePicker;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.ScheduleDatePicker;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractLocalEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class PlanningPart
extends AbstractLocalEditorPart {
    private boolean needsDueDate;
    private String notesString;
    private RichTextEditor noteEditor;
    private static final int CONTROL_WIDTH = 120;
    private DatePicker dueDatePicker;
    private Text activeTimeText;
    private Spinner estimatedTimeSpinner;
    private ScheduleDatePicker scheduleDatePicker;
    private static final String PERSONAL_NOTES = Messages.PlanningPart_Personal_Notes;
    private final ITaskListChangeListener TASK_LIST_LISTENER = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                AbstractTask updateTask;
                if (!(taskContainerDelta.getElement() instanceof ITask) || (updateTask = (AbstractTask)taskContainerDelta.getElement()) == null || PlanningPart.this.getTask() == null || !updateTask.getHandleIdentifier().equals(PlanningPart.this.getTask().getHandleIdentifier()) || PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().isClosing()) continue;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlanningPart.this.refresh(false);
                    }
                });
            }
        }
    };
    private final ITaskActivationListener activationListener = new TaskActivationAdapter(){

        public void taskActivated(ITask task) {
            if (task.equals(PlanningPart.this.getTask())) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).PlanningPart.this.activeTimeText != null && !(this).PlanningPart.this.activeTimeText.isDisposed()) {
                            PlanningPart.this.updateActiveTime();
                        }
                    }
                });
            }
        }

        public void taskDeactivated(ITask task) {
            if (task.equals(PlanningPart.this.getTask())) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).PlanningPart.this.activeTimeText != null && !(this).PlanningPart.this.activeTimeText.isDisposed()) {
                            PlanningPart.this.updateActiveTime();
                        }
                    }
                });
            }
        }
    };
    private final ITaskActivityListener timingListener = new TaskActivityAdapter(){

        public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
            if (task.equals(PlanningPart.this.getTask())) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).PlanningPart.this.activeTimeText != null && !(this).PlanningPart.this.activeTimeText.isDisposed()) {
                            PlanningPart.this.updateActiveTime();
                        }
                    }
                });
            }
        }
    };
    private final IPropertyChangeListener ACTIVITY_PROPERTY_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.monitor.activity.tracking.enabled")) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).PlanningPart.this.activeTimeText != null && !(this).PlanningPart.this.activeTimeText.isDisposed()) {
                            PlanningPart.this.updateActiveTime();
                        }
                    }
                });
            }
        }
    };
    private CommonTextSupport textSupport;
    private TaskFormPage page;
    private Composite activeTimeComposite;
    private ToolBarManager toolBarManager;
    private boolean needsNotes = true;
    private boolean alwaysExpand;
    private Composite sectionClient;
    private boolean activeTimeEnabled = true;
    private Label scheduledLabel;
    private Composite layoutControl;

    public PlanningPart(int sectionStyle) {
        super(sectionStyle, Messages.PersonalPart_Personal_Planning);
    }

    public void initialize(IManagedForm managedForm, TaskRepository taskRepository, AbstractTask task, boolean needsDueDate, TaskFormPage page, CommonTextSupport textSupport) {
        super.initialize(managedForm, taskRepository, task);
        this.needsDueDate = needsDueDate;
        this.page = page;
        this.textSupport = textSupport;
    }

    private boolean notesEqual() {
        if (this.getTask().getNotes() == null && this.notesString == null) {
            return true;
        }
        if (this.getTask().getNotes() != null && this.notesString != null) {
            return this.getTask().getNotes().equals(this.notesString) || this.notesString.equals(PERSONAL_NOTES);
        }
        return false;
    }

    public void commit(boolean onSave) {
        Assert.isNotNull((Object)this.getTask());
        if (!this.notesEqual()) {
            this.getTask().setNotes(this.notesString);
        }
        if (this.scheduleDatePicker != null && this.scheduleDatePicker.getScheduledDate() != null) {
            if (this.getTask().getScheduledForDate() == null || this.getTask().getScheduledForDate() != null && !this.scheduleDatePicker.getScheduledDate().equals((Object)this.getTask().getScheduledForDate()) || this.getTask().getScheduledForDate() instanceof DayDateRange) {
                TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.getTask(), this.scheduleDatePicker.getScheduledDate());
                this.getTask().setReminded(false);
            }
        } else {
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.getTask(), null);
            this.getTask().setReminded(false);
        }
        if (this.estimatedTimeSpinner != null) {
            this.getTask().setEstimatedTimeHours(this.estimatedTimeSpinner.getSelection());
        }
        if (this.dueDatePicker != null && this.dueDatePicker.getDate() != null) {
            TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)this.getTask(), this.dueDatePicker.getDate().getTime());
        } else {
            TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)this.getTask(), null);
        }
        super.commit(onSave);
    }

    @Override
    public Control createControl(Composite parent, final FormToolkit toolkit) {
        this.notesString = this.getTask().getNotes();
        if (this.notesString == null) {
            this.notesString = "";
        }
        boolean expand = this.isAlwaysExpand() || this.notesString.length() > 0;
        final Section section = this.createSection(parent, toolkit, expand);
        section.clientVerticalSpacing = 0;
        if (section.isExpanded()) {
            this.expandSection(toolkit, section);
        } else {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (PlanningPart.this.sectionClient == null) {
                        PlanningPart.this.expandSection(toolkit, section);
                        if (PlanningPart.this.page instanceof AbstractTaskEditorPage) {
                            ((AbstractTaskEditorPage)PlanningPart.this.page).reflow();
                        }
                    }
                }
            });
        }
        TasksUiInternal.getTaskList().addChangeListener(this.TASK_LIST_LISTENER);
        TasksUiPlugin.getTaskActivityManager().addActivityListener(this.timingListener);
        TasksUiPlugin.getTaskActivityManager().addActivationListener(this.activationListener);
        MonitorUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.ACTIVITY_PROPERTY_LISTENER);
        this.setSection(toolkit, section);
        return section;
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        this.sectionClient = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().applyTo(this.sectionClient);
        this.layoutControl = toolkit.createComposite(this.sectionClient);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.layoutControl);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = this.needsDueDate ? 6 : 4;
        this.layoutControl.setLayout((Layout)layout);
        this.createScheduledDatePicker(toolkit, this.layoutControl);
        if (this.needsDueDate) {
            this.createDueDatePicker(toolkit, this.layoutControl);
        }
        this.createEstimatedTime(toolkit, this.layoutControl);
        if (this.needsNotes()) {
            this.createNotesArea(toolkit, this.layoutControl, layout.numColumns);
        }
        this.createActiveTime(toolkit, this.layoutControl, layout.numColumns);
        toolkit.paintBordersFor(this.sectionClient);
        section.setClient((Control)this.sectionClient);
        CommonUiUtil.setMenu((Composite)this.sectionClient, (Menu)section.getParent().getMenu());
    }

    private void createNotesArea(FormToolkit toolkit, Composite parent, int numColumns) {
        AbstractTaskEditorExtension extension;
        IContextService contextService;
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 1;
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().span(numColumns, -1).grab(true, true).applyTo((Control)composite);
        if (this.page != null && (contextService = (IContextService)this.page.getEditorSite().getService(IContextService.class)) != null && (extension = TaskEditorExtensions.getTaskEditorExtension(this.getRepository())) != null) {
            this.noteEditor = new RichTextEditor(this.getRepository(), 8389186, contextService, extension, (ITask)this.getTask());
        }
        if (this.noteEditor == null) {
            this.noteEditor = new RichTextEditor(this.getRepository(), 8389186, null, null, (ITask)this.getTask());
        }
        this.noteEditor.setSpellCheckingEnabled(true);
        this.noteEditor.createControl(composite, toolkit);
        this.noteEditor.setText(this.notesString);
        this.noteEditor.getControl().setLayoutData((Object)EditorUtil.getTextControlLayoutData(this.page, this.noteEditor.getViewer().getControl(), true));
        this.noteEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.noteEditor.setReadOnly(false);
        if (this.textSupport != null) {
            this.textSupport.install((TextViewer)this.noteEditor.getViewer(), true);
        }
        this.noteEditor.getViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                String string = PlanningPart.this.notesString = PERSONAL_NOTES.equals(PlanningPart.this.noteEditor.getText()) ? "" : PlanningPart.this.noteEditor.getText();
                if (!PlanningPart.this.notesEqual()) {
                    PlanningPart.this.markDirty();
                }
            }
        });
        this.addNotesLabelText(toolkit, composite);
        toolkit.paintBordersFor(composite);
    }

    private void addNotesLabelText(final FormToolkit toolkit, final Composite composite) {
        if (!this.noteEditor.getViewer().getTextWidget().isFocusControl()) {
            this.setNotesLabelText(composite);
        }
        this.noteEditor.getViewer().getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (PERSONAL_NOTES.equals(PlanningPart.this.noteEditor.getText())) {
                    PlanningPart.this.noteEditor.setText("");
                    if (PlanningPart.this.noteEditor.getViewer() != null) {
                        PlanningPart.this.noteEditor.getViewer().getTextWidget().setForeground(toolkit.getColors().getForeground());
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                PlanningPart.this.setNotesLabelText(composite);
            }
        });
    }

    private void setNotesLabelText(Composite composite) {
        if (this.notesString.length() == 0) {
            this.notesString = PERSONAL_NOTES;
            this.noteEditor.setText(this.notesString);
            if (this.noteEditor.getViewer() != null) {
                this.noteEditor.getViewer().getTextWidget().setForeground(composite.getShell().getDisplay().getSystemColor(15));
            }
        }
    }

    private void createActiveTime(FormToolkit toolkit, Composite toolbarComposite, int numColumns) {
        String labelString;
        this.activeTimeComposite = toolkit.createComposite(toolbarComposite);
        GridDataFactory.fillDefaults().span(numColumns, -1).grab(false, false).applyTo((Control)this.activeTimeComposite);
        this.activeTimeComposite.setBackground(null);
        this.activeTimeComposite.setBackgroundMode(2);
        RowLayout rowLayout = new RowLayout();
        rowLayout.center = true;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        this.activeTimeComposite.setLayout((Layout)rowLayout);
        if (MonitorUiPlugin.getDefault().isTrackingOsTime()) {
            labelString = Messages.PlanningPart_Active_time_Label;
        } else {
            String productName = CommonUiUtil.getProductName((String)Messages.PlanningPart_Default_Product);
            labelString = NLS.bind((String)Messages.PlanningPart_Active_time_in_Product_Label, (Object)productName);
        }
        Label label = toolkit.createLabel(this.activeTimeComposite, labelString);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setToolTipText(Messages.TaskEditorPlanningPart_Time_working_on_this_task);
        label.setBackground(null);
        this.activeTimeText = new Text(this.activeTimeComposite, 0x800008);
        this.activeTimeText.setText("00:00");
        this.activeTimeText.setFont(EditorUtil.TEXT_FONT);
        this.activeTimeText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        toolkit.adapt((Control)this.activeTimeText, true, false);
        this.activeTimeText.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.activeTimeText.setBackground(null);
        this.activeTimeText.setEditable(false);
        ImageHyperlink resetActivityTimeButton = toolkit.createImageHyperlink(this.activeTimeComposite, 0);
        resetActivityTimeButton.setBackground(null);
        resetActivityTimeButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR_DISABLED));
        resetActivityTimeButton.setHoverImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        resetActivityTimeButton.setToolTipText(Messages.PlanningPart_Reset_Active_Time);
        resetActivityTimeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (MessageDialog.openConfirm((Shell)PlanningPart.this.getControl().getShell(), (String)Messages.TaskEditorPlanningPart_Confirm_Activity_Time_Deletion, (String)Messages.TaskEditorPlanningPart_Do_you_wish_to_reset_your_activity_time_on_this_task_)) {
                    MonitorUi.getActivityContextManager().removeActivityTime(PlanningPart.this.getTask().getHandleIdentifier(), 0L, System.currentTimeMillis());
                }
            }
        });
        this.updateActiveTime();
    }

    private void updateActiveTime() {
        boolean visible;
        boolean show = TasksUiInternal.isActivityTrackingEnabled() && this.isActiveTimeEnabled();
        long elapsedTime = TasksUiInternal.getActiveTime((ITask)this.getTask());
        boolean bl = visible = this.activeTimeComposite != null && this.activeTimeComposite.isVisible();
        if (show && (elapsedTime > 0L || this.getTask().isActive())) {
            String elapsedTimeString;
            if (this.activeTimeComposite != null && !this.activeTimeComposite.isVisible()) {
                this.activeTimeComposite.setVisible(true);
                ((GridData)this.activeTimeComposite.getLayoutData()).exclude = false;
                this.activeTimeComposite.getParent().layout();
            }
            if ((elapsedTimeString = DateUtil.getFormattedDurationShort((long)elapsedTime)).equals("")) {
                elapsedTimeString = Messages.TaskEditorPlanningPart_0_SECOUNDS;
            }
            this.activeTimeText.setText(elapsedTimeString);
        } else if (this.activeTimeComposite != null) {
            ((GridData)this.activeTimeComposite.getLayoutData()).exclude = true;
            this.activeTimeComposite.getParent().layout();
            this.activeTimeComposite.setVisible(false);
        }
        if (!this.needsNotes() && visible != (this.activeTimeComposite != null && this.activeTimeComposite.isVisible()) && this.page instanceof AbstractTaskEditorPage) {
            ((AbstractTaskEditorPage)this.page).reflow();
        }
    }

    private Composite createComposite(Composite parent, int col, FormToolkit toolkit) {
        Composite nameValueComp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 3;
        nameValueComp.setLayout((Layout)layout);
        return nameValueComp;
    }

    private void createDueDatePicker(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, Messages.TaskEditorPlanningPart_Due);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 1, toolkit);
        this.dueDatePicker = new DatePicker(composite, 0x800000, DatePicker.LABEL_CHOOSE, true, 0);
        GridDataFactory.fillDefaults().hint(120, -1).applyTo((Control)this.dueDatePicker);
        this.dueDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.dueDatePicker.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        if (this.getTask().getDueDate() != null) {
            Calendar calendar = TaskActivityUtil.getCalendar();
            calendar.setTime(this.getTask().getDueDate());
            this.dueDatePicker.setDate(calendar);
        }
        this.dueDatePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PlanningPart.this.markDirty();
            }
        });
        toolkit.adapt((Control)this.dueDatePicker, false, false);
        toolkit.paintBordersFor(composite);
    }

    private void createEstimatedTime(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, Messages.TaskEditorPlanningPart_Estimated);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 2, toolkit);
        this.estimatedTimeSpinner = new Spinner(composite, 0x800000);
        this.estimatedTimeSpinner.setDigits(0);
        this.estimatedTimeSpinner.setMaximum(10000);
        this.estimatedTimeSpinner.setMinimum(0);
        this.estimatedTimeSpinner.setIncrement(1);
        this.estimatedTimeSpinner.setSelection(this.getTask().getEstimatedTimeHours());
        if (!PlatformUiUtil.spinnerHasNativeBorder()) {
            this.estimatedTimeSpinner.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        }
        this.estimatedTimeSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PlanningPart.this.getTask().getEstimatedTimeHours() != PlanningPart.this.estimatedTimeSpinner.getSelection()) {
                    PlanningPart.this.markDirty();
                }
            }
        });
        toolkit.paintBordersFor(composite);
    }

    private void createScheduledDatePicker(FormToolkit toolkit, Composite parent) {
        Label label = toolkit.createLabel(parent, Messages.TaskEditorPlanningPart_Scheduled);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite composite = this.createComposite(parent, 2, toolkit);
        this.scheduleDatePicker = new ScheduleDatePicker(composite, this.getTask(), 0x800000);
        GridDataFactory.fillDefaults().hint(120, -1).applyTo((Control)this.scheduleDatePicker);
        this.scheduleDatePicker.setData("FormWidgetFactory.drawBorder", "treeBorder");
        toolkit.adapt((Control)this.scheduleDatePicker, false, false);
        toolkit.paintBordersFor(composite);
        this.scheduleDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.scheduleDatePicker.addPickerSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                PlanningPart.this.markDirty();
            }
        });
    }

    public void dispose() {
        TasksUiPlugin.getTaskActivityManager().removeActivationListener(this.activationListener);
        TasksUiPlugin.getTaskActivityManager().removeActivityListener(this.timingListener);
        TasksUiInternal.getTaskList().removeChangeListener(this.TASK_LIST_LISTENER);
        MonitorUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.ACTIVITY_PROPERTY_LISTENER);
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
        }
    }

    @Override
    protected void setSection(FormToolkit toolkit, Section section) {
        super.setSection(toolkit, section);
        if (section.getTextClient() == null) {
            Composite toolbarComposite = toolkit.createComposite((Composite)section);
            toolbarComposite.setBackground(null);
            RowLayout rowLayout = new RowLayout();
            rowLayout.marginLeft = 0;
            rowLayout.marginRight = 0;
            rowLayout.marginTop = 0;
            rowLayout.marginBottom = 0;
            rowLayout.center = true;
            toolbarComposite.setLayout((Layout)rowLayout);
            this.createScheduledLabel(toolbarComposite, section, toolkit);
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            this.fillToolBar(toolBarManager);
            if (toolBarManager.getSize() > 0) {
                toolBarManager.createControl(toolbarComposite);
                section.clientVerticalSpacing = 0;
                section.descriptionVerticalSpacing = 0;
            }
            section.setTextClient((Control)toolbarComposite);
        }
    }

    private void createScheduledLabel(Composite composite, Section section, FormToolkit toolkit) {
        this.scheduledLabel = toolkit.createLabel(composite, "");
        this.scheduledLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.scheduledLabel.setBackground(null);
        this.updateScheduledLabel(section.isExpanded());
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent event) {
                PlanningPart.this.updateScheduledLabel(event.getState());
            }
        });
    }

    private void updateScheduledLabel(boolean sectionIsExpanded) {
        if (this.scheduledLabel != null && !this.scheduledLabel.isDisposed()) {
            if (!sectionIsExpanded && !this.getTask().isCompleted()) {
                DateRange date = this.getTask().getScheduledForDate();
                if (date != null) {
                    this.scheduledLabel.setText(PlanningPart.getLabel(date));
                    this.scheduledLabel.setToolTipText(NLS.bind((String)Messages.PlanningPart_Scheduled_for_X_Tooltip, (Object)date.toString()));
                } else {
                    this.scheduledLabel.setText("");
                    this.scheduledLabel.setToolTipText(null);
                }
                if (!this.scheduledLabel.isVisible()) {
                    this.scheduledLabel.setVisible(true);
                }
                this.scheduledLabel.getParent().getParent().layout(true);
            } else if (this.scheduledLabel.isVisible()) {
                this.scheduledLabel.setVisible(false);
                this.scheduledLabel.getParent().getParent().layout(true);
            }
        }
    }

    public static String getLabel(DateRange dateRange) {
        if (dateRange instanceof WeekDateRange) {
            if (dateRange.isPast() || dateRange.isPresent()) {
                return Messages.PlanningPart_This_Week;
            }
            if (TaskActivityUtil.getNextWeek().compareTo(dateRange) == 0) {
                return Messages.PlanningPart_Next_Week;
            }
        } else {
            if (dateRange.isPast() || dateRange.isPresent()) {
                return Messages.PlanningPart_Today;
            }
            if (TaskActivityUtil.getCurrentWeek().includes(dateRange)) {
                return Messages.PlanningPart_This_Week;
            }
            if (TaskActivityUtil.getNextWeek().includes(dateRange)) {
                return Messages.PlanningPart_Next_Week;
            }
        }
        return Messages.PlanningPart_Later;
    }

    protected void fillToolBar(ToolBarManager toolBarManager) {
    }

    public boolean needsNotes() {
        return this.needsNotes;
    }

    public void setNeedsNotes(boolean needsNotes) {
        this.needsNotes = needsNotes;
    }

    public boolean isAlwaysExpand() {
        return this.alwaysExpand;
    }

    public void setAlwaysExpand(boolean alwaysExpand) {
        this.alwaysExpand = alwaysExpand;
    }

    @Override
    protected void refresh(boolean discardChanges) {
        if (this.scheduleDatePicker != null && !this.scheduleDatePicker.isDisposed()) {
            if (this.getTask().getScheduledForDate() != null) {
                this.scheduleDatePicker.setScheduledDate(this.getTask().getScheduledForDate());
            } else {
                this.scheduleDatePicker.setScheduledDate(null);
            }
        }
        if (this.scheduledLabel != null && !this.scheduledLabel.isDisposed()) {
            this.updateScheduledLabel(this.getSection().isExpanded());
        }
        if (this.estimatedTimeSpinner != null && !this.estimatedTimeSpinner.isDisposed()) {
            this.estimatedTimeSpinner.setSelection(this.getTask().getEstimatedTimeHours());
        }
    }

    public boolean isActiveTimeEnabled() {
        return this.activeTimeEnabled;
    }

    public void setActiveTimeEnabled(boolean activeTimeEnabled) {
        this.activeTimeEnabled = activeTimeEnabled;
        if (this.activeTimeComposite != null && !this.activeTimeComposite.isDisposed()) {
            this.updateActiveTime();
        }
    }

    public RichTextEditor getNoteEditor() {
        return this.noteEditor;
    }

    public Control getLayoutControl() {
        return this.layoutControl;
    }
}

