/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasMethod;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.ProposalExtraInfo;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.IPHPCompletionProposalExtension;
import org.eclipse.php.internal.ui.editor.contentassist.Messages;
import org.eclipse.php.internal.ui.editor.contentassist.PHPOverrideCompletionProposal;
import org.eclipse.php.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public final class ParameterGuessingProposal
extends PHPOverrideCompletionProposal
implements IPHPCompletionProposalExtension {
    private static final char[] NO_TRIGGERS = new char[0];
    protected static final char LPAREN = '(';
    protected static final char RPAREN = ')';
    protected static final String COMMA = ", ";
    private CompletionProposal fProposal;
    private IMethod method;
    private IMethod guessingMethod;
    private final boolean fFillBestGuess;
    private boolean fReplacementStringComputed = false;
    private Object extraInfo;
    private boolean fReplacementLengthComputed;
    private String alias = null;
    private IDocument document = null;
    private IScriptProject sProject = null;
    private ICompletionProposal[][] fChoices;
    private Position[] fPositions;
    private IRegion fSelectedRegion;
    private IPositionUpdater fUpdater;

    public ParameterGuessingProposal(CompletionProposal proposal, IScriptProject jproject, ISourceModule cu, String methodName, String[] paramTypes, int start, int length, StyledString displayName, String completionProposal, boolean fillBestGuess, Object extraInfo, IDocument document) {
        super(jproject, cu, methodName, paramTypes, start, length, displayName, completionProposal);
        this.fProposal = proposal;
        this.guessingMethod = this.method = (IMethod)this.fProposal.getModelElement();
        this.fFillBestGuess = fillBestGuess;
        this.extraInfo = extraInfo;
        this.document = document;
        this.sProject = jproject;
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        try {
            this.dealPrefix();
            this.dealSuffix(document, offset);
            int lengthChange = this.getReplacementString().length();
            super.apply(document, trigger, offset);
            lengthChange = Math.max(0, this.getReplacementString().length() - lengthChange);
            int baseOffset = this.getReplacementOffset();
            String replacement = this.getReplacementString();
            boolean hasParameters = false;
            try {
                hasParameters = this.method.getParameters().length != 0;
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            if (!ProposalExtraInfo.isMethodOnly((Object)this.extraInfo) && hasParameters && this.getTextViewer() != null) {
                LinkedModeModel model = new LinkedModeModel();
                if (this.fPositions != null && this.fPositions.length > 0) {
                    int i = 0;
                    while (i < this.fPositions.length) {
                        LinkedPositionGroup group = new LinkedPositionGroup();
                        int positionOffset = this.fPositions[i].getOffset() + lengthChange;
                        int positionLength = this.fPositions[i].getLength();
                        if (this.fChoices[i].length < 2) {
                            group.addPosition(new LinkedPosition(document, positionOffset, positionLength, -1));
                        } else {
                            this.ensurePositionCategoryInstalled(document, model);
                            document.addPosition(this.getCategory(), this.fPositions[i]);
                            group.addPosition((LinkedPosition)new ProposalPosition(document, positionOffset, positionLength, -1, this.fChoices[i]));
                        }
                        model.addGroup(group);
                        ++i;
                    }
                } else {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, this.getReplacementOffset() + this.getCursorPosition(), 0, -1));
                    model.addGroup(group);
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(baseOffset + this.getCursorPosition(), 0);
            }
        }
        catch (BadLocationException e) {
            this.ensurePositionCategoryRemoved(document);
            PHPUiPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            this.ensurePositionCategoryRemoved(document);
            PHPUiPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
    }

    private void dealPrefix() {
        String prefix = "";
        if (this.shouldHaveGlobalNamespace()) {
            prefix = String.valueOf(prefix) + '\\';
        }
        if (ProposalExtraInfo.isMethodOnly((Object)this.extraInfo)) {
            this.setReplacementString(String.valueOf(prefix) + this.method.getElementName());
            return;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.php.core");
        boolean fileArgumentNames = prefs.getBoolean("contentAssistFillMethodArguments", true);
        if (fileArgumentNames && !this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString(prefix));
        }
        if (!fileArgumentNames) {
            this.setReplacementString(String.valueOf(prefix) + super.getReplacementString());
        }
    }

    private boolean shouldHaveGlobalNamespace() {
        if (ProjectOptions.getPHPVersion((IProject)this.sProject.getProject()).isLessThan(PHPVersion.PHP5_3)) {
            return false;
        }
        IType type = this.method.getDeclaringType();
        boolean isInNamespace = PHPModelUtils.getCurrentNamespaceIfAny((ISourceModule)this.fSourceModule, (int)this.getReplacementOffset()) != null;
        boolean isNotAlias = !(type instanceof AliasType);
        boolean isNamespacedType = PHPModelUtils.getCurrentNamespace((IModelElement)type) != null;
        try {
            boolean globalConstructor;
            boolean globalMethod = type == null && this.method.getNamespace() == null;
            boolean bl = globalConstructor = type != null && !isNamespacedType && this.method.isConstructor();
            if ((globalMethod && this.prefixGlobalFunctionCall() || globalConstructor) && isInNamespace && isNotAlias && this.document.getChar(this.getReplacementOffset() - 1) != '\\') {
                return true;
            }
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
        }
        catch (BadLocationException e) {
            PHPUiPlugin.log(e);
        }
        return false;
    }

    private boolean prefixGlobalFunctionCall() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistPrefixGlobalFunctionCall", false, null);
    }

    private void dealSuffix(IDocument document, int offset) {
        boolean toggleEating = this.isToggleEating();
        boolean insertCompletion = this.insertCompletion();
        String replacement = this.getReplacementString();
        int posReplacementLP = replacement.indexOf(40);
        if (posReplacementLP >= 0 && replacement.endsWith(String.valueOf(')'))) {
            int searchOffset = !insertCompletion || toggleEating ? this.getReplacementOffset() + this.getReplacementLength() : offset;
            int posLP = this.getRelativePositionOf(document, searchOffset, '(');
            if (posLP >= 0) {
                int posRP = this.getRelativePositionOf(document, searchOffset + (posLP + 1), ')');
                if (posRP < 0) {
                    this.fPositions = null;
                    this.fChoices = null;
                    replacement = replacement.substring(0, posReplacementLP);
                    this.setReplacementString(replacement);
                    this.setReplacementLength(this.getReplacementLength() + posLP);
                } else {
                    this.setReplacementLength(this.getReplacementLength() + (posLP + 1) + (posRP + 1));
                }
            }
        } else if (!ProposalExtraInfo.isMethodOnly((Object)this.extraInfo)) {
            this.fPositions = null;
            this.fChoices = null;
            int searchOffset = !insertCompletion || toggleEating ? this.getReplacementOffset() + this.getReplacementLength() : offset;
            int posLP = this.getRelativePositionOf(document, searchOffset, '(');
            if (posLP < 0) {
                replacement = String.valueOf(replacement) + '(' + ')';
                this.setReplacementString(replacement);
            } else {
                this.setReplacementLength(this.getReplacementLength() + posLP);
            }
        }
    }

    private int getRelativePositionOf(IDocument document, int offset, char search) {
        int lineEnd;
        block4: {
            IRegion line = document.getLineInformationOfOffset(offset);
            lineEnd = line.getOffset() + line.getLength();
            if (offset < lineEnd) break block4;
            return -1;
        }
        try {
            int pos = 0;
            while (offset + pos < lineEnd - 1 && Character.isWhitespace(document.getChar(offset + pos))) {
                ++pos;
            }
            return document.getChar(offset + pos) == search ? pos : -1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public final int getReplacementLength() {
        if (!this.fReplacementLengthComputed) {
            this.setReplacementLength(this.fProposal.getReplaceEnd() - this.fProposal.getReplaceStart());
        }
        return super.getReplacementLength();
    }

    public final void setReplacementLength(int replacementLength) {
        this.fReplacementLengthComputed = true;
        super.setReplacementLength(replacementLength);
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    private String computeReplacementString(String prefix) {
        block3: {
            this.fReplacementStringComputed = true;
            try {
                this.method = this.getProperMethod(this.guessingMethod);
                if (this.alias != null || this.hasParameters() && this.hasArgumentList()) {
                    return this.computeGuessingCompletion(prefix);
                }
            }
            catch (ModelException e) {
                if (e.isDoesNotExist()) break block3;
                PHPCorePlugin.log((Throwable)e);
            }
        }
        return String.valueOf(prefix) + super.getReplacementString();
    }

    private IMethod getProperMethod(IMethod modelElement) {
        if (modelElement instanceof FakeConstructor) {
            IType type;
            IMethod[] ctors;
            FakeConstructor fc = (FakeConstructor)modelElement;
            if (fc.getParent() instanceof AliasType) {
                AliasType aliasType = (AliasType)fc.getParent();
                this.alias = aliasType.getAlias();
                if (aliasType.getParent() instanceof IType) {
                    fc = FakeConstructor.createFakeConstructor(null, (IType)((IType)aliasType.getParent()), (boolean)false);
                }
            }
            if ((ctors = FakeConstructor.getConstructors((IType)(type = fc.getDeclaringType()), (boolean)fc.isEnclosingClass())) != null && ctors.length == 2 && ctors[0] != null && ctors[1] != null) {
                return ctors[0];
            }
            return fc;
        }
        return modelElement;
    }

    protected boolean hasArgumentList() {
        if (10 == this.fProposal.getKind()) {
            return false;
        }
        String completion = this.fProposal.getCompletion();
        return !this.isInDoc() && completion.length() > 0;
    }

    protected boolean isValidPrefix(String prefix) {
        this.initAlias();
        String replacementString = null;
        replacementString = this.alias != null ? String.valueOf(this.alias) + '(' + ')' : super.getReplacementString();
        boolean result = this.isPrefix(prefix, replacementString);
        if (!result && prefix.length() > 0 && prefix.charAt(0) == '\\') {
            prefix = prefix.substring(1);
            result = this.isPrefix(prefix, replacementString);
        }
        return result;
    }

    private void initAlias() {
        this.alias = null;
        if (this.method instanceof FakeConstructor) {
            FakeConstructor fc = (FakeConstructor)this.method;
            if (fc.getParent() instanceof AliasType) {
                this.alias = ((AliasType)fc.getParent()).getAlias();
            }
        } else if (this.method instanceof AliasMethod) {
            this.alias = ((AliasMethod)this.method).getAlias();
        }
    }

    private boolean hasParameters() throws ModelException {
        return !ProposalExtraInfo.isMethodOnly((Object)this.extraInfo) && this.method.getParameters() != null && this.hasNondefaultValues(this.method.getParameters());
    }

    private boolean hasNondefaultValues(IParameter[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            IParameter parameter = parameters[i];
            if (parameter.getDefaultValue() == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String computeGuessingCompletion(String prefix) throws ModelException {
        StringBuilder buffer = new StringBuilder(prefix);
        this.appendMethodNameReplacement(buffer);
        this.setCursorPosition(buffer.length());
        IParameter[] parameters = this.method.getParameters();
        ArrayList<String> paramList = new ArrayList<String>();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                IParameter parameter = parameters[i];
                if (parameter.getDefaultValue() == null) {
                    paramList.add(parameter.getName());
                }
                ++i;
            }
        }
        char[][] parameterNames = new char[paramList.size()][];
        int i = 0;
        while (i < paramList.size()) {
            parameterNames[i] = ((String)paramList.get(i)).toCharArray();
            ++i;
        }
        this.fChoices = this.guessParameters(parameterNames);
        int count = this.fChoices.length;
        int replacementOffset = this.getReplacementOffset();
        int i2 = 0;
        while (i2 < count) {
            if (i2 != 0) {
                buffer.append(COMMA);
            }
            ICompletionProposal proposal = this.fChoices[i2][0];
            String argument = proposal.getDisplayString();
            Position position = this.fPositions[i2];
            position.setOffset(replacementOffset + buffer.length());
            position.setLength(argument.length());
            buffer.append(argument);
            ++i2;
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected void appendMethodNameReplacement(StringBuilder buffer) {
        if (this.alias != null) {
            buffer.append(this.alias);
            buffer.append('(');
        } else {
            buffer.append(this.fProposal.getName());
            buffer.append('(');
        }
    }

    private ICompletionProposal[][] guessParameters(char[][] parameterNames) throws ModelException {
        int count = parameterNames.length;
        this.fPositions = new Position[count];
        this.fChoices = new ICompletionProposal[count][];
        IParameter[] parameters = this.method.getParameters();
        int i = count - 1;
        while (i >= 0) {
            String paramName = new String(parameterNames[i]);
            Position position = new Position(0, 0);
            ICompletionProposal[] argumentProposals = this.parameterProposals(parameters[i].getDefaultValue(), paramName, position, this.fFillBestGuess);
            this.fPositions[i] = position;
            this.fChoices[i] = argumentProposals;
            --i;
        }
        return this.fChoices;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)Messages.ParameterGuessingProposal_0, (String)e.getMessage());
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    ParameterGuessingProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater(this.fUpdater);
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }

    public ICompletionProposal[] parameterProposals(String initialValue, String paramName, Position pos, boolean fillBestGuess) throws ModelException {
        ArrayList<String> typeMatches = new ArrayList<String>();
        if (initialValue != null) {
            typeMatches.add(initialValue);
        }
        ICompletionProposal[] ret = new ICompletionProposal[typeMatches.size()];
        int i = 0;
        int replacementLength = 0;
        for (String name : typeMatches) {
            if (i == 0) {
                replacementLength = name.length();
            }
            char[] triggers = new char[1];
            triggers[triggers.length - 1] = 59;
            ret[i++] = new PositionBasedCompletionProposal(name, pos, replacementLength, this.getImage(), name, null, null, triggers);
        }
        if (!fillBestGuess) {
            ICompletionProposal[] extended = new ICompletionProposal[ret.length + 1];
            System.arraycopy(ret, 0, extended, 1, ret.length);
            extended[0] = new PositionBasedCompletionProposal(paramName, pos, replacementLength, null, paramName, null, null, NO_TRIGGERS);
            return extended;
        }
        return ret;
    }

    public void setReplacementOffset(int replacementOffset) {
        int oldReplacementOffset = this.getReplacementOffset();
        if (this.fPositions != null && this.fPositions.length > 0) {
            Position[] positionArray = this.fPositions;
            int n = this.fPositions.length;
            int n2 = 0;
            while (n2 < n) {
                Position position = positionArray[n2];
                position.offset += replacementOffset - oldReplacementOffset;
                ++n2;
            }
        }
        super.setReplacementOffset(replacementOffset);
    }

    public IModelElement getModelElement() {
        return this.guessingMethod;
    }

    @Override
    public Object getExtraInfo() {
        return this.extraInfo;
    }
}

