/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.php.internal.ui.text.correction.LinkedNodeFinder;
import org.eclipse.php.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.ui.text.correction.IInvocationContext;
import org.eclipse.swt.graphics.Image;

public class CorrectMainTypeNameProposal
extends ASTRewriteCorrectionProposal {
    private final Identifier fOldName;
    private final Identifier fNewName;
    private final IInvocationContext fContext;

    public CorrectMainTypeNameProposal(ISourceModule cu, IInvocationContext context, Identifier oldTypeName, Identifier newTypeName, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fContext = context;
        this.setDisplayName(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renametype_description, BasicElementLabels.getJavaElementName((String)newTypeName.getName())));
        this.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_change.png"));
        this.fOldName = oldTypeName;
        this.fNewName = newTypeName;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        Program astRoot = this.fContext.getASTRoot();
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        TypeDeclaration decl = this.findTypeDeclaration(astRoot.statements(), this.fOldName);
        if (decl != null) {
            Identifier[] sameNodes = LinkedNodeFinder.findByNode((ASTNode)astRoot, decl.getName());
            int i = 0;
            while (i < sameNodes.length) {
                rewrite.replace((ASTNode)sameNodes[i], (ASTNode)this.fNewName, null);
                ++i;
            }
            if (sameNodes.length == 0) {
                rewrite.replace((ASTNode)this.fOldName, (ASTNode)this.fNewName, null);
            }
        }
        return rewrite;
    }

    private TypeDeclaration findTypeDeclaration(List<Statement> types, Identifier name) {
        if (types == null || types.size() == 0) {
            return null;
        }
        if (types.get(0) instanceof NamespaceDeclaration) {
            types = ((NamespaceDeclaration)types.get(0)).getBody().statements();
        }
        for (Statement decl : types) {
            if (!(decl instanceof TypeDeclaration) || !name.equals((Object)((TypeDeclaration)decl).getName())) continue;
            return (TypeDeclaration)decl;
        }
        return null;
    }
}

