/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipantDescriptor;

public class SynchronizeParticipantDescriptor
implements ISynchronizeParticipantDescriptor {
    public static final String ATTR_ID = "id";
    public static final String ATTR_SERVICE_ID = "serviceId";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLASS = "class";
    private final String fName;
    private final String fId;
    private final String fServiceId;
    private final String fClass;
    private final String fContributorName;
    private ISynchronizeParticipant fParticipant;

    public SynchronizeParticipantDescriptor(IConfigurationElement configElement) {
        this.fId = configElement.getAttribute(ATTR_ID);
        this.fName = configElement.getAttribute(ATTR_NAME);
        this.fServiceId = configElement.getAttribute(ATTR_SERVICE_ID);
        this.fClass = configElement.getAttribute(ATTR_CLASS);
        this.fContributorName = configElement.getDeclaringExtension().getContributor().getName();
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public ISynchronizeParticipant getParticipant() {
        if (this.fParticipant == null) {
            try {
                Class cls = Platform.getBundle((String)this.fContributorName).loadClass(this.fClass);
                Constructor cons = cls.getConstructor(ISynchronizeParticipantDescriptor.class);
                this.fParticipant = (ISynchronizeParticipant)cons.newInstance(this);
            }
            catch (Exception e) {
                RDTSyncUIPlugin.log(NLS.bind((String)Messages.SynchronizeParticipantDescriptor_invalidClass, (Object[])new String[]{this.fClass, this.fId}), e);
                return null;
            }
        }
        return this.fParticipant;
    }

    @Override
    public String getServiceId() {
        return this.fServiceId;
    }
}

