/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemActionViewerFilter;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemRemoteResourceDialog;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemSelectRemoteFileAction
extends SystemBaseDialogAction {
    private IRSESystemType[] systemTypes;
    private IHost systemConnection;
    private IHost outputConnection;
    private IHost rootFolderConnection;
    private IRemoteFile preSelection;
    private String rootFolderAbsPath;
    private String message;
    private String treeTip;
    private String dlgTitle;
    private boolean showNewConnectionPrompt = true;
    private boolean showPropertySheet = false;
    private boolean showPropertySheetDetailsButtonInitialState;
    private boolean showPropertySheetDetailsButton = false;
    private boolean multipleSelectionMode = false;
    private boolean onlyConnection = false;
    private IValidatorRemoteSelection clientProvidedSelectionValidator = null;
    private List viewerFilters = new ArrayList();
    private SystemActionViewerFilter customViewerFilter = null;
    private boolean allowFolderSelection = true;

    public SystemSelectRemoteFileAction(Shell shell) {
        this(shell, FileResources.ACTION_SELECT_FILE_LABEL, FileResources.ACTION_SELECT_FILE_TOOLTIP);
    }

    public SystemSelectRemoteFileAction(Shell shell, String label, String tooltip) {
        super(label, tooltip, null, shell);
        super.setNeedsProgressMonitor(true);
    }

    public void setHost(IHost conn) {
        this.systemConnection = conn;
        this.onlyConnection = true;
    }

    public void setDefaultConnection(IHost conn) {
        this.systemConnection = conn;
        this.onlyConnection = false;
    }

    public void setSystemTypes(IRSESystemType[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public void setSystemType(IRSESystemType systemType) {
        if (systemType == null) {
            this.setSystemTypes(null);
        } else {
            this.setSystemTypes(new IRSESystemType[]{systemType});
        }
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.showNewConnectionPrompt = show;
    }

    public void setRootFolder(IHost connection, String folderAbsolutePath) {
        this.rootFolderConnection = connection;
        this.rootFolderAbsPath = folderAbsolutePath;
        IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem((IHost)this.rootFolderConnection);
        if (ss != null) {
            try {
                IRemoteFile rootFolder = ss.getRemoteFileObject(this.rootFolderAbsPath, (IProgressMonitor)new NullProgressMonitor());
                if (rootFolder != null) {
                    this.setPreSelection(rootFolder);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.onlyConnection = true;
    }

    public void setRootFolder(IRemoteFile rootFolder) {
        this.setRootFolder(rootFolder.getHost(), rootFolder.getAbsolutePath());
    }

    public void setPreSelection(IRemoteFile selection) {
        this.preSelection = selection;
    }

    public void setShowPropertySheet(boolean show) {
        this.showPropertySheet = show;
    }

    public void setShowPropertySheet(boolean show, boolean initialState) {
        this.setShowPropertySheet(show);
        if (show) {
            this.showPropertySheetDetailsButton = true;
            this.showPropertySheetDetailsButtonInitialState = initialState;
        }
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.multipleSelectionMode = multiple;
    }

    public void setSelectionValidator(IValidatorRemoteSelection selectionValidator) {
        this.clientProvidedSelectionValidator = selectionValidator;
    }

    public void setDialogTitle(String title) {
        this.dlgTitle = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSelectionTreeToolTipText(String tip) {
        this.treeTip = tip;
    }

    public IRemoteFile getSelectedFile() {
        Object o = this.getValue();
        if (o instanceof IRemoteFile[]) {
            return ((IRemoteFile[])o)[0];
        }
        if (o instanceof IRemoteFile) {
            return (IRemoteFile)o;
        }
        return null;
    }

    public IRemoteFile[] getSelectedFiles() {
        Object o = this.getValue();
        if (o instanceof Object[]) {
            Object[] temp = (Object[])o;
            IRemoteFile[] files = new IRemoteFile[temp.length];
            int i = 0;
            while (i < temp.length) {
                if (!(temp[i] instanceof IRemoteFile)) {
                    return new IRemoteFile[0];
                }
                files[i] = (IRemoteFile)temp[i];
                ++i;
            }
            return files;
        }
        return null;
    }

    public Object[] getSelectedObjects() {
        Object remoteObject = this.getValue();
        if (remoteObject == null) {
            return null;
        }
        if (remoteObject instanceof Object[]) {
            return (Object[])remoteObject;
        }
        if (remoteObject instanceof IRemoteFile[]) {
            return (Object[])remoteObject;
        }
        return null;
    }

    public IHost getSelectedConnection() {
        return this.outputConnection;
    }

    public void setCustomViewerFilter(SystemActionViewerFilter filter) {
        this.customViewerFilter = filter;
    }

    protected Dialog createDialog(Shell shell) {
        SystemRemoteFileDialog dlg = null;
        dlg = this.dlgTitle == null ? new SystemRemoteFileDialog(shell) : new SystemRemoteFileDialog(shell, this.dlgTitle);
        dlg.setMultipleSelectionMode(this.multipleSelectionMode);
        dlg.setShowNewConnectionPrompt(this.showNewConnectionPrompt);
        if (this.systemConnection != null) {
            dlg.setDefaultSystemConnection(this.systemConnection, this.onlyConnection);
        }
        dlg.setCustomViewerFilter(this.customViewerFilter);
        if (this.message != null) {
            dlg.setMessage(this.message);
        }
        if (this.treeTip != null) {
            dlg.setSelectionTreeToolTipText(this.treeTip);
        }
        if (this.systemTypes != null) {
            dlg.setSystemTypes(this.systemTypes);
        }
        if (this.preSelection != null) {
            dlg.setPreSelection(this.preSelection);
        }
        if (this.showPropertySheet) {
            if (this.showPropertySheetDetailsButton) {
                dlg.setShowPropertySheet(true, this.showPropertySheetDetailsButtonInitialState);
            } else {
                dlg.setShowPropertySheet(true);
            }
        }
        RemoteFileSelectionValidator selectionValidator = new RemoteFileSelectionValidator(this.allowFolderSelection, this.clientProvidedSelectionValidator);
        dlg.setSelectionValidator(selectionValidator);
        return dlg;
    }

    protected Object getDialogValue(Dialog dlg) {
        SystemRemoteResourceDialog ourDlg = (SystemRemoteResourceDialog)dlg;
        Object outputObject = null;
        this.outputConnection = null;
        if (!ourDlg.wasCancelled()) {
            outputObject = this.multipleSelectionMode ? ourDlg.getSelectedObjects() : ourDlg.getSelectedObject();
            this.outputConnection = ourDlg.getSelectedConnection();
        }
        return outputObject;
    }

    public void addViewerFilter(ViewerFilter filter) {
        this.viewerFilters.add(filter);
    }

    public void setAllowFolderSelection(boolean allow) {
        this.allowFolderSelection = allow;
    }

    static class RemoteFileSelectionValidator
    implements IValidatorRemoteSelection {
        private boolean allowFolderSelect = true;
        private IValidatorRemoteSelection previousInChain = null;

        public RemoteFileSelectionValidator(boolean allowFolderSelection, IValidatorRemoteSelection previousInChain) {
            this.allowFolderSelect = allowFolderSelection;
            this.previousInChain = previousInChain;
        }

        public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
            SimpleSystemMessage msg = null;
            if (selectedObjects == null || selectedObjects.length == 0) {
                msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", 1, FileResources.MSG_MAKE_SELECTION);
                return msg;
            }
            if (this.allowFolderSelect) {
                if (this.previousInChain != null) {
                    return this.previousInChain.isValid(selectedConnection, selectedObjects, remoteAdaptersForSelectedObjects);
                }
                return null;
            }
            int i = 0;
            while (i < selectedObjects.length) {
                IRemoteFile selectedFile;
                if (selectedObjects[i] instanceof IRemoteFile && (selectedFile = (IRemoteFile)selectedObjects[i]) != null && selectedFile.isDirectory()) {
                    msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", 1, FileResources.MSG_SELECT_FOLDER_NOT_VALID);
                    return msg;
                }
                ++i;
            }
            if (this.previousInChain != null) {
                return this.previousInChain.isValid(selectedConnection, selectedObjects, remoteAdaptersForSelectedObjects);
            }
            return null;
        }
    }
}

