/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.unittest.internal.UnitTestPreferencesConstants;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.ui.CompareResultsAction;
import org.eclipse.unittest.internal.ui.EnableStackFilterAction;
import org.eclipse.unittest.internal.ui.FailureTableDisplay;
import org.eclipse.unittest.internal.ui.ShowStackTraceInConsoleViewAction;
import org.eclipse.unittest.internal.ui.TestRunnerViewPart;
import org.eclipse.unittest.internal.ui.TextualTrace;
import org.eclipse.unittest.internal.ui.UnitTestCopyAction;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.ui.ITestViewSupport;

public class FailureTraceUIBlock
implements IMenuListener {
    private static final int MAX_LABEL_LENGTH = 256;
    private final Table fTable;
    private final TestRunnerViewPart fTestRunner;
    private String fInputTrace;
    private final Clipboard fClipboard;
    private TestElement fFailure;
    private final CompareResultsAction fCompareAction;
    private final FailureTableDisplay fFailureTableDisplay;
    private final ShowStackTraceInConsoleViewAction fShowTraceInConsoleAction;

    public FailureTraceUIBlock(Composite parent, Clipboard clipboard, TestRunnerViewPart testRunner, ToolBar toolBar) {
        Assert.isNotNull((Object)clipboard);
        ToolBarManager failureToolBarmanager = new ToolBarManager(toolBar);
        this.fShowTraceInConsoleAction = new ShowStackTraceInConsoleViewAction();
        this.fShowTraceInConsoleAction.setDelegate(null);
        this.fShowTraceInConsoleAction.setEnabled(false);
        failureToolBarmanager.add((IAction)this.fShowTraceInConsoleAction);
        failureToolBarmanager.add((IAction)new EnableStackFilterAction(this));
        this.fCompareAction = new CompareResultsAction(this);
        this.fCompareAction.setEnabled(false);
        failureToolBarmanager.add((IAction)this.fCompareAction);
        failureToolBarmanager.update(true);
        this.fTable = new Table(parent, 772);
        this.fTestRunner = testRunner;
        this.fClipboard = clipboard;
        OpenStrategy handler = new OpenStrategy((Control)this.fTable);
        handler.addOpenListener(e -> {
            IAction a;
            if (this.fTable.getSelectionIndex() == 0 && this.fFailure.getFailureTrace() != null && this.fFailure.getFailureTrace().isComparisonFailure()) {
                this.fCompareAction.run();
            }
            if (this.fTable.getSelection().length != 0 && (a = this.createOpenEditorAction(this.getSelectedText())) != null) {
                a.run();
            }
        });
        this.initMenu();
        this.fFailureTableDisplay = new FailureTableDisplay(this.fTable);
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTable.getSelectionCount() > 0) {
            IAction a = this.createOpenEditorAction(this.getSelectedText());
            if (a != null) {
                manager.add(a);
            }
            manager.add((IAction)new UnitTestCopyAction(this, this.fClipboard));
        }
        if (this.fFailure != null && this.fFailure.getFailureTrace() != null && this.fFailure.getFailureTrace().isComparisonFailure()) {
            manager.add((IAction)this.fCompareAction);
        }
    }

    public String getTrace() {
        return this.fInputTrace;
    }

    private String getSelectedText() {
        return this.fTable.getSelection()[0].getText();
    }

    private IAction createOpenEditorAction(String traceLine) {
        return this.fFailure.getTestRunSession().getTestViewSupport().createOpenEditorAction(this.fTestRunner.getSite().getShell(), this.fFailure, traceLine);
    }

    public Composite getComposite() {
        return this.fTable;
    }

    public void refresh() {
        this.updateTable(this.fInputTrace);
    }

    public void showFailure(TestElement test) {
        this.fFailure = test;
        String trace = "";
        this.updateActions(test);
        this.updateEnablement(test);
        if (test != null && test.getFailureTrace() != null) {
            trace = test.getFailureTrace().getTrace();
        }
        if (Objects.equals(this.fInputTrace, trace)) {
            return;
        }
        this.fInputTrace = trace;
        this.updateTable(trace);
    }

    private void updateActions(TestElement test) {
        ITestViewSupport testViewSupport = test != null ? test.getTestRunSession().getTestViewSupport() : null;
        this.fShowTraceInConsoleAction.setDelegate(testViewSupport != null && test.getFailureTrace() != null ? testViewSupport.createShowStackTraceInConsoleViewActionDelegate(test) : null);
    }

    private void updateEnablement(TestElement test) {
        boolean enableCompare = test != null && test.getFailureTrace() != null && test.getFailureTrace().isComparisonFailure();
        this.fCompareAction.setEnabled(enableCompare);
        if (enableCompare) {
            this.fCompareAction.updateOpenDialog(test);
        }
        boolean enableShowTraceInConsole = test != null && test.getFailureTrace() != null;
        this.fShowTraceInConsoleAction.setEnabled(enableShowTraceInConsole);
    }

    private void updateTable(String trace) {
        if (trace == null || trace.trim().isEmpty()) {
            this.clear();
            return;
        }
        trace = trace.trim();
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        new TextualTrace(trace, this.getFilterPatterns()).display(this.fFailureTableDisplay, 256);
        this.fTable.setRedraw(true);
    }

    private Collection<StringMatcher> getFilterPatterns() {
        if (UnitTestPreferencesConstants.getFilterStack()) {
            return this.getFilterPatterns(this.fFailure.getTestRunSession());
        }
        return Collections.emptySet();
    }

    public Collection<StringMatcher> getFilterPatterns(ITestRunSession session) {
        Collection<StringMatcher> res;
        if (session == null) {
            return Collections.emptySet();
        }
        ITestViewSupport viewSupport = ((TestRunSession)session).getTestViewSupport();
        if (viewSupport != null && (res = viewSupport.getTraceExclusionFilterPatterns()) != null) {
            return res;
        }
        return Collections.emptySet();
    }

    public void setInformation(String text) {
        this.clear();
        TableItem tableItem = this.fFailureTableDisplay.newTableItem();
        tableItem.setText(text);
    }

    public void clear() {
        this.fTable.removeAll();
        this.fInputTrace = null;
    }

    public TestElement getFailedTest() {
        return this.fFailure;
    }

    public Shell getShell() {
        return this.fTable.getShell();
    }

    public void dispose() {
    }
}

