/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description.rules;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.apache.commons.digester3.Rule;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.GenericTypeResolver;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.property.accessor.MethodExpressionAccessor;
import org.eclipse.wb.internal.core.xml.model.property.converter.ExpressionConverter;
import org.xml.sax.Attributes;

public final class CreatePropertiesPropertyDescriptorRule
extends Rule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        ComponentDescription componentDescription = (ComponentDescription)this.getDigester().peek();
        List descriptors = ReflectionUtils.getPropertyDescriptors(null, componentDescription.getComponentClass());
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            this.addSingleProperty(componentDescription, propertyDescriptor);
        }
    }

    private void addSingleProperty(ComponentDescription componentDescription, PropertyDescriptor propertyDescriptor) throws Exception {
        Method setMethod = ReflectionUtils.getWriteMethod((PropertyDescriptor)propertyDescriptor);
        if (setMethod == null) {
            return;
        }
        if (!ReflectionUtils.isPublic((Method)setMethod)) {
            return;
        }
        String title = propertyDescriptor.getName();
        String attribute = StringUtils.substringBeforeLast((String)StringUtils.uncapitalize((String)title), (String)"(");
        Method getMethod = ReflectionUtils.getReadMethod((PropertyDescriptor)propertyDescriptor);
        Class<?> propertyType = CreatePropertiesPropertyDescriptorRule.resolvePropertyType(componentDescription, setMethod);
        String id = setMethod.getName() + "(" + ReflectionUtils.getFullyQualifiedName(propertyType, (boolean)false) + ")";
        MethodExpressionAccessor accessor = new MethodExpressionAccessor(attribute, setMethod, getMethod);
        ExpressionConverter converter = DescriptionPropertiesHelper.getConverterForType(propertyType);
        PropertyEditor editor = DescriptionPropertiesHelper.getEditorForType(propertyType);
        GenericPropertyDescription property = new GenericPropertyDescription(id, title, propertyType, accessor);
        property.setConverter(converter);
        property.setEditor(editor);
        componentDescription.addProperty(property);
    }

    private static Class<?> resolvePropertyType(ComponentDescription componentDescription, Method setMethod) {
        Class<?> propertyType = setMethod.getParameterTypes()[0];
        final Type genericPropertyType = setMethod.getGenericParameterTypes()[0];
        if (genericPropertyType instanceof TypeVariable) {
            final Class<?> declaringClass = setMethod.getDeclaringClass();
            final Class<?> actualClass = componentDescription.getComponentClass();
            return (Class)ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Class<?>>(){

                public Class<?> runObject() throws Exception {
                    String typeName = GenericsUtils.getTypeName((GenericTypeResolver)GenericTypeResolver.superClass((GenericTypeResolver)GenericTypeResolver.EMPTY, (Class)actualClass, (Class)declaringClass), (Type)genericPropertyType);
                    return actualClass.getClassLoader().loadClass(typeName);
                }
            }, propertyType);
        }
        return propertyType;
    }
}

