/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.commons.logging.Log;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class.getName());
    static final Map nsmap = new HashMap();
    protected static HashMap TYPES = new HashMap(7);

    static QName findQName(String namespace, String localName) {
        QName qname = null;
        HashMap<String, QName> ln2qn = (HashMap<String, QName>)nsmap.get(namespace);
        if (null == ln2qn) {
            ln2qn = new HashMap<String, QName>();
            nsmap.put(namespace, ln2qn);
            qname = new QName(namespace, localName);
            ln2qn.put(localName, qname);
        } else {
            qname = (QName)ln2qn.get(localName);
            if (null == qname) {
                qname = new QName(namespace, localName);
                ln2qn.put(localName, qname);
            }
        }
        return qname;
    }

    public static String getScopedAttribute(Node node, String attr) {
        if (node == null) {
            return null;
        }
        if (node.getAttributes() == null) {
            return Utils.getScopedAttribute(node.getParentNode(), attr);
        }
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return Utils.getScopedAttribute(node.getParentNode(), attr);
    }

    public static String getAttribute(Node node, String attr) {
        if (node == null || node.getAttributes() == null) {
            return null;
        }
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    public static Vector getAttributesWithLocalName(Node node, String localName) {
        Vector<Node> v = new Vector<Node>();
        if (node == null) {
            return v;
        }
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node attrNode = map.item(i);
                if (attrNode == null || !attrNode.getLocalName().equals(localName)) continue;
                v.add(attrNode);
            }
        }
        return v;
    }

    public static QName getNodeQName(Node node) {
        if (node == null) {
            return null;
        }
        String localName = node.getLocalName();
        if (localName == null) {
            return null;
        }
        String namespace = node.getNamespaceURI();
        return Utils.findQName(namespace, localName);
    }

    public static QName getNodeNameQName(Node node) {
        QName ref;
        if (node == null) {
            return null;
        }
        String localName = null;
        String namespace = null;
        localName = Utils.getAttribute(node, "name");
        if (localName == null && (ref = Utils.getTypeQNameFromAttr(node, "ref")) != null) {
            localName = ref.getLocalPart();
            namespace = ref.getNamespaceURI();
        }
        Node search = node.getParentNode();
        while (search != null) {
            String ln = search.getLocalName();
            if (ln.equals("schema")) {
                search = null;
                continue;
            }
            if (ln.equals("element") || ln.equals("attribute")) {
                localName = ">" + Utils.getNodeNameQName(search).getLocalPart();
                search = null;
                continue;
            }
            if (ln.equals("complexType") || ln.equals("simpleType")) {
                localName = Utils.getNodeNameQName(search).getLocalPart() + ">" + localName;
                search = null;
                continue;
            }
            search = search.getParentNode();
        }
        if (localName == null) {
            return null;
        }
        if (namespace == null) {
            namespace = Utils.getScopedAttribute(node, "targetNamespace");
        }
        return Utils.findQName(namespace, localName);
    }

    public static QName getTypeQName(Node node, BooleanHolder forElement, boolean ignoreMaxOccurs) {
        if (node == null) {
            return null;
        }
        forElement.value = false;
        QName qName = Utils.getTypeQNameFromAttr(node, "type");
        if (qName == null) {
            String localName = node.getLocalName();
            if (!(localName == null || localName.equals("attributeGroup") || localName.equals("group") || localName.equals("list"))) {
                forElement.value = true;
            }
            qName = Utils.getTypeQNameFromAttr(node, "ref");
        }
        if (qName == null) {
            qName = Utils.getTypeQNameFromAttr(node, "itemType");
        }
        if (!ignoreMaxOccurs && qName != null) {
            String maxOccursValue = Utils.getAttribute(node, "maxOccurs");
            String minOccursValue = Utils.getAttribute(node, "minOccurs");
            String nillableValue = Utils.getAttribute(node, "nillable");
            if (maxOccursValue == null) {
                maxOccursValue = "1";
            }
            if (minOccursValue == null) {
                minOccursValue = "1";
            }
            if (!(minOccursValue.equals("0") && maxOccursValue.equals("1") || maxOccursValue.equals("1") && minOccursValue.equals("1"))) {
                String localPart = qName.getLocalPart();
                String wrapped = nillableValue != null && nillableValue.equals("true") ? " wrapped" : "";
                String range = "[";
                if (!minOccursValue.equals("1")) {
                    range = range + minOccursValue;
                }
                range = range + ",";
                if (!maxOccursValue.equals("1")) {
                    range = range + maxOccursValue;
                }
                range = range + "]";
                localPart = localPart + range + wrapped;
                qName = Utils.findQName(qName.getNamespaceURI(), localPart);
            }
        }
        if (qName == null) {
            forElement.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "element");
        }
        if (qName == null) {
            forElement.value = false;
            qName = Utils.getTypeQNameFromAttr(node, "base");
        }
        return qName;
    }

    public static QName[] getMemberTypeQNames(Node node) {
        String attribute = Utils.getAttribute(node, "memberTypes");
        if (attribute == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(attribute, " ");
        QName[] memberTypes = new QName[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            memberTypes[i] = XMLUtils.getFullQNameFromString(element, node);
            ++i;
        }
        return memberTypes;
    }

    private static QName getTypeQNameFromAttr(Node node, String typeAttrName) {
        if (node == null) {
            return null;
        }
        String prefixedName = Utils.getAttribute(node, typeAttrName);
        if (prefixedName == null && typeAttrName.equals("type") && Utils.getAttribute(node, "ref") == null && Utils.getAttribute(node, "base") == null && Utils.getAttribute(node, "element") == null) {
            QName anonQName = SchemaUtils.getElementAnonQName(node);
            if (anonQName == null) {
                anonQName = SchemaUtils.getAttributeAnonQName(node);
            }
            if (anonQName != null) {
                return anonQName;
            }
            String localName = node.getLocalName();
            if (localName != null && Constants.isSchemaXSD(node.getNamespaceURI()) && (localName.equals("element") || localName.equals("attribute"))) {
                return Constants.XSD_ANYTYPE;
            }
        }
        if (prefixedName == null) {
            return null;
        }
        QName qName = Utils.getQNameFromPrefixedName(node, prefixedName);
        return qName;
    }

    public static QName getQNameFromPrefixedName(Node node, String prefixedName) {
        String localName = prefixedName.substring(prefixedName.lastIndexOf(":") + 1);
        String namespace = null;
        namespace = prefixedName.length() == localName.length() ? Utils.getScopedAttribute(node, "xmlns") : Utils.getScopedAttribute(node, "xmlns:" + prefixedName.substring(0, prefixedName.lastIndexOf(":")));
        return Utils.findQName(namespace, localName);
    }

    public static HashSet getDerivedTypes(TypeEntry type, SymbolTable symbolTable) {
        HashSet types = (HashSet)symbolTable.derivedTypes.get(type);
        if (types != null) {
            return types;
        }
        types = new HashSet();
        symbolTable.derivedTypes.put(type, types);
        if (type != null && type.getNode() != null) {
            Utils.getDerivedTypes(type, types, symbolTable);
        } else if (type != null && Constants.isSchemaXSD(type.getQName().getNamespaceURI()) && (type.getQName().getLocalPart().equals("anyType") || type.getQName().getLocalPart().equals("any"))) {
            Collection typeValues = symbolTable.getTypeIndex().values();
            types.addAll(typeValues);
        }
        return types;
    }

    private static void getDerivedTypes(TypeEntry type, HashSet types, SymbolTable symbolTable) {
        if (types.size() == symbolTable.getTypeEntryCount()) {
            return;
        }
        Iterator it = symbolTable.getTypeIndex().values().iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            if (!(t instanceof DefinedType) || t.getNode() == null || types.contains(t) || ((DefinedType)t).getComplexTypeExtensionBase(symbolTable) != type) continue;
            types.add(t);
            Utils.getDerivedTypes(t, types, symbolTable);
        }
    }

    protected static HashSet getNestedTypes(TypeEntry type, SymbolTable symbolTable, boolean derivedFlag) {
        HashSet types = new HashSet();
        Utils.getNestedTypes(type, types, symbolTable, derivedFlag);
        return types;
    }

    private static void getNestedTypes(TypeEntry type, HashSet types, SymbolTable symbolTable, boolean derivedFlag) {
        TypeEntry extendType;
        if (type == null) {
            return;
        }
        if (types.size() == symbolTable.getTypeEntryCount()) {
            return;
        }
        if (derivedFlag) {
            HashSet derivedTypes = Utils.getDerivedTypes(type, symbolTable);
            Iterator it = derivedTypes.iterator();
            while (it.hasNext()) {
                TypeEntry derivedType = (TypeEntry)it.next();
                if (types.contains(derivedType)) continue;
                types.add(derivedType);
                Utils.getNestedTypes(derivedType, types, symbolTable, derivedFlag);
            }
        }
        if (type.getNode() == null) {
            return;
        }
        Node node = type.getNode();
        Vector v = SchemaUtils.getContainedElementDeclarations(node, symbolTable);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                ElementDecl elem = (ElementDecl)v.get(i);
                if (types.contains(elem.getType())) continue;
                types.add(elem.getType());
                Utils.getNestedTypes(elem.getType(), types, symbolTable, derivedFlag);
            }
        }
        if ((v = SchemaUtils.getContainedAttributeTypes(node, symbolTable)) != null) {
            for (int i = 0; i < v.size(); ++i) {
                ContainedAttribute attr = (ContainedAttribute)v.get(i);
                TypeEntry te = attr.getType();
                if (types.contains(te)) continue;
                types.add(te);
                Utils.getNestedTypes(te, types, symbolTable, derivedFlag);
            }
        }
        if (type.getRefType() != null && !types.contains(type.getRefType())) {
            types.add(type.getRefType());
            Utils.getNestedTypes(type.getRefType(), types, symbolTable, derivedFlag);
        }
        if ((extendType = SchemaUtils.getComplexElementExtensionBase(node, symbolTable)) != null && !types.contains(extendType)) {
            types.add(extendType);
            Utils.getNestedTypes(extendType, types, symbolTable, derivedFlag);
        }
    }

    public static String getLastLocalPart(String localPart) {
        int anonymousDelimitorIndex = localPart.lastIndexOf(62);
        if (anonymousDelimitorIndex > -1 && anonymousDelimitorIndex < localPart.length() - 1) {
            localPart = localPart.substring(anonymousDelimitorIndex + 1);
        }
        return localPart;
    }

    public static QName getXSIType(TypeEntry te) {
        QName xmlType = null;
        if (te != null && te instanceof Element && te.getRefType() != null) {
            te = te.getRefType();
        }
        if (te != null && te instanceof CollectionTE && te.getRefType() != null) {
            te = te.getRefType();
        }
        if (te != null) {
            xmlType = te.getQName();
        }
        return xmlType;
    }

    public static QName getMIMETypeQName(String mimeName) {
        if ("text/plain".equals(mimeName)) {
            return Constants.MIME_PLAINTEXT;
        }
        if ("image/gif".equals(mimeName) || "image/jpeg".equals(mimeName)) {
            return Constants.MIME_IMAGE;
        }
        if ("text/xml".equals(mimeName) || "applications/xml".equals(mimeName)) {
            return Constants.MIME_SOURCE;
        }
        if ("application/octet-stream".equals(mimeName) || "application/octetstream".equals(mimeName)) {
            return Constants.MIME_OCTETSTREAM;
        }
        if (mimeName != null && mimeName.startsWith("multipart/")) {
            return Constants.MIME_MULTIPART;
        }
        return Constants.MIME_DATA_HANDLER;
    }

    public static QName getXSIType(Parameter param) {
        if (param.getMIMEInfo() != null) {
            return Utils.getMIMETypeQName(param.getMIMEInfo().getType());
        }
        return Utils.getXSIType(param.getType());
    }

    public static boolean hasMIME(BindingEntry bEntry) {
        List operations = bEntry.getBinding().getBindingOperations();
        for (int i = 0; i < operations.size(); ++i) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            if (!Utils.hasMIME(bEntry, operation)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMIME(BindingEntry bEntry, BindingOperation operation) {
        Parameters parameters = bEntry.getParameters(operation.getOperation());
        if (parameters != null) {
            for (int idx = 0; idx < parameters.list.size(); ++idx) {
                Parameter p = (Parameter)parameters.list.get(idx);
                if (p.getMIMEInfo() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static QName getOperationQName(BindingOperation bindingOper, BindingEntry bEntry, SymbolTable symbolTable) {
        Map parts;
        Input input;
        Operation operation = bindingOper.getOperation();
        String operationName = operation.getName();
        if (bEntry.getBindingStyle() == Style.DOCUMENT && symbolTable.isWrapped() && (input = operation.getInput()) != null && (parts = input.getMessage().getParts()) != null && !parts.isEmpty()) {
            Iterator i = parts.values().iterator();
            Part p = (Part)i.next();
            return p.getElementName();
        }
        String ns = null;
        BindingInput bindInput = bindingOper.getBindingInput();
        if (bindInput != null) {
            Iterator it = bindInput.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                ExtensibilityElement elem = (ExtensibilityElement)it.next();
                if (elem instanceof SOAPBody) {
                    SOAPBody body = (SOAPBody)elem;
                    ns = body.getNamespaceURI();
                    if (bEntry.getInputBodyType(operation) != Use.ENCODED || ns != null && ns.length() != 0) break;
                    log.warn((Object)Messages.getMessage("badNamespaceForOperation00", bEntry.getName(), operation.getName()));
                    break;
                }
                if (elem instanceof MIMEMultipartRelated) {
                    Object part = null;
                    MIMEMultipartRelated mpr = (MIMEMultipartRelated)elem;
                    List l = mpr.getMIMEParts();
                    block1: for (int j = 0; l != null && j < l.size() && part == null; ++j) {
                        MIMEPart mp = (MIMEPart)l.get(j);
                        List ll = mp.getExtensibilityElements();
                        for (int k = 0; ll != null && k < ll.size() && part == null; ++k) {
                            part = ll.get(k);
                            if (part instanceof SOAPBody) {
                                SOAPBody body = part;
                                ns = body.getNamespaceURI();
                                if (bEntry.getInputBodyType(operation) != Use.ENCODED || ns != null && ns.length() != 0) continue block1;
                                log.warn((Object)Messages.getMessage("badNamespaceForOperation00", bEntry.getName(), operation.getName()));
                                continue block1;
                            }
                            part = null;
                        }
                    }
                    continue;
                }
                if (!(elem instanceof SOAP12Body)) continue;
                ns = ((SOAP12Body)elem).getNamespaceURI();
            }
        }
        if (ns == null) {
            ns = "";
        }
        return new QName(ns, operationName);
    }

    public static String getWrapperType(String type) {
        String ret = (String)TYPES.get(type);
        return ret == null ? type : ret;
    }

    public static boolean isXsNode(Node node, String nameName) {
        return node.getLocalName().equals(nameName) && Constants.isSchemaXSD(node.getNamespaceURI());
    }

    static {
        TYPES.put("int", "java.lang.Integer");
        TYPES.put("float", "java.lang.Float");
        TYPES.put("boolean", "java.lang.Boolean");
        TYPES.put("double", "java.lang.Double");
        TYPES.put("byte", "java.lang.Byte");
        TYPES.put("short", "java.lang.Short");
        TYPES.put("long", "java.lang.Long");
    }
}

