/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.ChunkIterator;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public class ChunkIterable<T>
extends AbstractLazyIterable<RichIterable<T>> {
    private final Iterable<T> iterable;
    private final int size;

    public ChunkIterable(Iterable<T> iterable, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.iterable = iterable;
        this.size = size;
    }

    @Override
    public Iterator<RichIterable<T>> iterator() {
        return new ChunkIterator<T>(this.iterable, this.size);
    }

    @Override
    public void each(Procedure<? super RichIterable<T>> procedure) {
        IterableIterate.forEach(this, procedure);
    }
}

