/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportUtilities;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class ViewportAwareConnectionLayerClippingStrategy
implements IClippingStrategy {
    private static final Insets PRIVATE_INSETS = new Insets(0, 0, 1, 1);
    private ConnectionLayer connectionLayer = null;

    public ViewportAwareConnectionLayerClippingStrategy(ConnectionLayer connectionLayer) {
        this.connectionLayer = connectionLayer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Rectangle[] getClip(IFigure figure) {
        Rectangle[] clipRect = null;
        IFigure iFigure = figure;
        if (iFigure instanceof Connection) {
            void conn;
            Connection connection = (Connection)iFigure;
            Connection cfr_ignored_0 = (Connection)iFigure;
            clipRect = this.getEdgeClippingRectangle((Connection)conn);
        } else {
            clipRect = new Rectangle[]{this.getNodeClippingRectangle(figure)};
        }
        Rectangle[] rectangleArray = clipRect;
        int n = clipRect.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle element = rectangleArray[n2];
            figure.translateToRelative(element);
            ++n2;
        }
        return clipRect;
    }

    protected Rectangle[] getEdgeClippingRectangle(Connection connection) {
        Viewport nearestEnclosingTargetViewport;
        Viewport nearestEnclosingSourceViewport;
        IFigure targetFigure;
        Rectangle clipRect = this.getAbsoluteBoundsAsCopy(connection);
        ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
        ConnectionAnchor targetAnchor = connection.getTargetAnchor();
        if (sourceAnchor == null || sourceAnchor.getOwner() == null || targetAnchor == null || targetAnchor.getOwner() == null) {
            return new Rectangle[]{clipRect};
        }
        IFigure sourceFigure = sourceAnchor.getOwner();
        Viewport nearestEnclosingCommonViewport = ViewportUtilities.getNearestCommonViewport(sourceFigure, targetFigure = targetAnchor.getOwner());
        if (nearestEnclosingCommonViewport == null) {
            return new Rectangle[]{clipRect};
        }
        if (nearestEnclosingCommonViewport != this.getRootViewport()) {
            clipRect.intersect(this.getNodeClippingRectangle(nearestEnclosingCommonViewport));
        }
        if ((nearestEnclosingSourceViewport = ViewportUtilities.getNearestEnclosingViewport(sourceFigure)) == (nearestEnclosingTargetViewport = ViewportUtilities.getNearestEnclosingViewport(targetFigure))) {
            return new Rectangle[]{clipRect};
        }
        Rectangle sourceClipRect = clipRect.getCopy();
        if (nearestEnclosingSourceViewport != nearestEnclosingCommonViewport) {
            this.clipAtViewports(sourceClipRect, ViewportUtilities.getViewportsPath(nearestEnclosingSourceViewport, nearestEnclosingCommonViewport, false));
        }
        Rectangle targetClipRect = clipRect.getCopy();
        if (nearestEnclosingTargetViewport != nearestEnclosingCommonViewport) {
            this.clipAtViewports(targetClipRect, ViewportUtilities.getViewportsPath(nearestEnclosingTargetViewport, nearestEnclosingCommonViewport, false));
        }
        PointList absolutePointsAsCopy = this.getAbsolutePointsAsCopy(connection);
        boolean sourceAnchorVisible = sourceClipRect.getExpanded(PRIVATE_INSETS).contains(absolutePointsAsCopy.getFirstPoint());
        boolean targetAnchorVisible = targetClipRect.getExpanded(PRIVATE_INSETS).contains(absolutePointsAsCopy.getLastPoint());
        if (!sourceAnchorVisible || !targetAnchorVisible) {
            return new Rectangle[0];
        }
        return new Rectangle[]{clipRect};
    }

    protected Rectangle getNodeClippingRectangle(IFigure figure) {
        Rectangle clipRect = this.getAbsoluteBoundsAsCopy(figure);
        List<Viewport> enclosingViewportsPath = ViewportUtilities.getViewportsPath(ViewportUtilities.getNearestEnclosingViewport(figure), this.getRootViewport(), false);
        this.clipAtViewports(clipRect, enclosingViewportsPath);
        return clipRect;
    }

    protected void clipAtViewports(Rectangle clipRect, List<Viewport> enclosingViewportsPath) {
        enclosingViewportsPath.forEach(vp -> {
            Rectangle rectangle2 = clipRect.intersect(this.getAbsoluteViewportAreaAsCopy((Viewport)vp));
        });
    }

    protected Viewport getRootViewport() {
        return ViewportUtilities.getNearestEnclosingViewport(this.connectionLayer);
    }

    protected PointList getAbsolutePointsAsCopy(Connection connection) {
        PointList points = connection.getPoints().getCopy();
        connection.translateToAbsolute(points);
        return points;
    }

    protected Rectangle getAbsoluteViewportAreaAsCopy(Viewport viewport) {
        return this.getAbsoluteClientAreaAsCopy(viewport);
    }

    protected Rectangle getAbsoluteClientAreaAsCopy(IFigure figure) {
        Rectangle absoluteClientArea = figure.getClientArea();
        figure.translateToParent(absoluteClientArea);
        figure.translateToAbsolute(absoluteClientArea);
        return absoluteClientArea;
    }

    protected Rectangle getAbsoluteBoundsAsCopy(IFigure figure) {
        Rectangle absoluteFigureBounds = figure.getBounds().getCopy();
        figure.translateToAbsolute(absoluteFigureBounds);
        return absoluteFigureBounds;
    }
}

