/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolbarDropdownContributionItem
extends ContributionItem {
    private static ImageCache globalImageCache;
    private final IAction action;
    private Widget widget = null;
    private final ActionListener listener = new ActionListener();

    public ToolbarDropdownContributionItem(IAction action) {
        super(action.getId());
        this.action = action;
    }

    private void actionPropertyChange(PropertyChangeEvent e) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(e.getProperty());
            } else {
                display.asyncExec(() -> this.update(e.getProperty()));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean belongsToContextMenu(MenuItem item) {
        menu = item.getParent();
        if (menu != null) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            menu = menu.getParentMenu();
lbl5:
            // 2 sources

            ** while (menu.getParentMenu() != null)
        }
lbl6:
        // 1 sources

        return (menu.getStyle() & 2) == 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ToolbarDropdownContributionItem)) {
            return false;
        }
        return this.action.equals(((ToolbarDropdownContributionItem)((Object)o)).action);
    }

    public void fill(Composite parent) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            if (this.action != null && this.action.getStyle() == 2) {
                flags = 2;
            }
            Button b = new Button(parent, flags);
            b.setData((Object)this);
            b.addListener(12, (Listener)this.listener);
            b.addListener(13, (Listener)this.listener);
            if (this.action.getHelpListener() != null) {
                b.addHelpListener(this.action.getHelpListener());
            }
            this.widget = b;
            this.update(null);
            this.action.addPropertyChangeListener((IPropertyChangeListener)this.listener);
        }
    }

    public void fill(Menu parent, int index) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            Menu subMenu = null;
            if (this.action != null) {
                int style = this.action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 4) {
                    IMenuCreator mc = this.action.getMenuCreator();
                    subMenu = mc.getMenu(parent);
                    flags = 64;
                }
            }
            MenuItem mi = null;
            mi = index >= 0 ? new MenuItem(parent, flags, index) : new MenuItem(parent, flags);
            this.widget = mi;
            mi.setData((Object)this);
            mi.addListener(30, (Listener)this.listener);
            mi.addListener(12, (Listener)this.listener);
            mi.addListener(13, (Listener)this.listener);
            if (this.action.getHelpListener() != null) {
                mi.addHelpListener(this.action.getHelpListener());
            }
            if (subMenu != null) {
                mi.setMenu(subMenu);
            }
            this.update(null);
            this.action.addPropertyChangeListener((IPropertyChangeListener)this.listener);
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget == null && parent != null) {
            int flags = 8;
            if (this.action != null) {
                int style = this.action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 4) {
                    flags = 4;
                }
            }
            ToolItem ti = null;
            ti = index >= 0 ? new ToolItem(parent, flags, index) : new ToolItem(parent, flags);
            ti.setData((Object)this);
            ti.addListener(13, (Listener)this.listener);
            ti.addListener(12, (Listener)this.listener);
            this.widget = ti;
            this.update(null);
            this.action.addPropertyChangeListener((IPropertyChangeListener)this.listener);
        }
    }

    public IAction getAction() {
        return this.action;
    }

    private ImageCache getImageCache() {
        ImageCache cache = globalImageCache;
        if (cache == null) {
            globalImageCache = cache = new ImageCache();
            Display display = Display.getDefault();
            if (display != null) {
                display.disposeExec(() -> {
                    if (globalImageCache != null) {
                        globalImageCache.dispose();
                        globalImageCache = null;
                    }
                });
            }
        }
        return cache;
    }

    private void handleWidgetArm(Event e) {
    }

    private void handleWidgetDispose(Event e) {
        if (e.widget == this.widget) {
            if (this.action.getStyle() == 4) {
                this.action.getMenuCreator().dispose();
            }
            this.action.removePropertyChangeListener((IPropertyChangeListener)this.listener);
            this.widget = null;
        }
    }

    private void handleWidgetEvent(Event e) {
        switch (e.type) {
            case 30: {
                this.handleWidgetArm(e);
                break;
            }
            case 12: {
                this.handleWidgetDispose(e);
                break;
            }
            case 13: {
                this.handleWidgetSelection(e);
            }
        }
    }

    private void handleWidgetSelection(Event e) {
        Widget item = e.widget;
        if (item != null) {
            ToolItem ti;
            IMenuCreator mc;
            Menu m;
            int style = item.getStyle();
            if ((style & 0x22) != 0) {
                if (this.action.getStyle() == 2) {
                    this.action.setChecked(!this.action.isChecked());
                }
            } else if ((style & 4) != 0 && this.action.getStyle() == 4 && (m = (mc = this.action.getMenuCreator()).getMenu((Control)(ti = (ToolItem)item).getParent())) != null) {
                Rectangle b = ti.getBounds();
                Point p = ti.getParent().toDisplay(new Point(b.x, b.y + b.height));
                m.setLocation(p.x, p.y);
                m.setVisible(true);
                return;
            }
            if (this.action.isEnabled()) {
                this.action.runWithEvent(e);
            }
        }
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    public boolean isEnabled() {
        return this.action != null && this.action.isEnabled();
    }

    public boolean isDynamic() {
        if (this.widget instanceof MenuItem) {
            boolean itemIsCheck = (this.widget.getStyle() & 0x20) != 0;
            boolean actionIsCheck = this.getAction() != null && this.getAction().getStyle() == 2;
            return itemIsCheck ^ actionIsCheck;
        }
        return false;
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean value = this.getParent().getOverrides().getEnabled((IContributionItem)this);
        return value == null ? true : value;
    }

    public final void update() {
        this.update(null);
    }

    /*
     * WARNING - void declaration
     */
    public void update(String propertyName) {
        if (this.widget != null) {
            boolean textChanged = propertyName == null || propertyName.equals("text");
            boolean imageChanged = propertyName == null || propertyName.equals("image");
            boolean tooltipTextChanged = propertyName == null || propertyName.equals("toolTipText");
            boolean enableStateChanged = propertyName == null || propertyName.equals("enabled") || propertyName.equals("enabled");
            boolean checkChanged = this.action.getStyle() == 2 && (propertyName == null || propertyName.equals("checked"));
            Widget widget = this.widget;
            if (widget instanceof ToolItem) {
                void ti;
                ToolItem toolItem = (ToolItem)widget;
                ToolItem cfr_ignored_0 = (ToolItem)widget;
                if (imageChanged) {
                    this.updateImages(true);
                }
                if (tooltipTextChanged) {
                    ti.setToolTipText(this.action.getToolTipText());
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (ti.getEnabled() != shouldBeEnabled) {
                        ti.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (ti.getSelection() != bv) {
                        ti.setSelection(bv);
                    }
                }
                return;
            }
            Widget widget2 = this.widget;
            if (widget2 instanceof MenuItem) {
                void mi;
                MenuItem bv = (MenuItem)widget2;
                MenuItem cfr_ignored_1 = (MenuItem)widget2;
                boolean isContextMenu = ToolbarDropdownContributionItem.belongsToContextMenu((MenuItem)mi);
                if (textChanged) {
                    if (isContextMenu) {
                        text = this.action.getText();
                        if (text != null) {
                            text = Action.removeAcceleratorText((String)text);
                            mi.setText(text);
                        }
                    } else {
                        text = null;
                        IContributionManagerOverrides overrides = null;
                        if (this.getParent() != null) {
                            overrides = this.getParent().getOverrides();
                        }
                        if (overrides != null) {
                            text = this.getParent().getOverrides().getText((IContributionItem)this);
                        }
                        if (text == null) {
                            text = this.action.getText();
                        }
                        if (text != null) {
                            String label = Action.removeAcceleratorText((String)text);
                            String accText = null;
                            Integer acc = null;
                            if (overrides != null) {
                                accText = overrides.getAcceleratorText((IContributionItem)this);
                                acc = overrides.getAccelerator((IContributionItem)this);
                            }
                            if (accText == null && label.length() + 1 < text.length()) {
                                accText = text.substring(label.length() + 1);
                            }
                            if (acc == null) {
                                acc = this.action.getAccelerator();
                            }
                            if (acc >= 0) {
                                mi.setAccelerator(acc.intValue());
                            }
                            if (accText == null) {
                                mi.setText(label);
                            } else {
                                mi.setText(label + "\t" + accText);
                            }
                        }
                    }
                }
                if (imageChanged) {
                    this.updateImages(false);
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (mi.getEnabled() != shouldBeEnabled) {
                        mi.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv2 = this.action.isChecked();
                    if (mi.getSelection() != bv2) {
                        mi.setSelection(bv2);
                    }
                }
                return;
            }
            Widget widget3 = this.widget;
            if (widget3 instanceof Button) {
                void button;
                String text;
                Button isContextMenu = (Button)widget3;
                Button cfr_ignored_2 = (Button)widget3;
                if (imageChanged && this.updateImages(false)) {
                    textChanged = false;
                }
                if (textChanged && (text = this.action.getText()) != null) {
                    button.setText(text);
                }
                if (tooltipTextChanged) {
                    button.setToolTipText(this.action.getToolTipText());
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled;
                    boolean bl = shouldBeEnabled = this.action.isEnabled() && this.isEnabledAllowed();
                    if (button.getEnabled() != shouldBeEnabled) {
                        button.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (button.getSelection() != bv) {
                        button.setSelection(bv);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateImages(boolean forceImage) {
        ImageCache cache = this.getImageCache();
        Widget widget = this.widget;
        if (widget instanceof ToolItem) {
            void toolItem;
            ToolItem toolItem2 = (ToolItem)widget;
            ToolItem cfr_ignored_0 = (ToolItem)widget;
            Image image = cache.getImage(this.action.getImageDescriptor());
            Image hoverImage = cache.getImage(this.action.getHoverImageDescriptor());
            Image disabledImage = cache.getImage(this.action.getDisabledImageDescriptor());
            if (image == null && hoverImage != null) {
                image = cache.getGrayImage(this.action.getHoverImageDescriptor());
            } else if (hoverImage == null && image != null) {
                hoverImage = image;
                image = cache.getGrayImage(this.action.getImageDescriptor());
            }
            if (hoverImage == null && image == null && forceImage) {
                image = cache.getMissingImage();
            }
            if (disabledImage != null) {
                toolItem.setDisabledImage(disabledImage);
            }
            toolItem.setHotImage(hoverImage);
            toolItem.setImage(image);
            return image != null;
        }
        if (this.widget instanceof Item || this.widget instanceof Button) {
            Widget widget2;
            Image image = cache.getImage(this.action.getHoverImageDescriptor());
            if (image == null) {
                image = cache.getImage(this.action.getImageDescriptor());
            }
            if (image == null && forceImage) {
                image = cache.getMissingImage();
            }
            if ((widget2 = this.widget) instanceof Item) {
                void item;
                Item hoverImage = (Item)widget2;
                Item cfr_ignored_1 = (Item)widget2;
                item.setImage(image);
            } else {
                Widget widget3 = this.widget;
                if (widget3 instanceof Button) {
                    void button;
                    Button button2 = (Button)widget3;
                    Button cfr_ignored_2 = (Button)widget3;
                    button.setImage(image);
                }
            }
            return image != null;
        }
        return false;
    }

    private class ActionListener
    implements Listener,
    IPropertyChangeListener {
        private ActionListener() {
        }

        public void handleEvent(Event event) {
            ToolbarDropdownContributionItem.this.handleWidgetEvent(event);
        }

        public void propertyChange(PropertyChangeEvent event) {
            ToolbarDropdownContributionItem.this.actionPropertyChange(event);
        }
    }

    private class ImageCache {
        private final Map<ImageDescriptor, Entry> entries = new HashMap<ImageDescriptor, Entry>(11);
        private Image missingImage;

        private ImageCache() {
        }

        Entry getEntry(ImageDescriptor desc) {
            return this.entries.computeIfAbsent(desc, ignore -> new Entry());
        }

        Image getImage(ImageDescriptor desc) {
            if (desc == null) {
                return null;
            }
            Entry entry = this.getEntry(desc);
            if (entry.image == null) {
                entry.image = desc.createImage();
            }
            return entry.image;
        }

        Image getGrayImage(ImageDescriptor desc) {
            Image image;
            if (desc == null) {
                return null;
            }
            Entry entry = this.getEntry(desc);
            if (entry.grayImage == null && (image = this.getImage(desc)) != null) {
                entry.grayImage = new Image(null, image, 2);
            }
            return entry.grayImage;
        }

        Image getMissingImage() {
            if (this.missingImage == null) {
                this.missingImage = this.getImage(ImageDescriptor.getMissingImageDescriptor());
            }
            return this.missingImage;
        }

        void dispose() {
            this.entries.values().forEach(Entry::dispose);
            this.entries.clear();
        }

        private class Entry {
            protected Image image;
            protected Image grayImage;

            private Entry() {
            }

            void dispose() {
                if (this.image != null) {
                    this.image.dispose();
                    this.image = null;
                }
                if (this.grayImage != null) {
                    this.grayImage.dispose();
                    this.grayImage = null;
                }
            }
        }
    }
}

