/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IModelElementSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.ElementSynchronizerImpl;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.SeiMerger;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.WSMethodSynchronizer;
import org.eclipse.jst.ws.jaxws.utils.JaxWsUtils;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;

public class WsSynchronizer
extends ElementSynchronizerImpl {
    private final SeiMerger seiMerger = new SeiMerger(this, new WSMethodSynchronizer(this));

    public WsSynchronizer(IModelElementSynchronizer parent) {
        super(parent);
    }

    private IWebService obtainInstance(IWebServiceProject wsProject, String implName) {
        for (IWebService ws : wsProject.getWebServices()) {
            if (ws.getImplementation() == null || !ws.getImplementation().equals(implName)) continue;
            return ws;
        }
        IWebService newWs = DomFactory.eINSTANCE.createIWebService();
        this.util().setFeatureValue(newWs, 0, implName);
        this.util().addToCollectionFeature(wsProject, 0, newWs);
        return newWs;
    }

    public IWebService synchronizeWebService(IWebServiceProject wsProject, IAnnotation<IType> wsAnnotation, IAnnotationInspector inspector) throws JavaModelException {
        if (((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName() == null) {
            return null;
        }
        IWebService ws = this.obtainInstance(wsProject, ((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName());
        this.mergeWebService(ws, wsProject, wsAnnotation, inspector);
        this.resource().getSerializerFactory().adapt((Notifier)ws, IAnnotationSerializer.class);
        this.adaptToLocationInterface((EObject)ws, "javax.jws.WebService", (IAnnotation)wsAnnotation);
        return ws;
    }

    private void mergeWebService(IWebService toMerge, IWebServiceProject wsProject, IAnnotation<IType> wsAnnotation, IAnnotationInspector inspector) throws JavaModelException {
        String portName;
        String targetNs;
        String wsName;
        String string = wsName = wsAnnotation.getPropertyValue("serviceName") == null ? JaxWsUtils.getDefaultServiceName((String)((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName()) : wsAnnotation.getPropertyValue("serviceName");
        if (!wsName.equals(toMerge.getName())) {
            this.util().setFeatureValue(toMerge, 1, wsName);
        }
        if (!(targetNs = this.extractTargetNamespace(wsAnnotation)).equals(toMerge.getTargetNamespace())) {
            this.util().setFeatureValue(toMerge, 3, targetNs);
        }
        String string2 = portName = wsAnnotation.getPropertyValue("portName") == null ? JaxWsUtils.getDefaultPortName((String)((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName()) : wsAnnotation.getPropertyValue("portName");
        if (!portName.equals(toMerge.getPortName())) {
            toMerge.setPortName(portName);
        }
        toMerge.setWsdlLocation(wsAnnotation.getPropertyValue("wsdlLocation"));
        String newSeiImpl = wsAnnotation.getPropertyValue("endpointInterface");
        if (newSeiImpl == null) {
            this.mergeImplicitInterface(this.obtainImplicitInterfaceInstance(wsProject, toMerge, wsAnnotation), wsAnnotation, inspector);
        } else if (toMerge.getServiceEndpoint() == null || !toMerge.getServiceEndpoint().getImplementation().equals(newSeiImpl)) {
            this.serviceData().map(toMerge, newSeiImpl);
            this.resolveInterface(toMerge, wsProject, wsAnnotation.getPropertyValue("endpointInterface"));
        }
    }

    private IServiceEndpointInterface obtainImplicitInterfaceInstance(IWebServiceProject wsProject, IWebService ws, IAnnotation<IType> wsAnnotation) {
        if (ws.getServiceEndpoint() != null && ws.getServiceEndpoint().isImplicit()) {
            return ws.getServiceEndpoint();
        }
        IServiceEndpointInterface sei = DomFactory.eINSTANCE.createIServiceEndpointInterface();
        this.util().setFeatureValue(sei, 2, true);
        this.util().setFeatureValue(sei, 0, ((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName());
        this.util().setFeatureValue(ws, 2, sei);
        wsProject.getServiceEndpointInterfaces().add((Object)sei);
        return sei;
    }

    private void mergeImplicitInterface(IServiceEndpointInterface sei, IAnnotation<IType> wsAnnotation, IAnnotationInspector inspector) throws JavaModelException {
        this.seiMerger.merge(sei, wsAnnotation, inspector);
        this.resource().getSerializerFactory().adapt((Notifier)sei, IAnnotationSerializer.class);
    }

    private String extractTargetNamespace(IAnnotation<IType> wsAnnotation) {
        String targetNs = wsAnnotation.getPropertyValue("targetNamespace");
        if (targetNs == null) {
            return JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)((IType)wsAnnotation.getAppliedElement()).getPackageFragment().getElementName());
        }
        return targetNs;
    }

    private void resolveInterface(IWebService ws, IWebServiceProject preffered, String implementation) {
        IServiceEndpointInterface resolved = null;
        block0: for (IWebServiceProject prj : this.getDomBeingLoaded().getWebServiceProjects()) {
            for (IServiceEndpointInterface sei : prj.getServiceEndpointInterfaces()) {
                if (!sei.getImplementation().equals(implementation)) continue;
                resolved = sei;
                if (preffered.equals(prj)) continue block0;
                resolved = sei;
            }
        }
        this.util().setFeatureValue(ws, 2, resolved);
    }
}

