/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.vagrant.ui.commands.Messages;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.PackageVMWizard;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.VagrantException;
import org.eclipse.linuxtools.vagrant.core.VagrantService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class PackageVMCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        List<IVagrantVM> vms = CommandUtils.getSelectedContainers(selection);
        IVagrantVM vm = vms.iterator().next();
        PackageVMWizard wizard = new PackageVMWizard();
        boolean finished = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (finished) {
            this.performPackageVM(vm, wizard.getBoxName(), Paths.get(wizard.getBoxFolder(), new String[0]));
        }
        return null;
    }

    private void performPackageVM(final IVagrantVM vm, final String name, final Path dest) {
        Job packageVMJob = new Job(Messages.PackageVMCommandHandler_title){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(NLS.bind((String)Messages.PackageVMCommandHandler_msg, (Object)vm.id()), -1);
                IVagrantConnection connection = VagrantService.getInstance();
                try {
                    connection.packageVM(vm, name);
                    Path vmBox = Paths.get(vm.directory().getAbsolutePath(), name);
                    while (!vmBox.toFile().exists()) {
                        try {
                            Thread.sleep(1000L);
                            if (!monitor.isCanceled()) continue;
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    Files.move(Paths.get(vm.directory().getAbsolutePath(), name), dest.resolve(name), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException | InterruptedException | VagrantException e) {
                    try {
                        Files.delete(Paths.get(vm.directory().getAbsolutePath(), name));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PackageVMCommandHandler_failed, (String)NLS.bind((String)Messages.PackageVMCommandHandler_failed_desc, (Object[])new String[]{vm.id(), dest.toString(), name})));
                }
                finally {
                    connection.getVMs(true);
                }
                return Status.OK_STATUS;
            }
        };
        packageVMJob.setUser(true);
        packageVMJob.schedule();
    }
}

