/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.AbstractBugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.internal.bugzilla.core.service.BugzillaXmlRpcClient;

public class CustomTransitionManager
implements Serializable {
    private static final long serialVersionUID = 3340305752692674487L;
    private static final String DEFAULT_DUPLICATE_STATUS = "RESOLVED";
    public static final String DEFAULT_START_STATUS = "NEW";
    private final HashMap<String, List<AbstractBugzillaOperation>> operationMapByCurrentStatus = new HashMap();
    private final HashMap<String, List<AbstractBugzillaOperation>> operationMapByEndStatus = new HashMap();
    private final ArrayList<String> closedStatuses = new ArrayList();
    private boolean customNames = false;
    private boolean valid = false;
    private String filePath = "";
    private String duplicateStatus = "RESOLVED";
    private String startStatus = "NEW";

    public boolean parse(String filePath) throws CoreException {
        if (filePath == null || filePath.length() < 1) {
            this.setValid(false);
            return false;
        }
        if (filePath.equals(this.filePath)) {
            return false;
        }
        this.filePath = filePath;
        this.setValid(true);
        this.operationMapByCurrentStatus.clear();
        this.operationMapByEndStatus.clear();
        this.closedStatuses.clear();
        File file = new File(filePath);
        if (!file.exists() || !file.canRead()) {
            this.setValid(false);
            return this.isValid();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String s;
                boolean checkOptions = true;
                while ((s = br.readLine()) != null && this.isValid()) {
                    if (s.equals("<transitions>")) {
                        checkOptions = false;
                        this.defaultNames();
                        continue;
                    }
                    if (checkOptions) {
                        this.parseOptions(s);
                        continue;
                    }
                    this.parseTransitions(s);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.setValid(false);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", 1, "Error parsing transition description file.\n\n" + e.getMessage(), (Throwable)e));
        }
        return this.valid;
    }

    private void parseOptions(String s) throws IOException {
        String[] pieces = s.split("=");
        if (pieces.length != 2) {
            throw new IOException(Messages.CustomTransitionManager_InvalidBugzillaOption + s);
        }
        String name = pieces[0];
        String value = pieces[1];
        if (name.equals("CustomStatusNames")) {
            this.customNames = value.equals("true");
        } else if (name.equals("DuplicateStatus")) {
            this.duplicateStatus = value;
        } else if (name.equals("ClosedCustomStatus")) {
            this.closedStatuses.add(value);
        } else if (name.equals("StartStatus")) {
            this.startStatus = value;
        }
    }

    private void parseTransitions(String s) throws IOException {
        String[] pieces = s.split(":");
        if (pieces.length < 4) {
            throw new IOException(Messages.CustomTransitionManager_InvalidBugzillaTransition + s);
        }
        String status = pieces[1];
        Object[] endStatuses = pieces[3].split(",");
        this.parse(status, endStatuses);
    }

    private void defaultNames() {
        if (this.operationMapByEndStatus.size() == 0) {
            ArrayList<BugzillaOperation> list = new ArrayList<BugzillaOperation>();
            list.add(BugzillaOperation.none);
            this.operationMapByEndStatus.put("NONE", list);
            list = new ArrayList();
            list.add(BugzillaOperation.accept);
            this.operationMapByEndStatus.put("ASSIGNED", list);
            list = new ArrayList();
            list.add(BugzillaOperation.resolve);
            if (this.duplicateStatus.equals(DEFAULT_DUPLICATE_STATUS)) {
                list.add(BugzillaOperation.duplicate);
            }
            this.operationMapByEndStatus.put(DEFAULT_DUPLICATE_STATUS, list);
            list = new ArrayList();
            list.add(BugzillaOperation.reopen);
            this.operationMapByEndStatus.put("REOPENED", list);
            list = new ArrayList();
            list.add(BugzillaOperation.unconfirmed);
            this.operationMapByEndStatus.put("UNCONFIRMED", list);
            list = new ArrayList();
            list.add(BugzillaOperation.verify);
            if (this.duplicateStatus.equals("VERIFIED")) {
                list.add(BugzillaOperation.duplicate);
            }
            this.operationMapByEndStatus.put("VERIFIED", list);
            list = new ArrayList();
            list.add(BugzillaOperation.close);
            list.add(BugzillaOperation.close_with_resolution);
            if (this.duplicateStatus.equals("CLOSED")) {
                list.add(BugzillaOperation.duplicate);
            }
            this.operationMapByEndStatus.put("CLOSED", list);
            list = new ArrayList();
            list.add(BugzillaOperation.markNew);
            this.operationMapByEndStatus.put(DEFAULT_START_STATUS, list);
        }
    }

    public List<AbstractBugzillaOperation> getOperation(String id) {
        return this.operationMapByEndStatus.get(id);
    }

    public List<AbstractBugzillaOperation> getValidTransitions(String key) {
        return this.operationMapByCurrentStatus.get(key);
    }

    public void setValid(boolean val) {
        if (!val) {
            this.filePath = "";
        }
        this.valid = val;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getDuplicateStatus() {
        if (this.duplicateStatus == null || this.duplicateStatus.length() == 0) {
            this.duplicateStatus = DEFAULT_DUPLICATE_STATUS;
        }
        return this.duplicateStatus;
    }

    public String getStartStatus() {
        if (this.startStatus == null || this.startStatus.length() == 0) {
            this.startStatus = DEFAULT_START_STATUS;
        }
        return this.startStatus;
    }

    private void addTransition(String start, String endStatus) {
        if (!this.customNames && start.equals("REOPENED") && (endStatus.equals("UNCONFIRMED") || endStatus.equals("REOPENED"))) {
            return;
        }
        List<AbstractBugzillaOperation> list = this.operationMapByCurrentStatus.get(start);
        if (list == null) {
            list = new ArrayList<AbstractBugzillaOperation>();
        }
        list.addAll((Collection<AbstractBugzillaOperation>)this.operationMapByEndStatus.get(endStatus));
        this.operationMapByCurrentStatus.put(start, list);
    }

    /*
     * WARNING - void declaration
     */
    private void parse(String start, Object[] transitions) {
        this.addNewStatus(start);
        Object[] objectArray = transitions;
        int n = transitions.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Object object = o;
            if (object instanceof HashMap) {
                void tran;
                HashMap cfr_ignored_0 = (HashMap)object;
                HashMap cfr_ignored_1 = (HashMap)object;
                endStatus = (String)tran.get("name");
                this.addNewStatus(endStatus);
                if (!endStatus.equals(start)) {
                    this.addTransition(start, endStatus);
                }
            } else {
                Object object2 = o;
                if (object2 instanceof String) {
                    String cfr_ignored_2 = (String)object2;
                    String cfr_ignored_3 = (String)object2;
                    this.addNewStatus(endStatus);
                    if (!endStatus.equals(start)) {
                        this.addTransition(start, endStatus);
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void parse(IProgressMonitor monitor, BugzillaXmlRpcClient xmlClient) throws CoreException {
        this.filePath = "";
        this.operationMapByCurrentStatus.clear();
        this.operationMapByEndStatus.clear();
        this.closedStatuses.clear();
        this.defaultNames();
        this.setValid(false);
        this.customNames = true;
        try {
            if (xmlClient.getUserID() == -1) {
                xmlClient.login(monitor);
            }
            String[] fields = new String[]{"bug_status"};
            Object[] objectArray = xmlClient.getFieldsWithNames(monitor, fields);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object raw = objectArray[n2];
                if (raw instanceof HashMap) {
                    Object[] values = (Object[])((HashMap)raw).get("values");
                    if (values != null) {
                        Object[] objectArray2 = values;
                        int n3 = values.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object status = objectArray2[n4];
                            Object object = status;
                            if (object instanceof HashMap) {
                                void map;
                                HashMap cfr_ignored_0 = (HashMap)object;
                                HashMap cfr_ignored_1 = (HashMap)object;
                                String start = (String)map.get("name");
                                Object is_open = map.get("is_open");
                                if (is_open.toString().equals("false")) {
                                    this.closedStatuses.add(start);
                                }
                                this.parse(start, (Object[])map.get("can_change_to"));
                            }
                            ++n4;
                        }
                    }
                } else {
                    throw new XmlRpcException(Messages.CustomTransitionManager_UnexpectedResponse);
                }
                ++n2;
            }
            if (this.operationMapByCurrentStatus.size() == 0) {
                throw new XmlRpcException(Messages.CustomTransitionManager_UnexpectedResponse);
            }
            this.setValid(true);
        }
        catch (XmlRpcException e) {
            this.setValid(false);
            String message = e.linkedException == null ? e.getMessage() : e.getMessage() + ">" + e.linkedException.getMessage();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", 1, "Error parsing xmlrpc response.\n\n" + message, (Throwable)e));
        }
    }

    private void addNewStatus(String status) {
        List<AbstractBugzillaOperation> list = this.operationMapByEndStatus.get(status);
        if (list != null) {
            return;
        }
        list = new ArrayList<AbstractBugzillaOperation>();
        if (!this.closedStatuses.contains(status)) {
            list.add(new BugzillaOperation("Set as " + status));
        } else {
            list.add(new BugzillaOperation("Set as " + status, "resolution", "singleSelect", status));
        }
        this.operationMapByEndStatus.put(status, list);
    }

    public ArrayList<String> getClosedStatuses() {
        return this.closedStatuses;
    }
}

