/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.builds.ui.view.Messages;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenWithBrowserAction
extends BaseSelectionListenerAction {
    public OpenWithBrowserAction() {
        super(Messages.OpenWithBrowserAction_openWithBrowser);
        this.setToolTipText(Messages.OpenWithBrowserAction_openWithBrowserToolTip);
        this.setImageDescriptor(CommonImages.BROWSER_OPEN_TASK);
    }

    public void run() {
        List<URI> uris = this.getUris(this.getStructuredSelection());
        for (URI uri : uris) {
            BrowserUtil.openUrl((String)uri.toString());
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.getUris(selection).size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public List<URI> getUris(IStructuredSelection selection) {
        ArrayList<URI> uris = new ArrayList<URI>(selection.size());
        for (Object object : selection.toList()) {
            void element;
            Object e = object;
            if (!(e instanceof IBuildElement)) continue;
            IBuildElement cfr_ignored_0 = (IBuildElement)e;
            IBuildElement cfr_ignored_1 = (IBuildElement)e;
            if (element.getUrl() == null) continue;
            try {
                uris.add(new URI(element.getUrl()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uris;
    }
}

