/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskRepositoryElement;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

public class TaskLabelDecorator
implements ILightweightLabelDecorator {
    /*
     * WARNING - void declaration
     */
    public void decorate(Object element, IDecoration decoration) {
        Object object;
        ImageDescriptor priorityOverlay = this.getPriorityImageDescriptor(element);
        if (priorityOverlay != null) {
            decoration.addOverlay(priorityOverlay, 2);
        }
        if ((object = element) instanceof ITask) {
            void task;
            ITask iTask = (ITask)object;
            ITask cfr_ignored_0 = (ITask)object;
            if (!task.isCompleted() && (TasksUiPlugin.getTaskActivityManager().isDueToday((ITask)task) || TasksUiPlugin.getTaskActivityManager().isOverdue((ITask)task))) {
                decoration.addOverlay(CommonImages.OVERLAY_DATE_OVERDUE, 1);
            } else if (!task.isCompleted() && task.getDueDate() != null) {
                decoration.addOverlay(CommonImages.OVERLAY_DATE_DUE, 1);
            }
            if (this.hasNotes((ITask)task)) {
                decoration.addOverlay(TasksUiImages.NOTES, 3);
            }
        } else {
            ImageDescriptor overlay;
            Object object2 = element;
            if (object2 instanceof ITaskRepositoryElement) {
                void repositoryElement;
                ITaskRepositoryElement iTaskRepositoryElement = (ITaskRepositoryElement)object2;
                ITaskRepositoryElement cfr_ignored_1 = (ITaskRepositoryElement)object2;
                String repositoryUrl = repositoryElement.getRepositoryUrl();
                TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(repositoryElement.getConnectorKind(), repositoryUrl);
                if (taskRepository != null) {
                    decoration.addSuffix("   [" + taskRepository.getRepositoryLabel() + "]");
                }
            } else if (element instanceof TaskRepository && (overlay = TasksUiPlugin.getDefault().getBrandManager().getOverlayIcon((TaskRepository)element)) != null) {
                decoration.addOverlay(overlay, 3);
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    /*
     * WARNING - void declaration
     */
    private ImageDescriptor getPriorityImageDescriptor(Object element) {
        Object object = element;
        if (object instanceof ITask) {
            ITask iTask = (ITask)object;
            ITask cfr_ignored_0 = (ITask)object;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(((ITask)element).getConnectorKind());
            if (connectorUi != null) {
                void repositoryTask;
                return connectorUi.getTaskPriorityOverlay((ITask)repositoryTask);
            }
        }
        if (element instanceof ITask) {
            return TasksUiInternal.getPriorityImage((ITask)element);
        }
        return null;
    }

    private boolean hasNotes(ITask task) {
        if (task instanceof AbstractTask) {
            return !((AbstractTask)task).getNotes().isEmpty();
        }
        return false;
    }
}

