/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteCategoryDefinitionAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.IFormPage;

class CategoryLabelProvider
extends LabelProvider {
    private final PDELabelProvider fSharedProvider;
    private Image fSiteFeatureImage = PDEPluginImages.DESC_FEATURE_OBJ.createImage();
    private Image fMissingSiteFeatureImage = PDEPluginImages.DESC_NOREF_FEATURE_OBJ.createImage();
    private final Image fSiteBundleImage = PDEPluginImages.DESC_PLUGIN_OBJ.createImage();
    private final Image fMissingSiteBundleImage = PDEPluginImages.DESC_PLUGIN_DIS_OBJ.createImage();
    private Image fPageImage;
    private Image fCatDefImage = PDEPluginImages.DESC_CATEGORY_OBJ.createImage();

    public CategoryLabelProvider() {
        this.fPageImage = PDEPluginImages.DESC_PAGE_OBJ.createImage();
        this.fSharedProvider = PDEPlugin.getDefault().getLabelProvider();
        this.fSharedProvider.connect((Object)this);
    }

    public Image getImage(Object element) {
        if (element instanceof ISiteCategoryDefinition) {
            return this.fCatDefImage;
        }
        if (element instanceof SiteCategoryDefinitionAdapter) {
            return this.getImage(((SiteCategoryDefinitionAdapter)element).category);
        }
        if (element instanceof SiteFeatureAdapter) {
            if (PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(((SiteFeatureAdapter)element).feature.getId(), ((SiteFeatureAdapter)element).feature.getVersion()) == null) {
                return this.fMissingSiteFeatureImage;
            }
            return this.fSiteFeatureImage;
        }
        if (element instanceof SiteBundleAdapter) {
            ISiteBundle bundle = ((SiteBundleAdapter)element).bundle;
            if (PluginRegistry.findModel((String)bundle.getId(), (String)bundle.getVersion(), (int)2, null) == null) {
                return this.fMissingSiteBundleImage;
            }
            return this.fSiteBundleImage;
        }
        if (element instanceof IFormPage) {
            return this.fPageImage;
        }
        return this.fSharedProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ISiteCategoryDefinition) {
            return ((ISiteCategoryDefinition)element).getLabel();
        }
        if (element instanceof SiteCategoryDefinitionAdapter) {
            return this.getText(((SiteCategoryDefinitionAdapter)element).category);
        }
        if (element instanceof SiteFeatureAdapter) {
            ISiteFeature feature = ((SiteFeatureAdapter)element).feature;
            return this.fSharedProvider.getObjectText(feature);
        }
        if (element instanceof SiteBundleAdapter) {
            ISiteBundle bundle = ((SiteBundleAdapter)element).bundle;
            return this.fSharedProvider.getObjectText(bundle);
        }
        if (element instanceof IFormPage) {
            return ((IFormPage)element).getTitle();
        }
        return this.fSharedProvider.getText(element);
    }

    public void dispose() {
        this.fSharedProvider.disconnect((Object)this);
        if (this.fCatDefImage != null && !this.fCatDefImage.isDisposed()) {
            this.fCatDefImage.dispose();
            this.fCatDefImage = null;
        }
        if (this.fSiteFeatureImage != null && !this.fSiteFeatureImage.isDisposed()) {
            this.fSiteFeatureImage.dispose();
            this.fSiteFeatureImage = null;
        }
        if (this.fMissingSiteFeatureImage != null && !this.fMissingSiteFeatureImage.isDisposed()) {
            this.fMissingSiteFeatureImage.dispose();
            this.fMissingSiteFeatureImage = null;
        }
        if (this.fPageImage != null && !this.fPageImage.isDisposed()) {
            this.fPageImage.dispose();
            this.fPageImage = null;
        }
        super.dispose();
    }
}

