/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ui.internal;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.core.internal.TipManager;
import org.eclipse.tips.ui.internal.DefaultTipManager;
import org.eclipse.tips.ui.internal.Messages;
import org.eclipse.tips.ui.internal.ProviderSelectionListener;
import org.eclipse.tips.ui.internal.util.ImageUtil;

public class Slider
extends Composite {
    private static final int RESIZE_RELOAD_DELAY = 100;
    private final Composite fScroller;
    private TipProvider fSelectedProvider;
    private final int fSpacing = 5;
    private int fSliderIndex = 0;
    private final List<ProviderSelectionListener> fListeners = new ArrayList<ProviderSelectionListener>();
    private TipManager fTipManager;
    private final Button fLeftButton;
    private final Button fRightButton;
    private Composite fSelectedProviderButton;
    private final HashMap<String, Image> fProviderImageCache = new HashMap();
    private int fIconSize = 48;
    private PropertyChangeListener fPropertyChangeListener;
    private final int fLeftRightButtonWidth;
    private long fLastResizeEventTime;
    private boolean fResizeRequestPending;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);

    public Slider(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.fLeftButton = new Button((Composite)this, 0x800000);
        this.fLeftRightButtonWidth = this.fIconSize / 2 + 8;
        this.setLeftRightButtonGridData(this.fLeftButton, this.fLeftRightButtonWidth);
        this.fLeftButton.setImage(DefaultTipManager.getImage("icons/" + this.fIconSize + "/aleft.png", this.resourceManager));
        this.fLeftButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.scrollLeft()));
        this.fScroller = new Composite((Composite)this, 0x20000000);
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.heightHint = this.fIconSize + 4;
        this.fScroller.setLayoutData((Object)layoutData);
        this.fRightButton = new Button((Composite)this, 0x800000);
        this.setLeftRightButtonGridData(this.fRightButton, this.fLeftRightButtonWidth);
        this.fRightButton.setImage(DefaultTipManager.getImage("icons/" + this.fIconSize + "/aright.png", this.resourceManager));
        this.fRightButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.scrollRight()));
        this.setupDisposeListener();
        this.setupProviderListener();
        this.setupResizeListener();
    }

    private void setupResizeListener() {
        this.addListener(11, event -> {
            this.fLastResizeEventTime = System.currentTimeMillis();
            if (!this.fResizeRequestPending) {
                this.fResizeRequestPending = true;
                this.submitResizeExecution();
            }
        });
    }

    private void submitResizeExecution() {
        this.getDisplay().timerExec(50, () -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.fLastResizeEventTime > 100L) {
                this.load();
                this.fResizeRequestPending = false;
            }
            if (this.fResizeRequestPending) {
                this.submitResizeExecution();
            }
        });
    }

    private void setLeftRightButtonGridData(Button pButton, int pWidth) {
        GridData gridData = new GridData(4, 4, false, false, 1, 1);
        gridData.widthHint = pWidth;
        gridData.heightHint = this.fIconSize;
        pButton.setLayoutData((Object)gridData);
    }

    private void setupDisposeListener() {
        this.addListener(12, event -> {
            this.fTipManager.getChangeSupport().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fProviderImageCache.values().forEach(img -> {
                if (!img.isDisposed()) {
                    img.dispose();
                }
            });
        });
    }

    private void setupProviderListener() {
        this.fPropertyChangeListener = provider -> {
            if (!this.isDisposed()) {
                this.getDisplay().asyncExec(this::load);
            }
        };
    }

    public void load() {
        if (this.isDisposed() || this.fScroller.isDisposed() || this.fTipManager == null) {
            return;
        }
        Arrays.stream(this.fScroller.getChildren()).filter(control -> !control.isDisposed()).forEach(Widget::dispose);
        List providers = this.fTipManager.getProviders();
        int spaceCount = Math.floorDiv(this.fScroller.getBounds().width, this.fIconSize + 5);
        int providerCount = providers.size();
        if (this.fSliderIndex > 0 && spaceCount >= providerCount) {
            this.fSliderIndex = 0;
        }
        if (spaceCount >= providerCount) {
            if (this.fRightButton.isEnabled()) {
                this.enableLeftRightButtons(false);
            }
        } else if (!this.fRightButton.isEnabled()) {
            this.enableLeftRightButtons(true);
        }
        int emptyPixelsLeft = Math.floorMod(this.fScroller.getBounds().width, this.fIconSize + 5);
        int newSpacing = 5 + emptyPixelsLeft / (spaceCount + 1);
        int i = 0;
        while (i < Math.min(providerCount - this.fSliderIndex, spaceCount)) {
            TipProvider provider = (TipProvider)providers.get(i + this.fSliderIndex);
            if (this.fSelectedProvider == null && !provider.getTips().isEmpty()) {
                this.fSelectedProvider = provider;
                this.notifyListeners(this.fSelectedProvider);
            }
            this.createProviderButton((TipProvider)providers.get(i + this.fSliderIndex), newSpacing, i);
            ++i;
        }
        this.setBackground(this.fScroller.getBackground());
    }

    private void enableLeftRightButtons(boolean enable) {
        this.fRightButton.setEnabled(enable);
        this.fRightButton.setVisible(enable);
        this.setLeftRightButtonGridData(this.fRightButton, enable ? this.fLeftRightButtonWidth : 0);
        this.fLeftButton.setEnabled(enable);
        this.fLeftButton.setVisible(enable);
        this.setLeftRightButtonGridData(this.fLeftButton, enable ? this.fLeftRightButtonWidth : 0);
        this.fRightButton.requestLayout();
        this.fLeftButton.requestLayout();
    }

    private Composite createProviderButton(TipProvider provider, int spacing, int index) {
        Composite button = new Composite(this.fScroller, 0x20000000);
        button.setToolTipText(provider.getDescription());
        button.setBackground(this.fScroller.getBackground());
        button.setSize(this.fIconSize + 4, this.fIconSize + 4);
        button.setLocation(index * (this.fIconSize + spacing) + spacing - 5, 2);
        button.addPaintListener(e -> {
            if (this.fSelectedProvider == provider) {
                this.fSelectedProviderButton = button;
            }
            this.paintButton(e.gc, button, provider);
        });
        button.addListener(6, event -> button.redraw());
        button.addListener(7, event -> button.redraw());
        button.addListener(4, event -> {
            if (this.fSelectedProvider == provider) {
                return;
            }
            this.fSelectedProvider = provider;
            if (this.fSelectedProviderButton != null && !this.fSelectedProviderButton.isDisposed()) {
                this.fSelectedProviderButton.redraw();
            }
            this.fSelectedProviderButton = button;
            this.fSelectedProviderButton.redraw();
            this.notifyListeners(provider);
        });
        if (this.fSelectedProvider == provider) {
            this.fSelectedProviderButton = button;
        }
        return button;
    }

    public void updateButton() {
        if (this.fSelectedProviderButton != null && !this.fSelectedProviderButton.isDisposed()) {
            this.getDisplay().asyncExec(() -> this.fSelectedProviderButton.redraw());
        }
    }

    public void updateButtons() {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(() -> {
                if (!this.fScroller.isDisposed()) {
                    Control[] controlArray = this.fScroller.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Composite && !control.isDisposed()) {
                            control.redraw();
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    public Slider setTipManager(TipManager tipManager) {
        this.fTipManager = tipManager;
        this.fTipManager.getChangeSupport().addPropertyChangeListener("PR", this.fPropertyChangeListener);
        this.fIconSize = 48;
        this.load();
        return this;
    }

    private void notifyListeners(TipProvider provider) {
        this.fListeners.forEach(listener -> {
            try {
                listener.selected(provider);
            }
            catch (Exception e) {
                this.fTipManager.log(LogUtil.error(((Object)((Object)this)).getClass(), (Throwable)e));
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.fIconSize * 3, this.fIconSize + 5 + 5);
    }

    protected void scrollRight() {
        if (this.fSliderIndex < this.fTipManager.getProviders().size() - 1) {
            ++this.fSliderIndex;
            this.load();
        }
    }

    protected void scrollLeft() {
        if (this.fSliderIndex > 0) {
            --this.fSliderIndex;
            this.load();
        }
    }

    public TipProvider getTipProvider() {
        return this.fSelectedProvider;
    }

    public Slider setTipProvider(TipProvider provider) {
        this.fSelectedProvider = provider;
        this.updateButtons();
        return this;
    }

    public Slider addTipProviderListener(ProviderSelectionListener listener) {
        this.fListeners.add(listener);
        return this;
    }

    public Slider removeTipProviderListener(ProviderSelectionListener listener) {
        this.fListeners.remove(listener);
        return this;
    }

    private void paintButton(GC gc, Composite providerButton, TipProvider provider) {
        gc.setAdvanced(true);
        if (!gc.getAdvanced()) {
            throw new RuntimeException(Messages.Slider_13);
        }
        if (provider.equals(this.fSelectedProvider)) {
            gc.setForeground(this.getDisplay().getSystemColor(27));
            gc.setBackground(this.getDisplay().getSystemColor(26));
            gc.drawRectangle(0, 0, this.fIconSize + 3, this.fIconSize + 3);
        } else {
            boolean mouseIn;
            gc.setForeground(this.fLeftButton.getForeground());
            gc.setBackground(this.fLeftButton.getBackground());
            boolean bl = mouseIn = this.getDisplay().getCursorControl() == providerButton;
            if (mouseIn) {
                gc.drawRectangle(0, 0, this.fIconSize + 3, this.fIconSize + 3);
            } else {
                gc.setBackground(this.fScroller.getBackground());
            }
        }
        gc.fillRectangle(2, 2, this.fIconSize, this.fIconSize);
        Image overlay = this.getUnreadOverlay(provider);
        gc.drawImage(overlay, 2, 2);
    }

    private TipImage selectProviderImage(TipProvider provider) {
        return provider.getImage();
    }

    private Image getProviderImage(TipProvider provider, TipImage image) {
        return this.fProviderImageCache.computeIfAbsent(provider.getID(), id -> {
            try {
                return new Image((Device)this.getDisplay(), ImageUtil.decodeToImage(image.getBase64Image()));
            }
            catch (Exception e) {
                this.fTipManager.log(LogUtil.error(((Object)((Object)this)).getClass(), (Throwable)e));
                return null;
            }
        });
    }

    private Image getUnreadOverlay(TipProvider provider) {
        Image providerImage = this.getProviderImage(provider, this.selectProviderImage(provider));
        if (provider.getTips().isEmpty()) {
            return providerImage;
        }
        int tipCount = provider.getTips().size();
        int backgroundColor = this.fTipManager.mustServeReadTips() ? 6 : 3;
        CircleNumberDescriptor numberOverlays = new CircleNumberDescriptor(tipCount, backgroundColor);
        DecorationOverlayIcon overlay = new DecorationOverlayIcon(providerImage, (ImageDescriptor)numberOverlays, 1);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)overlay);
    }

    private static Point getTextSize(String text, Font font) {
        GC gc2 = new GC((Drawable)font.getDevice());
        gc2.setFont(font);
        Point textExtent = gc2.textExtent(text);
        gc2.dispose();
        return textExtent;
    }

    private static final class CircleNumberDescriptor
    extends ImageDescriptor {
        private final int number;
        private final int backgroundColor;

        CircleNumberDescriptor(int number, int backgroundColor) {
            this.number = number;
            this.backgroundColor = backgroundColor;
        }

        public ImageData getImageData(int zoom) {
            Display display = Display.getCurrent();
            Font font = display.getSystemFont();
            Font boldFont = FontDescriptor.createFrom((Font)font).withStyle(1).createFont((Device)display);
            String text = Integer.toString(this.number);
            Point textExtent = Slider.getTextSize(text, boldFont);
            int imageHeight = textExtent.y + 5;
            int imageWidth = this.number > 9 ? textExtent.x + 8 : imageHeight;
            PaletteData palette = new PaletteData(new RGB[]{new RGB(255, 255, 255)});
            ImageData transparentBackground = new ImageData(imageWidth, imageHeight, 32, palette);
            transparentBackground.transparentPixel = transparentBackground.getPixel(0, 0);
            Image image = new Image((Device)display, transparentBackground);
            GC gc = new GC((Drawable)image);
            gc.setAdvanced(true);
            gc.setBackground(display.getSystemColor(this.backgroundColor));
            gc.setForeground(display.getSystemColor(1));
            gc.setFont(boldFont);
            gc.setTextAntialias(1);
            gc.fillOval(0, 0, imageWidth, imageHeight);
            int textX = this.number > 9 ? 4 : (imageHeight - textExtent.x + 1) / 2;
            gc.drawText(text, textX, 2, true);
            gc.dispose();
            boldFont.dispose();
            ImageData data = image.getImageData(zoom);
            image.dispose();
            return data;
        }

        public int hashCode() {
            return Objects.hash(this.number, this.backgroundColor);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CircleNumberDescriptor) {
                CircleNumberDescriptor other = (CircleNumberDescriptor)((Object)obj);
                if (this.number == other.number && this.backgroundColor == other.backgroundColor) {
                    return true;
                }
            }
            return false;
        }
    }
}

