/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.databinding.xsd.component.Component;
import org.eclipse.wb.core.databinding.xsd.component.ConfigurablePropertyType;
import org.eclipse.wb.core.databinding.xsd.component.ContextFactory;
import org.eclipse.wb.core.databinding.xsd.component.Creation;
import org.eclipse.wb.core.databinding.xsd.component.ExposingRulesType;
import org.eclipse.wb.core.databinding.xsd.component.MethodParameter;
import org.eclipse.wb.core.databinding.xsd.component.MethodsOrderType;
import org.eclipse.wb.core.databinding.xsd.component.MorphingType;
import org.eclipse.wb.core.databinding.xsd.component.ParameterBaseType;
import org.eclipse.wb.core.databinding.xsd.component.PropertyConfiguration;
import org.eclipse.wb.core.databinding.xsd.component.PropertyConfigurationElements;
import org.eclipse.wb.core.databinding.xsd.component.PropertyEditor;
import org.eclipse.wb.core.databinding.xsd.component.TagType;
import org.eclipse.wb.core.databinding.xsd.component.TypeParameterType;
import org.eclipse.wb.core.databinding.xsd.component.TypeParametersType;
import org.eclipse.wb.internal.core.model.description.AbstractInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescriptionKey;
import org.eclipse.wb.internal.core.model.description.ConfigurablePropertyDescription;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.IDescriptionProcessor;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.model.description.helpers.EditorStateLoadingContext;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.internal.AbstractConfigurableDescription;
import org.eclipse.wb.internal.core.model.description.internal.PropertyEditorDescription;
import org.eclipse.wb.internal.core.model.description.resource.ClassResourceInfo;
import org.eclipse.wb.internal.core.model.description.resource.ResourceInfo;
import org.eclipse.wb.internal.core.model.description.rules.ConfigurableObjectListParameterRule;
import org.eclipse.wb.internal.core.model.description.rules.ConfigurableObjectParameterRule;
import org.eclipse.wb.internal.core.model.description.rules.ExposingRulesRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodOrderDefaultRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodOrderMethodRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodOrderMethodsRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodPropertyRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodsOperationRule;
import org.eclipse.wb.internal.core.model.description.rules.ModelClassRule;
import org.eclipse.wb.internal.core.model.description.rules.MorphingNoInheritRule;
import org.eclipse.wb.internal.core.model.description.rules.MorphingTargetRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyCategoryRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyDefaultRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyGetterRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyTagRule;
import org.eclipse.wb.internal.core.model.description.rules.PublicFieldPropertiesRule;
import org.eclipse.wb.internal.core.model.description.rules.SetClassPropertyRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesAdvancedRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesHiddenRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesNoDefaultValueRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesNormalRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesPreferredRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertyTagRule;
import org.eclipse.wb.internal.core.model.description.rules.ToolkitRule;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstParser;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.core.utils.reflect.IntrospectionHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.osgi.framework.Bundle;

public final class ComponentDescriptionHelper {
    private static final ClassMap<ComponentDescription> m_getDescription_Class = ClassMap.create();

    private ComponentDescriptionHelper() {
    }

    public static ComponentDescription getDescription(AstEditor editor, FactoryMethodDescription factoryMethodDescription) throws Exception {
        Class<?> componentClass = factoryMethodDescription.getReturnClass();
        String signature = factoryMethodDescription.getSignature();
        String signatureUnix = StringUtils.replaceChars((String)signature, (String)"(,)", (String)"___");
        Class<?> declaringClass = factoryMethodDescription.getDeclaringClass();
        ComponentDescriptionKey declaringKey = new ComponentDescriptionKey(declaringClass);
        ComponentDescriptionKey key = new ComponentDescriptionKey(componentClass, declaringKey, signatureUnix);
        return ComponentDescriptionHelper.getKeySpecificDescription(editor, componentClass, key);
    }

    public static ComponentDescription getDescription(AstEditor editor, ComponentDescription hostDescription, Method method) throws Exception {
        Class<?> componentClass = method.getReturnType();
        String suffix = method.getName();
        ComponentDescriptionKey key = new ComponentDescriptionKey(componentClass, hostDescription.getKey(), suffix);
        return ComponentDescriptionHelper.getKeySpecificDescription(editor, componentClass, key);
    }

    public static ComponentDescription getDescription(AstEditor editor, ComponentDescription hostDescription, SingleVariableDeclaration parameter) throws Exception {
        String parameterClassName = AstNodeUtils.getFullyQualifiedName(parameter.getType(), true);
        Class<?> parameterClass = EditorState.get(editor).getEditorLoader().loadClass(parameterClassName);
        MethodDeclaration methodDeclaration = (MethodDeclaration)parameter.getParent();
        String signature = AstNodeUtils.getMethodSignature(methodDeclaration);
        String signatureUnix = StringUtils.replaceChars((String)signature, (String)"(,)", (String)"___");
        int parameterIndex = DomGenerics.parameters(methodDeclaration).indexOf(parameter);
        String suffix = signatureUnix + "." + parameterIndex;
        ArrayList<ClassResourceInfo> additionalDescriptions = new ArrayList<ClassResourceInfo>();
        Class<?> hostComponentClass = hostDescription.getComponentClass();
        List types = ReflectionUtils.getSuperHierarchy(hostComponentClass);
        Collections.reverse(types);
        for (Class type : types) {
            String descriptionPath;
            ComponentDescriptionKey hostKey = new ComponentDescriptionKey(type);
            EditorState state = EditorState.get(editor);
            ILoadingContext context = EditorStateLoadingContext.get(state);
            ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo(context, type, descriptionPath = hostKey.getName() + "." + suffix + ".wbp-component.xml");
            if (resourceInfo == null) continue;
            ClassResourceInfo descriptionInfo = new ClassResourceInfo(parameterClass, resourceInfo);
            additionalDescriptions.add(descriptionInfo);
        }
        if (additionalDescriptions.isEmpty()) {
            return ComponentDescriptionHelper.getDescription(editor, parameterClass);
        }
        ComponentDescriptionKey key = new ComponentDescriptionKey(parameterClass, hostDescription.getKey(), suffix);
        return ComponentDescriptionHelper.getDescription0(editor, key, additionalDescriptions);
    }

    public static ComponentDescription getDescription(AstEditor editor, Class<?> componentClass) throws Exception {
        ComponentDescription description = (ComponentDescription)m_getDescription_Class.get(componentClass);
        if (description == null) {
            description = ComponentDescriptionHelper.getDescription0(editor, componentClass);
            m_getDescription_Class.put(componentClass, (Object)description);
        }
        return description;
    }

    private static ComponentDescription getDescription0(AstEditor editor, Class<?> componentClass) throws Exception {
        String innerPart;
        String componentClassName;
        int index;
        while ((index = (componentClassName = componentClass.getName()).indexOf(36)) != -1 && componentClass.getInterfaces().length == 0 && StringUtils.isNumeric((CharSequence)(innerPart = componentClassName.substring(index + 1)))) {
            componentClass = componentClass.getSuperclass();
        }
        ComponentDescriptionKey key = new ComponentDescriptionKey(componentClass);
        return ComponentDescriptionHelper.getDescription0(editor, key, Collections.emptyList());
    }

    public static ComponentDescription getDescription(AstEditor editor, String componentClassName) throws Exception {
        Class<?> componentClass = EditorState.get(editor).getEditorLoader().loadClass(componentClassName);
        return ComponentDescriptionHelper.getDescription(editor, componentClass);
    }

    private static ComponentDescription getKeySpecificDescription(AstEditor editor, Class<?> componentClass, ComponentDescriptionKey key) throws Exception {
        String descriptionPath;
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo(context, componentClass, descriptionPath = key.getName() + ".wbp-component.xml");
        if (resourceInfo == null) {
            return ComponentDescriptionHelper.getDescription(editor, componentClass);
        }
        ClassResourceInfo descriptionInfo = new ClassResourceInfo(componentClass, resourceInfo);
        return ComponentDescriptionHelper.getDescription0(editor, key, List.of(descriptionInfo));
    }

    private static ComponentDescription getDescription0(AstEditor editor, ComponentDescriptionKey key, List<ClassResourceInfo> additionalDescriptionInfos) throws Exception {
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        Class<?> componentClass = key.getComponentClass();
        try {
            ComponentDescription componentDescription = new ComponentDescription(key);
            ComponentDescriptionHelper.addConstructors(editor.getJavaProject(), componentDescription);
            componentDescription.setBeanInfo(ReflectionUtils.getBeanInfo(componentClass));
            componentDescription.setBeanDescriptor(new IntrospectionHelper(componentClass).getBeanDescriptor());
            LinkedList<ClassResourceInfo> descriptionInfos = new LinkedList<ClassResourceInfo>();
            DescriptionHelper.addDescriptionResources(descriptionInfos, context, componentClass);
            Assert.isTrueException((!descriptionInfos.isEmpty() ? 1 : 0) != 0, (int)500, (Object[])new Object[]{componentClass.getName()});
            descriptionInfos.addAll(additionalDescriptionInfos);
            for (ClassResourceInfo descriptionInfo : descriptionInfos) {
                ResourceInfo resourceInfo = descriptionInfo.resource;
                componentDescription.setCurrentClass(descriptionInfo.clazz);
                JAXBContext jaxbContext = ContextFactory.createContext();
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                Component component = (Component)jaxbUnmarshaller.unmarshal(resourceInfo.getURL());
                ComponentDescriptionHelper.process(componentDescription, component, editor);
                if (descriptionInfo.clazz == componentClass) continue;
                componentDescription.clearCreations();
                componentDescription.setDescription(null);
            }
            if (componentDescription.getToolkit() == null) {
                int i = descriptionInfos.size() - 1;
                while (i >= 0) {
                    ClassResourceInfo descriptionInfo = descriptionInfos.get(i);
                    ToolkitDescription toolkit = descriptionInfo.resource.getToolkit();
                    if (toolkit != null) {
                        componentDescription.setToolkit(toolkit);
                        break;
                    }
                    --i;
                }
                Assert.isTrueException((componentDescription.getToolkit() != null ? 1 : 0) != 0, (int)503, (Object[])new Object[]{componentClass.getName()});
            }
            ComponentDescriptionHelper.setIcon(context, componentDescription, componentClass);
            ComponentDescriptionHelper.configureDefaultCreation(componentDescription);
            Assert.isNotNull(componentDescription.getModelClass());
            componentDescription.joinProperties();
            if (key.isPureComponent() && !"true".equals(componentDescription.getParameter("dontCacheDescription")) && ComponentDescriptionHelper.shouldCacheDescriptions_inPackage(descriptionInfos.getLast(), componentClass)) {
                componentDescription.setCached(true);
            }
            if (ComponentDescriptionHelper.shouldCachePresentation(descriptionInfos.getLast(), componentClass)) {
                componentDescription.setPresentationCached(true);
            }
            for (IDescriptionProcessor processor : ComponentDescriptionHelper.getDescriptionProcessors()) {
                processor.process(editor, componentDescription);
            }
            return componentDescription;
        }
        catch (Exception e) {
            throw new DesignerException(502, (Throwable)e, new String[]{componentClass.getName()});
        }
    }

    private static void configureDefaultCreation(ComponentDescription componentDescription) {
        Class<?> componentClass = componentDescription.getComponentClass();
        Constructor constructor = ReflectionUtils.getShortestConstructor(componentClass);
        if (constructor == null) {
            return;
        }
        String source = ComponentDescriptionHelper.getDefaultConstructorInvocation(constructor);
        CreationDescription creationDefault = new CreationDescription(componentDescription, null, null);
        creationDefault.setSource(source);
        componentDescription.setCreationDefault(creationDefault);
    }

    public static String getDefaultConstructorInvocation(Constructor<?> constructor) {
        Class<?> componentClass = constructor.getDeclaringClass();
        String componentClassName = ReflectionUtils.getCanonicalName(componentClass);
        StringBuilder buffer = new StringBuilder();
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameter = classArray[n2];
            String parameterName = ReflectionUtils.getCanonicalName(parameter);
            buffer.append(AstParser.getDefaultValue(parameterName));
            buffer.append(", ");
            ++n2;
        }
        String arguments = StringUtils.removeEnd((String)buffer.toString(), (String)", ");
        return "new " + componentClassName + "(" + arguments + ")";
    }

    private static void setIcon(ILoadingContext context, ComponentDescription componentDescription, Class<?> currentClass) throws Exception {
        if (currentClass != null) {
            ImageDescriptor icon;
            if (componentDescription.getIcon() == null && (icon = DescriptionHelper.getIcon(context, currentClass)) != null) {
                componentDescription.setIcon(icon);
                return;
            }
            Class<?>[] classArray = currentClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                if (componentDescription.getIcon() == null) {
                    ComponentDescriptionHelper.setIcon(context, componentDescription, interfaceClass);
                }
                ++n2;
            }
            if (componentDescription.getIcon() == null) {
                ComponentDescriptionHelper.setIcon(context, componentDescription, currentClass.getSuperclass());
            }
        }
    }

    public static void ensureInitialized(final IJavaProject javaProject, final AbstractInvocationDescription methodDescription) {
        if (!methodDescription.isInitialized()) {
            methodDescription.setInitialized(true);
            ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    IMethod method = CodeUtils.findMethod(javaProject, methodDescription.getDeclaringClass().getName(), methodDescription.getSignature());
                    if (method != null) {
                        String[] parameterNames = method.getParameterNames();
                        for (ParameterDescription parameter : methodDescription.getParameters()) {
                            if (parameter.getName() != null) continue;
                            int parameterIndex = parameter.getIndex();
                            String parameterName = parameterNames[parameterIndex];
                            parameter.setName(parameterName);
                        }
                    }
                }
            });
        }
    }

    private static void addConstructors(IJavaProject javaProject, ComponentDescription componentDescription) throws Exception {
        Class<?> componentClass = componentDescription.getComponentClass();
        Constructor<?>[] constructorArray = componentClass.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            constructor.setAccessible(true);
            ConstructorDescription constructorDescription = new ConstructorDescription(componentClass);
            Class<?>[] classArray = constructor.getParameterTypes();
            int n3 = classArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> parameterType = classArray[n4];
                ComponentDescriptionHelper.addParameter(constructorDescription, parameterType);
                ++n4;
            }
            constructorDescription.postProcess();
            componentDescription.addConstructor(constructorDescription);
            ++n2;
        }
    }

    private static void addParameter(AbstractInvocationDescription description, Class<?> parameterType) throws Exception {
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.setType(parameterType);
        description.addParameter(parameterDescription);
    }

    private static void process(ComponentDescription componentDescription, Component component, AstEditor editor) throws Exception {
        Component.Parameters parameters;
        MethodsOrderType methodsOrder;
        MorphingType morphingTargets;
        Class<?> componentClass;
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        ComponentDescriptionHelper.acceptSafe(componentDescription, component.getToolkit(), new ToolkitRule());
        ComponentDescriptionHelper.acceptSafe(componentDescription, component.getModel(), new ModelClassRule());
        Component.Methods methods = component.getMethods();
        if (methods != null) {
            for (Object method : methods.getMethod()) {
                componentClass = componentDescription.getComponentClass();
                MethodDescription methodDescription = new MethodDescription(componentClass);
                methodDescription.setName(method.getName());
                ComponentDescriptionHelper.acceptSafe(methodDescription, method.getOrder(), MethodDescription::setOrderSpecification);
                ComponentDescriptionHelper.acceptSafe(methodDescription, method.isExecutable(), MethodDescription::setExecutable);
                for (TagType tag : method.getTag()) {
                    methodDescription.putTag(tag.getName(), tag.getValue());
                }
                for (MethodParameter parameter : method.getParameter()) {
                    ComponentDescriptionHelper.addParametersRules(methodDescription, parameter, state);
                }
                methodDescription.postProcess();
                String signature = methodDescription.getSignature();
                Method javaMethod = ReflectionUtils.getMethodBySignature(componentClass, (String)signature);
                Assert.isNotNull2((Object)javaMethod, (String)"No such method {0}.{1} during parsing {2}", (Object[])new Object[]{componentClass.getName(), signature, componentDescription.getCurrentClass().getName()});
                methodDescription.setReturnClass(javaMethod.getReturnType());
                componentDescription.addMethod(methodDescription);
            }
        }
        ComponentDescriptionHelper.acceptSafe(componentDescription, component.getStandardBeanProperties(), new StandardBeanPropertiesRule());
        for (Component.PropertiesPreferred properties : component.getPropertiesPreferred()) {
            ComponentDescriptionHelper.acceptSafe(componentDescription, properties, new StandardBeanPropertiesPreferredRule());
        }
        for (Component.PropertiesPreferred properties : component.getPropertiesNormal()) {
            ComponentDescriptionHelper.acceptSafe(componentDescription, properties, new StandardBeanPropertiesNormalRule());
        }
        for (Component.PropertiesPreferred properties : component.getPropertiesAdvanced()) {
            ComponentDescriptionHelper.acceptSafe(componentDescription, properties, new StandardBeanPropertiesAdvancedRule());
        }
        for (Component.PropertiesPreferred properties : component.getPropertiesHidden()) {
            ComponentDescriptionHelper.acceptSafe(componentDescription, properties, new StandardBeanPropertiesHiddenRule());
        }
        for (Component.PropertiesPreferred properties : component.getPropertiesNoDefaultValue()) {
            ComponentDescriptionHelper.acceptSafe(componentDescription, properties, new StandardBeanPropertiesNoDefaultValueRule());
        }
        for (Component.PropertyTag propertyTag : component.getPropertyTag()) {
            ComponentDescriptionHelper.acceptSafe(componentDescription, propertyTag, new StandardBeanPropertyTagRule());
        }
        for (Component.MethodSingleProperty singleProperty : component.getMethodSingleProperty()) {
            GenericPropertyDescription propertyDescription = ComponentDescriptionHelper.getGenericPropertyDescription(componentDescription, singleProperty);
            ComponentDescriptionHelper.addPropertyConfigurationRules(componentDescription, propertyDescription, (PropertyConfigurationElements)singleProperty, state);
        }
        for (Component.MethodProperty methodProperty : component.getMethodProperty()) {
            ComponentDescriptionHelper.acceptSafe(componentDescription, methodProperty, new MethodPropertyRule(editor.getJavaProject()));
        }
        ComponentDescriptionHelper.acceptSafe(componentDescription, component.getPublicFieldProperties(), new PublicFieldPropertiesRule());
        ComponentDescriptionHelper.acceptSafe(componentDescription, component.getOrder(), ComponentDescription::setOrder);
        for (Creation creation : component.getCreation()) {
            CreationDescription creationDescription = ComponentDescriptionHelper.getCreationDescription(componentDescription, creation, context);
            ComponentDescriptionHelper.addCreationRules(creationDescription, creation);
            for (TagType tagType : creation.getTag()) {
                creationDescription.putTag(tagType.getName(), tagType.getValue());
            }
            TypeParametersType typeParameters = creation.getTypeParameters();
            if (typeParameters != null) {
                for (TypeParameterType typeParameter : typeParameters.getTypeParameter()) {
                    String name = typeParameter.getName();
                    String type = typeParameter.getType();
                    String description = typeParameter.getTitle();
                    creationDescription.setTypeParameter(name, type, description);
                }
            }
            componentDescription.addCreation(creationDescription);
        }
        Creation creationDefault = component.getCreationDefault();
        if (creationDefault != null) {
            CreationDescription creationDescription = ComponentDescriptionHelper.getCreationDescription(componentDescription, creationDefault, context);
            ComponentDescriptionHelper.addCreationRules(creationDescription, creationDefault);
            for (TagType tagType : creationDefault.getTag()) {
                creationDescription.putTag(tagType.getName(), tagType.getValue());
            }
            componentDescription.setCreationDefault(creationDescription);
        }
        if ((morphingTargets = component.getMorphTargets()) != null) {
            MorphingType morphingType = component.getMorphTargets();
            ComponentDescriptionHelper.acceptSafe(componentDescription, morphingType.getNoInherit(), new MorphingNoInheritRule());
            for (MorphingType.MorphTarget morphTarget : morphingType.getMorphTarget()) {
                ComponentDescriptionHelper.acceptSafe(componentDescription, morphTarget, new MorphingTargetRule(state));
            }
        }
        ComponentDescriptionHelper.acceptSafe(componentDescription, component.getDescription(), ComponentDescription::setDescription);
        Component.Constructors constructors = component.getConstructors();
        if (constructors != null) {
            for (Component.Constructors.Constructor constructor : constructors.getConstructor()) {
                componentClass = componentDescription.getComponentClass();
                ConstructorDescription constructorDescription = new ConstructorDescription(componentClass);
                for (MethodParameter parameter : constructor.getParameter()) {
                    ComponentDescriptionHelper.addParametersRules(constructorDescription, parameter, state);
                }
                constructorDescription.postProcess();
                if (componentDescription.getCurrentClass() != componentDescription.getComponentClass()) continue;
                componentDescription.addConstructor(constructorDescription);
            }
        }
        if ((methodsOrder = component.getMethodOrder()) != null) {
            ComponentDescriptionHelper.acceptSafe(componentDescription, methodsOrder.getDefault(), new MethodOrderDefaultRule());
            for (Object method : methodsOrder.getMethod()) {
                ComponentDescriptionHelper.acceptSafe(componentDescription, method, new MethodOrderMethodRule());
            }
            for (MethodsOrderType.Methods methods2 : methodsOrder.getMethods()) {
                ComponentDescriptionHelper.acceptSafe(componentDescription, methods2, new MethodOrderMethodsRule());
            }
        }
        if (component.getExposingRules() != null) {
            ExposingRulesType exposingRules = component.getExposingRules();
            for (JAXBElement exposingRule : exposingRules.getExcludeOrInclude()) {
                ComponentDescriptionHelper.acceptSafe(componentDescription, exposingRule, new ExposingRulesRule());
            }
        }
        if ((methods = component.getMethods()) != null) {
            for (Component.Methods.MethodsInclude methodsInclude : methods.getMethodsInclude()) {
                ComponentDescriptionHelper.acceptSafe(componentDescription, methodsInclude.getSignature(), new MethodsOperationRule(true));
            }
            for (Component.Methods.MethodsExclude methodsExclude : methods.getMethodsExclude()) {
                ComponentDescriptionHelper.acceptSafe(componentDescription, methodsExclude.getSignature(), new MethodsOperationRule(false));
            }
        }
        if ((parameters = component.getParameters()) != null) {
            for (Component.Parameters.Parameter parameter : parameters.getParameter()) {
                componentDescription.addParameter(parameter.getName(), parameter.getValue());
            }
        }
        ComponentDescriptionHelper.addPropertiesRules(componentDescription, component, state);
        ComponentDescriptionHelper.addConfigurablePropertiesRules(componentDescription, component);
    }

    private static void addPropertiesRules(ComponentDescription componentDescription, Component component, EditorState state) throws Exception {
        for (PropertyConfiguration property : component.getProperty()) {
            String id = property.getId();
            GenericPropertyDescription propertyDescription = componentDescription.getProperty(id);
            ComponentDescriptionHelper.addPropertyConfigurationRules(componentDescription, propertyDescription, (PropertyConfigurationElements)property, state);
        }
    }

    private static void addPropertyConfigurationRules(ComponentDescription componentDescription, GenericPropertyDescription propertyDescription, PropertyConfigurationElements property, EditorState state) throws Exception {
        ComponentDescriptionHelper.acceptSafe(propertyDescription, property.getCategory(), new PropertyCategoryRule());
        PropertyEditor editorModel = property.getEditor();
        if (editorModel != null) {
            String id = editorModel.getId();
            org.eclipse.wb.internal.core.model.property.editor.PropertyEditor editor = DescriptionPropertiesHelper.getConfigurableEditor(id);
            PropertyEditorDescription editorDescription = new PropertyEditorDescription(state, editor);
            ComponentDescriptionHelper.addConfigurableObjectParametersRules(editorDescription, (ParameterBaseType)editorModel);
            editor = editorDescription.getConfiguredEditor();
            propertyDescription.setEditor(editor);
        }
        ClassLoader classLoader = state.getEditorLoader();
        ComponentDescriptionHelper.acceptSafe(propertyDescription, property.getDefaultValue(), new PropertyDefaultRule(classLoader));
        ComponentDescriptionHelper.acceptSafe(propertyDescription, property.getGetter(), new PropertyGetterRule(componentDescription));
        ComponentDescriptionHelper.acceptSafe(propertyDescription, property.getTag(), new PropertyTagRule());
    }

    private static void addConfigurablePropertiesRules(ComponentDescription componentDescription, Component component) throws Exception {
        for (ConfigurablePropertyType property : component.getAddProperty()) {
            ConfigurablePropertyDescription propertyDescription = ComponentDescriptionHelper.getConfigurablePropertyDescription(componentDescription, property);
            ComponentDescriptionHelper.addConfigurableObjectParametersRules(propertyDescription, (ParameterBaseType)property);
        }
    }

    private static void addConfigurableObjectParametersRules(AbstractConfigurableDescription configurableDescription, ParameterBaseType configurable) throws Exception {
        for (ParameterBaseType.Parameter parameter : configurable.getParameter()) {
            ComponentDescriptionHelper.acceptSafe(configurableDescription, parameter, new ConfigurableObjectParameterRule());
        }
        for (ParameterBaseType.ParameterList parameterList : configurable.getParameterList()) {
            ComponentDescriptionHelper.acceptSafe(configurableDescription, parameterList, new ConfigurableObjectListParameterRule());
        }
    }

    private static void addCreationRules(CreationDescription creationDescription, Creation creation) throws Exception {
        ComponentDescriptionHelper.acceptSafe(creationDescription, creation.getDescription(), CreationDescription::setDescription);
        ComponentDescriptionHelper.acceptSafe(creationDescription, creation.getSource(), CreationDescription::setSource);
        for (Creation.Invocation invocation : creation.getInvocation()) {
            CreationInvocationDescription invocationDescription = new CreationInvocationDescription();
            invocationDescription.setSignature(invocation.getSignature());
            invocationDescription.setArguments(invocation.getContent());
            creationDescription.addInvocation(invocationDescription);
        }
        for (Creation.Parameter parameter : creation.getParameter()) {
            creationDescription.addParameter(parameter.getName(), parameter.getContent());
        }
    }

    static void addParametersRules(AbstractInvocationDescription methodDescription, MethodParameter parameter, EditorState state) throws Exception {
        ClassLoader classLoader = state.getEditorLoader();
        ParameterDescription parameterDescription = new ParameterDescription();
        ComponentDescriptionHelper.acceptSafe(parameterDescription, parameter.getType(), new SetClassPropertyRule(classLoader));
        ComponentDescriptionHelper.acceptSafe(parameterDescription, parameter.getName(), ParameterDescription::setName);
        ComponentDescriptionHelper.acceptSafe(parameterDescription, parameter.getDefaultSource(), ParameterDescription::setDefaultSource);
        ComponentDescriptionHelper.acceptSafe(parameterDescription, parameter.isParent(), ParameterDescription::setParent);
        ComponentDescriptionHelper.acceptSafe(parameterDescription, parameter.isParent2(), ParameterDescription::setParent2);
        ComponentDescriptionHelper.acceptSafe(parameterDescription, parameter.isChild(), ParameterDescription::setChild);
        ComponentDescriptionHelper.acceptSafe(parameterDescription, parameter.isChild2(), ParameterDescription::setChild2);
        ComponentDescriptionHelper.acceptSafe(parameterDescription, parameter.getProperty(), ParameterDescription::setProperty);
        methodDescription.addParameter(parameterDescription);
        PropertyEditor editorModel = parameter.getEditor();
        if (editorModel != null) {
            String id = editorModel.getId();
            org.eclipse.wb.internal.core.model.property.editor.PropertyEditor editor = DescriptionPropertiesHelper.getConfigurableEditor(id);
            PropertyEditorDescription editorDescription = new PropertyEditorDescription(state, editor);
            ComponentDescriptionHelper.addConfigurableObjectParametersRules(editorDescription, (ParameterBaseType)editorModel);
            editor = editorDescription.getConfiguredEditor();
            parameterDescription.setEditor(editor);
        }
        for (TagType tag : parameter.getTag()) {
            parameterDescription.putTag(tag.getName(), tag.getValue());
        }
    }

    private static boolean shouldCacheDescriptions_inPackage(ClassResourceInfo descriptionInfo, Class<?> componentClass) throws Exception {
        return ComponentDescriptionHelper.hasMarkerFileForPackage(descriptionInfo, componentClass, ".wbp-cache-descriptions");
    }

    private static boolean shouldCachePresentation(ClassResourceInfo descriptionInfo, Class<?> componentClass) throws Exception {
        Bundle bundle;
        if (descriptionInfo.clazz == componentClass && (bundle = descriptionInfo.resource.getBundle()) != null) {
            return bundle.getEntry("wbp-meta/.wbp-cache-presentations") != null;
        }
        return false;
    }

    private static boolean hasMarkerFileForPackage(ClassResourceInfo descriptionInfo, Class<?> componentClass, String markerFileName) throws Exception {
        ResourceInfo resourceInfo = descriptionInfo.resource;
        if (resourceInfo.getBundle() != null) {
            String packageName = CodeUtils.getPackage(componentClass.getName());
            String markerName = packageName.replace('.', '/') + "/" + markerFileName;
            return DescriptionHelper.getResourceInfo(null, resourceInfo.getBundle(), markerName) != null;
        }
        return false;
    }

    public static List<IDescriptionProcessor> getDescriptionProcessors() {
        return ExternalFactoriesHelper.getElementsInstances(IDescriptionProcessor.class, (String)"org.eclipse.wb.core.descriptionProcessors", (String)"processor");
    }

    private static CreationDescription getCreationDescription(ComponentDescription componentDescription, Creation creation, ILoadingContext context) throws Exception {
        String id = creation.getId();
        String name = creation.getName();
        CreationDescription creationDescription = new CreationDescription(componentDescription, id, name);
        if (id != null) {
            Class<?> componentClass = componentDescription.getComponentClass();
            String suffix = "_" + id;
            creationDescription.setIcon(DescriptionHelper.getIcon(context, componentClass, suffix));
        }
        return creationDescription;
    }

    private static GenericPropertyDescription getGenericPropertyDescription(ComponentDescription componentDescription, Component.MethodSingleProperty property) throws Exception {
        Class<?> componentClass = componentDescription.getComponentClass();
        String propertyTitle = property.getTitle();
        String methodSignature = property.getMethod();
        Method method = ReflectionUtils.getMethodBySignature(componentClass, (String)methodSignature);
        Assert.isTrue((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (String)"Method with single parameter expected: %s", (Object[])new Object[]{method});
        return StandardBeanPropertiesRule.addSingleProperty(componentDescription, propertyTitle, method, null);
    }

    private static ConfigurablePropertyDescription getConfigurablePropertyDescription(ComponentDescription componentDescription, ConfigurablePropertyType property) throws Exception {
        String id = property.getId();
        String title = property.getTitle();
        ConfigurablePropertyDescription propertyDescription = new ConfigurablePropertyDescription();
        propertyDescription.setId(id);
        propertyDescription.setTitle(title);
        componentDescription.addConfigurableProperty(propertyDescription);
        return propertyDescription;
    }

    static <U, T> void acceptSafe(U description, T model, FailableBiConsumer<U, T, ? extends Exception> consumer) throws Exception {
        if (model == null) {
            return;
        }
        consumer.accept(description, model);
    }
}

