/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.firefox;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.AbstractRunHTMLDebugTab;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.firefox.FirefoxRunDebugLaunchShortcut;

public class RunFirefoxDebugTab
extends AbstractRunHTMLDebugTab {
    private Button reloadOnChange;

    public RunFirefoxDebugTab() {
        this.shortcut = new FirefoxRunDebugLaunchShortcut();
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.reloadOnChange = new Button(this.resComposite, 32);
        this.reloadOnChange.setText(Messages.RunFirefoxDebugTab_ReloadOnChange);
        this.reloadOnChange.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            boolean reloadOnChangeValue = configuration.getAttribute("reloadOnChange", false);
            this.reloadOnChange.setSelection(reloadOnChangeValue);
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log(ex.getStatus());
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("reloadOnChange", this.reloadOnChange.getSelection());
    }
}

