/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client.impl;

import com.google.gwt.core.client.JsArray;
import com.google.gwt.editor.client.AutoBean;
import com.google.gwt.editor.client.AutoBeanUtils;
import com.google.gwt.editor.client.AutoBeanVisitor;
import com.google.gwt.requestfactory.client.impl.AbstractRequest;
import com.google.gwt.requestfactory.client.impl.AbstractRequestFactory;
import com.google.gwt.requestfactory.client.impl.EntityCodex;
import com.google.gwt.requestfactory.client.impl.EntityProxyCategory;
import com.google.gwt.requestfactory.client.impl.SimpleEntityProxyId;
import com.google.gwt.requestfactory.client.impl.messages.RequestContentData;
import com.google.gwt.requestfactory.client.impl.messages.ReturnRecord;
import com.google.gwt.requestfactory.client.impl.messages.SideEffects;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.EntityProxyChange;
import com.google.gwt.requestfactory.shared.Receiver;
import com.google.gwt.requestfactory.shared.RequestContext;
import com.google.gwt.requestfactory.shared.RequestTransport;
import com.google.gwt.requestfactory.shared.ServerFailure;
import com.google.gwt.requestfactory.shared.ValueCodex;
import com.google.gwt.requestfactory.shared.Violation;
import com.google.gwt.requestfactory.shared.WriteOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractRequestContext
implements RequestContext {
    private static final String PARENT_OBJECT = "parentObject";
    private List<AbstractRequest<?>> invocations = new ArrayList();
    private boolean locked;
    private final AbstractRequestFactory requestFactory;
    private final Map<SimpleEntityProxyId<?>, AutoBean<?>> editedProxies = new LinkedHashMap();
    private Set<Violation> errors = new LinkedHashSet<Violation>();
    private final Map<SimpleEntityProxyId<?>, AutoBean<?>> returnedProxies = new HashMap();

    protected AbstractRequestContext(AbstractRequestFactory factory) {
        this.requestFactory = factory;
    }

    @Override
    public <T extends EntityProxy> T create(Class<T> clazz) {
        this.checkLocked();
        AutoBean<T> created = this.requestFactory.createEntityProxy(clazz, this.requestFactory.allocateId(clazz));
        return this.takeOwnership(created);
    }

    @Override
    public <T extends EntityProxy> T edit(T object) {
        AutoBean<T> bean = this.checkStreamsNotCrossed(object);
        this.checkLocked();
        AutoBean<?> previouslySeen = this.editedProxies.get(object.stableId());
        if (previouslySeen != null && !previouslySeen.isFrozen()) {
            return (T)((EntityProxy)previouslySeen.as());
        }
        AutoBean<T> parent = bean;
        bean = this.cloneBeanAndCollections(bean);
        bean.setTag(PARENT_OBJECT, parent);
        return this.takeOwnership(bean);
    }

    @Override
    public void fire() {
        boolean needsReceiver = true;
        for (AbstractRequest<?> request : this.invocations) {
            if (!request.hasReceiver()) continue;
            needsReceiver = false;
            break;
        }
        if (needsReceiver) {
            this.doFire(new Receiver<Void>(){

                @Override
                public void onSuccess(Void response) {
                }
            });
        } else {
            this.doFire(null);
        }
    }

    @Override
    public void fire(Receiver<Void> receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException();
        }
        this.doFire(receiver);
    }

    public AbstractRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public boolean isChanged() {
        for (AutoBean<?> bean : this.editedProxies.values()) {
            AutoBean<?> previous = (AutoBean<?>)bean.getTag(PARENT_OBJECT);
            if (previous == null) {
                Class<?> proxyClass = ((EntityProxy)bean.as()).stableId().getProxyClass();
                previous = this.getRequestFactory().getAutoBeanFactory().create(proxyClass);
            }
            if (AutoBeanUtils.diff(previous, bean).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void reuse() {
        this.freezeEntities(false);
        this.locked = false;
    }

    protected void addErrors(Collection<Violation> errors) {
        this.errors.addAll(errors);
    }

    protected void addInvocation(AbstractRequest<?> request) {
        if (this.invocations.size() > 0) {
            throw new IllegalStateException("Method chaining not implemented");
        }
        this.invocations.add(request);
        for (Object arg : request.getRequestData().getParameters()) {
            this.retainArg(arg);
        }
    }

    <Q extends EntityProxy> AutoBean<Q> getProxyForReturnPayloadGraph(SimpleEntityProxyId<Q> id) {
        assert (!id.isEphemeral());
        AutoBean<Object> bean = this.returnedProxies.get(id);
        if (bean == null) {
            Class<Q> proxyClass = id.getProxyClass();
            bean = this.requestFactory.createEntityProxy(proxyClass, id);
            this.returnedProxies.put(id, bean);
        }
        return bean;
    }

    <Q extends EntityProxy> Q processReturnRecord(SimpleEntityProxyId<Q> id, final ReturnRecord returnRecord, WriteOperation ... operations) {
        AutoBean<Q> toMutate = this.getProxyForReturnPayloadGraph(id);
        toMutate.accept(new AutoBeanVisitor(){

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                if (ctx.canSet() && returnRecord.hasProperty(propertyName)) {
                    Object raw = returnRecord.get(propertyName);
                    if (returnRecord.isNull(propertyName)) {
                        ctx.set(null);
                    } else {
                        Object decoded = EntityCodex.decode(ctx.getType(), ctx.getElementType(), AbstractRequestContext.this, raw);
                        ctx.set(decoded);
                    }
                }
                return false;
            }

            @Override
            public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                if (ctx.canSet() && returnRecord.hasProperty(propertyName)) {
                    Object raw = returnRecord.get(propertyName);
                    if (returnRecord.isNull(propertyName)) {
                        ctx.set(null);
                    } else {
                        Object decoded = ValueCodex.convertFromString(ctx.getType(), String.valueOf(raw));
                        ctx.set(decoded);
                    }
                }
                return false;
            }
        });
        this.makeImmutable(toMutate);
        EntityProxy proxy = (EntityProxy)toMutate.as();
        if (operations != null) {
            for (WriteOperation op : operations) {
                if (op.equals((Object)WriteOperation.UPDATE) && !this.requestFactory.hasVersionChanged(id, returnRecord.getVersion())) continue;
                this.requestFactory.getEventBus().fireEventFromSource(new EntityProxyChange<EntityProxy>(proxy, op), id.getProxyClass());
            }
        }
        return (Q)proxy;
    }

    void processSideEffects(SideEffects sideEffects) {
        JsArray<ReturnRecord> deleted;
        JsArray<ReturnRecord> updated;
        JsArray<ReturnRecord> persisted = sideEffects.getPersist();
        if (persisted != null) {
            this.processReturnRecords(persisted, WriteOperation.PERSIST);
        }
        if ((updated = sideEffects.getUpdate()) != null) {
            this.processReturnRecords(updated, WriteOperation.UPDATE);
        }
        if ((deleted = sideEffects.getDelete()) != null) {
            this.processReturnRecords(deleted, WriteOperation.DELETE);
        }
    }

    private void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("A request is already in progress");
        }
    }

    private <T> AutoBean<T> checkStreamsNotCrossed(T object) {
        AutoBean bean = AutoBeanUtils.getAutoBean(object);
        if (bean == null) {
            throw new IllegalArgumentException(object.getClass().getName());
        }
        RequestContext context = (RequestContext)bean.getTag("requestContext");
        if (!bean.isFrozen() && context != this) {
            assert (context != null) : "Unfrozen bean with null RequestContext";
            throw new IllegalArgumentException("Attempting to edit an EntityProxy previously edited by another RequestContext");
        }
        return bean;
    }

    private <T> AutoBean<T> cloneBeanAndCollections(AutoBean<T> toClone) {
        AutoBean<T> clone = toClone.clone(false);
        clone.accept(new AutoBeanVisitor(){

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                if (value != null) {
                    if (List.class == ctx.getType()) {
                        ctx.set(new ArrayList((List)value.as()));
                    } else if (Set.class == ctx.getType()) {
                        ctx.set(new HashSet((Set)value.as()));
                    }
                }
                return false;
            }
        });
        return clone;
    }

    private void doFire(final Receiver<Void> receiver) {
        this.checkLocked();
        this.locked = true;
        this.freezeEntities(true);
        String payload = this.makePayload();
        this.requestFactory.getRequestTransport().send(payload, new RequestTransport.TransportReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTransportFailure(String message) {
                ServerFailure failure = new ServerFailure(message, null, null);
                try {
                    assert (AbstractRequestContext.this.invocations.size() == 1);
                    ((AbstractRequest)AbstractRequestContext.this.invocations.get(0)).fail(failure);
                    if (receiver != null) {
                        receiver.onFailure(failure);
                    }
                }
                finally {
                    AbstractRequestContext.this.postRequestCleanup();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTransportSuccess(String payload) {
                try {
                    assert (AbstractRequestContext.this.invocations.size() == 1);
                    ((AbstractRequest)AbstractRequestContext.this.invocations.get(0)).handleResponseText(payload);
                    if (receiver != null) {
                        if (AbstractRequestContext.this.errors.isEmpty()) {
                            receiver.onSuccess(null);
                            AbstractRequestContext.this.editedProxies.clear();
                            AbstractRequestContext.this.invocations.clear();
                            AbstractRequestContext.this.returnedProxies.clear();
                        } else {
                            receiver.onViolation(AbstractRequestContext.this.errors);
                        }
                    }
                }
                finally {
                    AbstractRequestContext.this.postRequestCleanup();
                }
            }
        });
    }

    private void freezeEntities(boolean frozen) {
        for (AutoBean<?> bean : this.editedProxies.values()) {
            bean.setFrozen(frozen);
        }
    }

    private void makeImmutable(AutoBean<? extends EntityProxy> toMutate) {
        toMutate.setTag(PARENT_OBJECT, toMutate);
        toMutate.setTag("requestContext", null);
        toMutate.setFrozen(true);
    }

    private String makePayload() {
        assert (this.invocations.size() == 1) : "addInvocation() should have failed";
        RequestContentData data = new RequestContentData();
        for (AutoBean<?> currentView : this.editedProxies.values()) {
            boolean isPersist = false;
            SimpleEntityProxyId<?> stableId = EntityProxyCategory.stableId(currentView);
            LinkedHashMap<String, String> encoded = new LinkedHashMap<String, String>();
            AutoBean<?> parent = (AutoBean<?>)currentView.getTag(PARENT_OBJECT);
            if (parent == null) {
                parent = this.requestFactory.createEntityProxy(stableId.getProxyClass(), stableId);
                isPersist = true;
                String clientId = String.valueOf(stableId.getClientId());
                encoded.put("!id", ValueCodex.encodeForJsonPayload(clientId));
            } else {
                encoded.put("!id", ValueCodex.encodeForJsonPayload(stableId.getServerId()));
            }
            Map<String, Object> diff = AutoBeanUtils.diff(parent, currentView);
            for (Map.Entry<String, Object> entry : diff.entrySet()) {
                encoded.put(entry.getKey(), EntityCodex.encodeForJsonPayload(entry.getValue()));
            }
            String typeToken = this.requestFactory.getTypeToken(stableId.getProxyClass());
            if (isPersist) {
                data.addPersist(typeToken, encoded);
                continue;
            }
            data.addUpdate(typeToken, encoded);
        }
        AbstractRequest<?> request = this.invocations.get(0);
        Map<String, String> requestMap = request.getRequestData().getRequestMap(data.toJson());
        String string = RequestContentData.flattenKeysToExpressions(requestMap);
        return string;
    }

    private void postRequestCleanup() {
        this.errors.clear();
    }

    private void processReturnRecords(JsArray<ReturnRecord> records, WriteOperation operations) {
        int j = records.length();
        for (int i = 0; i < j; ++i) {
            ReturnRecord record = records.get(i);
            SimpleEntityProxyId id = this.requestFactory.getId(record.getSchema(), record.getEncodedId(), record.getFutureId());
            this.processReturnRecord(id, record, operations);
        }
    }

    private void retainArg(Object arg) {
        if (arg instanceof Iterable) {
            for (Object o : (Iterable)arg) {
                this.retainArg(o);
            }
        } else if (arg instanceof EntityProxy) {
            this.edit((EntityProxy)arg);
        }
    }

    private <T extends EntityProxy> T takeOwnership(AutoBean<T> bean) {
        this.editedProxies.put(EntityProxyCategory.stableId(bean), bean);
        bean.setTag("requestContext", this);
        return (T)((EntityProxy)bean.as());
    }
}

