/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.actions;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CommonSQLObjectAction
extends Action
implements IObjectActionDelegate {
    protected SQLObject _sqlObject = null;
    protected Database _database = null;
    protected IConnectionProfile _connectionProfile = null;
    protected IWorkbenchPart _targetPart = null;

    public CommonSQLObjectAction() {
    }

    public CommonSQLObjectAction(Object selectedResource) {
        this.initSQLObject((IAction)this, selectedResource);
        this.initConnectionProfile();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this._connectionProfile = null;
        this._sqlObject = null;
        this._database = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object selectedResource = structuredSelection.getFirstElement();
            this.initSQLObject(action, selectedResource);
        }
        this.initConnectionProfile();
    }

    protected void initConnectionProfile() {
        this._connectionProfile = CommonSQLObjectAction.getConnectionProfile(this._database);
    }

    public static IConnectionProfile getConnectionProfile(Database database) {
        ConnectionInfo connInfo;
        if (database != null && (connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database)) instanceof ConnectionInfoImpl) {
            return ((ConnectionInfoImpl)connInfo).getConnectionProfile();
        }
        return null;
    }

    protected void initSQLObject(IAction action, Object selectedResource) {
        if (selectedResource instanceof SQLObject) {
            this._sqlObject = (SQLObject)selectedResource;
            action.setEnabled(true);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

