/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.caching.AbstractContentCache;
import org.eclipse.dltk.core.caching.cache.CacheEntry;
import org.eclipse.dltk.core.caching.cache.CacheEntryAttribute;
import org.eclipse.dltk.core.caching.cache.CacheFactory;
import org.eclipse.dltk.core.caching.cache.CacheIndex;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class MetadataContentCache
extends AbstractContentCache {
    private static final int DAY_IN_MILIS = 60;
    private static final int SAVE_DELTA = 60000;
    private Resource indexResource = null;
    private long newSaveTime = 0L;
    private Map<EntryKey, CacheEntry> entryCache = new HashMap<EntryKey, CacheEntry>();
    private IPath cacheLocation;
    private CRC32 checksum = new CRC32();
    long changeCount = 0L;
    private File indexFileHandle;

    public MetadataContentCache(IPath cacheLocation) {
        this.cacheLocation = cacheLocation;
    }

    private synchronized void initialize() {
        if (this.indexResource == null) {
            File file = new File(this.cacheLocation.toOSString());
            if (!file.exists()) {
                file.mkdir();
            }
            IPath indexFile = this.cacheLocation.append("index");
            this.indexResource = new XMIResourceImpl();
            this.indexFileHandle = new File(indexFile.toOSString());
            if (this.indexFileHandle.exists()) {
                try {
                    BufferedInputStream loadStream = new BufferedInputStream(new FileInputStream(this.indexFileHandle), 4096);
                    this.indexResource.load((InputStream)loadStream, null);
                    loadStream.close();
                }
                catch (Exception e) {
                    this.save(false);
                }
            }
            EList contents = this.indexResource.getContents();
            for (EObject eObject : contents) {
                CacheIndex index = (CacheIndex)eObject;
                EList<CacheEntry> entries = index.getEntries();
                for (CacheEntry cacheEntry : entries) {
                    this.entryCache.put(this.makeKey(cacheEntry), cacheEntry);
                }
            }
        }
    }

    private synchronized CacheEntry getEntry(IFileHandle handle) {
        this.initialize();
        EntryKey key = this.makeKey(handle);
        if (this.entryCache.containsKey(key)) {
            CacheEntry entry = this.entryCache.get(key);
            long accessTime = entry.getLastAccessTime();
            long timeMillis = System.currentTimeMillis();
            if (timeMillis - accessTime > 60L) {
                long handleTimestamp;
                long entryTimestamp = entry.getTimestamp() / 1000L;
                if (entryTimestamp == (handleTimestamp = this.getHandleLastModification(handle) / 1000L)) {
                    entry.setLastAccessTime(timeMillis);
                    return entry;
                }
                entry.setLastAccessTime(timeMillis);
                this.removeCacheEntry(entry, key);
            } else {
                entry.setLastAccessTime(timeMillis);
                return entry;
            }
        }
        CacheIndex index = this.getCacheIndex(handle.getEnvironmentId());
        CacheEntry entry = CacheFactory.eINSTANCE.createCacheEntry();
        entry.setPath(handle.getPath().toPortableString());
        entry.setTimestamp(this.getHandleLastModification(handle));
        index.getEntries().add((Object)entry);
        entry.setLastAccessTime(System.currentTimeMillis());
        this.entryCache.put(key, entry);
        return entry;
    }

    private long getHandleLastModification(IFileHandle handle) {
        block4: {
            IEnvironment environment = handle.getEnvironment();
            if (environment != null && environment.isLocal()) {
                try {
                    File file = new File(handle.getPath().toOSString());
                    File canonicalFile = file.getCanonicalFile();
                    if (!file.getAbsolutePath().equals(canonicalFile.getAbsoluteFile())) {
                        return canonicalFile.lastModified();
                    }
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
        return handle.lastModified();
    }

    private CacheIndex getCacheIndex(String environmentId) {
        EList contents = this.indexResource.getContents();
        for (EObject eObject : contents) {
            CacheIndex index = (CacheIndex)eObject;
            if (!index.getEnvironment().equals(environmentId)) continue;
            return index;
        }
        CacheIndex index = CacheFactory.eINSTANCE.createCacheIndex();
        index.setEnvironment(environmentId);
        index.setLastIndex(0L);
        contents.add((Object)index);
        return index;
    }

    private void removeCacheEntry(CacheEntry entry, EntryKey key) {
        if (entry == null || key == null) {
            return;
        }
        EList<CacheEntryAttribute> attributes = entry.getAttributes();
        for (CacheEntryAttribute attr : attributes) {
            this.removeAttribute(attr);
        }
        attributes.clear();
        CacheIndex index = (CacheIndex)entry.eContainer();
        index.getEntries().remove((Object)entry);
        this.entryCache.remove(key);
    }

    private void removeAttribute(CacheEntryAttribute attr) {
        String location = attr.getLocation();
        IPath cacheEntryFile = this.cacheLocation.append(location);
        File file = new File(cacheEntryFile.toOSString());
        if (file.exists()) {
            file.delete();
        }
    }

    private EntryKey makeKey(CacheEntry entry) {
        CacheIndex index = (CacheIndex)entry.eContainer();
        return new EntryKey(index.getEnvironment(), entry.getPath());
    }

    private EntryKey makeKey(IFileHandle handle) {
        return new EntryKey(handle.getEnvironmentId(), handle.getPath().toString());
    }

    public synchronized void save(boolean countSaves) {
        block6: {
            if (this.indexResource == null) {
                return;
            }
            if (countSaves) {
                long current = System.currentTimeMillis();
                if (current > this.newSaveTime) {
                    this.newSaveTime = current + 60000L;
                } else {
                    return;
                }
            }
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("SAVE_ONLY_IF_CHANGED", Boolean.TRUE);
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(this.indexFileHandle), 4096);
                this.indexResource.save((OutputStream)outStream, options);
                outStream.close();
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getCacheEntryAttribute(IFileHandle handle, String attribute) {
        if (handle == null) {
            return null;
        }
        File file = null;
        CacheEntry entry = null;
        MetadataContentCache metadataContentCache = this;
        synchronized (metadataContentCache) {
            entry = this.getEntry(handle);
            EList<CacheEntryAttribute> attributes = entry.getAttributes();
            for (CacheEntryAttribute cacheEntryAttribute : attributes) {
                if (!cacheEntryAttribute.getName().equals(attribute)) continue;
                file = new File(this.cacheLocation.append(cacheEntryAttribute.getLocation()).toOSString());
                break;
            }
        }
        if (file != null && file.exists()) {
            try {
                RuntimePerformanceMonitor.PerformanceNode node = RuntimePerformanceMonitor.begin();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                BufferedInputStream inp = new BufferedInputStream(new FileInputStream(file), 4096);
                Util.copy(inp, bout);
                inp.close();
                node.done("Metadata", "IO Read", file.length(), EnvironmentManager.getLocalEnvironment());
                return new ByteArrayInputStream(bout.toByteArray());
            }
            catch (FileNotFoundException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public synchronized OutputStream getCacheEntryAttributeOutputStream(IFileHandle handle, String attribute) {
        File file = this.getEntryAsFile(handle, attribute);
        try {
            return new BufferedOutputStream(new FileOutputStream(file), 4096);
        }
        catch (FileNotFoundException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public File getEntryAsFile(IFileHandle handle, String attribute) {
        if (handle == null) {
            return null;
        }
        CacheEntry entry = this.getEntry(handle);
        File file = null;
        EList<CacheEntryAttribute> attributes = entry.getAttributes();
        for (CacheEntryAttribute cacheEntryAttribute : attributes) {
            if (!cacheEntryAttribute.getName().equals(attribute)) continue;
            file = new File(this.cacheLocation.append(cacheEntryAttribute.getLocation()).toOSString());
            return file;
        }
        IPath location = this.generateNewLocation(handle.getPath(), handle.getEnvironmentId());
        CacheEntryAttribute attrEntry = CacheFactory.eINSTANCE.createCacheEntryAttribute();
        attrEntry.setLocation(location.toPortableString());
        attrEntry.setName(attribute);
        entry.getAttributes().add((Object)attrEntry);
        this.save(true);
        file = new File(this.cacheLocation.append(location).toOSString());
        return file;
    }

    private IPath generateNewLocation(IPath path, String environment) {
        File file;
        this.checksum.reset();
        this.checksum.update(environment.getBytes());
        IPath indexPath = this.cacheLocation.append(Long.toString(this.checksum.getValue()));
        File indexFolderFile = new File(indexPath.toOSString());
        if (!indexFolderFile.exists()) {
            indexFolderFile.mkdir();
        }
        this.checksum.reset();
        this.checksum.update(path.removeLastSegments(1).toPortableString().getBytes());
        IPath folder = indexPath.append(Long.toString(this.checksum.getValue()));
        File folderFile = new File(folder.toOSString());
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        CacheIndex index = this.getCacheIndex(environment);
        IPath location = null;
        long i = index.getLastIndex() + 1L;
        while ((file = new File((location = folder.append(Long.toString(i++) + ".idx")).toOSString())).exists()) {
        }
        index.setLastIndex(i);
        return location.removeFirstSegments(this.cacheLocation.segmentCount()).setDevice(null);
    }

    @Override
    public synchronized void removeCacheEntryAttributes(IFileHandle handle, String attribute) {
        if (handle == null) {
            return;
        }
        CacheEntry entry = this.getEntry(handle);
        EList<CacheEntryAttribute> attributes = entry.getAttributes();
        for (CacheEntryAttribute cacheEntryAttribute : attributes) {
            if (!cacheEntryAttribute.getName().equals(attribute)) continue;
            this.removeAttribute(cacheEntryAttribute);
            attributes.remove((Object)cacheEntryAttribute);
            this.save(true);
            return;
        }
    }

    @Override
    public synchronized void clearCacheEntryAttributes(IFileHandle handle) {
        if (handle == null) {
            return;
        }
        EntryKey key = this.makeKey(handle);
        if (this.entryCache.containsKey(key)) {
            CacheEntry entry = this.entryCache.get(key);
            this.removeCacheEntry(entry, key);
            this.save(true);
        }
    }

    @Override
    public synchronized void clear() {
        this.initialize();
        HashSet<EntryKey> keySet = new HashSet<EntryKey>(this.entryCache.keySet());
        for (EntryKey k : keySet) {
            this.removeCacheEntry(this.entryCache.get(k), k);
        }
        this.save(true);
    }

    @Override
    public InputStream getCacheEntryAttribute(IFileHandle handle, String attribute, boolean localonly) {
        return this.getCacheEntryAttribute(handle, attribute);
    }

    @Override
    public void updateFolderTimestamps(IFileHandle parent) {
        IFileHandle[] children = parent.getChildren();
        if (children == null) {
            return;
        }
        IFileHandle[] iFileHandleArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFileHandle child = iFileHandleArray[n2];
            this.getEntry(child);
            ++n2;
        }
    }

    private static class EntryKey {
        private String environment;
        private String path;

        public EntryKey(String environment, String path) {
            this.environment = environment;
            this.path = path;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntryKey other = (EntryKey)obj;
            if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }
}

