/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.text.ContentBox;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.TextFlow;

public class TextFragmentBox
extends ContentBox {
    public int length;
    public int offset;
    private TextFlow textflow;
    private boolean truncated;

    public TextFragmentBox(TextFlow textflow) {
        this.textflow = textflow;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getBaseline() - this.getAscentWithBorder() && y <= this.getBaseline() + this.getDescentWithBorder();
    }

    @Override
    public int getAscent() {
        return this.textflow.getAscent();
    }

    @Override
    int getAscentWithBorder() {
        return this.textflow.getAscent() + FlowUtilities.getBorderAscent(this.textflow);
    }

    @Override
    public int getDescent() {
        return this.textflow.getDescent();
    }

    @Override
    int getDescentWithBorder() {
        return this.textflow.getDescent() + FlowUtilities.getBorderDescent(this.textflow);
    }

    @Override
    int getOuterAscent() {
        return this.textflow.getAscent() + FlowUtilities.getBorderAscentWithMargin(this.textflow);
    }

    @Override
    int getOuterDescent() {
        return this.textflow.getDescent() + FlowUtilities.getBorderDescentWithMargin(this.textflow);
    }

    final int getTextTop() {
        return this.getBaseline() - this.getAscent();
    }

    public boolean isRightToLeft() {
        return this.getBidiLevel() % 2 == 1;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(boolean value) {
        this.truncated = value;
    }

    public String toString() {
        return "[" + this.offset + ", " + (this.offset + this.length) + ") = \"" + this.textflow.getText().substring(this.offset, this.offset + this.length) + "\"";
    }
}

