/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.eef.properties.ui.api.IEEFTypeMapper;
import org.eclipse.eef.properties.ui.legacy.internal.EEFPropertiesUiLegacyPlugin;
import org.eclipse.eef.properties.ui.legacy.internal.Messages;
import org.eclipse.eef.properties.ui.legacy.internal.extension.AbstractRegistryEventListener;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertySectionItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.impl.LegacyPropertySectionRegistry;
import org.eclipse.eef.properties.ui.legacy.internal.legacy2eef.EEFLegacyTypeMapper;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;

public class LegacyPropertySectionsRegistryEventListener
extends AbstractRegistryEventListener {
    public static final String TAG_PROPERTY_SECTIONS = "propertySections";
    public static final String CONTRIBUTOR_ID_ATTR = "contributorId";
    public static final String TAG_PROPERTY_SECTION = "propertySection";
    public static final String TAB_ATTR = "tab";
    public static final String ID_ATTR = "id";
    public static final String CLASS_ATTR = "class";
    public static final String AFTER_SECTION_ATTR = "afterSection";
    public static final String ENABLES_FOR_ATTR = "enablesFor";
    public static final String FILTER_ATTR = "filter";
    public static final String ELEMENT_INPUT = "input";
    public static final String ATT_INPUT_TYPE = "type";
    private LegacyPropertySectionRegistry propertySectionRegistry;

    public LegacyPropertySectionsRegistryEventListener(String namespace, String extensionPointID, LegacyPropertySectionRegistry itemRegistry) {
        super(namespace, extensionPointID);
        this.propertySectionRegistry = itemRegistry;
    }

    @Override
    protected boolean validateConfigurationElement(IConfigurationElement configurationElement) {
        boolean isValid = false;
        if (TAG_PROPERTY_SECTIONS.equals(configurationElement.getName())) {
            if (!this.isValidAttribute(configurationElement, CONTRIBUTOR_ID_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), CONTRIBUTOR_ID_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else {
                isValid = true;
            }
        } else if (TAG_PROPERTY_SECTION.equals(configurationElement.getName())) {
            if (!this.isValidAttribute(configurationElement, TAB_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), TAB_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else if (!this.isValidAttribute(configurationElement, ID_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), ID_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else if (!this.isValidAttribute(configurationElement, CLASS_ATTR)) {
                String message = MessageFormat.format(Messages.RegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), CLASS_ATTR);
                EEFPropertiesUiLegacyPlugin.getImplementation().logError(message, null);
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    private boolean isValidAttribute(IConfigurationElement configurationElement, String attributeName) {
        return configurationElement.getAttribute(attributeName) != null && !"".equals(configurationElement.getAttribute(attributeName));
    }

    @Override
    protected boolean processAddition(IConfigurationElement configurationElement) {
        if (TAG_PROPERTY_SECTIONS.equals(configurationElement.getName())) {
            IConfigurationElement[] propertySections;
            String contributorId = configurationElement.getAttribute(CONTRIBUTOR_ID_ATTR);
            IConfigurationElement[] iConfigurationElementArray = propertySections = configurationElement.getChildren(TAG_PROPERTY_SECTION);
            int n = propertySections.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement propertySection = iConfigurationElementArray[n2];
                ITypeMapper typeMapper = EEFPropertiesUiLegacyPlugin.getImplementation().getTabbedPropertyContributorRegistry().getTypeMapper(contributorId);
                EEFLegacyTypeMapper eefTypeMapper = null;
                if (typeMapper != null) {
                    eefTypeMapper = new EEFLegacyTypeMapper(typeMapper);
                }
                LegacyPropertySectionItemDescriptor legacySectionDescriptor = new LegacyPropertySectionItemDescriptor(propertySection, (IEEFTypeMapper)eefTypeMapper);
                this.propertySectionRegistry.add(legacySectionDescriptor);
                ++n2;
            }
        }
        return true;
    }

    @Override
    protected boolean processRemoval(IConfigurationElement configurationElement) {
        return this.propertySectionRegistry.remove(configurationElement.getAttribute(ID_ATTR));
    }
}

