/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.ui.swt;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.transfer.CDOTransfer;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferMapping;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.CDOTransferType;
import org.eclipse.emf.cdo.transfer.ui.TransferDialog;
import org.eclipse.emf.cdo.transfer.ui.TransferTypeContentProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.StructuredContentProvider;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class TransferDetailsComposite
extends Composite
implements IListener {
    private static final String UP = "..";
    private static final Path UP_PATH = new Path("..");
    private CDOTransfer transfer;
    private CDOTransferType[] transferTypes;
    private CDOTransferMapping mapping;
    private boolean handlingMappingEvent;
    private Text sourcePath;
    private Text targetPath;
    private ComboViewer transferType;
    private Text status;
    private Text relativePath;
    private Combo resolution;
    private ListViewer unmappedModels;
    private Button mapSource;
    private Button replaceTarget;
    private Button keepAsIs;

    public TransferDetailsComposite(Composite parent, int style, final CDOTransfer transfer) {
        super(parent, style);
        this.transfer = transfer;
        this.transfer.addListener((IListener)this);
        this.initTransferTypes(transfer);
        GridLayout gl_composite = new GridLayout(4, false);
        gl_composite.marginWidth = 10;
        this.setLayout((Layout)gl_composite);
        Label sourcePathLabel = new Label((Composite)this, 0);
        sourcePathLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        sourcePathLabel.setText("Source Path:");
        this.sourcePath = new Text((Composite)this, 2056);
        this.sourcePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label transferTypeLabel = new Label((Composite)this, 0);
        transferTypeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        transferTypeLabel.setText("Type:");
        this.transferType = new ComboViewer((Composite)this, 0);
        this.transferType.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.transferType.setContentProvider((IContentProvider)new TransferTypeContentProvider());
        this.transferType.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.transferType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TransferDetailsComposite.this.mapping != null) {
                    IStructuredSelection selection = (IStructuredSelection)TransferDetailsComposite.this.transferType.getSelection();
                    CDOTransferType type = (CDOTransferType)selection.getFirstElement();
                    TransferDetailsComposite.this.mapping.setTransferType(type);
                }
            }
        });
        Label targetPathLabel = new Label((Composite)this, 0);
        targetPathLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        targetPathLabel.setText("Target Path:");
        this.targetPath = new Text((Composite)this, 2056);
        this.targetPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label statusLabel = new Label((Composite)this, 0);
        statusLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        statusLabel.setText("Status:");
        this.status = new Text((Composite)this, 2056);
        this.status.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label relativePathLabel = new Label((Composite)this, 0);
        relativePathLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        relativePathLabel.setText("Relative Path:");
        GridData gd_pathPane = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_pathPane.heightHint = 27;
        GridLayout pathPaneLayout = new GridLayout(4, false);
        pathPaneLayout.marginWidth = 0;
        pathPaneLayout.marginHeight = 0;
        Composite pathPane = new Composite((Composite)this, 0);
        pathPane.setLayoutData((Object)gd_pathPane);
        pathPane.setLayout((Layout)pathPaneLayout);
        this.relativePath = new Text(pathPane, 2048);
        this.relativePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.relativePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TransferDetailsComposite.this.mapping != null && !TransferDetailsComposite.this.handlingMappingEvent) {
                    String text = TransferDetailsComposite.this.relativePath.getText();
                    TransferDetailsComposite.this.mapping.setRelativePath(text);
                }
            }
        });
        Button leftButton = new Button(pathPane, 0);
        leftButton.setBounds(0, 0, 75, 25);
        leftButton.setText("<");
        leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Path path = new Path(TransferDetailsComposite.this.relativePath.getText());
                path = path.isEmpty() || TransferDetailsComposite.UP.equals(path.segment(0)) ? UP_PATH.append((IPath)path) : path.removeFirstSegments(1);
                TransferDetailsComposite.this.mapping.setRelativePath((IPath)path);
            }
        });
        Button rightButton = new Button(pathPane, 0);
        rightButton.setBounds(0, 0, 75, 25);
        rightButton.setText(">");
        rightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object path = new Path(TransferDetailsComposite.this.relativePath.getText());
                path = TransferDetailsComposite.UP.equals(path.segment(0)) ? path.removeFirstSegments(1) : (path.isEmpty() ? new Path(TransferDetailsComposite.this.mapping.getSource().getName()) : new Path("folder").append((IPath)path));
                TransferDetailsComposite.this.mapping.setRelativePath((IPath)path);
            }
        });
        Button renameButton = new Button(pathPane, 0);
        renameButton.setText("+");
        renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sourceName = TransferDetailsComposite.this.mapping.getSource().getName();
                Path path = new Path(TransferDetailsComposite.this.relativePath.getText());
                if (path.isEmpty() || TransferDetailsComposite.UP.equals(path.segment(0))) {
                    path = new Path(sourceName);
                }
                String name = path.lastSegment();
                int i = 1;
                while (transfer.getTargetSystem().getElement((IPath)path) != null) {
                    path = path.removeLastSegments(1).append(String.valueOf(name) + i);
                }
                TransferDetailsComposite.this.mapping.setRelativePath((IPath)path);
            }
        });
        Label resolutionLabel = new Label((Composite)this, 0);
        resolutionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        resolutionLabel.setText("Resolution:");
        resolutionLabel.setVisible(false);
        this.resolution = new Combo((Composite)this, 0);
        this.resolution.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.resolution.setVisible(false);
        Label unmappedModelsLabel = new Label((Composite)this, 0);
        unmappedModelsLabel.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        unmappedModelsLabel.setText("Unmapped Models:");
        this.unmappedModels = new ListViewer((Composite)this, 2048);
        List list = this.unmappedModels.getList();
        list.setForeground(SWTResourceManager.getColor(3));
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.unmappedModels.setContentProvider((IContentProvider)new UnmappedModelsContentProvider());
        this.unmappedModels.setLabelProvider((IBaseLabelProvider)new UnmappedModelsLabelProvider(transfer));
        this.unmappedModels.setInput((Object)transfer);
        this.unmappedModels.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TransferDetailsComposite.this.unmappedModels.getSelection();
                Resource resource = (Resource)selection.getFirstElement();
                TransferDetailsComposite.this.updateTransformationButtons(resource);
            }
        });
        GridLayout transformationButtonsPaneLayout = new GridLayout(1, false);
        transformationButtonsPaneLayout.marginWidth = 0;
        transformationButtonsPaneLayout.marginHeight = 0;
        Composite transformationButtonsPane = new Composite((Composite)this, 0);
        transformationButtonsPane.setLayout((Layout)transformationButtonsPaneLayout);
        transformationButtonsPane.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        this.mapSource = new Button(transformationButtonsPane, 0);
        this.mapSource.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mapSource.setBounds(0, 0, 75, 25);
        this.mapSource.setText("Map From Source");
        this.mapSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TransferDetailsComposite.this.unmappedModels.getSelection();
                Resource resource = (Resource)selection.getFirstElement();
                URI uri = resource.getURI();
                CDOTransferElement element = transfer.getSourceSystem().getElement(uri);
                TransferDialog.initializeTransfer(transfer, Collections.singleton(element));
            }
        });
        this.replaceTarget = new Button(transformationButtonsPane, 0);
        this.replaceTarget.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.replaceTarget.setBounds(0, 0, 75, 25);
        this.replaceTarget.setText("Replace With Target");
        this.keepAsIs = new Button(transformationButtonsPane, 0);
        this.keepAsIs.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keepAsIs.setBounds(0, 0, 75, 25);
        this.keepAsIs.setText("Keep As Is");
        this.keepAsIs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TransferDetailsComposite.this.unmappedModels.getSelection();
                Resource resource = (Resource)selection.getFirstElement();
                URI uri = resource.getURI();
                transfer.getModelTransferContext().setResolution(uri, new CDOTransfer.ModelTransferResolution(){});
            }
        });
        Button refresh = new Button(transformationButtonsPane, 0);
        refresh.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        refresh.setBounds(0, 0, 75, 25);
        refresh.setText("Refresh");
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransferDetailsComposite.this.unmappedModels.refresh();
            }
        });
        this.updateTransformationButtons(null);
    }

    public void dispose() {
        this.transfer.removeListener((IListener)this);
        this.transfer = null;
        this.mapping = null;
        super.dispose();
    }

    public CDOTransfer getTransfer() {
        return this.transfer;
    }

    public CDOTransferMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(CDOTransferMapping mapping) {
        if (!ObjectUtil.equals((Object)this.mapping, (Object)mapping)) {
            this.mapping = mapping;
            if (mapping != null) {
                this.sourcePath.setText(mapping.getSource().getPath().toString());
                this.targetPath.setText(mapping.getFullPath().makeAbsolute().toString());
                this.status.setText(mapping.getStatus().toString());
                this.relativePath.setText(mapping.getRelativePath().toString());
                CDOTransferType type = mapping.getTransferType();
                this.transferType.setInput((Object)(type != CDOTransferType.FOLDER ? this.transferTypes : CDOTransferType.FOLDER));
                this.transferType.setSelection((ISelection)new StructuredSelection((Object)type));
                this.transferType.getCombo().setEnabled(type != CDOTransferType.FOLDER);
            } else {
                this.sourcePath.setText("");
                this.targetPath.setText("");
                this.status.setText("");
                this.relativePath.setText("");
                this.transferType.setInput((Object)TransferTypeContentProvider.NO_TANSFER_TYPES);
                this.transferType.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    public Text getSourcePath() {
        return this.sourcePath;
    }

    public Text getTargetPath() {
        return this.targetPath;
    }

    public ComboViewer getTransferType() {
        return this.transferType;
    }

    public Text getStatus() {
        return this.status;
    }

    public Text getRelativePath() {
        return this.relativePath;
    }

    public Combo getResolution() {
        return this.resolution;
    }

    public ListViewer getUnmappedModels() {
        return this.unmappedModels;
    }

    public boolean setFocus() {
        return this.relativePath.setFocus();
    }

    public void notifyEvent(final IEvent event) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TransferDetailsComposite.this.isDisposed()) {
                        try {
                            if (event instanceof CDOTransfer.MappingEvent) {
                                CDOTransfer.MappingEvent e = (CDOTransfer.MappingEvent)event;
                                if (ObjectUtil.equals((Object)e.getMapping(), (Object)TransferDetailsComposite.this.mapping)) {
                                    TransferDetailsComposite.this.notifyMappingEvent(e);
                                }
                            } else if (event instanceof CDOTransfer.UnmappedModelsEvent) {
                                TransferDetailsComposite.this.unmappedModels.refresh();
                            }
                        }
                        catch (SWTException sWTException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    protected void notifyMappingEvent(CDOTransfer.MappingEvent event) {
        if (event instanceof CDOTransfer.TransferTypeChangedEvent) {
            CDOTransfer.TransferTypeChangedEvent e = (CDOTransfer.TransferTypeChangedEvent)event;
            CDOTransferType newType = e.getNewType();
            Object currentType = ((IStructuredSelection)this.transferType.getSelection()).getFirstElement();
            if (currentType != newType) {
                this.transferType.setSelection((ISelection)new StructuredSelection((Object)newType));
            }
            this.unmappedModels.refresh();
        } else if (event instanceof CDOTransfer.RelativePathChangedEvent) {
            CDOTransfer.RelativePathChangedEvent e = (CDOTransfer.RelativePathChangedEvent)event;
            String value = e.getNewPath().toString();
            if (!ObjectUtil.equals((Object)value, (Object)this.relativePath.getText())) {
                try {
                    this.handlingMappingEvent = true;
                    this.relativePath.setText(value);
                    this.status.setText(this.mapping.getStatus().toString());
                }
                finally {
                    this.handlingMappingEvent = false;
                }
            }
            this.targetPath.setText(this.mapping.getFullPath().makeAbsolute().toString());
        }
    }

    protected void initTransferTypes(CDOTransfer transfer) {
        HashSet set = new HashSet(CDOTransferType.REGISTRY.values());
        set.remove(CDOTransferType.FOLDER);
        this.transferTypes = set.toArray(new CDOTransferType[set.size()]);
        Arrays.sort(this.transferTypes);
    }

    protected void updateTransformationButtons(Resource resource) {
        if (resource == null) {
            this.mapSource.setEnabled(false);
            this.replaceTarget.setEnabled(false);
            this.keepAsIs.setEnabled(false);
            return;
        }
        URI uri = resource.getURI();
        CDOTransferSystem sourceSystem = this.transfer.getSourceSystem();
        CDOTransferElement sourceElement = sourceSystem.getElement(uri);
        this.mapSource.setEnabled(sourceElement != null);
        CDOTransfer.ModelTransferContext context = this.transfer.getModelTransferContext();
        CDOTransfer.ModelTransferResolution resolution = context.getResolution(uri);
        this.keepAsIs.setEnabled(resolution == null);
    }

    public static class UnmappedModelsContentProvider
    extends StructuredContentProvider<CDOTransfer> {
        public Object[] getElements(Object inputElement) {
            CDOTransfer transfer = (CDOTransfer)this.getInput();
            CDOTransfer.ModelTransferContext context = transfer.getModelTransferContext();
            Set resources = context.getUnmappedModels();
            return resources.toArray(new Resource[resources.size()]);
        }
    }

    public static class UnmappedModelsLabelProvider
    extends LabelProvider
    implements IColorProvider {
        @Deprecated
        public static final Color GRAY = null;
        @Deprecated
        public static final Color RED = null;
        private CDOTransfer transfer;

        public UnmappedModelsLabelProvider(CDOTransfer transfer) {
            this.transfer = transfer;
        }

        public CDOTransfer getTransfer() {
            return this.transfer;
        }

        public String getText(Object element) {
            if (element instanceof Resource) {
                Resource resource = (Resource)element;
                return resource.getURI().toString();
            }
            return super.getText(element);
        }

        public Color getForeground(Object element) {
            if (element instanceof Resource) {
                Resource resource = (Resource)element;
                URI uri = resource.getURI();
                CDOTransfer.ModelTransferContext context = this.transfer.getModelTransferContext();
                CDOTransfer.ModelTransferResolution resolution = context.getResolution(uri);
                if (resolution != null) {
                    return UIUtil.grayColor();
                }
            }
            return UIUtil.redColor();
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

